/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.service.address.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.orm.query.QFilter;
import kd.scm.pbd.common.entity.AddressTreeNode;
import kd.scm.pbd.service.address.AbstractAddressMatcher;

public class XyAddressMatcher
extends AbstractAddressMatcher {
    private static final long JI_YUAN = 1478L;
    private static final long XIAN_TAO = 1692L;
    private static final long QIAN_JIANG = 1718L;
    private static final long TIAN_MEN = 1744L;
    private static final long SHEN_NONG_JIA = 1773L;
    private static final long WU_JIA_QU = 3302L;
    private static final long TU_MU_SHU = 3291L;
    private static final long A_LA_ER = 3272L;
    private static final long SHI_HE_ZI = 3264L;
    private static final long JIA_YU_GUAN = 285L;
    private static final long DONG_GUAN = 511L;
    private static final long ZHONG_SHAN = 547L;
    private static final Map<Long, Long> HAI_NAN_MAP = new HashMap<Long, Long>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(899L, 1199979058704728064L);
            this.put(917L, 1199979060365673473L);
            this.put(930L, 1199979060466335744L);
            this.put(944L, 1199979060365673472L);
            this.put(955L, 1199979062093725696L);
            this.put(985L, 1199979064694194176L);
            this.put(1000L, 1199979065725992960L);
            this.put(1011L, 1199979065608552448L);
            this.put(831L, 1199979058016862208L);
            this.put(840L, 1199979054669808640L);
            this.put(878L, 1199979058050416640L);
            this.put(1028L, 1199979067160445952L);
            this.put(1043L, 1199979067168834560L);
            this.put(1057L, 1199979068175466496L);
            this.put(972L, 1199979062152445952L);
            this.put(856L, 1199979055491892224L);
        }
    };
    private static final long EC_JI_YUAN = 1199978934779823104L;
    private static final long EC_XIAN_TAO = 1199978956934136832L;
    private static final long EC_QIAN_JIANG = 1199978957278068736L;
    private static final long EC_TIAN_MEN = 1199978958167261184L;
    private static final long EC_SHEN_NONG_JIA = 1199978958192427008L;
    private static final long EC_WU_JIA_QU = 1199979312351069184L;
    private static final long EC_TU_MU_SHU = 1199979312225240064L;
    private static final long EC_A_LA_ER = 1199979312049079296L;
    private static final long EC_SHI_HE_ZI = 1199979311990358016L;
    private static final long EC_JIA_YU_GUAN = 1199979317577171968L;
    private static final long EC_DONG_GUAN = 1199979008431801344L;
    private static final long EC_ZHONG_SHAN = 1199979008549241856L;

    @Override
    public int matchBdAddressWithEcAddress(List<AddressTreeNode> bdAddressTreeNodeList, List<AddressTreeNode> ecAddressTreeNodeList) {
        AtomicInteger cnt = new AtomicInteger();
        boolean bdAddrVersion = this.getValidAddrCount() <= 3500;
        this.match(bdAddressTreeNodeList, ecAddressTreeNodeList, cnt, bdAddrVersion);
        return cnt.get();
    }

    @Override
    public boolean specialRuleMatch(AddressTreeNode bdNode, AddressTreeNode ecNode, boolean bdAddrVersion) {
        long ecAddressId = ecNode.getId();
        if (bdNode.getParentId() == 1478L && ecAddressId == 1199978934779823104L) {
            return true;
        }
        if (bdNode.getParentId() == 1692L && ecAddressId == 1199978956934136832L || bdNode.getParentId() == 1718L && ecAddressId == 1199978957278068736L || bdNode.getParentId() == 1744L && ecAddressId == 1199978958167261184L || bdNode.getParentId() == 1773L && ecAddressId == 1199978958192427008L) {
            return true;
        }
        if (bdNode.getParentId() == 3302L && ecAddressId == 1199979312351069184L || bdNode.getParentId() == 3291L && ecAddressId == 1199979312225240064L || bdNode.getParentId() == 3272L && ecAddressId == 1199979312049079296L || bdNode.getParentId() == 3264L && ecAddressId == 1199979311990358016L) {
            return true;
        }
        if (bdNode.getParentId() == 285L && ecAddressId == 1199979317577171968L) {
            return true;
        }
        if (bdNode.getParentId() == 511L && ecAddressId == 1199979008431801344L || bdNode.getParentId() == 547L && ecAddressId == 1199979008549241856L) {
            return true;
        }
        return HAI_NAN_MAP.containsKey(bdNode.getParentId()) && ecAddressId == HAI_NAN_MAP.get(bdNode.getParentId());
    }

    @Override
    public void handleAfterBuildNodeResult(List<AddressTreeNode> resultList, boolean isMatchSource) {
        if (this.getValidAddrCount() <= 3500 && isMatchSource) {
            for (AddressTreeNode node : resultList) {
                if (!DIRECT_PROVINCE_ID_LIST.contains(node.getId())) continue;
                this.fillToFourthLevel(node);
            }
        }
    }

    @Override
    public QFilter getBdAddrFilter() {
        QFilter levelFilter = new QFilter("level", "in", (Object)new ArrayList<Integer>(){
            {
                this.add(1);
                this.add(2);
                this.add(3);
            }
        });
        QFilter filter = new QFilter("issystem", "=", (Object)"1");
        return new QFilter("enable", "=", (Object)"1").and(levelFilter).and(filter);
    }
}

