/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.domain.model.esconfig.schedule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.es.storage.EsBatchValue;
import kd.scm.common.es.storage.EsFilterField;
import kd.scm.common.es.storage.EsPropertyValue;
import kd.scm.common.es.storage.EsResultVo;
import kd.scm.common.es.storage.EsSearchParam;
import kd.scm.common.es.storage.EsStorageFactory;
import kd.scm.pbd.domain.model.esconfig.EsConfig;
import kd.scm.pbd.domain.service.EsSearchService;
import kd.scm.pbd.domain.service.PbdDomainServiceFactory;

public class PbdEsGoodsSalesSyncTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(PbdEsGoodsSalesSyncTask.class);
    private static final int PAGE_SIZE = 1000;

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        log.info("\u6267\u884c\u5168\u6587\u68c0\u7d22\u5e93\u6570\u636e\u540c\u6b65\u4efb\u52a1\u5f00\u59cb\uff1a" + params);
        DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)params.get("trigger"), (String)"pbd_data_sync_trigger");
        DynamicObject goodsSalesConfigDyn = trigger.getDynamicObject("esconfig");
        EsConfig esGoodsConfig = new EsConfig(Long.valueOf(1560871593289408512L));
        EsConfig esGoodsSalesConfig = new EsConfig(Long.valueOf(goodsSalesConfigDyn.getLong("id")));
        EsSearchParam saleEsSearchParam = new EsSearchParam();
        ArrayList<EsFilterField> esFilterFields = new ArrayList<EsFilterField>();
        EsFilterField billStatusFilter = new EsFilterField("billstatus", "=", new Object[]{BillStatusEnum.AUDIT.getVal()});
        esFilterFields.add(billStatusFilter);
        saleEsSearchParam.setEsFilterFields(esFilterFields);
        int curPage = 0;
        boolean isContinue = true;
        while (isContinue) {
            Object sales2;
            saleEsSearchParam.setPageNum(curPage);
            saleEsSearchParam.setPageSize(1000);
            EsResultVo salesEsResultVo = ((EsSearchService)PbdDomainServiceFactory.serviceOf(EsSearchService.class, (String)esGoodsSalesConfig.getRegion())).search(saleEsSearchParam, esGoodsSalesConfig);
            if (salesEsResultVo.getResultData().size() <= 1000) {
                isContinue = false;
            }
            ++curPage;
            Map aggsData = salesEsResultVo.getAggsData();
            Map salesAggMap = (Map)aggsData.get("salesagg");
            List buckets = (List)salesAggMap.get("buckets");
            HashMap<Long, Object> goodsIdToSalesMap = new HashMap<Long, Object>((int)salesEsResultVo.getTotalHits());
            if (!ObjectUtils.isEmpty((Object)buckets)) {
                for (Map bucket : buckets) {
                    Map entryQtyAgg = (Map)bucket.get("entryQtyAgg");
                    if (entryQtyAgg == null) continue;
                    sales2 = entryQtyAgg.get("value");
                    goodsIdToSalesMap.put(Long.valueOf(String.valueOf(bucket.get("key"))), sales2);
                }
            }
            ArrayList<EsBatchValue> esBatchValues = new ArrayList<EsBatchValue>((int)salesEsResultVo.getTotalHits());
            ArrayList<Long> prodPoolGoodsIdList = new ArrayList<Long>((int)salesEsResultVo.getTotalHits());
            DataSet prodPoolDs = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pmm_prodpool", (String)"id, goods.id", (QFilter[])new QFilter[]{new QFilter("goods.id", "in", goodsIdToSalesMap.keySet()).and("mallstatus", "=", (Object)"B")}, null);
            sales2 = null;
            try {
                Iterator iterator = prodPoolDs.iterator();
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    Object sales3 = goodsIdToSalesMap.get(row.getLong("goods.id"));
                    prodPoolGoodsIdList.add(row.getLong("goods.id"));
                    EsBatchValue esBatchValue = new EsBatchValue((Object)row.getLong("id"), new EsPropertyValue[]{new EsPropertyValue("sales", sales3)});
                    esBatchValues.add(esBatchValue);
                }
            }
            catch (Throwable throwable) {
                sales2 = throwable;
                throw throwable;
            }
            finally {
                if (prodPoolDs != null) {
                    if (sales2 != null) {
                        try {
                            prodPoolDs.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)sales2).addSuppressed(throwable);
                        }
                    } else {
                        prodPoolDs.close();
                    }
                }
            }
            for (Long goodsId2 : prodPoolGoodsIdList) {
                goodsIdToSalesMap.remove(goodsId2);
            }
            goodsIdToSalesMap.forEach((goodsId, sales) -> esBatchValues.add(new EsBatchValue(goodsId, new EsPropertyValue[]{new EsPropertyValue("sales", sales)})));
            try {
                EsStorageFactory.getStorage((String)esGoodsConfig.getRegion()).batchUpdate(esGoodsConfig.getIndexName(), "_doc", esBatchValues.toArray(new EsBatchValue[0]));
            }
            catch (Exception e) {
                log.info("\u9500\u91cf\u66f4\u65b0\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        trigger.set("trigged_time", (Object)TimeServiceHelper.now());
        trigger.set("total_count", (Object)(trigger.getInt("total_count") + 1));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trigger});
    }
}

