/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.service;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pbd.business.AddressServiceHelper;
import kd.scm.pbd.service.IAddressService;

public class AddressServiceImp
implements IAddressService {
    private static final String ADDRESS_ENTITY = "pbd_emaladdress";
    private static final String MALADDRESSREL_ENTITY = "pbd_maladdressrel";
    private static final String EMALTYPE = "emaltype";
    private static final String ADDRESS = "address";

    private DynamicObject getEmalAddressRelDObj(String addressId, String emalType) {
        QFilter filter = new QFilter(EMALTYPE, "=", (Object)emalType);
        filter.and(new QFilter(ADDRESS, "=", (Object)addressId));
        return QueryServiceHelper.queryOne((String)MALADDRESSREL_ENTITY, (String)"longnumber", (QFilter[])new QFilter[]{filter});
    }

    private DynamicObject getEmalAddressDObj(String addressId, String emalType) {
        DynamicObject emalAddressRelDObj = this.getEmalAddressRelDObj(addressId, emalType);
        QFilter filter = new QFilter("id", "=", (Object)emalAddressRelDObj.getString("emaladdress"));
        return QueryServiceHelper.queryOne((String)ADDRESS_ENTITY, (String)"name,fullname,longnumber", (QFilter[])new QFilter[]{filter});
    }

    public String getLongNumber(String addressId, String emalType) {
        DynamicObject obj = this.getEmalAddressRelDObj(addressId, emalType);
        if (obj != null) {
            return obj.getString("longnumber");
        }
        return "";
    }

    public String getNumber(String addressId, String emalType) {
        String longNumber = this.getLongNumber(addressId, emalType);
        if (longNumber.isEmpty()) {
            return null;
        }
        String[] arr = longNumber.split("/.");
        return arr[arr.length - 1];
    }

    public String getFullName(String addressId, String emalType) {
        DynamicObject obj = this.getEmalAddressDObj(addressId, emalType);
        if (obj != null) {
            return obj.getString("fullname");
        }
        return "";
    }

    public String getName(String addressId, String emalType) {
        DynamicObject obj = this.getEmalAddressDObj(addressId, emalType);
        if (obj != null) {
            return obj.getString("name");
        }
        return "";
    }

    public Map<String, Integer> matchAddressByEcType(String currentNodeId, String ecType) {
        AddressServiceHelper helper = new AddressServiceHelper();
        return helper.matchAddressByEcType(currentNodeId, ecType);
    }
}

