/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.service;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class PbdMallGoodsUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(PbdMallGoodsUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setEl("warning");
        StringBuilder pProcessInfo = new StringBuilder();
        try {
            result.setLog("start upgrade mallgoods");
            boolean upgradeResult = this.upgrade(dbKey, pProcessInfo);
            if (upgradeResult) {
                result.setSuccess(true);
            } else {
                result.setSuccess(false);
                result.setErrorInfo(pProcessInfo.toString());
            }
            result.setLog("end upgrade mallgoods");
            return result;
        }
        catch (Exception e) {
            result.setErrorInfo(pProcessInfo.append(e.getMessage()).toString());
            result.setSuccess(false);
            logger.warn("end upgrade mallgoods", (Throwable)e);
            throw new KDBizException(result.getErrorInfo());
        }
    }

    public boolean upgrade(String dbKey, StringBuilder pProcessInfo) {
        DBRoute dbRoute = DBRoute.of((String)dbKey);
        int pageSize = 2000;
        boolean isContinue = true;
        int from = 0;
        int total = 0;
        int currentPage = 0;
        int priceTotal = 0;
        int statusTotal = 0;
        String sql = MessageFormat.format("SELECT TOP {0},{1} fid FROM t_mal_goods order by fid", String.valueOf(pageSize), String.valueOf(from));
        while (isContinue) {
            DataSet ecGoodsDs = this.getDataSet(dbRoute, sql);
            Throwable throwable = null;
            try {
                int count = 0;
                ++currentPage;
                HashSet<Object> goodsIdSet = new HashSet<Object>(4096);
                for (Row row : ecGoodsDs) {
                    goodsIdSet.add(row.get("fid"));
                    ++count;
                    ++total;
                }
                if (!goodsIdSet.isEmpty()) {
                    Object row2;
                    String priceSql = "SELECT fid,fmallgoodsid FROM t_mal_goods_price where fmallgoodsid in (" + StringUtils.join((Object[])goodsIdSet.toArray(), (String)",") + ")";
                    HashMap<Object, Object> goodsId2priceIdMap = new HashMap<Object, Object>(4096);
                    try (DataSet priceDs = this.getDataSet(dbRoute, priceSql);){
                        for (Object row2 : priceDs) {
                            goodsId2priceIdMap.put(row2.get("fmallgoodsid"), row2.get("fid"));
                        }
                    }
                    String statusSql = "SELECT fid,fmallgoodsid FROM t_mal_goods_status where fmallgoodsid in (" + StringUtils.join((Object[])goodsIdSet.toArray(), (String)",") + ")";
                    HashMap<Object, Object> goodsId2statusIdMap = new HashMap<Object, Object>(4096);
                    DataSet priceDs = this.getDataSet(dbRoute, statusSql);
                    row2 = null;
                    try {
                        for (Row row3 : priceDs) {
                            goodsId2statusIdMap.put(row3.get("fmallgoodsid"), row3.get("fid"));
                        }
                    }
                    catch (Throwable throwable2) {
                        row2 = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (priceDs != null) {
                            if (row2 != null) {
                                try {
                                    priceDs.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)row2).addSuppressed(throwable3);
                                }
                            } else {
                                priceDs.close();
                            }
                        }
                    }
                    String updateStatusSql = "update t_mal_goods set fstatusinfoid = ? where fid = ?";
                    ArrayList<Object[]> statusParamsList = new ArrayList<Object[]>(2048);
                    for (Map.Entry entry : goodsId2statusIdMap.entrySet()) {
                        if (entry.getValue() == null) continue;
                        Object[] params = new Object[]{entry.getValue(), entry.getKey()};
                        statusParamsList.add(params);
                    }
                    if (!statusParamsList.isEmpty()) {
                        this.updateBatch(dbRoute, updateStatusSql, statusParamsList);
                        statusTotal += statusParamsList.size();
                    }
                    String updatePriceSql = "update t_mal_goods set fpriceinfoid = ? where fid = ?";
                    ArrayList<Object[]> priceParamsList = new ArrayList<Object[]>(4096);
                    for (Map.Entry entry : goodsId2priceIdMap.entrySet()) {
                        if (entry.getValue() == null) continue;
                        Object[] params = new Object[]{entry.getValue(), entry.getKey()};
                        priceParamsList.add(params);
                    }
                    if (!priceParamsList.isEmpty()) {
                        this.updateBatch(dbRoute, updatePriceSql, priceParamsList);
                        priceTotal += priceParamsList.size();
                    }
                    if (count < pageSize) {
                        isContinue = false;
                    } else {
                        sql = MessageFormat.format("SELECT TOP {0},{1} fid FROM t_mal_goods order by fid", String.valueOf(pageSize), String.valueOf(from += pageSize));
                    }
                } else {
                    isContinue = false;
                }
                logger.info("\u5f53\u524d\u9875\u6570\uff1a" + currentPage);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (ecGoodsDs == null) continue;
                if (throwable != null) {
                    try {
                        ecGoodsDs.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                ecGoodsDs.close();
            }
        }
        pProcessInfo.append("priceTotal\uff1a").append(priceTotal);
        pProcessInfo.append("statusTotal\uff1a").append(statusTotal);
        pProcessInfo.append("total\uff1a").append(total);
        return true;
    }

    private void updateBatch(DBRoute dbRoute, String updateSql, List<Object[]> paramsList) {
        DB.executeBatch((DBRoute)dbRoute, (String)updateSql, paramsList);
    }

    private DataSet getDataSet(DBRoute dbRoute, String sql) {
        return DB.queryDataSet((String)RequestContext.get().getTraceId(), (DBRoute)dbRoute, (String)sql);
    }
}

