/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.service.bdcontrol;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pbd.business.bdcontrol.BasedataControlFactory;
import kd.scm.pbd.business.bdcontrol.IBasedataControl;
import kd.scm.pbd.service.IBasedataControlService;

public class BasedataControlService
implements IBasedataControlService {
    public Map validator(String billname, String actiontype, Set billidSet, DynamicObjectCollection objcol) throws Exception {
        Map results = new HashMap(64);
        DynamicObjectCollection schemecol = this.getScheme(billname, actiontype);
        for (DynamicObject scheme : schemecol) {
            String defaultclass = (String)scheme.get("defaultclass");
            if (defaultclass == null) continue;
            IBasedataControl iBasedataControl = BasedataControlFactory.getInstances((String)defaultclass);
            if (iBasedataControl == null) {
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"%s\u521d\u59cb\u5316\u5931\u8d25\u3002", (String)"BasedataControlService_1", (String)"scm-pbd-mservice", (Object[])new Object[0]), defaultclass));
            }
            results = iBasedataControl.process(scheme, billname, billidSet, objcol);
        }
        return results;
    }

    private DynamicObjectCollection getScheme(String billname, String actiontype) {
        QFilter number = new QFilter("billentity.number", "=", (Object)billname);
        DynamicObjectCollection registerbills = QueryServiceHelper.query((String)"pbd_billregister", (String)"id,billentity.number", (QFilter[])new QFilter[]{number});
        if (registerbills == null || registerbills.size() == 0) {
            return null;
        }
        String selecor = "defaultclass,billentity.id,group,group.controltype,group.defaultclass,operationfield,controlmode,tooltips,filtergridtext_tag";
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter operationfield = new QFilter("operationfield", "=", (Object)actiontype);
        QFilter billentity = new QFilter("billentity.id", "=", (Object)((DynamicObject)registerbills.get(0)).getLong("id"));
        QFilter controltype = new QFilter("group.controltype", "=", (Object)"1");
        DynamicObjectCollection schemecol = QueryServiceHelper.query((String)"pbd_scheme", (String)selecor, (QFilter[])new QFilter[]{status, enable, billentity, controltype, operationfield});
        return schemecol;
    }
}

