/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pbd.service.credit;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.scm.pbd.extpoint.IBusinessRulesFillParseService;

public class RegcapitalFillParseService
implements IBusinessRulesFillParseService {
    private static Log log = LogFactory.getLog(RegcapitalFillParseService.class);
    private static String REGEX_CHINESE = "[\u4e00-\u9fa5]";

    public Map<String, Object> assembelRequest(DynamicObject dy) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        return map;
    }

    public Map<String, Object> fillDyByResult(DynamicObject dy, Object standardResult) {
        Map result;
        Object regcapital;
        log.info("\u6ce8\u518c\u8d44\u672c\u8f6c\u6362\u63d2\u4ef6\u53c2\u6570\uff1a{}", standardResult);
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        if (standardResult instanceof Map && !Objects.isNull(regcapital = (result = (Map)standardResult).get("regcapital"))) {
            BigDecimal regAmount = this.transferCapital(regcapital);
            dy.set("regcapital", (Object)regAmount);
        }
        return map;
    }

    private BigDecimal transferCapital(Object regcapital) {
        BigDecimal regAmount = BigDecimal.ZERO;
        String str = regcapital.toString();
        try {
            String Wan = "\\u4e07";
            String gbEncoding = RegcapitalFillParseService.decodeUnicode(Wan);
            if (str.contains(gbEncoding)) {
                regAmount = this.strTransferBigDecimal(str);
                regAmount = regAmount.multiply(BigDecimal.valueOf(10000L));
            } else {
                regAmount = this.strTransferBigDecimal(str);
            }
        }
        catch (Exception e) {
            log.warn("\u6ce8\u518c\u8d44\u672c\u8f6c\u6362\u63d2\u4ef6");
            log.warn((Throwable)e);
            regAmount = BigDecimal.ZERO;
        }
        return regAmount;
    }

    private BigDecimal strTransferBigDecimal(String str) {
        Pattern pat = Pattern.compile(REGEX_CHINESE);
        Matcher mat = pat.matcher(str);
        String strMatcher = mat.replaceAll("");
        if (StringUtils.isNotEmpty((CharSequence)strMatcher)) {
            BigDecimal regAmount = new BigDecimal(strMatcher.trim());
            return regAmount;
        }
        return BigDecimal.ZERO;
    }

    public static String decodeUnicode(String dataStr) {
        int start = 0;
        int end = 0;
        StringBuilder buffer = new StringBuilder();
        while (start > -1) {
            end = dataStr.indexOf("\\u", start + 2);
            String charStr = "";
            charStr = end == -1 ? dataStr.substring(start + 2, dataStr.length()) : dataStr.substring(start + 2, end);
            char letter = (char)Integer.parseInt(charStr, 16);
            String str = Character.valueOf(letter).toString();
            buffer.append(str);
            start = end;
        }
        return buffer.toString();
    }
}

