/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.report.mutidimamount;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.scm.common.ecapi.enums.EcPlatformEnum;

public class PmmMultiReturnAmountMapFunc
extends MapFunction {
    private static final long serialVersionUID = 7528549172046471513L;
    private RowMeta rowMeta;
    private Map<String, Integer> idxs;

    public PmmMultiReturnAmountMapFunc(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
        this.buildIndexs();
    }

    private void buildIndexs() {
        Field[] fields = this.rowMeta.getFields();
        ArrayList<String> cols = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            cols.add(field.getName());
        }
        this.idxs = this.buildIndexs(this.rowMeta, cols);
    }

    private Map<String, Integer> buildIndexs(RowMeta rowMeta, Collection<String> cols) {
        HashMap<String, Integer> indexs = new HashMap<String, Integer>(cols.size());
        for (String col : cols) {
            indexs.put(col, rowMeta.getFieldIndex(col));
        }
        return indexs;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RowX map(RowX row) {
        BigDecimal ecreturnamount = row.getBigDecimal(this.idxs.get("ecreturnamount").intValue());
        String platform = row.getString(this.idxs.get("platform").intValue());
        BigDecimal amount = row.getBigDecimal(this.idxs.get("amount").intValue());
        BigDecimal taxamount_return = row.getBigDecimal(this.idxs.get("taxamount_return").intValue());
        BigDecimal taxamount_receipt_return = row.getBigDecimal(this.idxs.get("taxamount_receipt_return").intValue());
        row.set(this.idxs.get("tradingamount").intValue(), (Object)amount);
        if (!EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platform) && ecreturnamount != null) {
            row.set(this.idxs.get("tradingamount").intValue(), (Object)amount.subtract(ecreturnamount));
        } else {
            if (taxamount_receipt_return != null) {
                row.set(this.idxs.get("tradingamount").intValue(), (Object)amount.subtract(taxamount_receipt_return));
            }
            if (taxamount_return != null) {
                row.set(this.idxs.get("tradingamount").intValue(), (Object)amount.subtract(taxamount_return));
            }
        }
        return row;
    }
}

