/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pmm.business.model.product.ProdMatMapping;
import kd.scm.pmm.business.service.impl.ProdMatMappingServiceImpl;
import kd.scm.pmm.service.IPmmMatMappingService;

public class PmmMatMappingServiceImpl
implements IPmmMatMappingService {
    public Map<Long, Long> syncProdMaterialMapping(Map<Long, Long> goodsIdMaterialIdMap) {
        if (goodsIdMaterialIdMap == null || goodsIdMaterialIdMap.isEmpty()) {
            return new HashMap<Long, Long>();
        }
        HashSet<ProdMatMapping> prodMatMappings = new HashSet<ProdMatMapping>(goodsIdMaterialIdMap.size());
        for (Map.Entry<Long, Long> entry : goodsIdMaterialIdMap.entrySet()) {
            prodMatMappings.add(new ProdMatMapping(entry.getKey(), entry.getValue()));
        }
        ProdMatMappingServiceImpl prodMatMappingService = new ProdMatMappingServiceImpl();
        return prodMatMappingService.saveProdMatMappingWithRes(prodMatMappings);
    }

    public Map<Long, List<Long>> getMaterialIdsByGoodsCategoryMapping(Long goodsCategoryId) {
        return new ProdMatMappingServiceImpl().getMaterialIdsByGoodsCategoryMapping(goodsCategoryId);
    }

    public Map<Long, Long> queryProdMaterialMapping(List<Map<String, Object>> goodsMappingArgs) {
        LinkedHashMap<Long, Long> res = new LinkedHashMap<Long, Long>(goodsMappingArgs.size() << 2);
        ArrayList<Long> goodsIds = new ArrayList<Long>(goodsMappingArgs.size());
        ArrayList<String> protocolNos = new ArrayList<String>(goodsMappingArgs.size());
        HashMap<Long, Long> goodsIdToCategoryIdMap = new HashMap<Long, Long>(goodsMappingArgs.size() << 2);
        HashMap<Long, Long> goodsIdToPurTypeIdMap = new HashMap<Long, Long>(goodsMappingArgs.size() << 2);
        for (Map<String, Object> arg : goodsMappingArgs) {
            Long goodsId = (Long)arg.get("goodsId");
            Long categoryId = (Long)arg.get("categoryId");
            Long purTypeId = (Long)arg.get("purchaseTypeId");
            String protocolNo = (String)arg.get("protocolNo");
            if (StringUtils.isNotBlank((CharSequence)protocolNo)) {
                protocolNos.add(protocolNo);
            }
            if (goodsId == null) continue;
            goodsIds.add(goodsId);
            if (categoryId != null) {
                goodsIdToCategoryIdMap.put(goodsId, categoryId);
            }
            if (purTypeId == null) continue;
            goodsIdToPurTypeIdMap.put(goodsId, purTypeId);
        }
        res.putAll(this.queryFromProdMatMapping(goodsIds, goodsIdToCategoryIdMap, goodsIdToPurTypeIdMap));
        res.putAll(this.queryFromProdAudit(goodsIds, protocolNos));
        return res;
    }

    private Map<Long, Long> queryFromProdAudit(List<Long> goodsIds, List<String> protocolNos) {
        HashMap<Long, Long> res = new HashMap<Long, Long>(goodsIds.size() << 2);
        QFilter qFilter = new QFilter("entryentity.goods", "in", goodsIds);
        qFilter.and(new QFilter("protocolid.billno", "in", protocolNos));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qFilter.and(new QFilter("entryentity.entryresult", "=", (Object)"1"));
        String selectFields = "entryentity.material.id,entryentity.goods.id,protocolid.billno";
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pmm_prodaudit", (String)selectFields, (QFilter[])qFilter.toArray(), null);){
            ds.forEach(row -> {
                long materialId = row.getLong("entryentity.material.id");
                long goodsId = row.getLong("entryentity.goods.id");
                if (materialId != 0L) {
                    res.put(goodsId, materialId);
                }
            });
        }
        return res;
    }

    private Map<Long, Long> queryFromProdMatMapping(List<Long> goodsIds, Map<Long, Long> goodsIdToCategoryIdMap, Map<Long, Long> goodsIdToPurTypeIdMap) {
        HashMap<Long, Long> res = new HashMap<Long, Long>();
        QFilter prodfilters = new QFilter("goods", "in", goodsIds);
        String selectedFields = "goods.id,material.id,category.id,purchasetype.id";
        try (DataSet prodMappingDs = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pmm_prodmatmapping", (String)selectedFields, (QFilter[])new QFilter[]{prodfilters}, (String)"modifytime desc");){
            prodMappingDs.forEach(row -> {
                Long goodsId = row.getLong("goods.id");
                Long purchaseTypeId = row.getLong("purchasetype.id");
                Long categoryId = row.getLong("category.id");
                Long materialId = row.getLong("material.id");
                if (materialId != 0L) {
                    res.put(goodsId, materialId);
                }
                Long catMappingMaterialId = (Long)goodsIdToCategoryIdMap.get(goodsId);
                if (categoryId != 0L && catMappingMaterialId != null) {
                    res.putIfAbsent(goodsId, catMappingMaterialId);
                }
                Long purTypeMappingMaterialId = (Long)goodsIdToPurTypeIdMap.get(goodsId);
                if (purchaseTypeId != 0L && purTypeMappingMaterialId != null) {
                    res.putIfAbsent(goodsId, purTypeMappingMaterialId);
                }
            });
        }
        return res;
    }
}

