/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.pmm.service.IPmmSrcContactToProtocolAfterConvertService;

public class PmmSrcContactToProtocolAfterConvertServiceImpl
implements IPmmSrcContactToProtocolAfterConvertService {
    private static Log log = LogFactory.getLog(PmmSrcContactToProtocolAfterConvertServiceImpl.class);

    public Map<Long, Map<String, Object>> getUpdateFieldMap(Map<Long, Long> srcContactEntryIdAndProtocolMap) {
        log.info("============PmmSrcContactToProtocolAfterConvertServiceImpl start============");
        log.info("PmmSrcContactToProtocolAfterConvertServiceImpl:srcContactEntryIdAndProtocolMap:" + SerializationUtils.toJsonString(srcContactEntryIdAndProtocolMap));
        DynamicObjectCollection srcContracts = QueryServiceHelper.query((String)"src_contract", (String)"id,creator,auditdate,entryentity.id,entryentity.supplier supplier", (QFilter[])new QFilter[]{new QFilter("entryentity.id", "in", srcContactEntryIdAndProtocolMap.keySet())});
        HashMap<Long, Map<String, Object>> protocolInfoMap = new HashMap<Long, Map<String, Object>>(srcContracts.size());
        HashMap<Long, List<Long>> supplierAndProtocolIdsMap = new HashMap<Long, List<Long>>(srcContracts.size());
        HashMap<Long, List<Long>> creatorAndProtocolIdsMap = new HashMap<Long, List<Long>>(srcContracts.size());
        for (DynamicObject srcContract : srcContracts) {
            Long protocolId = srcContactEntryIdAndProtocolMap.get(srcContract.getLong("entryentity.id"));
            if (protocolInfoMap.get(protocolId) != null) continue;
            Map infoMap = protocolInfoMap.computeIfAbsent(protocolId, map -> new HashMap(8));
            List protocolIdList = supplierAndProtocolIdsMap.computeIfAbsent(srcContract.getLong("supplier"), list -> new ArrayList());
            protocolIdList.add(protocolId);
            List protocolIdOfCreatorList = creatorAndProtocolIdsMap.computeIfAbsent(srcContract.getLong("creator"), list -> new ArrayList());
            protocolIdOfCreatorList.add(protocolId);
            Date auditShortDate = DateUtil.string2date((String)DateUtil.date2str((Date)srcContract.getDate("auditdate"), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd");
            infoMap.put("effectdate", auditShortDate);
            infoMap.put("protocolsigndate", auditShortDate);
            infoMap.put("invaliddate", DateUtil.addYear((Date)auditShortDate, (int)1));
            infoMap.put("isautosoldout", Boolean.TRUE);
        }
        this.addDeptInfo(creatorAndProtocolIdsMap, protocolInfoMap);
        this.addSupplierInfo(supplierAndProtocolIdsMap, protocolInfoMap);
        log.info("PmmSrcContactToProtocolAfterConvertServiceImpl:protocolInfoMap" + SerializationUtils.toJsonString(protocolInfoMap));
        log.info("============PmmSrcContactToProtocolAfterConvertServiceImpl end============");
        return protocolInfoMap;
    }

    private void addDeptInfo(Map<Long, List<Long>> creatorAndProtocolIdsMap, Map<Long, Map<String, Object>> protocolInfoMap) {
        log.info("PmmSrcContactToProtocolAfterConvertServiceImpl:creatorAndProtocolIdsMap" + SerializationUtils.toJsonString(creatorAndProtocolIdsMap));
        DynamicObjectCollection users = QueryServiceHelper.query((String)"bos_user", (String)"id,entryentity.dpt dpt,entryentity.ispartjob ispartjob", (QFilter[])new QFilter[]{new QFilter("id", "in", creatorAndProtocolIdsMap.keySet())});
        for (DynamicObject user : users) {
            List<Long> protocolIds = creatorAndProtocolIdsMap.get(user.getLong("id"));
            long dpt = user.getLong("dpt");
            if (user.getBoolean("ispartjob") || 0L == dpt) continue;
            for (Long protocolId : protocolIds) {
                Map<String, Object> infoMap = protocolInfoMap.get(protocolId);
                infoMap.put("handledept_id", dpt);
            }
        }
    }

    private void addSupplierInfo(Map<Long, List<Long>> supplierAndProtocolIdsMap, Map<Long, Map<String, Object>> protocolInfoMap) {
        log.info("PmmSrcContactToProtocolAfterConvertServiceImpl:supplierAndProtocolIdsMap" + SerializationUtils.toJsonString(supplierAndProtocolIdsMap));
        DynamicObjectCollection suppliers = QueryServiceHelper.query((String)"bd_supplier", (String)"id,issuppcolla", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierAndProtocolIdsMap.keySet())});
        for (DynamicObject supplier : suppliers) {
            Long bizPartner = BizPartnerUtil.getBizPartnerBySupplier((Object)supplier.getLong("id"));
            List<Long> protocolIds = supplierAndProtocolIdsMap.get(supplier.getLong("id"));
            boolean isSup = supplier.getBoolean("issuppcolla");
            for (Long protocolId : protocolIds) {
                Map<String, Object> infoMap = protocolInfoMap.get(protocolId);
                infoMap.put("issrm", isSup);
                infoMap.put("issupgood", isSup);
                infoMap.put("partyb_id", supplier.getLong("id"));
                infoMap.put("bizpartner_id", bizPartner);
            }
        }
    }
}

