/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.service.ecinit;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataManagerUtils;
import kd.bos.orm.datamanager.IDataManager;
import kd.bos.orm.datamanager.ReadWhere;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pmm.common.ecinit.entity.EcInitResultEntryRow;
import kd.scm.pmm.common.ecinit.entity.EcInitResultHeader;
import kd.scm.pmm.common.enums.TaskStatusEnum;
import kd.scm.pmm.service.ecinit.EcInitializeContext;
import kd.scm.pmm.service.ecinit.utils.TimeUtils;

public class EcInitResult {
    protected static final Log logger = LogFactory.getLog(EcInitResult.class);
    private IDataEntityType resultHeadType;
    private IDataEntityType resultEntryType;
    private EcInitResultHeader ecInitResult;

    public IDataEntityType getResultHeadType() {
        if (this.resultHeadType == null) {
            this.resultHeadType = OrmUtils.getDataEntityType(EcInitResultHeader.class);
        }
        return this.resultHeadType;
    }

    public IDataEntityType getResultEntryType() {
        if (this.resultEntryType == null) {
            this.resultEntryType = OrmUtils.getDataEntityType(EcInitResultEntryRow.class);
        }
        return this.resultEntryType;
    }

    public EcInitResultHeader getEcInitResult() {
        return this.ecInitResult;
    }

    public EcInitResultHeader loadOrCreateEcInitResult(EcInitializeContext context) {
        Long id = context.getInputArgs().getEcInitResultId();
        if (id == null || Long.compare(0L, id) == 0) {
            id = DBServiceHelper.genGlobalLongId();
        } else {
            this.ecInitResult = this.loadEcInitResult(id);
            if (this.ecInitResult != null) {
                return this.ecInitResult;
            }
        }
        this.ecInitResult = this.createAndSaveEcInitResult(context, id);
        context.getInputArgs().setEcInitResultId(id);
        return this.ecInitResult;
    }

    public void upateEcInitResult(int mProgess, String status) {
        if (this.ecInitResult == null) {
            return;
        }
        int totalProgress = this.ecInitResult.getProgress() + mProgess;
        if (mProgess >= 100) {
            this.ecInitResult.setProgress(100);
        } else if (totalProgress >= 100) {
            this.ecInitResult.setProgress(99);
        } else {
            this.ecInitResult.setProgress(totalProgress);
        }
        this.ecInitResult.setTime(TimeUtils.getSecond(this.ecInitResult.getStartTime(), TimeServiceHelper.now()));
        this.ecInitResult.setStatus(status);
        this.ecInitResult.setDirtyFlag("Progress");
        this.ecInitResult.setDirtyFlag("Time");
        this.ecInitResult.setDirtyFlag("Status");
        BusinessDataWriter.update((IDataEntityType)this.getResultHeadType(), (Object[])new Object[]{this.ecInitResult});
    }

    public void saveHeader() {
        if (this.ecInitResult != null) {
            BusinessDataWriter.update((IDataEntityType)this.getResultHeadType(), (Object[])new Object[]{this.ecInitResult});
        }
    }

    public void upateEcInitResultDetail(Long subTaskId, String status) {
        if (this.ecInitResult == null || subTaskId == null) {
            return;
        }
        EcInitResultEntryRow resultEntryRow = (EcInitResultEntryRow)this.ecInitResult.getEntryRows().get(subTaskId);
        if (resultEntryRow == null) {
            return;
        }
        resultEntryRow.setSubStatus(status);
        resultEntryRow.setDirtyFlag("SubStatus");
        if (TaskStatusEnum.TASK_DOING.getValue().equals(status)) {
            resultEntryRow.setSubStartTime(TimeServiceHelper.now());
            resultEntryRow.setDirtyFlag("SubStartTime");
            resultEntryRow.setDetail("");
            resultEntryRow.setDirtyFlag("Detail");
        }
        if (TaskStatusEnum.TASK_SUCCESS.getValue().equals(status)) {
            long oldTime = resultEntryRow.getSubTime();
            Long subTime = TimeUtils.getMilliSecond(resultEntryRow.getSubStartTime(), TimeServiceHelper.now());
            resultEntryRow.setSubTime(subTime + oldTime);
            resultEntryRow.setDirtyFlag("SubTime");
        }
        BusinessDataWriter.update((IDataEntityType)this.getResultEntryType(), (Object[])new Object[]{resultEntryRow});
    }

    private EcInitResultHeader createAndSaveEcInitResult(EcInitializeContext context, Long ecInitResultId) {
        DynamicObject taskConfig = context.getTaskConfig();
        EcInitResultHeader resultHeader = new EcInitResultHeader();
        Date startTime = TimeServiceHelper.now();
        resultHeader.setId(ecInitResultId.longValue());
        resultHeader.setTaskId(context.getTaskConfigId().longValue());
        resultHeader.setStartTime(startTime);
        resultHeader.setTime(0L);
        resultHeader.setStatus(TaskStatusEnum.TASK_DOING.getValue());
        resultHeader.setProgress(0);
        resultHeader.setExecutor(RequestContext.get().getCurrUserId());
        resultHeader.setEmalAuthId(context.getEcAdmitId().longValue());
        resultHeader.setCreateTime(startTime);
        resultHeader.setCreator(RequestContext.get().getCurrUserId());
        resultHeader.setModifyTime(startTime);
        resultHeader.setModifier(RequestContext.get().getCurrUserId());
        DynamicObjectCollection taskConfigEntrys = taskConfig.getDynamicObjectCollection("entryentity");
        int seq = 1;
        for (DynamicObject entry : taskConfigEntrys) {
            if (!entry.getBoolean("valid")) continue;
            EcInitResultEntryRow resultRow = new EcInitResultEntryRow();
            resultRow.setEntryId(DBServiceHelper.genGlobalLongId());
            resultRow.setId(ecInitResultId.longValue());
            resultRow.setSeq(seq);
            resultRow.setsubTaskId(entry.getLong("task.id"));
            resultRow.setSubStatus(TaskStatusEnum.TASK_NOSTART.getValue());
            if (seq == 1) {
                resultRow.setSubStartTime(startTime);
            }
            resultHeader.getEntryRows().put(resultRow.getSubTaskId(), resultRow);
            ++seq;
        }
        SaveServiceHelper.save((IDataEntityType)this.getResultHeadType(), (Object[])new Object[]{resultHeader});
        if (!resultHeader.getEntryRows().isEmpty()) {
            SaveServiceHelper.save((IDataEntityType)this.getResultEntryType(), (Object[])resultHeader.getEntryRows().values().toArray());
        }
        return resultHeader;
    }

    private EcInitResultHeader loadEcInitResult(Long ecInitResultId) {
        Object[] entryObjs;
        Object[] resultObjs = BusinessDataServiceHelper.load((Object[])new Object[]{ecInitResultId}, (IDataEntityType)this.getResultHeadType());
        if (resultObjs == null || resultObjs.length == 0) {
            return null;
        }
        EcInitResultHeader resultHeader = (EcInitResultHeader)resultObjs[0];
        IDataManager dataManager = DataManagerUtils.getDataManager((IDataEntityType)this.getResultEntryType());
        dataManager.setSelectHeadOnly(true);
        ArrayList<SqlParameter> sqlParams = new ArrayList<SqlParameter>(1);
        sqlParams.add(new SqlParameter("fid", -5, (Object)ecInitResultId));
        ReadWhere where = new ReadWhere("fid = ?", sqlParams);
        for (Object entryObj : entryObjs = dataManager.read(where)) {
            EcInitResultEntryRow entryRow = (EcInitResultEntryRow)entryObj;
            resultHeader.getEntryRows().put(entryRow.getSubTaskId(), entryRow);
        }
        return resultHeader;
    }

    public void resetEcInitResultHeader() {
        Date startTime = TimeServiceHelper.now();
        this.ecInitResult.setStartTime(startTime);
        this.ecInitResult.setTime(0L);
        this.ecInitResult.setStatus(TaskStatusEnum.TASK_DOING.getValue());
        this.ecInitResult.setProgress(0);
        this.ecInitResult.setExecutor(RequestContext.get().getCurrUserId());
        SaveServiceHelper.save((IDataEntityType)this.getResultHeadType(), (Object[])new Object[]{this.ecInitResult});
    }
}

