/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.service.ecinit;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pmm.common.ecinit.entity.EcInitializeArgs;
import kd.scm.pmm.common.enums.TaskStatusEnum;
import kd.scm.pmm.service.ecinit.EcInitResultManager;
import kd.scm.pmm.service.ecinit.EcInitializeContext;
import kd.scm.pmm.service.ecinit.IEcInitializeAction;
import kd.scm.pmm.service.ecinit.utils.TimeUtils;

public class EcInitializeEngine {
    private static final Log LOG = LogFactory.getLog(EcInitializeEngine.class);
    private EcInitializeContext context;
    private EcInitResultManager resultManager;
    private static final IAppCache redisBdCache = AppCache.get((String)"scm");

    public void doEcInitialize(EcInitializeArgs ecInitializeArgs) {
        String msg = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5f00\u59cb,\u53c2\u6570: ", (String)"EcInitializeEngine_0", (String)"scm-pmm-mservice", (Object[])new Object[0]);
        LOG.info("EcInitializeEngine.doEcInitialize:" + EcPlatformEnum.fromVal((String)ecInitializeArgs.getPlatform()).getName() + msg + ecInitializeArgs);
        this.context = new EcInitializeContext();
        this.context.setInputArgs(ecInitializeArgs);
        this.context.setIgnoreException(ecInitializeArgs.isIgnoreExcetions());
        Long taskConfigId = ecInitializeArgs.getTaskConfigId();
        this.context.setTaskConfigId(taskConfigId);
        this.context.setEcAdmitId(ecInitializeArgs.getId());
        DynamicObject config = BusinessDataServiceHelper.loadSingle((Object)taskConfigId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmm_initconfig"));
        if (config == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5546\u57ce\u521d\u59cb\u5316\u914d\u7f6e\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5", (String)"EcInitializeEngine_1", (String)"scm-pmm-mservice", (Object[])new Object[0]));
        }
        this.context.setTaskConfig(config);
        this.resultManager = new EcInitResultManager();
        this.handleTask(this.context, this.resultManager);
        LOG.info(ResManager.loadKDString((String)"EcInitializeEngine.doEcInitialize:\u521d\u59cb\u5316\u7ed3\u675f", (String)"EcInitializeEngine_2", (String)"scm-pmm-mservice", (Object[])new Object[0]));
    }

    private void innerDoTask(EcInitializeContext context, DynamicObject config, EcInitResultManager resultManager) {
        LinkedHashMap<Object, Object> actionsMap = new LinkedHashMap<Long, String>(16);
        if (CollectionUtils.isEmpty(context.getActionsToBeRunMap())) {
            actionsMap = this.getActions(config, context);
            context.getActionsToBeRunMap().putAll(actionsMap);
        } else {
            actionsMap.putAll(context.getActionsToBeRunMap());
        }
        if (CollectionUtils.isEmpty(actionsMap)) {
            throw new KDException(new ErrorCode("EcInitEngine init faild", ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5f15\u64ce\u5931\u8d25\u3002", (String)"EcInitializeEngine_3", (String)"scm-pmm-mservice", (Object[])new Object[0])), new Object[0]);
        }
        for (Map.Entry<Object, Object> entry : actionsMap.entrySet()) {
            String className = (String)entry.getValue();
            IEcInitializeAction action = this.getClass(className);
            if (null == action) {
                String msg = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5f15\u64ce\u6267\u884c\u5668\u5931\u8d25\uff1a", (String)"EcInitializeEngine_4", (String)"scm-pmm-mservice", (Object[])new Object[0]);
                throw new KDException(new ErrorCode("EcInitEngine init faild", msg + className), new Object[0]);
            }
            if (StringUtils.equals((CharSequence)((CharSequence)redisBdCache.get(this.getSuspendingKey(), String.class)), (CharSequence)"true")) {
                String msg = ResManager.loadKDString((String)"\u624b\u5de5\u6267\u884c\u4e2d\u6b62", (String)"EcInitializeEngine_7", (String)"scm-pmm-mservice", (Object[])new Object[0]);
                throw new KDException(new ErrorCode("Excute suspeding", msg + className), new Object[0]);
            }
            action.setSubTaskId((Long)entry.getKey());
            action.setContext(context);
            action.setResultManager(resultManager);
            action.execute();
            context.getActionsToBeRunMap().remove(entry.getKey());
            this.saveContext(context);
        }
    }

    private String getSuspendingKey() {
        return RequestContext.get().getTenantId() + "_" + "isSuspending";
    }

    public void retryEcInitialize(Long ecInitResultId) {
        LOG.info(ResManager.loadKDString((String)"EcInitializeEngine.retryEcInitialize\u5f00\u59cb", (String)"EcInitializeEngine_5", (String)"scm-pmm-mservice", (Object[])new Object[0]));
        DynamicObject ecInitResult = BusinessDataServiceHelper.loadSingle((Object)ecInitResultId, (String)"pmm_initresult", (String)"id,context");
        String contextStr = ecInitResult.getString("context");
        EcInitializeContext context = this.deSerializeConetext(contextStr);
        EcInitResultManager resultManager = new EcInitResultManager();
        resultManager.create(context);
        this.setInitStatus(context);
        this.handleTask(context, resultManager);
        LOG.info(ResManager.loadKDString((String)"EcInitializeEngine.retryEcInitialize:\u91cd\u8bd5\u7ed3\u675f", (String)"EcInitializeEngine_6", (String)"scm-pmm-mservice", (Object[])new Object[0]));
    }

    public void retryBySkipCurrFailedTask(Long ecInitResultId) {
        LOG.info(ResManager.loadKDString((String)"EcInitializeEngine.retryBySkipCurrFailedTask\u5f00\u59cb", (String)"EcInitializeEngine_8", (String)"scm-pmm-mservice", (Object[])new Object[0]));
        DynamicObject ecInitResult = BusinessDataServiceHelper.loadSingle((Object)ecInitResultId, (String)"pmm_initresult", (String)"id,context,entryentity.subtask,entryentity.substatus,entryentity.detail");
        String contextStr = ecInitResult.getString("context");
        EcInitializeContext context = this.deSerializeConetext(contextStr);
        this.setManualHandle(ecInitResult, context);
        EcInitResultManager resultManager = new EcInitResultManager();
        resultManager.create(context);
        this.setInitStatus(context);
        this.handleTask(context, resultManager);
        LOG.info(ResManager.loadKDString((String)"EcInitializeEngine.retryEcInitialize:\u91cd\u8bd5\u7ed3\u675f", (String)"EcInitializeEngine_9", (String)"scm-pmm-mservice", (Object[])new Object[0]));
    }

    private void setManualHandle(DynamicObject ecInitResult, EcInitializeContext context) {
        DynamicObjectCollection entrys = ecInitResult.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            String status = entry.getString("substatus");
            if (!TaskStatusEnum.TASK_FAIL.getValue().equals(status) && !TaskStatusEnum.TASK_DOING.getValue().equals(status)) continue;
            entry.set("substatus", (Object)TaskStatusEnum.TASK_SUCCESS.getValue());
            entry.set("detail", (Object)ResManager.loadKDString((String)"\u624b\u5de5\u6807\u8fc7", (String)"EcInitializeEngine_10", (String)"scm-pmm-mservice", (Object[])new Object[0]));
            context.getActionsToBeRunMap().remove(entry.getLong("subtask.id"));
            break;
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ecInitResult});
    }

    private void setInitStatus(EcInitializeContext context) {
        Long ecAdmitId = context.getEcAdmitId();
        DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)ecAdmitId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmm_ecadmit"));
        dyo.set("openstatus", (Object)"4");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyo});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTask(EcInitializeContext context, EcInitResultManager resultManager) {
        StringBuilder errMsg = new StringBuilder();
        if (MutexHelper.require((String)"pmm_ecadmit", (Object)context.getInputArgs().getId(), (String)"open", (StringBuilder)errMsg)) {
            try {
                this.innerDoTask(context, context.getTaskConfig(), resultManager);
                resultManager.getEcInitResult().upateEcInitResult(100, TaskStatusEnum.TASK_SUCCESS.getValue());
            }
            catch (Throwable e) {
                LOG.error(e);
                this.writeErroToEcInitResult(context.getInputArgs().getEcInitResultId(), e, context);
                this.failEcAdmint(context.getEcAdmitId());
            }
            finally {
                MutexHelper.release((String)"pmm_ecadmit", (String)"open", (String)String.valueOf(context.getInputArgs().getId()));
                redisBdCache.remove(this.getSuspendingKey());
            }
        }
    }

    private LinkedHashMap<Long, String> getActions(DynamicObject configObj, EcInitializeContext context) {
        LinkedHashMap<Long, String> actions = new LinkedHashMap<Long, String>(16);
        if (null != configObj) {
            DynamicObjectCollection col = configObj.getDynamicObjectCollection("entryentity");
            col.sort((Comparator)new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    return o1.getInt("subsort") - o2.getInt("subsort");
                }
            });
            for (DynamicObject entry : col) {
                String className = entry.getString("task.classname");
                if (StringUtils.isBlank((CharSequence)className) || !entry.getBoolean("valid")) continue;
                actions.putIfAbsent(entry.getLong("task.id"), className);
            }
        }
        return actions;
    }

    private IEcInitializeAction getClass(String calssName) {
        try {
            Class<?> clazz = Class.forName(calssName);
            return (IEcInitializeAction)clazz.newInstance();
        }
        catch (Exception e) {
            LOG.info(ExceptionUtil.getStackTrace((Throwable)e));
            return null;
        }
    }

    private void failEcAdmint(Long ecAdmitId) {
        DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)ecAdmitId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"pmm_ecadmit"));
        dyo.set("openstatus", (Object)"5");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyo});
    }

    public void saveContext(EcInitializeContext context) {
        Long ecInitResultId = context.getInputArgs().getEcInitResultId();
        QFilter filter = new QFilter("id", "=", (Object)ecInitResultId);
        DynamicObject[] resultDyos = BusinessDataServiceHelper.load((String)"pmm_initresult", (String)"id,context", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        if (resultDyos == null || resultDyos.length == 0) {
            return;
        }
        DynamicObject resultDyo = resultDyos[0];
        EcInitializeContext copyContext = new EcInitializeContext();
        copyContext.setActionsToBeRunMap(context.getActionsToBeRunMap());
        copyContext.setEcAdmitId(context.getEcAdmitId());
        copyContext.setIgnoreException(context.isIgnoreException());
        copyContext.setInputArgs(context.getInputArgs());
        copyContext.setTaskConfigId(context.getTaskConfigId());
        resultDyo.set("context", (Object)this.serializeContext(copyContext));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{resultDyo});
    }

    private void writeErroToEcInitResult(Long ecInitResultId, Throwable ex, EcInitializeContext context) {
        if (ecInitResultId == null) {
            return;
        }
        if (ex == null) {
            return;
        }
        String errInfo = ExceptionUtil.wrapExceptionErrorInfo((Throwable)ex);
        QFilter filter = new QFilter("id", "=", (Object)ecInitResultId);
        DynamicObject[] resultDyos = BusinessDataServiceHelper.load((String)"pmm_initresult", (String)"id,progress,time,starttime,status,context,entryentity.subtask,entryentity.substarttime,entryentity.subtime,entryentity.substatus,entryentity.detail", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        if (resultDyos == null || resultDyos.length == 0) {
            return;
        }
        DynamicObject resultDyo = resultDyos[0];
        resultDyo.set("progress", (Object)100);
        resultDyo.set("time", (Object)TimeUtils.getSecond(resultDyo.getDate("starttime"), TimeServiceHelper.now()));
        resultDyo.set("status", (Object)TaskStatusEnum.TASK_FAIL.getValue());
        resultDyo.set("context", (Object)this.serializeContext(context));
        DynamicObjectCollection entrys = resultDyo.getDynamicObjectCollection("entryentity");
        DynamicObject doingEntry = null;
        for (DynamicObject entry : entrys) {
            String status = entry.getString("substatus");
            if (TaskStatusEnum.TASK_DOING.getValue().equals(status) || TaskStatusEnum.TASK_FAIL.getValue().equals(status)) {
                doingEntry = entry;
                break;
            }
            if (doingEntry != null || !TaskStatusEnum.TASK_NOSTART.getValue().equals(entry.getString("substatus"))) continue;
            doingEntry = entry;
        }
        if (doingEntry == null && !entrys.isEmpty()) {
            doingEntry = (DynamicObject)entrys.get(entrys.size() - 1);
        }
        if (doingEntry != null) {
            if (doingEntry.getInt("subtime") == 0) {
                doingEntry.set("substarttime", (Object)TimeServiceHelper.now());
                doingEntry.set("subtime", (Object)"1");
            }
            doingEntry.set("substatus", (Object)"3");
            doingEntry.set("detail", (Object)(errInfo.length() > 2000 ? errInfo.substring(0, 2000) : errInfo));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{resultDyo});
    }

    private String serializeContext(EcInitializeContext context) {
        context.setTaskConfig(null);
        context.getSubTaskMapConfig().clear();
        return SerializationUtils.toJsonString((Object)context);
    }

    private EcInitializeContext deSerializeConetext(String contextStr) {
        if (StringUtils.isBlank((CharSequence)contextStr)) {
            return new EcInitializeContext();
        }
        EcInitializeContext context = (EcInitializeContext)SerializationUtils.fromJsonString((String)contextStr, EcInitializeContext.class);
        DynamicObject taskConfig = BusinessDataServiceHelper.loadSingle((Object)context.getTaskConfigId(), (String)"pmm_initconfig");
        context.setTaskConfig(taskConfig);
        return context;
    }
}

