/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.service.ecinit.action;

import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pmm.common.ecinit.entity.EcInitializeArgs;
import kd.scm.pmm.common.enums.TaskStatusEnum;
import kd.scm.pmm.service.ecinit.AbstractEcInitializeAction;
import kd.scm.pmm.service.ecinit.EcInitResult;
import kd.scm.pmm.service.ecinit.utils.ExceptionWrapper;

public class EcClassExcelImportAction
extends AbstractEcInitializeAction {
    private static Log log = LogFactory.getLog(EcClassExcelImportAction.class);
    private static final String billFormId = "mdr_goodsclass";
    private static final String BOS_IMPORTLOG = "bos_importlog";

    @Override
    public void doExecute() {
        log.info("EcClassExcelImportAction.doExecute:\u5546\u54c1\u5206\u7c7bExcel\u5bfc\u5165\u5f00\u59cb");
        EcInitResult ecInitResult = this.getResultManager().getEcInitResult();
        ecInitResult.upateEcInitResultDetail(this.getSubTaskId(), TaskStatusEnum.TASK_DOING.getValue());
        EcInitializeArgs args = this.getContext().getInputArgs();
        Object logId = this.createImportlog(billFormId, ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b", (String)"EcClassExcelImportAction_0", (String)"scm-pmm-mservice", (Object[])new Object[0]));
        DispatchServiceHelper.invokeBOSServiceByAppId((String)"pmm", (String)"importService", (String)"startImport", (Object[])new Object[]{args.getPageId(), logId.toString()});
        DynamicObject subTaskConfig = this.getContext().getSubTaskMapConfig().get(this.getSubTaskId());
        String param = subTaskConfig.getString("param");
        String internalTimes = "30";
        if (StringUtils.isNotBlank((CharSequence)param)) {
            internalTimes = param.split(",")[0];
        }
        boolean flag = true;
        boolean success = false;
        int waitTimes = 0;
        QFilter filter = new QFilter("id", "=", logId);
        try {
            while (flag) {
                Thread.sleep(2000L);
                ++waitTimes;
                DynamicObject dyo = QueryServiceHelper.queryOne((String)BOS_IMPORTLOG, (String)"importstatus", (QFilter[])new QFilter[]{filter});
                String state = dyo.getString("importstatus");
                if (StringUtils.equals((CharSequence)"1", (CharSequence)state)) {
                    flag = false;
                    success = true;
                    continue;
                }
                if (waitTimes <= Parser.toInt((Object)internalTimes)) continue;
                flag = false;
            }
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u5bfc\u5165\u5546\u54c1\u5206\u7c7b\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a", (String)"EcClassExcelImportAction_1", (String)"scm-pmm-mservice", (Object[])new Object[0]);
            ExceptionWrapper.wrapExceptions(this.getContext().isIgnoreException(), msg + ExceptionUtil.getStackTrace((Throwable)e));
        }
        if (!success) {
            ExceptionWrapper.wrapExceptions(this.getContext().isIgnoreException(), ResManager.loadKDString((String)"\u5bfc\u5165\u5546\u54c1\u5206\u7c7b\u5f02\u5e38\uff0c\u8bf7\u67e5\u8be2\u540e\u53f0\u65e5\u5fd7\u5206\u6790", (String)"EcClassExcelImportAction_2", (String)"scm-pmm-mservice", (Object[])new Object[0]));
        }
        ecInitResult.upateEcInitResult(5, TaskStatusEnum.TASK_DOING.getValue());
        ecInitResult.upateEcInitResultDetail(this.getSubTaskId(), TaskStatusEnum.TASK_SUCCESS.getValue());
        log.info("EcClassExcelImportAction.doExecute:\u5546\u54c1\u5206\u7c7bExcel\u5bfc\u5165\u7ed3\u675f");
    }

    private Object createImportlog(String billFormId, String name) {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)BOS_IMPORTLOG);
        DynamicObject dyn = (DynamicObject)objType.createInstance();
        dyn.set("name", (Object)name);
        dyn.set("billstatus", (Object)"C");
        dyn.set("importstatus", (Object)"0");
        dyn.set("createtime", (Object)TimeServiceHelper.now());
        String billno = CodeRuleServiceHelper.getNumber((String)BOS_IMPORTLOG, (DynamicObject)dyn, null);
        dyn.set("billno", (Object)billno);
        dyn = (DynamicObject)BusinessDataWriter.save((IDataEntityType)objType, (Object[])new Object[]{dyn})[0];
        return dyn.getPkValue();
    }
}

