/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.service.ecinit.action;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pmm.common.enums.TaskStatusEnum;
import kd.scm.pmm.service.ecinit.AbstractEcInitializeAction;
import kd.scm.pmm.service.ecinit.EcInitResult;
import kd.scm.pmm.service.ecinit.utils.ExceptionWrapper;

public class EcIscDataSourceUpdateAction
extends AbstractEcInitializeAction {
    private static final Log log = LogFactory.getLog(EcIscDataSourceUpdateAction.class);
    private static final String SELECTORS = "dblink,connection_type";

    @Override
    public void doExecute() {
        log.info("EcIscDataSourceUpdateAction.doExecute:\u6570\u636e\u6e90\u914d\u7f6e\uff0c\u8fde\u63a5\u7c7b\u578b\u542f\u7528\u5f00\u59cb");
        EcInitResult ecInitResult = this.getResultManager().getEcInitResult();
        ecInitResult.upateEcInitResultDetail(this.getSubTaskId(), TaskStatusEnum.TASK_DOING.getValue());
        DynamicObject subTaskConfig = this.getContext().getSubTaskMapConfig().get(this.getSubTaskId());
        String connectTypeId = this.getContext().getTaskConfig().getString("connecttype.id");
        if (StringUtils.isNotBlank((CharSequence)connectTypeId)) {
            this.doOperationByIds("isc_connection_type", "refresh_env", new Object[]{connectTypeId}, this.getOperateOption());
            QFilter filter = new QFilter("id", "=", (Object)connectTypeId).and(new QFilter("enable", "=", (Object)"0"));
            if (QueryServiceHelper.exists((String)"isc_connection_type", (QFilter[])new QFilter[]{filter})) {
                this.doOperationByIds("isc_connection_type", "enable", new Object[]{connectTypeId}, this.getOperateOption());
            }
        }
        String params = subTaskConfig.getString("param");
        String sourceName = this.getContext().getTaskConfig().getString("sourcename");
        if (StringUtils.isNotBlank((CharSequence)params)) {
            String[] strs = params.split(",");
            if (strs.length >= 2) {
                String ecDataSourceId = strs[0];
                String dbLinkId = strs[1];
                String selfDataSourceId = strs[2];
                this.setEcDataSource(ecDataSourceId, this.getOperateOption(), sourceName, dbLinkId);
                this.setSelfDataSource(selfDataSourceId, this.getOperateOption());
            }
        } else {
            ExceptionWrapper.wrapExceptions(this.getContext().isIgnoreException(), ResManager.loadKDString((String)"\u66f4\u65b0\u6570\u636e\u6e90\u8fde\u63a5\u5668\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7", (String)"EcIscDataSourceUpdateAction_0", (String)"scm-pmm-mservice", (Object[])new Object[0]));
        }
        ecInitResult.upateEcInitResult(2, TaskStatusEnum.TASK_DOING.getValue());
        ecInitResult.upateEcInitResultDetail(this.getSubTaskId(), TaskStatusEnum.TASK_SUCCESS.getValue());
        log.info("EcIscDataSourceUpdateAction.doExecute:\u6570\u636e\u6e90\u914d\u7f6e\uff0c\u8fde\u63a5\u7c7b\u578b\u542f\u7528\u7ed3\u675f");
    }

    private void setSelfDataSource(String selfDataSourceId, OperateOption option) {
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(selfDataSourceId));
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((String)"isc_data_source", (String)SELECTORS, (QFilter[])new QFilter[]{filter});
        if (null != dataSource && null == dataSource.getDynamicObject("dblink")) {
            DynamicObject dbLink = QueryServiceHelper.queryOne((String)"isc_database_link", (String)"id", (QFilter[])new QFilter[]{new QFilter("database_type", "=", (Object)"self")});
            if (null != dbLink) {
                dataSource.set("dblink_id", (Object)dbLink.getLong("id"));
            } else {
                Long id = this.createSelfDbLink(option);
                dataSource.set("dblink_id", (Object)id);
            }
            dataSource.set("connection_type", (Object)"self");
            this.doOperationByDataEntities("isc_data_source", "save", new DynamicObject[]{dataSource}, option);
        }
    }

    private void setEcDataSource(String ecDataSourceId, OperateOption option, String sourceName, String dbLinkId) {
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(ecDataSourceId));
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((String)"isc_data_source", (String)SELECTORS, (QFilter[])new QFilter[]{filter});
        dataSource.set("dblink_id", (Object)Long.parseLong(dbLinkId));
        dataSource.set("connection_type", (Object)sourceName);
        this.doOperationByDataEntities("isc_data_source", "save", new DynamicObject[]{dataSource}, option);
    }

    private Long createSelfDbLink(OperateOption option) {
        DynamicObject dbLink = BusinessDataServiceHelper.newDynamicObject((String)"isc_database_link");
        dbLink.set("number", (Object)"currentApp");
        dbLink.set("name", (Object)"currentApp");
        dbLink.set("database_type", (Object)"self");
        OperationResult opRes = this.doOperationByDataEntities("isc_database_link", "save", new DynamicObject[]{dbLink}, option);
        return (Long)opRes.getSuccessPkIds().get(0);
    }
}

