/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.service.event;

import java.util.ArrayList;
import java.util.List;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.fulltext.utils.PbdMalElasticSearchUtils;
import kd.scm.common.util.MalOrderUtil;

public class PmmSrmSupplierChangeUpdateFullTextPlugin
implements IEventServicePlugin {
    private static final Log logger = LogFactory.getLog(PmmSrmSupplierChangeUpdateFullTextPlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        logger.info("srm_supchange.chgeffect.executePlugin start");
        logger.info("EntityEventNumber:" + evt.getEventNumber() + ", EntityEventId" + evt.getEventId());
        EntityEvent entityEvent = null;
        if (evt instanceof EntityEvent) {
            entityEvent = (EntityEvent)evt;
        }
        if (entityEvent == null) {
            logger.info("srm_supchange.chgeffect.executePlugin: evt == null");
            return evt.getEventId();
        }
        ArrayList<Long> pkIds = new ArrayList<Long>(entityEvent.getBusinesskeys().size());
        for (String businesskey : entityEvent.getBusinesskeys()) {
            pkIds.add(Long.valueOf(businesskey));
        }
        this.updateProdFullText(pkIds);
        return evt.getEventId();
    }

    private void updateProdFullText(List<Long> pkIds) {
        if (MalOrderUtil.getDefaultMalVersion()) {
            DynamicObject[] srmSupChangeArray = BusinessDataServiceHelper.load((String)"srm_supchange", (String)"id,supplier", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
            ArrayList<Long> supplierPkIds = new ArrayList<Long>(srmSupChangeArray.length);
            for (DynamicObject dynamicObject : srmSupChangeArray) {
                supplierPkIds.add(dynamicObject.getDynamicObject("supplier").getDynamicObject("supplier").getLong("id"));
            }
            DynamicObjectCollection pmmProdManageArray = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,supplier", (QFilter[])new QFilter[]{new QFilter("supplier", "in", supplierPkIds)});
            logger.info("\u5546\u57ce\u7248\u672c\u53c2\u6570\u4e3a\u65b0\u7248\u672c\uff0c\u540c\u6b65\u5546\u54c1\u57fa\u7840\u8d44\u6599\u6570\u636e\u3002");
            ArrayList<Long> goodsIds = new ArrayList<Long>(pmmProdManageArray.size());
            for (DynamicObject dyo : pmmProdManageArray) {
                goodsIds.add(dyo.getLong("id"));
            }
            if (!goodsIds.isEmpty()) {
                PbdMalElasticSearchUtils.MalGoodsBatchSync((String)"pmm_prodmanage", goodsIds);
            }
        }
        logger.info("srm_supchange.chgeffect.executePlugin end");
    }
}

