/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.constant.BillAssistConstant;

public class PmmBatchCategoryMappingPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        Object classId = this.getView().getFormShowParameter().getCustomParam("classId");
        if (StringUtils.isNotBlank((Object)classId)) {
            this.getModel().setValue("goodscategory", (Object)Long.valueOf((String)classId));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit materialgroup = (BasedataEdit)this.getControl("materialgroup");
        materialgroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"materialgroup")) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qFilter = new QFilter("standard", "=", (Object)BillAssistConstant.MATERIAL_STANDARD_ID);
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("batchcreate".equals(operateKey)) {
            if (!this.checkPermission()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5206\u7c7b\u5bf9\u5e94\u201d\u7684\u201c\u6279\u91cf\u751f\u6210\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PmmBatchCategoryMappingPlugin_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Set<Long> newClassIds = this.getNewClassIds(this.getModel().getDataEntity());
            if (newClassIds.isEmpty()) {
                this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5546\u54c1\u5206\u7c7b\u4e0b\u7684\u4e09\u7ea7\u5206\u7c7b\u5747\u5df2\u7ef4\u62a4\u5bf9\u5e94\u5173\u7cfb\uff0c\u65e0\u65b0\u7684\u5bf9\u5e94\u5173\u7cfb\u751f\u6210\u3002", (String)"PmmBatchCategoryMappingPlugin_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                this.getView().sendFormAction(this.getView().getParentView());
                args.setCancel(true);
                this.getView().close();
            }
        }
    }

    private boolean checkPermission() {
        String appId = AppMetadataCache.getAppInfo((String)"pmm").getId();
        return PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (String)appId, (String)"pmm_categorymatmapping", (String)"3E=1U09VENCW");
    }

    private Set<Long> getNewClassIds(DynamicObject dynamicObject) {
        DynamicObject goodsCategory = dynamicObject.getDynamicObject("goodscategory");
        String longnumber = goodsCategory.getString("longnumber");
        Long classStandardId = goodsCategory.getLong("standard_id");
        QFilter f1 = new QFilter("longnumber", "like", (Object)(longnumber + ".%"));
        QFilter f2 = new QFilter("standard.id", "=", (Object)classStandardId);
        QFilter f3 = new QFilter("level", "=", (Object)3);
        QFilter f4 = new QFilter("enable", "=", (Object)"1");
        QFilter[] qFilters = new QFilter[]{f1, f2, f3, f4};
        HashSet<Long> childClassIds = new HashSet<Long>();
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mdr_goodsclass", (String)"id", (QFilter[])qFilters, (String)"id");){
            dataSet.forEach(row -> childClassIds.add(row.getLong("id")));
        }
        dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pmm_categorymatmapping", (String)"goodscategory", (QFilter[])new QFilter[]{new QFilter("goodscategory", "in", childClassIds)}, (String)"id");
        var12_12 = null;
        try {
            dataSet.forEach(row -> childClassIds.remove(row.getLong("goodscategory")));
        }
        catch (Throwable throwable) {
            var12_12 = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (var12_12 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        var12_12.addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        return childClassIds;
    }
}

