/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.util.GetCategorysUtil;

public class PmmCategoryMapping
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String KEY_CONFIRM = "confirm";
    private static final String PRODCLASS = "prodclass";
    private static final String MAPPINGCLASS = "mappingid";
    protected static final String SOURCE_JD = "2";
    public static final String FOCUS_NODE_ID = "focusNodeId";
    private static final String SELECTCLASS = "selectclass";
    private static final String SELECTCATE = "selectcate";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String selectdClass = (String)this.getView().getFormShowParameter().getCustomParam(SELECTCLASS);
        if (null != selectdClass) {
            IDataModel model = this.getModel();
            model.setValue(PRODCLASS, (Object)selectdClass);
        }
        this.initTree();
        this.refreshEntry();
    }

    private void initTree() {
        TreeNode treenode = this.getCloudData(SOURCE_JD);
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        tree.deleteAllNodes();
        tree.addNode(treenode);
        tree.setRootVisible(true);
        tree.expand(treenode.getId());
    }

    public TreeNode getCloudData(String source) {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        TreeNode RootNode = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"PmmCategoryMapping_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        String rootid = RootNode.getId();
        QFilter filter = new QFilter("source", "=", null);
        if (source != null) {
            filter = new QFilter("source", "=", (Object)source);
        }
        filter.and("level", "!=", (Object)3);
        QFilter[] filters = new QFilter[]{filter};
        ORM orm = ORM.create();
        String orderby = "number";
        cloudNode.add(RootNode);
        try (DataSet ds = orm.queryDataSet("pbd_jdclass", "pbd_jdclass", this.assembleSelectFilds(), filters, orderby);){
            for (Row row : ds) {
                TreeNode node = new TreeNode();
                String nodeID = row.getString("id");
                String parentid = row.getString("parent.id");
                node.setText(row.getString("name"));
                if (RootNode.getId().equals(rootid) && parentid.equals("0")) {
                    node.setParentid(rootid);
                } else {
                    node.setParentid(parentid);
                }
                node.setId(nodeID);
                cloudNode.add(node);
            }
        }
        Map<String, TreeNode> nodes = this.buildTree(cloudNode);
        if (null != nodes.get(RootNode.getId())) {
            RootNode = nodes.get(RootNode.getId());
            RootNode.setParentid("");
        }
        return nodes.get(RootNode.getId());
    }

    private Map<String, TreeNode> buildTree(List<TreeNode> nodes) {
        HashMap<String, TreeNode> allNodes = new HashMap<String, TreeNode>((int)((double)nodes.size() / 0.75));
        for (TreeNode node : nodes) {
            allNodes.put(node.getId(), node);
        }
        for (TreeNode node : allNodes.values()) {
            TreeNode parentNode = (TreeNode)allNodes.get(node.getParentid());
            if (parentNode == null) continue;
            parentNode.addChild(node);
        }
        return allNodes;
    }

    public void refreshEntry() {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        QFilter filter = null;
        if (null != this.getPageCache().get(FOCUS_NODE_ID)) {
            ArrayList<String> nodeid = new ArrayList<String>();
            nodeid.add(this.getPageCache().get(FOCUS_NODE_ID));
            ArrayList nodelist = GetCategorysUtil.getAllLeafNodeByLevel(nodeid, (String)SOURCE_JD, (int)3);
            ArrayList nodeLongList = new ArrayList(nodelist.size());
            nodelist.forEach(id -> nodeLongList.add(Long.valueOf(id)));
            filter = new QFilter("id", "in", nodeLongList);
        } else {
            filter = new QFilter("source", "=", (Object)SOURCE_JD);
            filter.and("level", "=", (Object)3);
        }
        DynamicObject[] categories = BusinessDataServiceHelper.load((String)"pbd_jdclass", (String)this.assembleSelectFilds(), (QFilter[])new QFilter[]{filter});
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        ArrayList<Integer> selectrows = new ArrayList<Integer>();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        ArrayList selectCates = (ArrayList)this.getView().getFormShowParameter().getCustomParam(SELECTCATE);
        for (int i = 0; i < categories.length; ++i) {
            DynamicObject category = categories[i];
            vs.set("number", (Object)category.getPkValue().toString(), i);
            if (null == selectCates || !selectCates.contains(category.getPkValue().toString())) continue;
            selectrows.add(i);
        }
        int[] selects = new int[selectrows.size()];
        for (int i = 0; i < selectrows.size(); ++i) {
            selects[i] = (Integer)selectrows.get(i);
        }
        grid.selectRows(selects, 0);
        model.deleteEntryData(ENTRY_ENTITY);
        model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        treeView.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                PmmCategoryMapping.this.getPageCache().put(PmmCategoryMapping.FOCUS_NODE_ID, evt.getNodeId().toString());
                PmmCategoryMapping.this.refreshEntry();
            }
        });
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "confirm": {
                this.confirm();
                break;
            }
        }
    }

    private void confirm() {
        if (!this.confirmcheck()) {
            return;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject prodclass = (DynamicObject)model.getValue(PRODCLASS);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selectrows = grid.getEntryState().getSelectedRows();
        ArrayList<Long> classId = new ArrayList<Long>(selectrows.length);
        for (int i = 0; i < selectrows.length; ++i) {
            DynamicObject cate = model.getEntryRowEntity(ENTRY_ENTITY, selectrows[i]);
            classId.add((Long)cate.getDynamicObject("number").getPkValue());
        }
        HashMap<String, ArrayList<Long>> idmap = new HashMap<String, ArrayList<Long>>();
        idmap.put("in", classId);
        HashMap<String, HashMap<String, ArrayList<Long>>> params = new HashMap<String, HashMap<String, ArrayList<Long>>>();
        params.put("id", idmap);
        Object[] entries = ORMUtil.load((String)"pbd_jdclass", (String)this.assembleSelectFilds(), params);
        for (int i = 0; i < entries.length; ++i) {
            DynamicObject category = entries[i];
            category.set(MAPPINGCLASS, (Object)prodclass);
        }
        SaveServiceHelper.save((IDataEntityType)entries[0].getDataEntityType(), (Object[])entries);
        view.updateView();
        view.showTipNotification(ResManager.loadKDString((String)"\u5206\u7c7b\u5bf9\u5e94\u6210\u529f", (String)"PmmCategoryMapping_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
    }

    private boolean confirmcheck() {
        IDataModel model = this.getModel();
        DynamicObject prodclass = (DynamicObject)model.getValue(PRODCLASS);
        if (null == prodclass) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u81ea\u5efa\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PmmCategoryMapping_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selectrows = grid.getEntryState().getSelectedRows();
        if (selectrows.length == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u81f3\u5c11\u52fe\u9009\u4e00\u4e2a\u5206\u7c7b\u3002", (String)"PmmCategoryMapping_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private String assembleSelectFilds() {
        String selectFields = "id,number,name,parent.id,parent.number,parent.name,level,source,enable,mappingid";
        return selectFields;
    }
}

