/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.pmm.common.ecinit.entity.EcInitializeArgs;
import kd.scm.pmm.common.enums.TaskStatusEnum;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class PmmEcInitTaskRunningEdit
extends AbstractFormPlugin
implements ProgresssListener {
    private static final IAppCache redisBdCache = AppCache.get((String)"scm");
    private boolean canClose = false;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
        progressBar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btnback", "btncancel"});
    }

    public void onProgress(ProgressEvent e) {
        String taskId = this.getTaskId();
        boolean start = this.isStart();
        this.setStart(true);
        if (!start && StringUtils.isBlank((CharSequence)taskId)) {
            this.dispatchTask();
        } else if (!StringUtils.isBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (taskInfo.isTaskEnd()) {
                this.complete(taskInfo, e);
            } else {
                int progress = taskInfo.getProgress();
                if (progress >= 100) {
                    progress = 99;
                }
                e.setProgress(progress);
                Long resultId = Parser.toLong((Object)this.getTaskCustData(taskInfo).get("ecInitResultId"));
                this.showRunningDetails(resultId);
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String controlKey = ((Control)evt.getSource()).getKey();
        if ("btncancel".equals(controlKey)) {
            this.setSuspending(true);
            redisBdCache.put(RequestContext.get().getTenantId() + "_" + "isSuspending", (Object)"true");
            ScheduleServiceHelper.stopTask((String)this.getTaskId());
            this.stopBar();
        }
        if ("btnback".equals(controlKey)) {
            if (this.isStart() && !this.isSuspending()) {
                if (!this.canClose && !this.isFinished() && StringUtils.isNotBlank((CharSequence)this.getTaskId())) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u8981\u628a\u7535\u5546\u521d\u59cb\u5316\u8f6c\u4e3a\u540e\u53f0\u6267\u884c\uff1f", (String)"PmmEcInitTaskRunningEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("CLOSE_CONFIRMED", (IFormPlugin)this));
                    this.stopBar();
                    evt.setCancel(true);
                }
            } else {
                evt.setCancel(true);
            }
        }
    }

    private void showRunningDetails(Long ecInitResultId) {
        if (!QueryServiceHelper.exists((String)"pmm_initresult", (Object)ecInitResultId)) {
            return;
        }
        DynamicObject ecInitResult = BusinessDataServiceHelper.loadSingle((Object)ecInitResultId, (String)"pmm_initresult");
        String taskname = ecInitResult.getString("task.name");
        int doneStep = 0;
        String doingStep = ResManager.loadKDString((String)"\u6267\u884c\u4e2d", (String)"PmmEcInitTaskRunningEdit_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
        DynamicObjectCollection taskRecordEntrys = ecInitResult.getDynamicObjectCollection("entryentity");
        JSONArray taskDetailInfos = new JSONArray();
        for (DynamicObject entry : taskRecordEntrys) {
            JSONObject taskDetailInfo = new JSONObject();
            taskDetailInfo.accumulate("status", entry.get("substatus"));
            taskDetailInfo.accumulate("name", (Object)entry.getString("subtask.name"));
            if (TaskStatusEnum.TASK_SUCCESS.getValue().equals(entry.getString("substatus"))) {
                ++doneStep;
            }
            if (TaskStatusEnum.TASK_DOING.getValue().equals(entry.getString("substatus"))) {
                doingStep = entry.getString("subtask.name");
                break;
            }
            taskDetailInfos.add((Object)taskDetailInfo);
        }
        CustomControl taskRunningUI = (CustomControl)this.getView().getControl("tasksteps");
        JSONObject taskRunningUIPara = new JSONObject();
        taskRunningUIPara.accumulate("doneStep", doneStep);
        taskRunningUIPara.accumulate("totalStep", taskRecordEntrys.size());
        taskRunningUIPara.accumulate("doingStep", (Object)doingStep);
        taskRunningUIPara.accumulate("taskname", (Object)taskname);
        taskRunningUIPara.accumulate("taskDetailInfos", (Object)taskDetailInfos.toString());
        taskRunningUI.setData((Object)taskRunningUIPara.toString());
        Label currstep = (Label)this.getView().getControl("currsteplab");
        currstep.setText(doneStep + "/" + taskRecordEntrys.size() + doingStep);
    }

    private void complete(TaskInfo taskInfo, ProgressEvent e) {
        boolean isFinished = this.isFinished();
        this.setFinished(true);
        Map<String, Object> taskData = this.getTaskCustData(taskInfo);
        if (StringUtils.equalsIgnoreCase((CharSequence)"FAILED", (CharSequence)taskInfo.getStatus())) {
            this.stopBar();
        } else if (!isFinished) {
            e.setProgress(99);
            Long resultId = Parser.toLong((Object)taskData.get("ecInitResultId"));
            this.showRunningDetails(resultId);
        } else {
            e.setProgress(100);
            this.stopBar();
            this.closeForm();
        }
    }

    private void closeForm() {
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    private Map<String, Object> getTaskCustData(TaskInfo taskInfo) {
        String strData = taskInfo.getData();
        if (StringUtils.isBlank((CharSequence)strData)) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            if (!CollectionUtils.isEmpty((Map)params) && null != params.get("EcInitializeArgs")) {
                EcInitializeArgs args = (EcInitializeArgs)SerializationUtils.fromJsonString((String)Parser.toString(params.get("EcInitializeArgs")), EcInitializeArgs.class);
                HashMap<String, Object> taskCustData = new HashMap<String, Object>();
                taskCustData.put("ecInitResultId", args.getEcInitResultId());
                taskInfo.setData(SerializationUtils.toJsonString(taskCustData));
                return taskCustData;
            }
            return new HashMap<String, Object>();
        }
        Map data = (Map)SerializationUtils.fromJsonString((String)strData, Map.class);
        return data;
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get("isfinished");
        return StringUtils.isBlank((CharSequence)finished) ? false : Boolean.parseBoolean(finished);
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put("isfinished", String.valueOf(finished));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.startBar();
        String taskId = this.getTaskId();
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
            bar.setPercent(progress);
        }
        this.initRunningDetails();
    }

    private void initRunningDetails() {
        CustomControl taskRunningUI = (CustomControl)this.getView().getControl("tasksteps");
        JSONObject taskRunningUIPara = new JSONObject();
        taskRunningUIPara.accumulate("doneStep", (Object)"");
        taskRunningUIPara.accumulate("totalStep", (Object)"");
        taskRunningUIPara.accumulate("doingStep", (Object)"");
        taskRunningUIPara.accumulate("taskname", (Object)"");
        taskRunningUIPara.accumulate("taskDetailInfos", (Object)"");
        taskRunningUI.setData((Object)taskRunningUIPara);
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.buildJobFormInfo();
        if (jobFormInfo != null) {
            String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
            this.putTaskId(taskId);
            this.putJobFormInfo(jobFormInfo);
        }
    }

    private void putJobFormInfo(JobFormInfo jobFormInfo) {
        if (jobFormInfo == null) {
            this.getPageCache().remove("ecinit_jobforminfo");
        } else {
            String str = SerializationUtils.toJsonString((Object)jobFormInfo);
            this.getPageCache().put("ecinit_jobforminfo", str);
        }
    }

    private JobFormInfo buildJobFormInfo() {
        if (!this.checkCustParams()) {
            return null;
        }
        Map params = this.getView().getFormShowParameter().getCustomParams();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setName(String.format(ResManager.loadKDString((String)"%s\u521d\u59cb\u5316", (String)"PmmEcInitTaskRunningEdit_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]), EcPlatformEnum.fromVal((String)Parser.toString(params.get("platform"))).getName()));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        String routeAppId = this.getView().getFormShowParameter().getServiceAppId();
        jobInfo.setAppId(routeAppId);
        jobInfo.setTaskClassname("kd.scm.pmm.formplugin.task.PmmEcInitTask");
        jobInfo.setParams(this.getView().getFormShowParameter().getCustomParams());
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
        jobFormInfo.setRootPageId(this.getView().getFormShowParameter().getRootPageId());
        jobFormInfo.setClickClassName("kd.scm.pmm.formplugin.task.PmmEcInitTaskClick");
        return jobFormInfo;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        super.confirmCallBack(messageboxclosedevent);
        if (messageboxclosedevent.getResult() == MessageBoxResult.Yes) {
            this.toBackground();
        } else {
            ProgressBar bar = (ProgressBar)this.getControl("progressbarap");
            bar.start();
        }
    }

    private void toBackground() {
        this.closeForm();
        String taskId = this.getTaskId();
        if (!StringUtils.isBlank((CharSequence)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            if (!TaskClientProxy.isExistTask((String)taskId)) {
                JobFormInfo jobFormInfo = this.getJobFormInfo();
                TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)jobFormInfo, (TaskInfo)taskInfo);
                BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), jobFormInfo, taskId);
                ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
            }
        }
    }

    private JobFormInfo getJobFormInfo() {
        String str = null;
        str = this.getView().getFormShowParameter().getCustomParams().containsKey("ecinit_jobforminfo") ? (String)this.getView().getFormShowParameter().getCustomParam("ecinit_jobforminfo") : this.getPageCache().get("ecinit_jobforminfo");
        return StringUtils.isBlank((CharSequence)str) ? null : (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
    }

    private boolean checkCustParams() {
        EcInitializeArgs args;
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (!CollectionUtils.isEmpty((Map)params) && null != params.get("EcInitializeArgs")) {
            args = (EcInitializeArgs)SerializationUtils.fromJsonString((String)Parser.toString(params.get("EcInitializeArgs")), EcInitializeArgs.class);
            if (StringUtils.isBlank((CharSequence)args.getPageId())) {
                args.setPageId(this.getView().getPageId());
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7535\u5546\u521d\u59cb\u5316\u53c2\u6570\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PmmEcInitTaskRunningEdit_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.getView().getFormShowParameter().getCustomParams().put("EcInitializeArgs", SerializationUtils.toJsonString((Object)args));
        return true;
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
    }

    private String getTaskId() {
        return this.getView().getFormShowParameter().getCustomParams().containsKey("ecinit_taskid") ? (String)this.getView().getFormShowParameter().getCustomParam("ecinit_taskid") : this.getPageCache().get("ecinit_taskid");
    }

    private void putTaskId(String taskId) {
        this.getPageCache().put("ecinit_taskid", taskId);
        this.getView().getFormShowParameter().getCustomParams().put("ecinit_taskid", taskId);
    }

    private void setStart(boolean start) {
        this.getPageCache().put("isstart", String.valueOf(start));
    }

    private boolean isStart() {
        String start = this.getPageCache().get("isstart");
        return StringUtils.isBlank((CharSequence)start) ? false : Boolean.parseBoolean(start);
    }

    private void setSuspending(boolean suspending) {
        this.getPageCache().put("pmm_initresult", String.valueOf(suspending));
    }

    private boolean isSuspending() {
        String suspending = this.getPageCache().get("pmm_initresult");
        return StringUtils.isBlank((CharSequence)suspending) ? false : Boolean.parseBoolean(suspending);
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.stop();
    }
}

