/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.algo.util.io.IOUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.malcore.constant.MalConstant;

public class PmmImportPicturePlugin
extends AbstractFormPlugin
implements UploadListener {
    private static Log log = LogFactory.getLog(PmmImportPicturePlugin.class);
    private static String UPLOAD_FLAG = "uploadFlag";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar advToolBar = (Toolbar)this.getControl("advcontoolbarap");
        if (null != advToolBar) {
            advToolBar.addItemClickListener((ItemClickListener)this);
            advToolBar.addUploadListener((UploadListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object goodsIds = customParams.get("goodsIds");
        if (Objects.nonNull(goodsIds)) {
            this.allotEntity((List)goodsIds);
        }
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            String zipUrl = (String)urls[0];
            DynamicObjectCollection dynList = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            boolean thumbnailFlag = false;
            boolean pictureFlag = false;
            for (DynamicObject dyn : dynList) {
                DynamicObject goods = dyn.getDynamicObject("goods");
                if (goods == null) continue;
                thumbnailFlag = thumbnailFlag || "true".equals(this.getPageCache().get(goods.getString("number") + "_thumbnail"));
                boolean bl = pictureFlag = pictureFlag || "true".equals(this.getPageCache().get(goods.getString("number") + "_picture"));
                if (!thumbnailFlag && !pictureFlag) continue;
                break;
            }
            if (thumbnailFlag || pictureFlag) {
                this.getPageCache().put("uploadZipUrl", zipUrl);
                this.showConfirmPage("coverageConfirm");
            } else {
                this.uploadZipFile(zipUrl, true);
            }
        }
    }

    private void showConfirmPage(String closeCallBackId) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("pbd_picuploadcmf");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParam("param", (Object)closeCallBackId);
        param.setCustomParam("hiddenLabel", (Object)this.getPageCache().get("hiddenLabel"));
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, closeCallBackId));
        this.getView().showForm(param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closedCallBack(ClosedCallBackEvent callBackEvent) {
        Map data;
        Map taskinfo;
        super.closedCallBack(callBackEvent);
        String actionId = callBackEvent.getActionId();
        Object returnData = callBackEvent.getReturnData();
        if (returnData != null && "coverageConfirm".equals(actionId)) {
            String zipUrl = this.getPageCache().get("uploadZipUrl");
            this.uploadZipFile(zipUrl, "cover".equals(returnData.toString()));
        }
        if ("taskcloseback".equals(actionId) && returnData != null && (taskinfo = (Map)SerializationUtils.fromJsonString((String)((String)((Map)returnData).get("taskinfo")), Map.class)) != null && taskinfo.get("data") != null && "true".equals((data = (Map)SerializationUtils.fromJsonString((String)taskinfo.get("data").toString(), Map.class)).get("success"))) {
            this.getPageCache().remove(UPLOAD_FLAG);
            this.getPageCache().remove("coverFlag");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u56fe\u7247\u6210\u529f\u3002", (String)"PmmImportPicturePlugin_9", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        }
        if ("importtaskcloseback".equals(actionId) && returnData != null) {
            try {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"bar_save"});
                this.importtaskcloseback(returnData);
            }
            catch (Exception e) {
                try {
                    this.getView().showErrorNotification(e.getMessage());
                }
                catch (Throwable throwable) {
                    this.getView().setEnable(Boolean.valueOf(true), new String[]{"bar_save"});
                    throw throwable;
                }
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"bar_save"});
            }
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"bar_save"});
        }
    }

    private void importtaskcloseback(Object returnData) {
        Map data;
        Map taskinfo = (Map)SerializationUtils.fromJsonString((String)((String)((Map)returnData).get("taskinfo")), Map.class);
        if (taskinfo != null && taskinfo.get("data") != null && "true".equals((data = (Map)SerializationUtils.fromJsonString((String)taskinfo.get("data").toString(), Map.class)).get("success"))) {
            boolean coverFlag = Boolean.parseBoolean(data.get("coverflag").toString());
            Map picListMap = (Map)data.get("picListMap");
            int result = Integer.parseInt(data.get("result").toString());
            int successNum = this.setImageInfo(picListMap, coverFlag);
            this.getPageCache().put("coverFlag", coverFlag ? "true" : "false");
            this.getPageCache().put(UPLOAD_FLAG, "true");
            if (result == 1) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4e0a\u4f20\u6210\u529f\uff0c\u6709\u6548\u5bfc\u5165{0}\u5f20\u56fe\u7247\uff0c\u90e8\u5206\u5546\u54c1\u56fe\u7247\u547d\u540d\u683c\u5f0f\u9519\u8bef\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"PmmImportPicturePlugin_8", (String)"scm-pmm-formplugin", (Object[])new Object[]{successNum}), MessageBoxOptions.OK);
            } else if (result == 2) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4e0a\u4f20\u6210\u529f\uff0c\u6709\u6548\u5bfc\u5165{0}\u5f20\u56fe\u7247\uff0c\u90e8\u5206\u5546\u54c1\u7684\u56fe\u7247\u8d85\u51fa\u7cfb\u7edf\u9650\u5236\uff0c\u4ec5\u652f\u6301\u4e0a\u4f205\u5f20\u56fe\u7247\u3002", (String)"PmmImportPicturePlugin_0", (String)"scm-pmm-formplugin", (Object[])new Object[]{successNum}), MessageBoxOptions.OK);
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4e0a\u4f20\u6210\u529f\uff0c\u6709\u6548\u5bfc\u5165{0}\u5f20\u56fe\u7247\u3002", (String)"PmmImportPicturePlugin_1", (String)"scm-pmm-formplugin", (Object[])new Object[]{successNum}), MessageBoxOptions.OK);
            }
        }
    }

    private void uploadZipFile(String zipFileUrl, boolean coverFlag) {
        log.info("zipFileUrl=" + zipFileUrl + ";coverFlag=" + coverFlag);
        String message = this.checkValidImgZip(zipFileUrl);
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            this.getView().showErrorNotification(message);
        } else {
            try {
                this.doImportTask(zipFileUrl, coverFlag);
            }
            catch (KDBizException e) {
                this.getView().showErrorNotification(e.getMessage());
            }
        }
    }

    private int setImageInfo(Map<String, Map<Object, Map<String, String>>> picListMap, boolean coverFlag) {
        DynamicObjectCollection dynList = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        String domianUrl = UrlService.getDomainContextUrl() + "/";
        ArrayList<Map<String, String>> pictureUrlList = new ArrayList<Map<String, String>>(dynList.size() * 5);
        int successNum = 0;
        for (int i = 0; i < dynList.size(); ++i) {
            DynamicObject entry = (DynamicObject)dynList.get(i);
            DynamicObject goods = entry.getDynamicObject("goods");
            String number = goods.getString("number");
            Map<Object, Map<String, String>> picMap = picListMap.get(number);
            if (picMap == null) continue;
            for (Map.Entry<Object, Map<String, String>> entry1 : picMap.entrySet()) {
                if ("1".equals(entry1.getKey())) {
                    successNum += this.setImageUrl(entry, "thumbnail", domianUrl, entry1.getValue(), coverFlag, pictureUrlList);
                    continue;
                }
                successNum += this.setImageUrl(entry, "picture" + (Integer.parseInt(entry1.getKey().toString()) - 1), domianUrl, entry1.getValue(), coverFlag, pictureUrlList);
            }
        }
        this.saveTempAttachments(pictureUrlList);
        this.getView().updateView();
        return successNum;
    }

    private int setImageUrl(DynamicObject uploadEntry, String imageKey, String domianUrl, Map<String, String> urlMap, boolean coverFlag, List<Map<String, String>> pictureUrlList) {
        int success = 0;
        if (urlMap != null && !urlMap.isEmpty()) {
            String picture = uploadEntry.getString(imageKey);
            if (coverFlag) {
                uploadEntry.set(imageKey, (Object)(domianUrl + urlMap.get("url") + "&accountId=" + RequestContext.get().getAccountId()));
                pictureUrlList.add(urlMap);
                success = 1;
            } else if (StringUtils.isEmpty((CharSequence)picture)) {
                uploadEntry.set(imageKey, (Object)(domianUrl + urlMap.get("url") + "&accountId=" + RequestContext.get().getAccountId()));
                pictureUrlList.add(urlMap);
                success = 1;
            }
        }
        return success;
    }

    private List<DynamicObject> saveTempAttachments(List<Map<String, String>> pictureUrlList) {
        ArrayList<Map<String, Object>> attachmentList = new ArrayList<Map<String, Object>>(pictureUrlList.size());
        for (Map<String, String> pictureUrl : pictureUrlList) {
            Map<String, Object> attachment = this.saveUrlFile2TempAttachment(pictureUrl.get("name"), pictureUrl.get("url"));
            attachmentList.add(attachment);
        }
        return AttachmentFieldServiceHelper.saveAttachments((String)"pmm_importpicture", (String)this.getView().getPageId(), attachmentList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkValidImgZip(String url) {
        ZipEntry zipEntry;
        BufferedInputStream buffInputStream;
        InputStream inputStream;
        ZipInputStream zipInputStream;
        block9: {
            String string;
            TempFileCache fileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            zipInputStream = null;
            inputStream = null;
            buffInputStream = null;
            try {
                inputStream = fileCache.getInputStream(url);
                buffInputStream = new BufferedInputStream(inputStream, inputStream.available() + 1);
                zipInputStream = new ZipInputStream((InputStream)buffInputStream, Charset.forName("GBK"));
                zipEntry = zipInputStream.getNextEntry();
                if (zipEntry != null) break block9;
                string = ResManager.loadKDString((String)"\u56fe\u7247\u538b\u7f29\u5305\u5185\u6ca1\u6709\u56fe\u7247\u6587\u4ef6\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u56fe\u7247\u8d44\u6e90\u5305\u3002", (String)"PmmImportPicturePlugin_5", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            }
            catch (Exception e) {
                String string2;
                try {
                    log.error("checkValidImgZip create InputStream error is ", (Throwable)e);
                    string2 = ResManager.loadKDString((String)"\u538b\u7f29\u5305\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"PmmImportPicturePlugin_4", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(buffInputStream);
                    IOUtils.closeQuietly((AutoCloseable)inputStream);
                    IOUtils.closeQuietly(zipInputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((AutoCloseable)buffInputStream);
                IOUtils.closeQuietly((AutoCloseable)inputStream);
                IOUtils.closeQuietly((AutoCloseable)zipInputStream);
                return string2;
            }
            IOUtils.closeQuietly((AutoCloseable)buffInputStream);
            IOUtils.closeQuietly((AutoCloseable)inputStream);
            IOUtils.closeQuietly((AutoCloseable)zipInputStream);
            return string;
        }
        while (true) {
            block12: {
                block11: {
                    block10: {
                        if (null == zipEntry) break;
                        if (!zipEntry.isDirectory()) break block10;
                        String string = ResManager.loadKDString((String)"\u56fe\u7247\u538b\u7f29\u5305\u5185\u542b\u6709\u6587\u4ef6\u5939\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u56fe\u7247\u8d44\u6e90\u5305\u3002", (String)"PmmImportPicturePlugin_7", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                        IOUtils.closeQuietly((AutoCloseable)buffInputStream);
                        IOUtils.closeQuietly((AutoCloseable)inputStream);
                        IOUtils.closeQuietly((AutoCloseable)zipInputStream);
                        return string;
                    }
                    if (this.isImgName(zipEntry.getName())) break block11;
                    String string = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230{0}\u6587\u4ef6\u4e0d\u5c5e\u4e8e\u56fe\u7247\u6587\u4ef6\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u56fe\u7247\u8d44\u6e90\u5305\u3002", (String)"PmmImportPicturePlugin_3", (String)"scm-pmm-formplugin", (Object[])new Object[]{zipEntry.getName()});
                    IOUtils.closeQuietly((AutoCloseable)buffInputStream);
                    IOUtils.closeQuietly((AutoCloseable)inputStream);
                    IOUtils.closeQuietly((AutoCloseable)zipInputStream);
                    return string;
                }
                long size = zipEntry.getSize();
                if (size <= 0x100000L) break block12;
                String string = ResManager.loadKDString((String)"\u56fe\u7247({0})\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc71M\u3002", (String)"PmmImportPicturePlugin_6", (String)"scm-pmm-formplugin", (Object[])new Object[]{zipEntry.getName()});
                IOUtils.closeQuietly((AutoCloseable)buffInputStream);
                IOUtils.closeQuietly((AutoCloseable)inputStream);
                IOUtils.closeQuietly((AutoCloseable)zipInputStream);
                return string;
            }
            zipEntry = zipInputStream.getNextEntry();
            continue;
            break;
        }
        IOUtils.closeQuietly((AutoCloseable)buffInputStream);
        IOUtils.closeQuietly((AutoCloseable)inputStream);
        IOUtils.closeQuietly((AutoCloseable)zipInputStream);
        return null;
    }

    private boolean isImgName(String name) {
        for (String imgName : MalConstant.IMG_NAME_LIST) {
            if (!name.toLowerCase(Locale.ROOT).endsWith(imgName)) continue;
            return true;
        }
        return false;
    }

    private void allotEntity(List<Long> goodsIdsList) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        DynamicObjectCollection goodsList = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,number,thumbnail,picture1,picture2,picture3,picture4", (QFilter[])new QFilter[]{new QFilter("id", "in", goodsIdsList)});
        String hiddenLabel = "";
        TableValueSetter ts = new TableValueSetter(new String[0]);
        for (int i = 0; i < goodsList.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)goodsList.get(i);
            String number = dynamicObject.getString("number");
            ts.set("goods", (Object)dynamicObject.getLong("id"), i);
            if (StringUtils.isNotBlank((Object)dynamicObject.get("thumbnail"))) {
                ts.set("thumbnail", dynamicObject.get("thumbnail"), i);
                this.getPageCache().put(number + "_thumbnail", "true");
            } else {
                hiddenLabel = "increase";
            }
            for (int j = 1; j < 5; ++j) {
                String pictureKey = "picture" + j;
                String picture = dynamicObject.getString(pictureKey);
                if (StringUtils.isNotEmpty((CharSequence)picture)) {
                    ts.set(pictureKey, (Object)picture, i);
                    this.getPageCache().put(number + "_picture", "true");
                    continue;
                }
                hiddenLabel = "increase";
            }
        }
        this.getPageCache().put("hiddenLabel", hiddenLabel);
        model.batchCreateNewEntryRow("entryentity", ts);
    }

    private Map<String, Object> saveUrlFile2TempAttachment(String imageName, String imageUrl) {
        HashMap<String, Object> attachItem = new HashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)imageName) && (imageName = imageUrl).lastIndexOf(47) > 0) {
            imageName = imageName.substring(imageName.lastIndexOf(47) + 1);
        }
        attachItem.put("name", imageName);
        String tempUrl = imageUrl;
        attachItem.put("uid", UUID.randomUUID().toString());
        attachItem.put("url", tempUrl);
        attachItem.put("status", "success");
        attachItem.put("entityNum", "pmm_importpicture");
        attachItem.put("attKey", "picture");
        attachItem.put("client", "web");
        return attachItem;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        ArrayList<Integer> seqList = new ArrayList<Integer>(16);
        for (Object row : entryentity) {
            if (!StringUtils.isEmpty((CharSequence)row.getString("thumbnail"))) continue;
            seqList.add(row.getInt("seq"));
        }
        if ("save".equals(operateKey)) {
            if (seqList.size() > 0) {
                args.setCancel(true);
                StringBuilder strBuilder = new StringBuilder();
                for (Integer seq : seqList) {
                    strBuilder.append(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u4e3b\u56fe\u4e3a\u7a7a\u3002", (String)"PmmImportPicturePlugin_13", (String)"scm-pmm-formplugin", (Object[])new Object[]{seq})).append('\n');
                }
                String str = strBuilder.substring(0, strBuilder.length() - 1);
                this.getView().showMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u56fe\u7247\u5931\u8d25", (String)"PmmImportPicturePlugin_2", (String)"scm-pmm-formplugin", (Object[])new Object[]{str}), strBuilder.toString(), MessageTypes.Default);
            } else {
                try {
                    this.dotask();
                }
                catch (KDException e) {
                    log.error("\u56fe\u7247\u4e0a\u4f20\u5931\u8d25", (Object)ExceptionUtil.getStackTrace((Throwable)e));
                    throw new KDBizException(e.getMessage());
                }
            }
        }
    }

    private void doImportTask(String zipFileUrl, boolean coverFlag) {
        int size = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").size();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("pmm");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(ResManager.loadKDString((String)"\u56fe\u7247\u66f4\u65b0\u4e2d", (String)"PmmImportPicturePlugin_12", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.scm.pmm.formplugin.task.PmmPictureTask");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("size", size);
        params.put("coverflag", coverFlag);
        params.put("zipfileurl", zipFileUrl);
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "importtaskcloseback");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u56fe\u7247\u4e0a\u4f20\u4e2d", (String)"PmmImportPicturePlugin_11", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(false);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }

    private void dotask() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("pmm");
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(ResManager.loadKDString((String)"\u56fe\u7247\u4fdd\u5b58\u4e2d", (String)"PmmImportPicturePlugin_10", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname("kd.scm.pmm.formplugin.task.PmmImportPictureTask");
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List goodsIds = (List)customParams.get("goodsIds");
        params.put("goodsIds", goodsIds);
        if (null == this.getPageCache().get("coverFlag")) {
            params.put("coverFlag", true);
        } else {
            params.put("coverFlag", this.getPageCache().get("coverFlag"));
        }
        DynamicObjectCollection uploadGoodsList = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        HashMap<String, Object> thumbnailMap = new HashMap<String, Object>();
        HashMap<String, Object> pictureMap = new HashMap<String, Object>();
        for (DynamicObject entryDyn : uploadGoodsList) {
            DynamicObject goods = entryDyn.getDynamicObject("goods");
            if (goods == null) continue;
            String number = goods.getString("number");
            thumbnailMap.put(number, entryDyn.get("thumbnail"));
            for (int i = 1; i < 5; ++i) {
                pictureMap.put(number + i, entryDyn.get("picture" + i));
            }
        }
        params.put("thumbnailMap", thumbnailMap);
        params.put("pictureMap", pictureMap);
        jobInfo.setParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
        JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
        jobFormInfo.setCaption(ResManager.loadKDString((String)"\u56fe\u7247\u4fdd\u5b58\u4e2d", (String)"PmmImportPicturePlugin_10", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        jobFormInfo.setCloseCallBack(closeCallBack);
        jobFormInfo.setCanBackground(true);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
    }
}

