/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.constant.CalConstant;
import kd.scm.common.fulltext.utils.PbdMalElasticSearchUtils;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.cal.CalculateUtils;

public class PmmProdAdjustTool
extends AbstractFormPlugin {
    private static final String KEY_CONFIRM = "confirm";
    private static final String ADJUSTFILED = "adjustfield";
    private static final String CATEGORY = "category";
    private static final String CATLONGNUMBER = "catlongnumber";
    private static final String TAXRATE = "taxrate";
    private static final String TAXRATENUMBER = "taxrateid";
    private static final String TAXPRICE = "taxprice";
    private static final String PRICE = "price";
    private static final String ALLPROD = "allProd";
    private static final String CONFIRMEND = "confirmend";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        IDataModel model = this.getModel();
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "confirm": {
                if (this.beforeConfirm(model)) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u66f4\u65b0\u5546\u54c1\u4fe1\u606f\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PmmProdAdjustTool_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRMEND));
                    break;
                }
                args.setCancel(false);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CONFIRMEND.equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.confirm();
        }
    }

    private void confirm() {
        int i;
        IDataModel model = this.getModel();
        String adjustField = (String)model.getValue(ADJUSTFILED);
        BigDecimal taxrate = new BigDecimal("0.00");
        DynamicObject cate = new DynamicObject();
        if (adjustField.equals("1")) {
            taxrate = (BigDecimal)model.getValue(TAXRATE);
        } else if (adjustField.equals("2")) {
            cate = (DynamicObject)model.getValue(CATEGORY);
        }
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        List prodlist = (List)param.get(ALLPROD);
        ArrayList<Long> list = new ArrayList<Long>(prodlist.size());
        ArrayList<Long> idList = new ArrayList<Long>(prodlist.size());
        for (Object prod : prodlist) {
            list.add(Long.parseLong(String.valueOf(prod)));
        }
        QFilter idfilter = new QFilter("id", "in", list);
        String selectfileds = DynamicObjectUtil.getSelectfields((String)"pmm_prodmanage", (boolean)false);
        String entrySelectFields = "protocolentry.prodpool";
        DynamicObject[] prods = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)(selectfileds + "," + entrySelectFields), (QFilter[])new QFilter[]{idfilter});
        HashMap<Long, Integer> prodPoolAndTaxType = new HashMap<Long, Integer>(prods.length);
        for (i = 0; i < prods.length; ++i) {
            DynamicObject prod = prods[i];
            if (adjustField.equals("1")) {
                prod.set(TAXRATE, (Object)taxrate);
                prod.set(TAXRATENUMBER, model.getValue(TAXRATENUMBER));
                BigDecimal price = CalConstant.BIGDECIMAL_ZERO;
                BigDecimal taxPrice = prod.getBigDecimal(TAXPRICE);
                int taxtype = prod.getInt("taxtype");
                price = 0 == taxtype ? CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxrate, (BigDecimal)taxPrice, (int)2) : CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxrate, (int)2);
                prod.set(PRICE, (Object)price);
                DynamicObjectCollection entrys = prod.getDynamicObjectCollection("protocolentry");
                entrys.forEach(entry -> prodPoolAndTaxType.put(entry.getLong("prodpool_id"), taxtype));
                continue;
            }
            if (!adjustField.equals("2")) continue;
            prod.set(CATEGORY, (Object)cate);
            prod.set(CATLONGNUMBER, cate.get("longnumber"));
            idList.add(prod.getLong("id"));
        }
        SaveServiceHelper.save((DynamicObject[])prods);
        if (idList.size() > 0) {
            for (i = 0; i < idList.size(); ++i) {
                PbdMalElasticSearchUtils.MalGoodsIncrSyn((String)"pmm_prodmanage", (long)((Long)idList.get(i)));
            }
        }
        if (adjustField.equals("1")) {
            this.updateProdPoolPrice(prodPoolAndTaxType, model);
        }
        this.getView().close();
    }

    private boolean beforeConfirm(IDataModel model) {
        String adjustField = (String)model.getValue(ADJUSTFILED);
        BigDecimal taxrate = new BigDecimal("0.00");
        DynamicObject cate = new DynamicObject();
        if (adjustField.equals("1")) {
            taxrate = (BigDecimal)model.getValue(TAXRATE);
            if (taxrate.compareTo(CalConstant.BIGDECIMAL_ZERO) < 0 || taxrate.compareTo(CalConstant.BIGDECIMAL_ONEHUNDRED) >= 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u7a0e\u7387\u4e0d\u80fd\u5c0f\u4e8e0\u6216\u8005\u5927\u4e8e\u7b49\u4e8e100\u3002", (String)"PmmProdAdjustTool_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else if (adjustField.equals("2") && null == (cate = (DynamicObject)model.getValue(CATEGORY))) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a", (String)"PmmProdAdjustTool_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void updateProdPoolPrice(Map<Long, Integer> prodPoolAndTaxType, IDataModel model) {
        DynamicObject[] prodPools;
        BigDecimal taxRate = (BigDecimal)model.getValue(TAXRATE);
        for (DynamicObject prodPool : prodPools = BusinessDataServiceHelper.load((String)"pmm_prodpool", (String)"id,taxprice,taxrateid,taxrate,price", (QFilter[])new QFilter[]{new QFilter("id", "in", prodPoolAndTaxType.keySet())})) {
            prodPool.set(TAXRATE, (Object)taxRate);
            prodPool.set(TAXRATENUMBER, model.getValue(TAXRATENUMBER));
            BigDecimal price = CalConstant.BIGDECIMAL_ZERO;
            BigDecimal taxPrice = prodPool.getBigDecimal(TAXPRICE);
            int taxtype = prodPoolAndTaxType.get(prodPool.getLong("id"));
            price = 0 == taxtype ? CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)2) : CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)2);
            prodPool.set(PRICE, (Object)price);
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])prodPools);
    }
}

