/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;

public class PmmProdAuditSubmitPlugin
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(PmmProdAuditSubmitPlugin.class);

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] objs = e.getDataEntities();
        ArrayList<Long> ids = new ArrayList<Long>((int)((double)objs.length / 0.75));
        HashMap<Long, DynamicObject> goodsMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject obj : objs) {
            long id = obj.getLong("id");
            DynamicObjectCollection entries = obj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                DynamicObject goods = entry.getDynamicObject("goods");
                if (null == goods || !"A".equals(goods.getString("status"))) continue;
                goodsMap.put(goods.getLong("id"), entry);
            }
            if (id == 0L) {
                objs[0].set("cfmstatus", (Object)"A");
                return;
            }
            ids.add(id);
        }
        this.setCfmstatus(ids, goodsMap);
    }

    public void setCfmstatus(List<Long> ids, HashMap<Long, DynamicObject> goodsMap) {
        DynamicObject[] sups;
        QFilter filter = new QFilter("id", "in", ids);
        QFilter[] filters = new QFilter[]{filter};
        for (DynamicObject sup : sups = BusinessDataServiceHelper.load((String)"ent_prodrequest", (String)"cfmstatus,entryentity.goods", (QFilter[])filters)) {
            sup.set("cfmstatus", (Object)"A");
        }
        this.setProductTaxprice(goodsMap);
        SaveServiceHelper.save((DynamicObject[])sups);
    }

    public void setProductTaxprice(HashMap<Long, DynamicObject> goodsMap) {
        DynamicObject[] goodses;
        QFilter goodsfilter1 = new QFilter("id", "in", goodsMap.keySet());
        QFilter goodsfilter2 = new QFilter("status", "=", (Object)"A");
        QFilter[] goodsfilters = new QFilter[]{goodsfilter1.and(goodsfilter2)};
        String sectlors = DynamicObjectUtil.getSelectfields((String)"pmm_prodmanage", (boolean)false);
        sectlors = DynamicObjectUtil.getEntrySelectfields((String)sectlors, (String)"pmm_prodmanage", (String)"protocolentry", (boolean)false);
        for (DynamicObject goods : goodses = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)sectlors, (QFilter[])goodsfilters)) {
            DynamicObject billGoods = goodsMap.get(goods.getLong("id"));
            if (billGoods == null) continue;
            goods.set("taxprice", billGoods.get("taxprice"));
            goods.set("price", billGoods.get("price"));
            goods.set("shopprice", billGoods.get("shopprice"));
        }
        if (goodses.length > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            OperationResult saveOpRes = OperationServiceHelper.executeOperate((String)"save", (String)"ent_prodmanage", (DynamicObject[])goodses, (OperateOption)option);
            if (!saveOpRes.isSuccess()) {
                log.info(ExceptionUtil.getErrorInfoDetails((List)saveOpRes.getAllErrorOrValidateInfo()));
            }
        }
    }

    @Deprecated
    public void setProductStatus(DynamicObject[] sups, List<Long> ids, HashMap<String, DynamicObject> goodsMap) {
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("goods");
        e.getFieldKeys().add("cfmstatus");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("entryentity.goods.status");
        e.getFieldKeys().add("entryentity.class");
        e.getFieldKeys().add("entryentity.taxprice");
        e.getFieldKeys().add("entryentity.price");
        e.getFieldKeys().add("entryentity.shopprice");
    }
}

