/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.GetCategorysUtil;
import kd.scm.common.util.MalFeeHandleHelper;

public class PmmSurchargeAllotPlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener {
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String FOCUS_NODE_ID = "focusNodeId";
    private static final String ALLOT = "allot";
    private static final String UNALLOT = "unallot";
    private static final String SURID = "surid";
    private static final String OPERATE = "operate";

    public void afterCreateNewData(EventObject e) {
        TreeNode treenode = this.getCloudData();
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        tree.deleteAllNodes();
        tree.addNode(treenode);
        tree.setRootVisible(true);
        tree.expand(treenode.getId());
        this.refreshEntry();
    }

    public TreeNode getCloudData() {
        ArrayList<TreeNode> cloudNode = new ArrayList<TreeNode>();
        TreeNode rootNode = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"PmmSurchargeAllotPlugin_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        rootNode.setText(ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b", (String)"PmmSurchargeAllotPlugin_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        cloudNode.add(rootNode);
        String rootid = rootNode.getId();
        QFilter filter = new QFilter("standard", "=", (Object)Long.parseLong("944841720602823680"));
        DynamicObjectCollection loads = QueryServiceHelper.query((String)"mdr_goodsclass", (String)"id,number,name,parent.id", (QFilter[])new QFilter[]{filter});
        for (DynamicObject group : loads) {
            TreeNode node = new TreeNode();
            String nodeID = group.getString("id");
            String parentid = group.getString("parent.id");
            node.setText(group.getString("name"));
            if (rootNode.getId().equals(rootid) && parentid.equals("0")) {
                node.setParentid(rootid);
            } else {
                node.setParentid(parentid);
            }
            node.setId(nodeID);
            cloudNode.add(node);
        }
        Map<String, TreeNode> nodes = this.buildTree(cloudNode);
        if (null != nodes.get(rootNode.getId())) {
            rootNode = nodes.get(rootNode.getId());
            rootNode.setParentid("");
        }
        return nodes.get(rootid);
    }

    private Map<String, TreeNode> buildTree(List<TreeNode> nodes) {
        HashMap<String, TreeNode> allNodes = new HashMap<String, TreeNode>(nodes.size());
        for (TreeNode node : nodes) {
            allNodes.put(node.getId(), node);
        }
        for (TreeNode node : allNodes.values()) {
            TreeNode parentNode = (TreeNode)allNodes.get(node.getParentid());
            if (parentNode == null) continue;
            parentNode.addChild(node);
        }
        return allNodes;
    }

    public void refreshEntry() {
        FormShowParameter param = this.getView().getFormShowParameter();
        QFilter filters = new QFilter("supplier", "in", param.getCustomParam("supplier"));
        if (null != this.getPageCache().get(FOCUS_NODE_ID)) {
            ArrayList<String> nodeid = new ArrayList<String>(1);
            nodeid.add(this.getPageCache().get(FOCUS_NODE_ID));
            ArrayList nodelist = GetCategorysUtil.getAllLeafNodeByLevel(nodeid, (String)EcPlatformEnum.ECPLATFORM_SELF.getVal(), (int)3);
            ArrayList<Long> categoryList = new ArrayList<Long>(nodelist.size());
            for (String node : nodelist) {
                categoryList.add(Long.parseLong(node));
            }
            filters.and(new QFilter("category", "in", categoryList));
        }
        String operate = (String)param.getCustomParam(OPERATE);
        String surid = (String)param.getCustomParam(SURID);
        if (UNALLOT.equals(operate)) {
            filters.and(new QFilter("surchargeid", "match", (Object)surid));
        }
        this.setProd(filters);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        List searchField = searchEnterEvent.getFieldNames();
        Search search = (Search)this.getControl("searchap");
        if ("searchap".equals(search.getKey())) {
            FormShowParameter param = this.getView().getFormShowParameter();
            QFilter filters = new QFilter("supplier", "in", param.getCustomParam("supplier"));
            String operate = (String)param.getCustomParam(OPERATE);
            String surid = (String)param.getCustomParam(SURID);
            if (UNALLOT.equals(operate)) {
                filters.and(new QFilter("surchargeid", "match", (Object)surid));
            }
            QFilter searchFieldFilter = null;
            for (String field : searchField) {
                if (searchFieldFilter == null) {
                    searchFieldFilter = new QFilter("upper(" + field + ")", "like", (Object)("%" + searchText.toUpperCase() + "%"));
                    continue;
                }
                searchFieldFilter.or(new QFilter("upper(" + field + ")", "like", (Object)("%" + searchText.toUpperCase() + "%")));
            }
            filters.and(searchFieldFilter);
            this.setProd(filters);
        }
    }

    private void setProd(QFilter filters) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,number,thumbnail", (QFilter[])new QFilter[]{filters});
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < query.size(); ++i) {
            vs.set("number", ((DynamicObject)query.get(i)).get("id"), i);
            vs.set("thumbnail", ((DynamicObject)query.get(i)).get("thumbnail"), i);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", vs);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        treeView.addTreeNodeClickListener(new TreeNodeClickListener(){

            public void treeNodeClick(TreeNodeEvent evt) {
                super.treeNodeClick(evt);
                PmmSurchargeAllotPlugin.this.getPageCache().put(PmmSurchargeAllotPlugin.FOCUS_NODE_ID, evt.getNodeId().toString());
                PmmSurchargeAllotPlugin.this.refreshEntry();
            }
        });
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (null == args.getOperationResult() || !args.getOperationResult().isSuccess()) {
            return;
        }
        if (args.getOperateKey().equals("confirm")) {
            FormShowParameter param = this.getView().getFormShowParameter();
            if (ALLOT.equals(param.getCustomParam(OPERATE))) {
                this.allot(param);
            } else {
                this.unallot(param);
            }
        }
    }

    private void allot(FormShowParameter param) {
        DynamicObject[] prods;
        String id = (String)param.getCustomParam(SURID);
        HashMap<String, String> surMap = new HashMap<String, String>();
        HashMap<String, BigDecimal> surAmountMap = new HashMap<String, BigDecimal>();
        ArrayList<DynamicObject> prodList = new ArrayList<DynamicObject>();
        if (!this.operateCheck(surMap, surAmountMap, prodList, param)) {
            return;
        }
        for (DynamicObject prod : prods = prodList.toArray(new DynamicObject[prodList.size()])) {
            String surchargeid = prod.getString("surchargeid");
            if (StringUtils.isEmpty((String)surchargeid)) {
                prod.set("surchargeid", (Object)id);
                prod.set("surchargename", surMap.get(id));
                String amo = String.valueOf(((BigDecimal)surAmountMap.get(id)).setScale(2, 4));
                prod.set("surchargeamount", (Object)("\uffe5" + amo));
                continue;
            }
            if (!this.checkSameSurcharge(prod, id)) {
                return;
            }
            StringBuilder idsb = new StringBuilder();
            StringBuilder namesb = new StringBuilder();
            StringBuilder amountsb = new StringBuilder();
            idsb.append(prod.getString("surchargeid")).append(',').append(id);
            namesb.append(prod.getString("surchargename")).append(',').append((String)surMap.get(id));
            String amo = String.valueOf(((BigDecimal)surAmountMap.get(id)).setScale(2, 4));
            amountsb.append(prod.getString("surchargeamount")).append(',').append('\uffe5').append(amo);
            prod.set("surchargeid", (Object)idsb.toString());
            prod.set("surchargename", (Object)namesb.toString());
            prod.set("surchargeamount", (Object)amountsb.toString());
        }
        this.saveProd(prods);
    }

    public void unallot(FormShowParameter param) {
        DynamicObject[] prods;
        String id = (String)param.getCustomParam(SURID);
        HashMap<String, String> surMap = new HashMap<String, String>();
        HashMap<String, BigDecimal> surAmountMap = new HashMap<String, BigDecimal>();
        ArrayList<DynamicObject> prodList = new ArrayList<DynamicObject>();
        if (!this.operateCheck(surMap, surAmountMap, prodList, param)) {
            return;
        }
        for (DynamicObject prod : prods = prodList.toArray(new DynamicObject[prodList.size()])) {
            String surchargeid = prod.getString("surchargeid");
            String surchargename = prod.getString("surchargename");
            String surchargeamount = prod.getString("surchargeamount");
            String[] surchargeids = surchargeid.split(",");
            int index = this.getSurchargeIndex(surchargeids, id);
            if (index == surchargeids.length + 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u4e0d\u5b58\u5728\u9009\u4e2d\u7684\u9644\u52a0\u8d39\u3002", (String)"PmmSurchargeAllotPlugin_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return;
            }
            surchargeid = this.removeIndex(index, surchargeids);
            surchargename = this.removeIndex(index, surchargename.split(","));
            surchargeamount = this.removeIndex(index, surchargeamount.split(","));
            prod.set("surchargeid", (Object)surchargeid);
            prod.set("surchargename", (Object)surchargename);
            prod.set("surchargeamount", (Object)surchargeamount);
        }
        this.saveProd(prods);
    }

    private void saveProd(DynamicObject[] prods) {
        SaveServiceHelper.save((IDataEntityType)prods[0].getDataEntityType(), (Object[])prods);
        HashMap<String, String> isSuccess = new HashMap<String, String>();
        isSuccess.put("success", "true");
        this.getView().returnDataToParent(isSuccess);
        this.getView().close();
    }

    private boolean checkSameSurcharge(DynamicObject prod, String id) {
        if (prod.getString("surchargeid").contains(id)) {
            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u5546\u54c1{0}\u5df2\u5206\u914d\u8be5\u9644\u52a0\u8d39\u4e0d\u80fd\u91cd\u590d\u5206\u914d\u3002", (String)"PmmSurchargeAllotPlugin_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]), prod.getString("name")));
            return false;
        }
        return true;
    }

    private String removeIndex(int index, String[] surchargeids) {
        StringBuilder strBuffer = new StringBuilder();
        for (int i = 0; i < surchargeids.length; ++i) {
            if (i == index) continue;
            strBuffer.append(surchargeids[i]).append(',');
        }
        if (strBuffer.length() > 0) {
            return strBuffer.toString().substring(0, strBuffer.toString().length() - 1);
        }
        return strBuffer.toString();
    }

    public int getSurchargeIndex(String[] surchargeids, String id) {
        int index = surchargeids.length + 1;
        for (int i = surchargeids.length - 1; i >= 0; --i) {
            if (!surchargeids[i].equals(id)) continue;
            return i;
        }
        return index;
    }

    public boolean operateCheck(Map<String, String> surMap, Map<String, BigDecimal> surAmountMap, List<DynamicObject> prods, FormShowParameter param) {
        String id = (String)param.getCustomParam(SURID);
        QFilter idfilter = new QFilter("id", "in", (Object)Long.parseLong(id));
        DynamicObject surcharge = QueryServiceHelper.queryOne((String)"pmm_surcharge", (String)"id,name,number,project.name,cost", (QFilter[])new QFilter[]{idfilter});
        surMap.put(surcharge.getString("id"), surcharge.getString("project.name"));
        surAmountMap.put(surcharge.getString("id"), surcharge.getBigDecimal("cost"));
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectrows = grid.getEntryState().getSelectedRows();
        if (selectrows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5546\u54c1\u3002", (String)"PmmSurchargeAllotPlugin_4", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList<Long> prodidList = new ArrayList<Long>(selectrows.length);
        for (int i = 0; i < selectrows.length; ++i) {
            DynamicObject prod = this.getModel().getEntryRowEntity("entryentity", selectrows[i]);
            String prodId = prod.getDynamicObject("number").getPkValue().toString();
            MalFeeHandleHelper.clearRedisCacheByGoodsKey((String)prodId);
            prodidList.add(Long.parseLong(prodId));
        }
        QFilter prodfilter = new QFilter("id", "in", prodidList);
        DynamicObject[] prodArray = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)"id,number,surchargename,surchargeid,surchargeamount", (QFilter[])new QFilter[]{prodfilter});
        if (prodArray.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5546\u54c1\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PmmSurchargeAllotPlugin_5", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        prods.addAll(Arrays.asList(prodArray));
        return true;
    }
}

