/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.MapControl;
import kd.bos.ext.form.control.events.MapSelectEvent;
import kd.bos.ext.form.control.events.MapSelectListener;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.util.AddressUtil;
import kd.scm.common.ecapi.util.EmalParamsUtil;

public class PmmAddressEdit
extends AbstractBasePlugIn
implements MapSelectListener {
    private static final String KEY_MAP_ADDRESS = "mapaddress";
    private static final String KEY_SHOWMAP_ID = "pbd_map";
    private static final String KEY_MAP_CITY = "mapcity";
    private static final String KEY_NAME = "name";
    private static final String KEY_NUMBER = "number";
    private static final String BD_ADMINDIVISION = "bd_admindivision";
    private static final String KEY_MAP_CONTROLAP = "mapcontrolap";
    private static final String ADDRESS = "address";
    private static final String MAPADDRESS = "mapaddress";
    private static final String JDADDRESSNUM = "jdaddressnum";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"mapaddress"});
        MapControl map = (MapControl)this.getView().getControl(KEY_MAP_CONTROLAP);
        map.addSelectListener((MapSelectListener)this);
    }

    public void select(MapSelectEvent evt) {
        this.setSelectData(evt);
    }

    private void setSelectData(MapSelectEvent evt) {
        Map map = evt.getPoint();
        IDataModel model = this.getView().getModel();
        BigDecimal latitude = (BigDecimal)map.get("latitude");
        BigDecimal longitude = (BigDecimal)map.get("longitude");
        if (null != latitude && null != longitude) {
            String area = longitude + "&" + latitude;
            model.setValue("area", (Object)area);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String property = e.getProperty().getName();
        IDataModel model = this.getModel();
        MapControl map = (MapControl)this.getView().getControl(KEY_MAP_CONTROLAP);
        Long addressNumber = this.getModelAddress(model);
        switch (property) {
            case "address": {
                this.getView().setVisible(Boolean.valueOf(this.isShowMap(addressNumber)), new String[]{KEY_MAP_CONTROLAP});
                if (addressNumber == 0L) {
                    return;
                }
                String address = this.getAreaFullName(addressNumber);
                if (StringUtils.isNotBlank((CharSequence)model.getValue("mapaddress").toString())) {
                    address = address + model.getValue("mapaddress");
                }
                map.selectAddress(address);
                break;
            }
            case "mapaddress": {
                String address = this.getAreaFullName(addressNumber);
                String mapaddress = address + model.getValue("mapaddress");
                map.selectAddress(mapaddress);
                break;
            }
        }
    }

    private Long getModelAddress(IDataModel model) {
        Long addressNumber = 0L;
        Object address = model.getValue(ADDRESS);
        if (address == null || StringUtils.isEmpty((CharSequence)String.valueOf(address))) {
            return addressNumber;
        }
        return Long.valueOf(String.valueOf(address));
    }

    private boolean isShowMap(Long addressNumber) {
        QFilter idFilter = new QFilter("id", "=", (Object)addressNumber);
        QFilter[] filters = new QFilter[]{idFilter};
        DynamicObject queryResult = QueryServiceHelper.queryOne((String)BD_ADMINDIVISION, (String)"level,country.number,country.twocountrycode", (QFilter[])filters);
        return queryResult != null && ("001".equals(queryResult.getString("country.number")) || "CN".equals(queryResult.getString("country.twocountrycode")));
    }

    private String getAreaFullName(Long city) {
        QFilter idfilter = new QFilter("id", "=", (Object)city);
        DynamicObject address = QueryServiceHelper.queryOne((String)BD_ADMINDIVISION, (String)"id,fullname,name", (QFilter[])new QFilter[]{idfilter});
        if (address == null) {
            return "";
        }
        return address.getString("fullname");
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String operationKey = evt.getOperationKey();
        if ("save".equals(operationKey)) {
            this.validateMapping();
        }
    }

    private void validateMapping() {
        DynamicObject addressDyn = this.getModel().getDataEntity();
        List openedMalNos = EmalParamsUtil.getOpenedEmalNumberList();
        if (openedMalNos == null) {
            return;
        }
        Long admindivisionId = addressDyn.getLong(ADDRESS);
        StringBuilder tips = new StringBuilder();
        for (String openedMalNo : openedMalNos) {
            String longNumber = AddressUtil.getLongNumber((Long)admindivisionId, (String)openedMalNo);
            if (!StringUtils.isEmpty((CharSequence)longNumber) || EcPlatformEnum.ECPLATFORM_ZKH.getVal().equals(openedMalNo)) continue;
            tips.append(EcPlatformEnum.fromVal((String)openedMalNo).getName()).append(" ");
        }
        if (tips.length() > 0) {
            String msg = ResManager.loadKDString((String)"\u5730\u5740\u4e0e\u7528\u6237\u5730\u5740\u4e0d\u5339\u914d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7ef4\u62a4\u5730\u5740\u5bf9\u5e94\u5173\u7cfb\uff08\u5546\u57ce\u7ba1\u7406-\u57fa\u7840\u8bbe\u7f6e-\u7535\u5546\u5730\u5740\u5339\u914d\uff09\u3002", (String)"PmmAddressEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showMessage(tips.toString().trim() + msg);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operateKey) && !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            if (StringUtils.isBlank((Object)this.getModel().getValue("phone"))) {
                this.getModel().setValue("phone", (Object)"");
            }
            if (StringUtils.isBlank((Object)this.getModel().getValue("email"))) {
                this.getModel().setValue("email", (Object)"");
            }
        }
    }
}

