/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.malcore.enums.MallStatusEnum;
import kd.scm.malcore.enums.SaleStatusEnum;
import kd.scm.malcore.util.MalFuzzySearchUtil;

public class PmmCategoryGoodsEdit
extends AbstractBasePlugIn
implements RowClickEventListener,
BeforeF7SelectListener,
BasedataFuzzySearchListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showGoods();
        this.getModel().setDataChanged(false);
    }

    private void showGoods() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("subentryentity");
        if (null != entryEntity) {
            int i;
            DynamicObject query;
            ArrayList<Long> selfList = new ArrayList<Long>(entryEntity.size());
            ArrayList<Long> malList = new ArrayList<Long>(entryEntity.size());
            ArrayList listMap = new ArrayList(entryEntity.size());
            HashMap<Long, Integer> indexMap = new HashMap<Long, Integer>(entryEntity.size());
            for (int i2 = 0; i2 < entryEntity.size(); ++i2) {
                query = (DynamicObject)entryEntity.get(i2);
                Integer seq = Integer.parseInt(query.getString("seq"));
                String source = query.getString("source");
                long goodsId = query.getLong("goods.id");
                if ("pmm_prodmanage".equals(source)) {
                    selfList.add(goodsId);
                    indexMap.put(goodsId, seq);
                    continue;
                }
                malList.add(goodsId);
                indexMap.put(goodsId, seq);
            }
            QFilter qFilter = new QFilter("id", "in", selfList);
            query = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,name,unit.name,supplier.name,thumbnail,shopprice", (QFilter[])new QFilter[]{qFilter});
            for (int i3 = 0; i3 < query.size(); ++i3) {
                HashMap<String, Object> map = new HashMap<String, Object>(query.size());
                DynamicObject queryOne = (DynamicObject)query.get(i3);
                long id = queryOne.getLong("id");
                map.put("source", "pmm_prodmanage");
                map.put("id", id);
                map.put("unit", queryOne.getString("unit.name"));
                map.put("supplier", queryOne.getString("supplier.name"));
                map.put("thumbnail", queryOne.getString("thumbnail"));
                map.put("shopprice", queryOne.getString("shopprice"));
                map.put("integer", indexMap.get(id));
                listMap.add(map);
            }
            QFilter malQfilter = new QFilter("id", "in", malList);
            DynamicObjectCollection querys = QueryServiceHelper.query((String)"pbd_mallgoods", (String)"id,name,unitid.name,mainpic,source", (QFilter[])new QFilter[]{malQfilter});
            QFilter filter = new QFilter("mallgoods", "in", malList);
            DynamicObjectCollection priceCol = QueryServiceHelper.query((String)"pbd_mallgoods_price", (String)"mallgoods,price", (QFilter[])new QFilter[]{filter});
            HashMap<Long, String> priceMap = new HashMap<Long, String>();
            for (DynamicObject price : priceCol) {
                priceMap.put(price.getLong("mallgoods"), price.getString("price"));
            }
            for (i = 0; i < querys.size(); ++i) {
                DynamicObject queryOne = (DynamicObject)querys.get(i);
                long id = queryOne.getLong("id");
                HashMap<String, Object> map = new HashMap<String, Object>(querys.size());
                map.put("source", "pbd_mallgoods");
                map.put("id", id);
                map.put("unit", queryOne.getString("unitid.name"));
                map.put("thumbnail", queryOne.getString("mainpic"));
                map.put("shopprice", priceMap.get(id));
                map.put("supplier", EcApiUtil.getMalName((String)queryOne.getString("source")));
                map.put("integer", indexMap.get(id));
                listMap.add(map);
            }
            for (i = 0; i < listMap.size(); ++i) {
                Map setMap = (Map)listMap.get(i);
                IDataModel model = this.getModel();
                int index = Integer.parseInt(setMap.get("integer").toString()) - 1;
                model.setValue("picture", setMap.get("thumbnail") == null ? null : setMap.get("thumbnail"), index);
                model.setValue("unit", setMap.get("unit") == null ? null : setMap.get("unit"), index);
                model.setValue("shopprice", setMap.get("shopprice") == null ? null : setMap.get("shopprice"), index);
                model.setValue("supplier", setMap.get("supplier") == null ? null : setMap.get("supplier"), index);
            }
        }
    }

    public void initialize() {
        super.initialize();
    }

    public void entryRowClick(RowClickEvent evt) {
        this.showGoods();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object value;
        String name = e.getProperty().getName();
        if ("category".equals(name) && null == (value = this.getModel().getValue("category"))) {
            this.getModel().deleteEntryData("subentryentity");
            for (int i = 0; i < 4; ++i) {
                this.getModel().createNewEntryRow("subentryentity");
            }
        }
        if ("selectmode".equals(name)) {
            String selectMode = String.valueOf(e.getChangeSet()[0].getNewValue());
            Object value2 = this.getModel().getValue("category");
            if (null != value2 && "A".equals(selectMode)) {
                this.getModel().deleteEntryData("subentryentity");
                for (int i = 0; i < 4; ++i) {
                    this.getModel().createNewEntryRow("subentryentity");
                }
            }
        }
        if ("goods".equals(name)) {
            DynamicObject goods;
            ChangeData[] changeData = e.getChangeSet();
            int index = -1;
            if (changeData.length > 0) {
                index = changeData[0].getRowIndex();
            }
            if (null != (goods = (DynamicObject)this.getModel().getValue("goods", index))) {
                long goodsId = goods.getLong("id");
                String source = this.getModel().getValue("source").toString();
                if ("pmm_prodmanage".equals(source)) {
                    QFilter qFilter = new QFilter("id", "=", (Object)goodsId);
                    DynamicObject queryOne = QueryServiceHelper.queryOne((String)"pmm_prodmanage", (String)"name,unit.name,supplier.name,thumbnail,shopprice", (QFilter[])new QFilter[]{qFilter});
                    this.setGoods(queryOne.getString("unit.name"), queryOne.getString("thumbnail"), queryOne.getString("shopprice"), queryOne.getString("supplier.name"), index, 0);
                } else {
                    QFilter qFilter = new QFilter("id", "=", (Object)goodsId);
                    DynamicObject queryOne = QueryServiceHelper.queryOne((String)"pbd_mallgoods", (String)"name,unitid.name,mainpic,source", (QFilter[])new QFilter[]{qFilter});
                    QFilter qFilters = new QFilter("mallgoods", "=", (Object)goodsId);
                    DynamicObject queryPrice = QueryServiceHelper.queryOne((String)"pbd_mallgoods_price", (String)"price", (QFilter[])new QFilter[]{qFilters});
                    this.setGoods(queryOne.getString("unitid.name"), queryOne.getString("mainpic"), queryPrice.getString("price"), queryOne.getString("source"), index, 1);
                }
            } else {
                EntryGrid grid = (EntryGrid)this.getView().getControl("subentryentity");
                int[] rows = grid.getEntryState().getSelectedRows();
                this.getModel().deleteEntryRow("subentryentity", rows[0]);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit goodsEdit = (BasedataEdit)this.getControl("goods");
        goodsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        goodsEdit.addBasedataFuzzySearchListener((BasedataFuzzySearchListener)this);
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey = arg0.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        showParameter.setMultiSelect(true);
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"goods")) {
            this.goodsBeforeF7SelectHandle(showParameter, arg0);
        }
    }

    private void goodsBeforeF7SelectHandle(ListShowParameter showParameter, BeforeF7SelectEvent arg0) {
        DynamicObject entryEntity;
        DynamicObject category;
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows.length == 0) {
            rows = new int[1];
        }
        if (null == (category = (DynamicObject)(entryEntity = this.getModel().getEntryRowEntity("entryentity", rows[0])).get("category"))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5546\u54c1\u5206\u7c7b\u201d\uff0c\u518d\u5f55\u5165\u5546\u54c1\u3002", (String)"PmmCategoryGoodsEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            arg0.setCancel(true);
            return;
        }
        DynamicObject standard = (DynamicObject)category.get("standard");
        String standardId = standard.getString("id");
        DynamicObjectCollection subEntryEntity = this.getModel().getEntryEntity("subentryentity");
        List prodList = subEntryEntity.stream().map(x -> x.getDynamicObject("goods")).filter(Objects::nonNull).map(x -> x.getLong("id")).collect(Collectors.toList());
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        if (standardId.equals("944841720602823680")) {
            qFilters.add(this.getZJQFilter(category));
        } else {
            qFilters.add(this.getEcQFilter(category));
        }
        if (prodList.size() > 0) {
            qFilters.add(new QFilter("id", "not in", prodList));
        }
        this.setF7OpenStyle(showParameter);
    }

    private QFilter getZJQFilter(DynamicObject category) {
        QFilter qFilter = new QFilter("protocolentry.prodpool.mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal());
        qFilter.and(new QFilter("protocolentry.prodpool.salestatus", "=", (Object)SaleStatusEnum.SALE.getVal()).or(new QFilter("protocolentry.prodpool.salestatus", "=", (Object)SaleStatusEnum.PARTSALE.getVal())));
        QFilter categoryFilter = null;
        int level = category.getInt("level");
        String number = category.getString("number");
        if (level == 3) {
            categoryFilter = new QFilter("category.number", "=", (Object)number);
        } else if (level == 2) {
            categoryFilter = new QFilter("category.parent.number", "=", (Object)number);
        } else if (level == 1) {
            categoryFilter = new QFilter("category.parent.parent.number", "=", (Object)number);
        }
        if (null != categoryFilter) {
            qFilter.and(categoryFilter);
        }
        return qFilter;
    }

    private QFilter getEcQFilter(DynamicObject category) {
        QFilter groupFilter = null;
        int level = category.getInt("level");
        String number = category.getString("number");
        DynamicObject standard = (DynamicObject)category.get("standard");
        String standardId = standard.getString("id");
        if (level == 3) {
            groupFilter = new QFilter("group.number", "=", (Object)number);
        } else if (level == 2) {
            groupFilter = new QFilter("group.parent.number", "=", (Object)number);
        } else if (level == 1) {
            groupFilter = new QFilter("group.parent.parent.number", "=", (Object)number);
        }
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and(new QFilter("source", "=", (Object)EcApiUtil.getSource((String)standardId)));
        DynamicObjectCollection malquery = QueryServiceHelper.query((String)"pbd_mallgoods", (String)"id", (QFilter[])new QFilter[]{qFilter});
        ArrayList<Long> idList = new ArrayList<Long>(malquery.size());
        if (malquery.size() > 0) {
            for (DynamicObject dyn : malquery) {
                idList.add(dyn.getLong("id"));
            }
            DynamicObjectCollection pricequery = QueryServiceHelper.query((String)"pbd_mallgoods_price", (String)"mallgoods", (QFilter[])new QFilter[]{new QFilter("mallgoods", "in", idList)});
            ArrayList<Long> priceList = new ArrayList<Long>(pricequery.size());
            for (DynamicObject dyn : pricequery) {
                priceList.add(dyn.getLong("mallgoods"));
            }
            QFilter filter = new QFilter("mallgoods", "in", priceList).and(new QFilter("mallstatus", "=", (Object)"1"));
            DynamicObjectCollection statusquery = QueryServiceHelper.query((String)"pbd_mallgoods_status", (String)"mallgoods", (QFilter[])new QFilter[]{filter});
            idList.clear();
            for (DynamicObject dyn : statusquery) {
                idList.add(dyn.getLong("mallgoods"));
            }
        }
        QFilter ecQFilter = new QFilter("id", "in", idList);
        if (null != groupFilter) {
            ecQFilter.and(groupFilter);
        }
        return ecQFilter;
    }

    private void setF7OpenStyle(ListShowParameter showParameter) {
        showParameter.setCustomParam("ismergerows", (Object)true);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("1152px");
        styleCss.setHeight("696px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        HashSet<String> hideFields = new HashSet<String>(8);
        hideFields.add("status");
        hideFields.add("prodmatmappingstatus");
        hideFields.add("protocol.effectdate");
        hideFields.add("protocol.invaliddate");
        showParameter.setCustomParam("hideFields", (Object)SerializationUtils.toJsonString(hideFields));
    }

    private void setGoods(String unit, String mainpic, String mallprice, String malSource, int index, int i) {
        this.getModel().setValue("unit", (Object)unit, index);
        this.getModel().setValue("picture", (Object)mainpic, index);
        this.getModel().setValue("shopprice", (Object)mallprice, index);
        if (i == 0) {
            this.getModel().setValue("supplier", (Object)malSource, index);
        } else {
            this.getModel().setValue("supplier", (Object)EcApiUtil.getMalName((String)malSource), index);
        }
    }

    public void handleData(BasedataFuzzySearchEvent arg0) {
        List queryData = arg0.getQueryData();
        MalFuzzySearchUtil.queryDataDuplicatesRemoveByNumber((List)queryData);
    }
}

