/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.container.Container;
import kd.bos.form.control.Image;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.PictureEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.pmm.business.model.mainpageconfig.CategoryGoods;
import kd.scm.pmm.business.model.mainpageconfig.ComponentType;
import kd.scm.pmm.business.model.mainpageconfig.MainPageConfig;
import kd.scm.pmm.business.model.product.PmmProdObtain;
import kd.scm.pmm.business.model.product.ProductObtainResult;
import kd.scm.pmm.business.service.PmmBusinessServiceFactory;
import kd.scm.pmm.business.service.PmmProductObtainService;

public class PmmFloorEdit
extends AbstractFormPlugin
implements IBillPlugin {
    private static final String PRODUCT_OBTAIN = "product_obtain";
    private static final String ENTRYENTITY = "entryentity";
    private static final String SHOW_WAY = "show_way";
    private static final String PICTURE = "picture";
    private static final String PIC_TITLE = "pic_title";
    private static final String GOODSENTRY = "goodsentry";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject scenarioscheme = (DynamicObject)this.getModel().getValue("scenarioscheme");
        if (scenarioscheme != null) {
            this.scenarioGoodsEntry();
        } else {
            this.fillGoodsEntry();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (StringUtils.isNotBlank((Object)this.getModel().getValue(SHOW_WAY))) {
            this.changeShowWaySelectedStyle((String)this.getModel().getValue(SHOW_WAY));
            this.setFieldMustInput((String)this.getModel().getValue(SHOW_WAY));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (ComponentType componentType : ComponentType.values()) {
            Image image = (Image)this.getControl(componentType.getVal());
            if (image == null) continue;
            image.addClickListener((ClickListener)this);
        }
        BasedataEdit scenarioscheme = (BasedataEdit)this.getControl("scenarioscheme");
        scenarioscheme.addBeforeF7SelectListener(new BeforeF7SelectListener(){

            public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
                QFilter dateFilter = new QFilter("validityperiodto", ">=", (Object)DateUtil.formatStartDate((Date)new Date()));
                dateFilter.and(new QFilter("validityperiodfrom", "<=", (Object)DateUtil.formatEndDate((Date)new Date())));
                ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                formShowParameter.getListFilterParameter().getQFilters().add(dateFilter);
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject group = (DynamicObject)this.getModel().getValue("group");
        if (group != null && "CJCG".equals(group.getString("number"))) {
            this.getModel().setValue(SHOW_WAY, (Object)"GoodsListEight");
        }
    }

    private void fillGoodsEntry() {
        DynamicObject productObtainDyn = (DynamicObject)this.getModel().getValue(PRODUCT_OBTAIN);
        if (productObtainDyn != null) {
            ProductObtainResult productObtainResult = ((PmmProductObtainService)PmmBusinessServiceFactory.serviceOf(PmmProductObtainService.class)).obtain(new PmmProdObtain(productObtainDyn));
            Map goodsObjMap = productObtainResult.getGoodsObjMap();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            int i = 0;
            this.getModel().deleteEntryData(GOODSENTRY);
            for (Map goodsInfoFromEs : goodsObjMap.values()) {
                String platform = (String)goodsInfoFromEs.get("source");
                if (StringUtils.equals((CharSequence)EcPlatformEnum.ECPLATFORM_SELF.getVal(), (CharSequence)platform)) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache(goodsInfoFromEs.get("goodsid"), (String)"pmm_prodmanage");
                    if (StringUtils.isBlank((CharSequence)dynamicObject.getString("name"))) continue;
                    vs.set("goodssupplier", goodsInfoFromEs.get("suppliername"), i);
                    vs.set("source", (Object)"pmm_prodmanage", i);
                    vs.set("goods", (Object)dynamicObject, i);
                    vs.set("goods_id", goodsInfoFromEs.get("goodsid"), i);
                } else {
                    vs.set("goodssupplier", goodsInfoFromEs.get("source_name"), i);
                    vs.set("source", (Object)"pbd_mallgoods", i);
                    vs.set("goods", (Object)BusinessDataServiceHelper.loadSingleFromCache(goodsInfoFromEs.get("goodsid"), (String)"pbd_mallgoods"), i);
                    vs.set("goods_id", goodsInfoFromEs.get("goodsid"), i);
                }
                vs.set("unit", goodsInfoFromEs.get("unitname"), i);
                vs.set("thumbnail", goodsInfoFromEs.get("thumbnail"), i);
                vs.set("shopprice", goodsInfoFromEs.get("price"), i);
                vs.set("categoryname", goodsInfoFromEs.get("classname"), i);
                ++i;
            }
            this.getModel().beginInit();
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(GOODSENTRY, vs);
            this.getModel().endInit();
            this.getView().updateView(GOODSENTRY);
        } else {
            this.getModel().deleteEntryData(GOODSENTRY);
            this.getView().updateView(GOODSENTRY);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Image) {
            for (ComponentType componentType : ComponentType.values()) {
                String showWayImageKey = ((Image)evt.getSource()).getKey();
                if (!componentType.getVal().equalsIgnoreCase(showWayImageKey)) continue;
                this.getModel().setValue(SHOW_WAY, (Object)componentType.getVal());
                this.changeShowWaySelectedStyle(showWayImageKey);
            }
        }
    }

    private void changeShowWaySelectedStyle(String showWayImageKey) {
        showWayImageKey = StringUtils.lowerCase((String)showWayImageKey);
        HashMap selectedParam = new HashMap();
        HashMap<String, String> b = new HashMap<String, String>();
        b.put("b", "2px_solid_themeColor");
        b.put("l", "2px_solid_themeColor");
        b.put("r", "2px_solid_themeColor");
        b.put("t", "2px_solid_themeColor");
        HashMap<String, HashMap<String, String>> style = new HashMap<String, HashMap<String, String>>();
        style.put("b", b);
        selectedParam.put("s", style);
        this.getView().updateControlMetadata(showWayImageKey, selectedParam);
        for (ComponentType componentType : ComponentType.values()) {
            if (componentType.getVal().equalsIgnoreCase(showWayImageKey)) continue;
            HashMap unSelectedParam = new HashMap();
            HashMap<String, String> borderMap = new HashMap<String, String>();
            borderMap.put("b", "");
            borderMap.put("l", "");
            borderMap.put("r", "");
            borderMap.put("t", "");
            HashMap<String, HashMap<String, String>> unSelectedStyle = new HashMap<String, HashMap<String, String>>();
            unSelectedStyle.put("b", borderMap);
            unSelectedParam.put("s", unSelectedStyle);
            this.getView().updateControlMetadata(componentType.getVal().toLowerCase(), unSelectedParam);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("save".equals(formOperate.getOperateKey())) {
            DynamicObject productObtain = (DynamicObject)this.getModel().getValue(PRODUCT_OBTAIN);
            Object showWay = this.getModel().getValue(SHOW_WAY);
            if (productObtain != null) {
                ProductObtainResult productObtainResult = ((PmmProductObtainService)PmmBusinessServiceFactory.serviceOf(PmmProductObtainService.class)).obtain(new PmmProdObtain(productObtain));
                List categoryGoodsList = MainPageConfig.getCategoryGoods((ProductObtainResult)productObtainResult, (boolean)true);
                if (ComponentType.GOODS_LIST_THREE.getVal().equals(showWay)) {
                    for (CategoryGoods categoryGoods : categoryGoodsList) {
                        if (categoryGoods.getGoodsList().size() < 5) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3a\u8fbe\u5230\u8f83\u597d\u7684\u89c6\u89c9\u6548\u679c\uff0c\u5efa\u8bae\u540c\u4e00\u5546\u54c1\u5206\u7c7b\u7684\u5546\u54c1\u6570\u91cf\u5927\u4e8e\u7b49\u4e8e5\u3002", (String)"PmmFloorEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                            break;
                        }
                        if (categoryGoods.getGoodsList().size() % 5 == 0) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3a\u8fbe\u5230\u8f83\u597d\u7684\u89c6\u89c9\u6548\u679c\uff0c\u5efa\u8bae\u5546\u54c1\u6570\u91cf\u4e3a5\u7684\u500d\u6570\u3002", (String)"PmmFloorEdit_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                        break;
                    }
                }
                if (ComponentType.GOODS_LIST_TWO.getVal().equals(showWay)) {
                    if (categoryGoodsList.size() < 3) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3a\u8fbe\u5230\u8f83\u597d\u7684\u89c6\u89c9\u6548\u679c\uff0c\u5546\u54c1\u5206\u5f55\u6d89\u53ca\u7684\u5206\u7c7b\u6570\u91cf\u5e94\u5927\u4e8e\u7b49\u4e8e3\u3002", (String)"PmmFloorEdit_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    for (CategoryGoods categoryGoods : categoryGoodsList) {
                        if (categoryGoods.getGoodsList().size() >= 5) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3a\u8fbe\u5230\u8f83\u597d\u7684\u89c6\u89c9\u6548\u679c\uff0c\u5efa\u8bae\u540c\u4e00\u5546\u54c1\u5206\u7c7b\u7684\u5546\u54c1\u6570\u91cf\u5927\u4e8e\u7b49\u4e8e5\u3002", (String)"PmmFloorEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                        break;
                    }
                }
                if (ComponentType.GOODS_LIST_ONE.getVal().equals(showWay)) {
                    int count = this.getPictureCount();
                    if (count == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u56fe\u7247\u3002", (String)"PmmFloorEdit_9", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    if (productObtainResult.getSize() < 10) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3a\u8fbe\u5230\u8f83\u597d\u7684\u89c6\u89c9\u6548\u679c\uff0c\u5efa\u8bae\u5546\u54c1\u6570\u91cf\u5927\u4e8e\u7b49\u4e8e10\u3002", (String)"PmmFloorEdit_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                    }
                }
                if (ComponentType.GOODS_LIST_FIVE.getVal().equals(showWay)) {
                    int count = this.getPictureCount();
                    if (count == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u56fe\u7247\u3002", (String)"PmmFloorEdit_9", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    if (productObtainResult.getSize() < 12) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3a\u8fbe\u5230\u8f83\u597d\u7684\u89c6\u89c9\u6548\u679c\uff0c\u5efa\u8bae\u5546\u54c1\u6570\u91cf\u5927\u4e8e\u7b49\u4e8e12\u3002", (String)"PmmFloorEdit_4", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                    }
                }
            } else if (!(ComponentType.GOODS_LIST_FOUR.getVal().equals(showWay) || "GoodsListSix".equalsIgnoreCase(showWay.toString()) || "GoodsListSeven".equalsIgnoreCase(showWay.toString()) || "GoodsListEight".equalsIgnoreCase(showWay.toString()))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5546\u54c1\u83b7\u53d6\u65b9\u6848\u201d\u3002", (String)"PmmFloorEdit_10", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (ComponentType.GOODS_LIST_FOUR.getVal().equals(showWay)) {
                int count = this.getPictureCount();
                if (count == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u5f55\u5165\u4e00\u884c\u5206\u5f55\u3002", (String)"PmmFloorEdit_5", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (count % 4 != 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e3a\u8fbe\u5230\u8f83\u597d\u7684\u89c6\u89c9\u6548\u679c\uff0c\u5efa\u8bae\u56fe\u7247\u6570\u91cf\u4e3a4\u7684\u500d\u6570\u3002", (String)"PmmFloorEdit_6", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private int getPictureCount() {
        DynamicObjectCollection entryCol = this.getModel().getEntryEntity(ENTRYENTITY);
        int count = 0;
        for (DynamicObject entry : entryCol) {
            String picUrl = entry.getString(PICTURE);
            if (!StringUtils.isNotBlank((CharSequence)picUrl)) continue;
            ++count;
        }
        return count;
    }

    private String getUrl(String url) {
        if (StringUtils.isEmpty((CharSequence)url) || url.contains("http") || url.contains("https")) {
            return url;
        }
        return UrlService.getImageFullUrl((String)url);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        if (PRODUCT_OBTAIN.equals(e.getProperty().getName())) {
            this.fillGoodsEntry();
        }
        if (SHOW_WAY.equals(e.getProperty().getName())) {
            newValue = e.getChangeSet()[0].getNewValue();
            this.setFieldMustInput(String.valueOf(newValue));
            this.getView().updateView(ENTRYENTITY);
            this.getView().updateView(PRODUCT_OBTAIN);
            if (ComponentType.GOODS_LIST_ONE.getVal().equals(newValue) || ComponentType.GOODS_LIST_FIVE.getVal().equals(newValue)) {
                int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
                if (entryRowCount == 0) {
                    this.getModel().createNewEntryRow(ENTRYENTITY);
                } else {
                    int[] rows = new int[entryRowCount - 1];
                    for (int i = 1; i < entryRowCount; ++i) {
                        rows[i - 1] = i;
                    }
                    this.getModel().deleteEntryRows(ENTRYENTITY, rows);
                }
                String text = ResManager.loadKDString((String)"\u5de6\u4fa7\u4e3b\u9898\u56fe", (String)"PmmFloorEdit_7", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.changeAdvconapText(text);
            } else {
                String text = ResManager.loadKDString((String)"\u56fe\u7247\u4fe1\u606f", (String)"PmmFloorEdit_8", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.changeAdvconapText(text);
            }
        }
        if ("scenarioscheme".equals(e.getProperty().getName())) {
            newValue = e.getChangeSet()[0].getNewValue();
            if (null == newValue) {
                this.getModel().deleteEntryData(GOODSENTRY);
                this.getView().updateView(GOODSENTRY);
                this.getModel().setValue(PRODUCT_OBTAIN, null);
                Container flexPanel = (Container)this.getView().getControl("scenario_image");
                if (flexPanel != null) {
                    flexPanel.setBackgroundImg(null);
                }
                this.deleteAllTag();
                return;
            }
            DynamicObject scenarioscheme = (DynamicObject)newValue;
            QFilter filter = new QFilter("number", "in", (Object)scenarioscheme.getString("number"));
            Map obtainMap = BusinessDataServiceHelper.loadFromCache((String)"pmm_product_obtain", (QFilter[])filter.toArray());
            if (obtainMap.size() > 0) {
                this.getModel().beginInit();
                this.getModel().setValue(PRODUCT_OBTAIN, obtainMap.values().toArray()[0]);
                this.getModel().endInit();
            }
            if (scenarioscheme != null) {
                DateRangeEdit dateRangeEdit = (DateRangeEdit)this.getControl("valid_date_range");
                dateRangeEdit.setMinDate(scenarioscheme.getDate("validityperiodfrom"));
                dateRangeEdit.setMaxDate(scenarioscheme.getDate("validityperiodto"));
            }
            this.scenarioGoodsEntry();
            this.setTag();
            this.getView().updateView();
        }
    }

    private void deleteAllTag() {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("imageaddtag");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("isclearall", "true");
        customcontrol.setData(data);
    }

    private void setTag() {
        DynamicObject scenarioscheme = (DynamicObject)this.getModel().getValue("scenarioscheme");
        if (scenarioscheme == null) {
            return;
        }
        Container flexPanel = (Container)this.getView().getControl("scenario_image");
        String url = null;
        if (scenarioscheme.get("scenarioimg") != null) {
            url = this.getUrl(scenarioscheme.get("scenarioimg").toString());
        }
        if (flexPanel != null) {
            flexPanel.setBackgroundImg(url);
        }
        if (scenarioscheme != null) {
            DynamicObjectCollection tag_entryentitys = scenarioscheme.getDynamicObjectCollection("tag_entryentity");
            ArrayList tagList = new ArrayList();
            for (DynamicObject entry : tag_entryentitys) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("tagname", entry.getDynamicObject("tag").get("name").toString());
                data.put("tagid", entry.getPkValue().toString());
                data.put("left", Integer.parseInt(entry.getString("left")));
                data.put("top", Integer.parseInt(entry.getString("top")));
                tagList.add(data);
            }
            CustomControl customcontrol = (CustomControl)this.getView().getControl("imageaddtag");
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("tagdata", tagList);
            data.put("isshowtag", "true");
            customcontrol.setData(data);
        }
    }

    private void scenarioGoodsEntry() {
        DynamicObject scenarioscheme = (DynamicObject)this.getModel().getValue("scenarioscheme");
        if (scenarioscheme != null) {
            DynamicObjectCollection goods_entryentitys = scenarioscheme.getDynamicObjectCollection(ENTRYENTITY);
            TableValueSetter vs = new TableValueSetter(new String[0]);
            int i = 0;
            this.getModel().deleteEntryData(GOODSENTRY);
            ArrayList<Long> selfGoodsIds = new ArrayList<Long>(goods_entryentitys.size());
            ArrayList<Long> ecGoodsIds = new ArrayList<Long>(goods_entryentitys.size());
            for (DynamicObject entry : goods_entryentitys) {
                Long goodsId = entry.getLong("goods.id");
                String source = entry.getString("source");
                if (!StringUtils.isNotBlank((CharSequence)source)) continue;
                if ("pmm_prodmanage".equals(source)) {
                    selfGoodsIds.add(goodsId);
                    continue;
                }
                ecGoodsIds.add(goodsId);
            }
            HashMap<Long, DynamicObject> goodsMap = new HashMap<Long, DynamicObject>();
            if (!selfGoodsIds.isEmpty()) {
                DynamicObjectCollection selfGoodsEntryCol = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,name,unit.name,supplier.name,thumbnail,shopprice,category.name categoryname", (QFilter[])new QFilter[]{new QFilter("id", "in", selfGoodsIds)});
                for (DynamicObject selfGoodsEntry : selfGoodsEntryCol) {
                    goodsMap.put(selfGoodsEntry.getLong("id"), selfGoodsEntry);
                }
            }
            if (!ecGoodsIds.isEmpty()) {
                DynamicObjectCollection ecGoodsPriceEntryCol = QueryServiceHelper.query((String)"pbd_mallgoods_price", (String)"mallgoods.id id, mallgoods.name name,mallgoods.unitid.name unit.name,mallgoods.mainpic thumbnail,mallgoods.source,price shopprice, mallgoods.group.name categoryname", (QFilter[])new QFilter[]{new QFilter("mallgoods", "in", ecGoodsIds)});
                for (DynamicObject malGoodsEntry : ecGoodsPriceEntryCol) {
                    goodsMap.put(malGoodsEntry.getLong("id"), malGoodsEntry);
                }
            }
            HashMap<String, String> sourceToSupplierNameMap = new HashMap<String, String>(16);
            for (DynamicObject entry : goods_entryentitys) {
                vs.set("tagscenariotag", entry.get("scenariotag"), i);
                if (entry.getDynamicObject("scenariotag") != null) {
                    vs.set("tagscenariotag_id", entry.getDynamicObject("scenariotag").getPkValue(), i);
                }
                vs.set("source", entry.get("source"), i);
                vs.set("goods", entry.get("goods"), i);
                if (entry.getDynamicObject("goods") != null) {
                    vs.set("goods_id", entry.getDynamicObject("goods").getPkValue(), i);
                    DynamicObject goods = (DynamicObject)goodsMap.get(entry.getDynamicObject("goods").getPkValue());
                    if (goods != null) {
                        vs.set("thumbnail", goods.get("thumbnail"), i);
                        vs.set("categoryname", goods.get("categoryname"), i);
                        vs.set("unit", goods.get("unit.name"), i);
                        vs.set("shopprice", goods.get("shopprice"), i);
                        if ("pmm_prodmanage".equals(entry.get("source"))) {
                            vs.set("goodssupplier", goods.get("supplier.name"), i);
                        } else {
                            String source;
                            String supplierName = (String)sourceToSupplierNameMap.get(goods.getString("mallgoods.source"));
                            if (StringUtils.isBlank((CharSequence)supplierName) && StringUtils.isNotBlank((CharSequence)(source = goods.getString("mallgoods.source")))) {
                                supplierName = EcApiUtil.getMalName((String)source);
                                sourceToSupplierNameMap.put(source, supplierName);
                            }
                            vs.set("goodssupplier", (Object)supplierName, i);
                        }
                    }
                }
                ++i;
            }
            this.getModel().beginInit();
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow(GOODSENTRY, vs);
            this.getModel().endInit();
            this.getView().updateView(GOODSENTRY);
        } else {
            this.getModel().deleteEntryData("scenariogoodsentry");
            this.getView().updateView("scenariogoodsentry");
        }
    }

    public void afterLoadData(EventObject e) {
        this.setTag();
    }

    private void changeAdvconapText(String text) {
        HashMap map = new HashMap();
        HashMap<String, String> nameMap = new HashMap<String, String>();
        nameMap.put(RequestContext.get().getLang().name(), text);
        map.put("text", nameMap);
        this.getView().updateControlMetadata("advconap", map);
    }

    private void setFieldMustInput(String showType) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(PRODUCT_OBTAIN);
        if ("GoodsListSix".equalsIgnoreCase(showType) || "GoodsListSeven".equalsIgnoreCase(showType) || "GoodsListEight".equalsIgnoreCase(showType)) {
            basedataEdit.setMustInput(false);
            return;
        }
        basedataEdit.setMustInput(!ComponentType.GOODS_LIST_FOUR.getVal().equals(showType));
        PictureEdit pictureEdit = (PictureEdit)this.getControl(PICTURE);
        pictureEdit.setMustInput(!Arrays.asList(ComponentType.GOODS_LIST_TWO.getVal(), ComponentType.GOODS_LIST_THREE.getVal()).contains(showType));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }
}

