/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.MalFeeHandleHelper;
import kd.scm.common.util.MalOrderUtil;

public class PmmFreightSchemeEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String BIZPARTER = "bizpartner";
    private static final String PROVINCE = "province";
    private static final String CTIY = "city";
    private static final String LONGNUMBER = "longnumber";
    private static final String FBASEDATAID = "fbasedataid";

    public void afterCreateNewData(EventObject e) {
        if (StringUtils.isNotBlank((CharSequence)MalOrderUtil.getDefaultCurrency())) {
            this.getModel().setValue("curr", (Object)MalOrderUtil.getDefaultCurrency());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnable();
    }

    private void setEnable() {
        DynamicObjectCollection entries = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entries.size(); ++i) {
            DynamicObjectCollection province = (DynamicObjectCollection)this.getModel().getValue(PROVINCE, i);
            if (province.size() == 1) {
                this.getView().setEnable(Boolean.TRUE, i, new String[]{CTIY});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, i, new String[]{CTIY});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (((AbstractOperate)args.getSource()).getOperateKey().equals("save")) {
            if (!this.checkBeforeSave(this.getModel())) {
                args.setCancel(true);
                return;
            }
            this.setEnable();
            DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier");
            if (supplier != null) {
                MalFeeHandleHelper.clearRedisCacheBySupKey((String)supplier.getString("id"));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String key;
        super.afterDoOperation(args);
        switch (key = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "delete": {
                DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier");
                if (supplier == null) break;
                MalFeeHandleHelper.clearRedisCacheBySupKey((String)supplier.getString("id"));
            }
        }
    }

    private boolean checkBeforeSave(IDataModel model) {
        DynamicObjectCollection entries = model.getEntryEntity("entryentity");
        HashMap<String, Integer> proMap = new HashMap<String, Integer>(entries.size());
        if (entries.size() >= 1) {
            for (int i = 0; i < entries.size(); ++i) {
                int j = i + 1;
                DynamicObject entry = (DynamicObject)entries.get(i);
                DynamicObjectCollection city = (DynamicObjectCollection)entry.get(CTIY);
                if (null == city || city.size() == 0) {
                    DynamicObjectCollection provinces = (DynamicObjectCollection)entry.get(PROVINCE);
                    for (DynamicObject obj : provinces) {
                        DynamicObject pro = obj.getDynamicObject(1);
                        if (null != proMap.get(pro.getPkValue().toString())) {
                            this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u8fd0\u8d39\u4fe1\u606f\uff0c\u7b2c{0}\u884c\u5206\u5f55\u548c\u7b2c{1}\u884c\u5206\u5f55\u5b58\u5728\u76f8\u540c\u7701\u4efd\u4e14\u540c\u65f6\u672a\u5f55\u5165\u5e02\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PmmFreightSchemeEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]), j, proMap.get(pro.getPkValue().toString())));
                            return false;
                        }
                        proMap.put(pro.getPkValue().toString(), j);
                    }
                    continue;
                }
                for (DynamicObject obj : city) {
                    DynamicObject cobj = obj.getDynamicObject(1);
                    if (null != proMap.get(cobj.getPkValue().toString())) {
                        this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u8fd0\u8d39\u4fe1\u606f\uff0c\u7b2c{0}\u884c\u5206\u5f55\u548c\u7b2c{1}\u884c\u5206\u5f55\u5b58\u5728\u76f8\u540c\u5e02\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PmmFreightSchemeEdit_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]), j, proMap.get(cobj.getPkValue().toString())));
                        return false;
                    }
                    proMap.put(cobj.getPkValue().toString(), j);
                }
            }
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String name = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObjectCollection province = (DynamicObjectCollection)model.getValue(PROVINCE, rowIndex);
        switch (name) {
            case "supplier": {
                DynamicObject[] suppliers;
                DynamicObject supplierdy = model.getDataEntity().getDynamicObject("supplier");
                if (supplierdy == null) {
                    return;
                }
                QFilter enterFilter = new QFilter("id", "=", (Object)supplierdy.getLong("id"));
                for (DynamicObject dyn : suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,name,number,bizpartner", (QFilter[])new QFilter[]{enterFilter})) {
                    DynamicObject bizpartnerdy = (DynamicObject)dyn.get(BIZPARTER);
                    if (null == bizpartnerdy) continue;
                    model.setValue(BIZPARTER, (Object)bizpartnerdy.getLong("id"));
                }
                break;
            }
            case "province": {
                ArrayList<String> proLongNumberList = new ArrayList<String>(province.size());
                if (province.size() == 1) {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{CTIY});
                } else {
                    this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{CTIY});
                }
                if (province.size() > 0) {
                    for (DynamicObject pro : province) {
                        DynamicObject fbasedataid = (DynamicObject)pro.get(FBASEDATAID);
                        String longnumber = fbasedataid.getString(LONGNUMBER);
                        proLongNumberList.add(longnumber);
                    }
                }
                model.setValue(CTIY, null, rowIndex);
                model.setValue(LONGNUMBER, (Object)(proLongNumberList == null ? null : String.join((CharSequence)",", proLongNumberList)), rowIndex);
                break;
            }
            case "city": {
                DynamicObjectCollection cities = (DynamicObjectCollection)model.getValue(CTIY, rowIndex);
                if (cities.size() > 0) {
                    ArrayList<String> cityLongNumberList = new ArrayList<String>(cities.size());
                    for (DynamicObject city : cities) {
                        DynamicObject fbasedataid = (DynamicObject)city.get(FBASEDATAID);
                        String longnumber = fbasedataid.getString(LONGNUMBER);
                        cityLongNumberList.add(longnumber);
                    }
                    model.setValue(LONGNUMBER, (Object)String.join((CharSequence)",", cityLongNumberList), rowIndex);
                    break;
                }
                if (province.size() > 0) {
                    model.setValue(LONGNUMBER, (Object)((DynamicObject)((DynamicObject)province.get(0)).get(FBASEDATAID)).getString(LONGNUMBER), rowIndex);
                    break;
                }
                model.setValue(LONGNUMBER, null, rowIndex);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        e.getSource();
        BasedataEdit city = (BasedataEdit)this.getView().getControl(CTIY);
        city.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit province = (BasedataEdit)this.getView().getControl(PROVINCE);
        province.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey = arg0.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)CTIY)) {
            DynamicObjectCollection province = (DynamicObjectCollection)this.getModel().getValue(PROVINCE, arg0.getRow());
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            ArrayList<Long> proLongNumberList = new ArrayList<Long>(1);
            if (province.size() > 0) {
                DynamicObject fbasedataid = (DynamicObject)((DynamicObject)province.get(0)).get(FBASEDATAID);
                proLongNumberList.add(fbasedataid.getLong("id"));
                qFilters.add(new QFilter("parent", "in", proLongNumberList));
            } else {
                qFilters.add(new QFilter("parent", "in", proLongNumberList));
            }
        }
    }
}

