/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.IDataModelChangeListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class PmmGoodsExpenseEdit
extends AbstractBillPlugIn
implements IDataModelChangeListener,
BeforeF7SelectListener {
    private static final String QTYFROM = "qtyfrom";
    private static final String QTYTO = "qtyto";
    private static final String PRICEFROM = "pricefrom";
    private static final String PRICETO = "priceto";
    private static final String EXPENSEITEM = "expenseitem";
    private static final String CONTROLTYPE = "controltype";
    private static final String CONTROLTYPE_PRICE = "0";
    private static final String CONTROLTYPE_QTY = "1";

    public void registerListener(EventObject e) {
        BasedataEdit expenseitem = (BasedataEdit)this.getControl(EXPENSEITEM);
        expenseitem.addBeforeF7SelectListener(this::beforeF7Select);
        BasedataEdit goodsuse = (BasedataEdit)this.getControl("gooduse");
        goodsuse.addBeforeF7SelectListener(this::beforeF7Select);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("curr", (Object)1L);
        this.setControlViewValue(0);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (CONTROLTYPE_QTY.equals(this.getModel().getValue("enable"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btn_save"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"btn_save"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if (EXPENSEITEM.equals(fieldKey)) {
            QFilter qFilter = this.getExpenseItemQFilter();
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        } else if ("gooduse".equals(fieldKey)) {
            Object orgId = this.getModel().getValue("createorg_id");
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"pmm_goods_use", (Long)Long.parseLong(orgId.toString()));
            qFilter.and("enable", "=", (Object)CONTROLTYPE_QTY);
            ArrayList goodsUseIds = new ArrayList();
            QFilter qFilter1 = new QFilter("group", "=", (Object)((DynamicObject)this.getModel().getValue("group")).getLong("id"));
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"pmm_goods_expense", (String)"gooduse", (QFilter[])qFilter1.toArray(), (String)"gooduse");){
                dataSet.forEach(row -> goodsUseIds.add(row.getLong("gooduse")));
            }
            qFilter.and("id", "not in", goodsUseIds);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    private QFilter getExpenseItemQFilter() {
        Object orgId = this.getModel().getValue("createorg_id");
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)Long.parseLong(orgId.toString()));
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        List expenseItemIds = entryEntity.stream().filter(entry -> entry.getLong("expenseitem_id") != 0L).map(entry -> entry.getLong("expenseitem_id")).collect(Collectors.toList());
        qFilter.and(new QFilter("id", "not in", expenseItemIds));
        return qFilter;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("deleteentry".equals(operateKey)) {
            this.deleteEntryOp(args);
        }
        if ("newentry".equals(operateKey)) {
            this.addEntryOp(args);
        }
    }

    private void deleteEntryOp(BeforeDoOperationEventArgs args) {
        int[] selectRows;
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity");
        for (int index : selectRows = grid.getSelectRows()) {
            if (index != 0) continue;
            args.setCancel(true);
            String msg = ResManager.loadKDString((String)"\u5fc5\u987b\u5b58\u5728\u4e00\u884c\u6570\u636e\uff0c\u9996\u884c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PmmGoodsExpenseEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return;
        }
    }

    private void addEntryOp(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObject endEntry = (DynamicObject)entries.get(entries.size() - 1);
        if (endEntry.getBigDecimal(QTYTO) == null || BigDecimal.ZERO.compareTo(endEntry.getBigDecimal(QTYTO)) == 0) {
            args.setCancel(true);
            String msg = ResManager.loadKDString((String)"\u8bf7\u5c06\u4e0a\u4e00\u884c\u6570\u636e\u8865\u5145\u5b8c\u6574\u540e\u65b0\u589e\u884c\u3002", (String)"PmmGoodsExpenseEdit_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return;
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        int curIndex = e.getRowDataEntities()[0].getRowIndex();
        int beforeIndex = curIndex - 1;
        IDataModel model = this.getModel();
        BigDecimal newQtyto = BigDecimal.ZERO;
        String toField = QTYTO;
        if (CONTROLTYPE_PRICE.equals(this.getModel().getValue(CONTROLTYPE))) {
            toField = PRICETO;
        }
        if (null != model.getValue(toField, beforeIndex)) {
            newQtyto = new BigDecimal(String.valueOf(model.getValue(toField, beforeIndex)));
        }
        model.setValue(QTYFROM, (Object)newQtyto, curIndex);
        model.setValue(PRICEFROM, (Object)newQtyto, curIndex);
        this.setControlViewValue(curIndex);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)CONTROLTYPE)) {
            IDataModel model = this.getModel();
            Object controltype = model.getValue(CONTROLTYPE);
            DynamicObjectCollection dynamics = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            for (int index = 0; index < dynamics.size(); ++index) {
                model.setValue("entryctrltype", controltype, index);
            }
        }
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)QTYTO) || StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)PRICETO)) {
            this.qtyToChange(e);
        }
        if (StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)CONTROLTYPE) || StringUtils.equals((CharSequence)e.getProperty().getName(), (CharSequence)"curr")) {
            int entrySize = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").size();
            for (int rowIndex = 0; rowIndex < entrySize; ++rowIndex) {
                this.setControlViewValue(rowIndex);
            }
            this.getView().updateView("entryentity");
        }
    }

    private void qtyToChange(PropertyChangedArgs e) {
        String changeField = e.getProperty().getName();
        String compareField = QTYFROM;
        if (PRICEFROM.equals(changeField)) {
            compareField = PRICETO;
        }
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        BigDecimal newValue = (BigDecimal)e.getChangeSet()[0].getNewValue();
        BigDecimal oldValue = (BigDecimal)e.getChangeSet()[0].getOldValue();
        BigDecimal fromValue = (BigDecimal)this.getModel().getValue(compareField, rowIndex);
        if (newValue.compareTo(BigDecimal.ZERO) != 0 && newValue.compareTo(fromValue) <= 0) {
            this.getModel().beginInit();
            String msg = CONTROLTYPE_PRICE.equals(this.getModel().getValue(CONTROLTYPE)) ? ResManager.loadKDString((String)"\u5355\u4ef7\u81f3\u9700\u5927\u4e8e\u5355\u4ef7\u4ece\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PmmGoodsExpenseEdit_13", (String)"scm-pmm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u91d1\u989d\u81f3\u9700\u5927\u4e8e\u91d1\u989d\u4ece\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PmmGoodsExpenseEdit_7", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            this.getModel().setValue(changeField, (Object)oldValue);
            this.setControlViewValue(rowIndex);
            this.getModel().endInit();
            this.getView().updateView("entryentity");
            return;
        }
        this.setControlViewValue(rowIndex);
        this.getModel().beginInit();
        this.getModel().setValue(QTYTO, (Object)newValue);
        this.getModel().setValue(PRICETO, (Object)newValue);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
        DynamicObjectCollection dynamics = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        if (rowIndex != dynamics.size() - 1) {
            this.getPageCache().put("qtyToChangeOldValue", oldValue.toString());
            this.getPageCache().put("qtyToChangeIndex", String.valueOf(rowIndex));
            String msg = ResManager.loadKDString((String)"\u4e0b\u65b9\u5df2\u5b58\u5728\u6570\u636e\uff0c\u4fee\u6539\u6570\u636e\u5c06\u540c\u65f6\u5220\u9664\u4e0b\u65b9\u6240\u6709\u884c\uff0c\u662f\u5426\u4fee\u6539\uff1f", (String)"PmmGoodsExpenseEdit_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("qtyToChange"));
        }
    }

    private void setControlViewValue(int rowIndex) {
        String sign = "\uffe5";
        String controlViewValue = "";
        Object controlTypeValue = this.getModel().getValue(CONTROLTYPE);
        DynamicObject curr = (DynamicObject)this.getModel().getValue("curr");
        int scale = 2;
        if (curr != null) {
            sign = curr.getString("sign");
            scale = CONTROLTYPE_PRICE.equals(controlTypeValue) ? curr.getInt("priceprecision") : curr.getInt("amtprecision");
        }
        String fromValueField = QTYFROM;
        String toValueField = QTYTO;
        if (CONTROLTYPE_PRICE.equals(controlTypeValue)) {
            fromValueField = PRICEFROM;
            toValueField = PRICETO;
        }
        String fromValue = ((BigDecimal)this.getModel().getValue(fromValueField, rowIndex)).setScale(scale, RoundingMode.HALF_UP).toPlainString();
        BigDecimal toValue = ((BigDecimal)this.getModel().getValue(toValueField, rowIndex)).setScale(scale, RoundingMode.HALF_UP);
        controlViewValue = toValue.compareTo(BigDecimal.ZERO) == 0 ? (CONTROLTYPE_QTY.equals(controlTypeValue) ? ResManager.loadKDString((String)"\u91d1\u989d>={0}{1}", (String)"PmmGoodsExpenseEdit_11", (String)"scm-pmm-formplugin", (Object[])new Object[]{sign, fromValue}) : ResManager.loadKDString((String)"\u5355\u4ef7>={0}{1}", (String)"PmmGoodsExpenseEdit_10", (String)"scm-pmm-formplugin", (Object[])new Object[]{sign, fromValue})) : (CONTROLTYPE_QTY.equals(controlTypeValue) ? ResManager.loadKDString((String)"{0}{1}<=\u91d1\u989d<{2}{3}", (String)"PmmGoodsExpenseEdit_9", (String)"scm-pmm-formplugin", (Object[])new Object[]{sign, fromValue, sign, toValue.toPlainString()}) : ResManager.loadKDString((String)"{0}{1}<=\u5355\u4ef7<{2}{3}", (String)"PmmGoodsExpenseEdit_8", (String)"scm-pmm-formplugin", (Object[])new Object[]{sign, fromValue, sign, toValue.toPlainString()}));
        this.getModel().setValue("controlview", (Object)controlViewValue, rowIndex);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("qtyToChange".equals(messageBoxClosedEvent.getCallBackId())) {
            int qtyToChangeIndex = Integer.parseInt(this.getPageCache().get("qtyToChangeIndex"));
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                int entrySize = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").size();
                int deleteSize = entrySize - qtyToChangeIndex - 1;
                int[] rows = new int[deleteSize];
                for (int row = 0; row < deleteSize; ++row) {
                    rows[row] = qtyToChangeIndex + 1 + row;
                }
                this.getModel().deleteEntryRows("entryentity", rows);
            } else {
                this.getModel().beginInit();
                BigDecimal qtyToChangeOldValue = new BigDecimal(this.getPageCache().get("qtyToChangeOldValue"));
                this.getModel().setValue(QTYTO, (Object)qtyToChangeOldValue, qtyToChangeIndex);
                this.getModel().setValue(PRICETO, (Object)qtyToChangeOldValue, qtyToChangeIndex);
                this.setControlViewValue(qtyToChangeIndex);
                this.getModel().endInit();
                this.getView().updateView("entryentity");
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }
}

