/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.scm.common.constant.CalConstant;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.malcore.domain.LadderPriceInfo;
import kd.scm.pmm.business.service.impl.PmmAuditCfmValidatorServiceImpl;

public class PmmPriceAuditEdit
extends AbstractBillPlugIn
implements HyperLinkClickListener,
RowClickEventListener {
    private static final String KEY_CONFIRM = "confirm";
    private static final String MODE = "mode";
    private static final String BILLIDLIST = "billidlist";
    private static final String ENTRYENTITY = "entryentity";
    private static final String GOODS = "goods";
    private static final String BIZSTATUS = "cfmstatus";
    private static final String BILLID = "billid";
    private static final String SUPPLIERNAME = "suppliername";
    private static final String SUPPLIERID = "supplierid";
    private static final String BIZTYPE = "biztype";
    private static final String SHOPPRICE = "shopprice";
    private static final String RESULTCALLBACKID = "confirmActionId";
    private static final String MALLMANAGEBIZAPPID = "/FQ504NB63AY";

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        String bizStatus = this.getModel().getValue(BIZSTATUS).toString();
        if (key.equals(KEY_CONFIRM)) {
            DynamicObject tempObj = this.getModel().getDataEntity();
            if (tempObj == null) {
                evt.setCancel(true);
                return;
            }
            bizStatus = tempObj.getString(BIZSTATUS);
        }
        switch (key) {
            case "confirm": {
                if (!bizStatus.equals("A")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5ba1\u6279\u72b6\u6001\u7b49\u4e8e\u5f85\u5ba1\u6279\u7684\u5355\u636e\u624d\u80fd\u5f55\u5165\u5ba1\u6279\u7ed3\u679c\u3002", (String)"PmmPriceAuditEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                DynamicObject tempObj = this.getModel().getDataEntity();
                evt.setCancel(this.checkShopPrice(tempObj));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"setladderprice")) {
            this.setLadderPrice(args);
        }
    }

    private void setLadderPrice(BeforeDoOperationEventArgs args) {
        DynamicObject row;
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        int[] selectRows = grid.getSelectRows();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(ENTRYENTITY);
        int rowIndex = selectRows[0];
        if (null != this.getPageCache().get("row")) {
            rowIndex = Integer.parseInt(this.getPageCache().get("row"));
        }
        if ("A".equals((row = (DynamicObject)entryCol.get(rowIndex)).getString("pricetype"))) {
            String msg = ResManager.loadKDString((String)"\u53ea\u6709\u4ef7\u683c\u7c7b\u578b\u4e3a\u9636\u68af\u4ef7\u624d\u80fd\u67e5\u770b\u9636\u68af\u4ef7\u3002", (String)"PmmPriceAuditEdit_5", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pbd_ladderprice");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> detailParamMap = new HashMap<String, String>();
        DynamicObjectCollection subEntryRows = row.getDynamicObjectCollection("subentryentity");
        List<Object> ladderPriceInfos = new ArrayList(1024);
        for (DynamicObject subrow : subEntryRows) {
            if (subrow.getBigDecimal("ladprice").compareTo(BigDecimal.ZERO) <= 0) continue;
            LadderPriceInfo info = new LadderPriceInfo(subrow.getBigDecimal("qtyfrom"), subrow.getBigDecimal("qtyto"), subrow.getBigDecimal("ladprice"), Long.valueOf(dataEntity.getDynamicObject("curr").getLong("id")));
            ladderPriceInfos.add(info);
        }
        ladderPriceInfos = ladderPriceInfos.stream().sorted(Comparator.comparing(LadderPriceInfo::getQtyfrom)).collect(Collectors.toList());
        detailParamMap.put("ladderPrices", SerializationUtils.toJsonString(ladderPriceInfos));
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "setladderprice"));
        detailParamMap.put("status", "1");
        showParameter.setCustomParams(detailParamMap);
        this.getView().showForm(showParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String itemKey;
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (null == result || !result.isSuccess()) {
            return;
        }
        switch (itemKey = args.getOperateKey()) {
            case "confirm": {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                boolean inProcess = WorkflowServiceHelper.inProcess((String)dataEntity.getString("id"));
                if (!inProcess) {
                    PmmAuditCfmValidatorServiceImpl pmmAuditCfmValidatorService = new PmmAuditCfmValidatorServiceImpl();
                    StringBuilder sb = pmmAuditCfmValidatorService.checkGoodsProtocol(new DynamicObject[]{dataEntity});
                    if (sb.length() > 0) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u5df2\u5173\u8054\u534f\u8bae\uff0c\u6570\u636e\u5df2\u6539\u53d8\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u8c03\u4ef7\u7533\u8bf7\u3002", (String)"PmmPriceAuditEdit_6", (String)"scm-pmm-formplugin", (Object[])new Object[0]), sb.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener(KEY_CONFIRM));
                        this.getView().updateView();
                        break;
                    }
                    this.auditResult();
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5728\u6d41\u7a0b\u4e2d\u6d41\u8f6c\uff0c\u4e0d\u80fd\u5ba1\u6279\u3002", (String)"PmmPriceAuditEdit_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void auditResult() {
        this.openDealPage("pmm_priceauditcfm", RESULTCALLBACKID, ShowType.Modal);
    }

    private void openDealPage(String pageKey, String actionId, ShowType showType) {
        IDataModel model = this.getModel();
        DynamicObjectCollection entries = model.getEntryEntity(ENTRYENTITY);
        for (DynamicObject entry : entries) {
            DynamicObject dynamicObject = entry.getDynamicObject(GOODS);
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String billids = this.getModel().getDataEntity().getPkValue().toString();
        paramMap.put(BILLIDLIST, billids);
        paramMap.put(MODE, "batch");
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)pageKey, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, actionId), (ShowType)showType));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        IFormView view = this.getView();
        BillModel model = (BillModel)this.getModel();
        switch (actionId) {
            case "confirmActionId": {
                model.load(model.getPKValue());
                view.updateView();
                this.getModel().setDataChanged(false);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        String param;
        super.afterBindData(e);
        this.resetStatus();
        if (!MalOrderUtil.getDefaultMalVersion()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"protocolnumber"});
        }
        if (Boolean.parseBoolean(param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"pricetype", "ladderprice"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pricetype", "ladderprice"});
        }
    }

    public void resetStatus() {
        this.getModel().setDataChanged(false);
        DynamicObject recruitObject = this.getModel().getDataEntity();
        String bizStatus = recruitObject.getString(BIZSTATUS);
        if (bizStatus == null) {
            return;
        }
        if (bizStatus.equals(ConfirmStatusEnum.UNCONFIRM.getVal())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_CONFIRM});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_CONFIRM});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)ENTRYENTITY, (CharSequence)source.getKey())) {
            int row = evt.getRow();
            this.getPageCache().put("row", String.valueOf(row));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent arg0) {
        String fieldName = arg0.getFieldName();
        if ("goodsname".equals(fieldName)) {
            DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRYENTITY);
            DynamicObject dynamicObject = (DynamicObject)rows.get(arg0.getRowIndex());
            DynamicObject prod = (DynamicObject)dynamicObject.get(GOODS);
            long prodId = prod.getLong("id");
            this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"pmm_prodmanage", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)prodId, null, null));
        } else if ("protocolnumber".equals(fieldName)) {
            DynamicObjectCollection rows = this.getModel().getEntryEntity(ENTRYENTITY);
            DynamicObject dynamicObject = (DynamicObject)rows.get(arg0.getRowIndex());
            DynamicObject prodPool = (DynamicObject)dynamicObject.get("prodpool");
            long protocolId = prodPool.getDynamicObject("protocol").getLong("id");
            this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"pmm_protocol", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)protocolId, null, null));
        }
    }

    public boolean checkShopPrice(DynamicObject tempObj) {
        IDataModel model = this.getModel();
        DynamicObjectCollection col = model.getEntryEntity(ENTRYENTITY);
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject entry = (DynamicObject)col.get(i);
            DynamicObject prod = entry.getDynamicObject(GOODS);
            if (entry.getBigDecimal(SHOPPRICE).compareTo(CalConstant.BIGDECIMAL_ZERO) != 0) continue;
            String msg = ResManager.loadKDString((String)"\u5546\u54c1{0}\u7684\u5546\u57ce\u4ef7\u4e0d\u80fd\u4e3a0\u3002", (String)"PmmPriceAuditEdit_1", (String)"scm-pmm-formplugin", (Object[])new Object[]{prod.getString("number")});
            this.getView().showMessage(msg);
            return true;
        }
        return false;
    }

    private void setPricelimit() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCols = dataEntity.getDynamicObjectCollection(ENTRYENTITY);
        HashSet<Long> goodsIds = new HashSet<Long>(16);
        for (DynamicObject row : entryCols) {
            DynamicObject prodpool = row.getDynamicObject("prodpool");
            if (null == prodpool) continue;
            goodsIds.add(prodpool.getLong("id"));
        }
        HashMap<Long, DynamicObject> prodPoolMap = new HashMap<Long, DynamicObject>(16);
        if (goodsIds.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", goodsIds);
            DynamicObjectCollection ent_prodpools = QueryServiceHelper.query((String)"ent_prodpool", (String)"id,protocolentry.taxprice", (QFilter[])qFilter.toArray());
            for (DynamicObject row : ent_prodpools) {
                long key = row.getLong("id");
                prodPoolMap.put(key, row);
            }
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        for (DynamicObject row : entryCols) {
            DynamicObject goods = row.getDynamicObject(GOODS);
            if (null == goods) continue;
            DynamicObject prodpool = row.getDynamicObject("prodpool");
            BigDecimal protocolTaxprice = BigDecimal.ZERO;
            if (null != prodpool) {
                long prodpoolId = prodpool.getLong("id");
                protocolTaxprice = ((DynamicObject)prodPoolMap.get(prodpoolId)).getBigDecimal("protocolentry.taxprice");
            }
            BigDecimal taxPrice = row.getBigDecimal("taxprice");
            BigDecimal taxprice_old = row.getBigDecimal("taxprice_old");
            this.setPricelimitValue(row.getInt("seq") - 1, taxPrice, taxprice_old, protocolTaxprice, cellStyles);
        }
        if (cellStyles.size() > 0) {
            grid.setCellStyle(cellStyles);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.setPricelimit();
    }

    private void setPricelimitValue(int seq, BigDecimal taxPrice, BigDecimal taxprice_old, BigDecimal protocolTaxprice, ArrayList<CellStyle> cellStyles) {
        BigDecimal newTaxPrice;
        BigDecimal hundred = new BigDecimal("100");
        if (taxPrice.compareTo(BigDecimal.ZERO) > 0 && taxprice_old.compareTo(BigDecimal.ZERO) > 0) {
            newTaxPrice = taxPrice.subtract(taxprice_old);
            if (newTaxPrice.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal multiply = newTaxPrice.divide(taxprice_old, 4, RoundingMode.HALF_UP).multiply(hundred).setScale(2);
                if (newTaxPrice.compareTo(BigDecimal.ZERO) > 0) {
                    this.getModel().setValue("pricelimit", (Object)(multiply + "%"), seq);
                    cellStyles.add(this.getCellStyle("#D9001B", "pricelimit", seq));
                } else {
                    this.getModel().setValue("pricelimit", (Object)(multiply + "%"), seq);
                    cellStyles.add(this.getCellStyle("#404040", "pricelimit", seq));
                }
            } else {
                this.getModel().setValue("pricelimit", (Object)"-", seq);
                cellStyles.add(this.getCellStyle("#404040", "pricelimit", seq));
            }
        } else {
            this.getModel().setValue("pricelimit", (Object)"-", seq);
            cellStyles.add(this.getCellStyle("#404040", "pricelimit", seq));
        }
        if (null != protocolTaxprice) {
            if (protocolTaxprice.compareTo(BigDecimal.ZERO) > 0) {
                this.getModel().setValue("protaxprice", (Object)protocolTaxprice, seq);
                newTaxPrice = taxPrice.subtract(protocolTaxprice);
                if (newTaxPrice.compareTo(BigDecimal.ZERO) != 0) {
                    this.getModel().setValue("protocolpricelimit", (Object)(newTaxPrice.divide(protocolTaxprice, 2, RoundingMode.HALF_UP).multiply(hundred) + "%"), seq);
                    cellStyles.add(this.getCellStyle("#D9001B", "protocolpricelimit", seq));
                } else {
                    this.getModel().setValue("protocolpricelimit", (Object)"-", seq);
                    cellStyles.add(this.getCellStyle("#404040", "protocolpricelimit", seq));
                }
            } else {
                this.getModel().setValue("protocolpricelimit", (Object)"-", seq);
                cellStyles.add(this.getCellStyle("#404040", "protocolpricelimit", seq));
            }
        } else {
            this.getModel().setValue("protocolpricelimit", (Object)"-", seq);
            cellStyles.add(this.getCellStyle("#404040", "protocolpricelimit", seq));
        }
    }

    private CellStyle getCellStyle(String foreColor, String fieldName, int seq) {
        CellStyle cs = new CellStyle();
        cs.setForeColor(foreColor);
        cs.setRow(seq);
        cs.setFieldKey(fieldName);
        return cs;
    }
}

