/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.BasedataItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.datamodel.events.QueryImportBasedataEventArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.scm.common.constant.BillAssistConstant;
import kd.scm.common.enums.ConfirmStatusEnum;
import kd.scm.common.util.BaseDataViewDetailUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.cal.CalculateUtils;
import kd.scm.malcore.domain.LadderPriceInfo;
import kd.scm.malcore.enums.MallStatusEnum;
import kd.scm.malcore.util.MalFuzzySearchUtil;
import kd.scm.pmm.business.model.product.ProdMatMapping;
import kd.scm.pmm.business.service.impl.ProdMatMappingServiceImpl;
import kd.scm.pmm.business.service.impl.ProdPoolCommandServiceImpl;

public class PmmProdAuditEdit
extends AbstractBillPlugIn
implements RowClickEventListener,
HyperLinkClickListener,
BeforeF7SelectListener,
BasedataFuzzySearchListener {
    private static Log log = LogFactory.getLog(PmmProdAuditEdit.class);
    private static final String KEY_CONFIRM = "confirm";
    private static final String MODE = "mode";
    private static final String BILLIDLIST = "billidlist";
    private static final String PMM_PRODAUDIT_CFM = "pmm_prodauditcfm";
    private static final String RESULTCALLBACKID = "confirmActionId";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String GOODS = "goods";
    private static final String GOOD_CLASS = "class";
    private static final String BIZSTATUS = "cfmstatus";
    private static final String BIZPARTER = "bizpartner";
    private static final String SUPPLIER = "supplier";
    private static final String PROD_NUMBER = "goods";
    private static final String PROD_CLASS = "class";
    private static final String PROD_UNIT = "unit";
    private static final String PROD_PRICE = "price";
    private static final String PROD_TAXPRICE = "taxprice";
    private static final String PROD_SHOPPRICE = "shopprice";
    private static final String PROD_TAXRATE = "taxrate";
    private static final String PRICEEFFECTDATE = "priceeffectdate";
    private static final String PRICEINVALIDDATE = "priceinvaliddate";
    private static final String BIZTYPE_UPLOAD = "1";
    private static final String BIZTYPE_DOWNLOAD = "2";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (!MalOrderUtil.getDefaultMalVersion()) {
            e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u4e0a\u67b6\u7ba1\u7406", (String)"PmmProdAuditEdit_18", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        String opkey = evt.getOperationKey();
        if (StringUtils.isEmpty((CharSequence)key)) {
            return;
        }
        if (KEY_CONFIRM.equals(opkey)) {
            DynamicObject tempObj = this.getModel().getDataEntity();
            if (tempObj == null) {
                evt.setCancel(true);
                return;
            }
            String bizStatus = tempObj.getString(BIZSTATUS);
            if (!"A".equals(bizStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5ba1\u6279\u72b6\u6001\u7b49\u4e8e\u5f85\u5ba1\u6279\u7684\u5355\u636e\u624d\u80fd\u5f55\u5165\u5ba1\u6279\u7ed3\u679c\u3002", (String)"PmmProdAuditEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    private void auditResult() {
        IDataModel model = this.getModel();
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        HashMap classMap = new HashMap();
        HashMap<String, String> entryNoteMap = new HashMap<String, String>();
        DynamicObjectCollection entries = model.getEntryEntity(ENTRY_ENTITY);
        int unAudit = 0;
        for (DynamicObject entry : entries) {
            if ("0".equals(entry.getString("entryresult"))) {
                ++unAudit;
            }
            entryNoteMap.put(entry.getString("id"), entry.getString("note"));
        }
        if (unAudit > 0) {
            if (unAudit != entries.size()) {
                this.getModel().setValue(BIZSTATUS, (Object)"C");
            } else {
                this.getModel().setValue(BIZSTATUS, (Object)"D");
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
            if (BIZTYPE_UPLOAD.equals(this.getModel().getValue("biztype"))) {
                this.updateProdInfo();
            }
            ProdPoolCommandServiceImpl prodPoolCommandService = new ProdPoolCommandServiceImpl();
            ArrayList<Long> prodAuditIdList = new ArrayList<Long>(8);
            prodAuditIdList.add(model.getDataEntity().getLong("id"));
            prodPoolCommandService.prodAuditCfm(prodAuditIdList);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ba1\u6838\u6210\u529f", (String)"PmmProdAuditEdit_4", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        } else {
            paramMap.put("class", classMap);
            String billids = this.getModel().getDataEntity().getPkValue().toString();
            paramMap.put(BILLIDLIST, billids);
            paramMap.put(MODE, "batch");
            paramMap.put("entryNote", entryNoteMap);
            paramMap.put("biztype", this.getModel().getValue("biztype"));
            FormShowParameter formShowParameter = BillFormUtil.assembleShowDynamicFormParam((String)PMM_PRODAUDIT_CFM, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, RESULTCALLBACKID), (ShowType)ShowType.Modal);
            if (BIZTYPE_DOWNLOAD.equals(this.getModel().getValue("biztype"))) {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u4e0b\u67b6\u5ba1\u6279\u7ed3\u679c", (String)"PmmProdAuditEdit_21", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            }
            this.getView().showForm(formShowParameter);
        }
    }

    private void updateProdInfo() {
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection(ENTRY_ENTITY);
        HashMap<Long, Long> prodIdAndCategoryIdMap = new HashMap<Long, Long>(entryEntity.size());
        HashSet<ProdMatMapping> newProdMatMappingSet = new HashSet<ProdMatMapping>(entryEntity.size());
        for (DynamicObject entry : entryEntity) {
            DynamicObject goods;
            if (!BIZTYPE_UPLOAD.equals(entry.getString("entryresult")) || (goods = entry.getDynamicObject("goods")) == null) continue;
            prodIdAndCategoryIdMap.put(goods.getLong("id"), entry.getDynamicObject("class").getLong("id"));
            if (entry.getDynamicObject("material") == null) continue;
            newProdMatMappingSet.add(new ProdMatMapping(Long.valueOf(goods.getLong("id")), Long.valueOf(entry.getDynamicObject("material").getLong("id"))));
        }
        ProdMatMappingServiceImpl prodMatMappingService = new ProdMatMappingServiceImpl();
        Set prodMatMappings = prodMatMappingService.queryProdsByMatId(prodIdAndCategoryIdMap.keySet());
        newProdMatMappingSet.removeAll(prodMatMappings);
        prodMatMappingService.saveProdMatMapping(newProdMatMappingSet);
        this.updateProdCategory(prodIdAndCategoryIdMap);
    }

    private void updateProdCategory(Map<Long, Long> prodIdAndCategoryIdMap) {
        DynamicObject[] prods;
        if (prodIdAndCategoryIdMap.isEmpty()) {
            return;
        }
        String selectFields = DynamicObjectUtil.getSelectfields((String)"pmm_prodmanage", (boolean)false);
        for (DynamicObject prod : prods = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", prodIdAndCategoryIdMap.keySet())})) {
            prod.set("category", (Object)prodIdAndCategoryIdMap.get(prod.getLong("id")));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ignoreValidation", String.valueOf(Boolean.TRUE));
        option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"pmm_prodmanage", (DynamicObject[])prods, (OperateOption)option);
        if (!operationResult.isSuccess()) {
            String errorInfoDetails = ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo());
            throw new KDBizException(errorInfoDetails);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        BillModel model = (BillModel)this.getModel();
        switch (actionId) {
            case "confirmActionId": {
                model.load(model.getPKValue());
                this.getView().updateView();
                this.getModel().setDataChanged(false);
                break;
            }
            case "quickcreategoods": {
                this.doDealQuickcreategoods(closedCallBackEvent);
                break;
            }
        }
    }

    private void doDealQuickcreategoods(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (null != returnData) {
            Object classId = ((ListSelectedRowCollection)e.getReturnData()).get(0).getPrimaryKeyValue();
            this.quickCreateGoods(classId);
            this.doQuickCreateOp();
        }
    }

    private void doQuickCreateOp() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isshowmessage", "false");
        OperationResult operationResult = this.getView().invokeOperation("save", operateOption);
        if (operationResult.isSuccess()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5546\u54c1\u521b\u5efa\u6210\u529f\u3002", (String)"PmmProdAuditEdit_20", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        } else {
            CommonUtil.check((OperationResult)operationResult);
        }
    }

    public void afterBindData(EventObject e) {
        List allPurViewPermissionOrgs;
        super.afterBindData(e);
        if (StringUtils.isNotBlank((CharSequence)MalOrderUtil.getDefaultCurrency())) {
            this.getModel().setValue("curr", (Object)MalOrderUtil.getDefaultCurrency());
        }
        this.resetStatus();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String cfmstatus = dataEntity.getString(BIZSTATUS);
        if (cfmstatus == null || String.valueOf(cfmstatus).isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryresult"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"note"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"entryresult"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"note"});
        }
        if (this.getModel().getValue("org") == null && (allPurViewPermissionOrgs = OrgUtil.getAllPurViewPermissionOrgs((String)this.getView().getEntityId())).contains(RequestContext.get().getOrgId())) {
            this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
        }
        this.setEntryValueByGoods();
        this.submitAndAuditButtonView();
        this.setBtnStatusByProtocolDiff();
    }

    private void setBtnStatusByProtocolDiff() {
        String biztype = (String)this.getModel().getValue("biztype");
        DynamicObject protocolid = this.getModel().getDataEntity(true).getDynamicObject("protocolid");
        if (null == protocolid || !protocolid.getBoolean("differentarea")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"purplan"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"proentryseq", "newentry", "deleteentry"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"proentryseq"});
            if (BIZTYPE_DOWNLOAD.equals(biztype) && protocolid.getBoolean("differentarea")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"newentry", "deleteentry"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"purplan"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"newentry", "deleteentry"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"purplan"});
            }
        }
    }

    public void resetStatus() {
        this.getModel().setDataChanged(false);
        DynamicObject recruitObject = this.getModel().getDataEntity();
        String bizStatus = recruitObject.getString(BIZSTATUS);
        if (bizStatus == null) {
            return;
        }
        if (bizStatus.equals(ConfirmStatusEnum.UNCONFIRM.getVal())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_CONFIRM});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_CONFIRM});
        }
    }

    private void setEntryValueByGoods() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entrys = model.getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        for (int rowIndex = 0; rowIndex < entrys.size(); ++rowIndex) {
            DynamicObject entry = (DynamicObject)entrys.get(rowIndex);
            if (entry.get("goods") != null) continue;
            model.setValue(PROD_PRICE, null, rowIndex);
            model.setValue(PROD_TAXPRICE, null, rowIndex);
            model.setValue(PROD_SHOPPRICE, null, rowIndex);
            model.setValue("class", null, rowIndex);
            model.setValue(PROD_UNIT, null, rowIndex);
            model.setValue("barcode", null, rowIndex);
            if (null != model.getValue("protocolentry", rowIndex)) continue;
            model.setValue(PRICEEFFECTDATE, null, rowIndex);
            model.setValue(PRICEINVALIDDATE, null, rowIndex);
        }
    }

    private void submitAndAuditButtonView() {
        if (!WorkflowServiceHelper.getEnabledProcDefByEntityNumber((String)"pmm_prodaudit").isEmpty()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"submitandaudit"});
        }
        if (!BIZTYPE_DOWNLOAD.equals(this.getModel().getValue("biztype"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"submitandaudit"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit goods = (BasedataEdit)this.getView().getControl("goods");
        goods.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        goods.addBasedataFuzzySearchListener((BasedataFuzzySearchListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit protocolid = (BasedataEdit)this.getView().getControl("protocolid");
        protocolid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        protocolid.addBeforeF7ViewDetailListener(beforeF7ViewDetailEvent -> {
            beforeF7ViewDetailEvent.setCancel(true);
            this.getView().showForm((FormShowParameter)BaseDataViewDetailUtil.buildShowParam((Object)beforeF7ViewDetailEvent.getPkId(), (String)"pmm_protocol", (String)"pmm_protocol"));
        });
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        DynamicObjectCollection rows = null;
        rows = this.getModel().getEntryEntity(ENTRY_ENTITY);
        DynamicObject dynamicObject = (DynamicObject)rows.get(hyperLinkClickEvent.getRowIndex());
        DynamicObject o = (DynamicObject)dynamicObject.get("goods");
        Long productId = o.getLong("id");
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"pmm_prodmanage", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.VIEW, (long)productId, null, null));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"quickcreategoods")) {
            this.checkQuickCreateGoods(args);
        }
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"batchimportimage")) {
            this.checkBatchImportImage(args);
        }
    }

    private void checkBatchImportImage(BeforeDoOperationEventArgs args) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"PmmProdAuditEdit_11", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        ArrayList<Long> idList = new ArrayList<Long>(1024);
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        for (int seq : selectRows) {
            DynamicObject row = (DynamicObject)entryCol.get(seq);
            DynamicObject goods = row.getDynamicObject("goods");
            if (null == goods) continue;
            idList.add(goods.getLong("id"));
        }
        DynamicObjectCollection dynList = QueryServiceHelper.query((String)"ent_prodmanage", (String)"id,supplier", (QFilter[])new QFilter("id", "in", idList).toArray());
        HashSet goodIds = new HashSet(dynList.size());
        dynList.forEach(t -> goodIds.add(t.getLong(SUPPLIER)));
        if (goodIds.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u4e00\u4e2a\u4f9b\u5e94\u5546\u7684\u5546\u54c1\u3002", (String)"PmmProdAuditEdit_12", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (idList.size() > 100) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5546\u54c1\u6570\u91cf\u8d85\u8fc7100\u4e2a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PmmProdAuditEdit_13", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("ent_importpicture");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap<String, Object> detailParamMap = new HashMap<String, Object>();
        detailParamMap.put("goodsIds", idList);
        detailParamMap.put("origin", "ent");
        showParameter.setCustomParams(detailParamMap);
        this.getView().showForm(showParameter);
    }

    private void checkQuickCreateGoods(BeforeDoOperationEventArgs args) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        int[] selectRows = grid.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"PmmProdAuditEdit_11", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        boolean isExistGoods = false;
        boolean isEmptyGoods = true;
        for (int seq : selectRows) {
            DynamicObject row = (DynamicObject)entryCol.get(seq);
            DynamicObject protocolentry = row.getDynamicObject("protocolentry");
            if (null == protocolentry || protocolentry.getString("materialname").isEmpty()) continue;
            isEmptyGoods = false;
            if (null == row.getDynamicObject("goods")) continue;
            isExistGoods = true;
        }
        if (isEmptyGoods) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u7269\u6599\uff0c\u65e0\u6cd5\u81ea\u52a8\u521b\u5efa\u5546\u54c1\u3002", (String)"PmmProdAuditEdit_14", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (isExistGoods) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("quickcreategoods", (IFormPlugin)this);
            String confirmTip = "";
            confirmTip = selectRows.length == 1 ? ResManager.loadKDString((String)"\u8be5\u884c\u5df2\u5b58\u5728\u5546\u54c1\uff0c\u662f\u5426\u8986\u76d6\uff1f", (String)"PmmProdAuditEdit_16", (String)"scm-pmm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u90e8\u5206\u884c\u4e2d\u5df2\u5b58\u5728\u5546\u54c1\uff0c\u662f\u5426\u8986\u76d6\uff1f", (String)"PmmProdAuditEdit_17", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        } else {
            this.showGoodClass(false);
        }
    }

    private void showGoodClass(boolean isYesNo) {
        int[] selectRows;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        long bizpartner = dataEntity.getDynamicObject(BIZPARTER).getLong("id");
        DynamicObject supplier = this.getSupplier(bizpartner);
        DynamicObject goods = this.createEntProdmanage((DynamicObject)entryCol.get(0), bizpartner, 0L, supplier);
        ArrayList<Integer> indexs = new ArrayList<Integer>(1024);
        EntryGrid grid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        for (int index : selectRows = grid.getSelectRows()) {
            DynamicObject protocolentry;
            DynamicObject row = (DynamicObject)entryCol.get(index);
            if (isYesNo) {
                indexs.add(index);
            }
            if (null == (protocolentry = row.getDynamicObject("protocolentry")) || protocolentry.getString("materialname").isEmpty() || isYesNo || null != row.getDynamicObject("goods")) continue;
            indexs.add(index);
        }
        if (indexs.size() == 0) {
            return;
        }
        this.getPageCache().put("index", SerializationUtils.toJsonString(indexs));
        String orgId = null;
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)"ent_prodmanage", (DynamicObject)goods, orgId);
        if (null == codeRule) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u5546\u54c1\u7f16\u7801\u89c4\u5219\u3002", (String)"PmmProdAuditEdit_15", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return;
        }
        Set<Long> materialGroupIds = this.getMaterialGroupIdsByMaterialIds(indexs);
        Map<Long, List<Long>> categoryMatMapping = this.getCategoryMatMappingByMaterialGroupIds(materialGroupIds);
        if (materialGroupIds.size() == 1 && !categoryMatMapping.isEmpty() && categoryMatMapping.entrySet().iterator().next().getValue().size() == 1) {
            this.quickCreateGoods(categoryMatMapping.get(materialGroupIds.iterator().next()).get(0));
            this.doQuickCreateOp();
            return;
        }
        List<Long> categoryMappingsIntersection = this.getCategoryMappingsIntersection(categoryMatMapping);
        if (categoryMappingsIntersection.isEmpty() && !categoryMatMapping.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u53ef\u9009\u5546\u54c1\u5206\u7c7b\u65e0\u4ea4\u96c6\uff0c\u8bf7\u5206\u5f00\u521b\u5efa\u5546\u54c1\u3002", (String)"PmmProdAuditEdit_19", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter classQfilter = new QFilter("number", "=", (Object)"00000801");
        DynamicObjectCollection classStards = QueryServiceHelper.query((String)"bd_goodsclassstandard", (String)"id", (QFilter[])classQfilter.toArray());
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        ListShowParameter parameter = new ListShowParameter();
        parameter.setFormId("bd_item_classtreelistf7");
        parameter.setBillFormId("mdr_goodsclass");
        parameter.getOpenStyle().setShowType(ShowType.Default);
        parameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "quickcreategoods"));
        parameter.setShowTitle(false);
        parameter.setLookUp(true);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getOpenStyle().setInlineStyleCss(css);
        parameter.setMultiSelect(false);
        parameter.setHasRight(true);
        QFilter qFilter = new QFilter("level", "=", (Object)3);
        qFilter.and("enable", "=", (Object)BIZTYPE_UPLOAD);
        qFilter.and("standard.number", "=", (Object)"00000801");
        if (!categoryMappingsIntersection.isEmpty()) {
            qFilter.and("id", "in", categoryMappingsIntersection);
        }
        parameter.getListFilterParameter().getQFilters().add(qFilter);
        HashMap<String, Long> paramMap = new HashMap<String, Long>(1024);
        if (classStards.size() > 0) {
            paramMap.put("groupStandard", ((DynamicObject)classStards.get(0)).getLong("id"));
        }
        parameter.getCustomParams().putAll(paramMap);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private Set<Long> getMaterialGroupIdsByMaterialIds(List<Integer> indexs) {
        ArrayList<Long> materialIds = new ArrayList<Long>(indexs.size());
        for (Integer index : indexs) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, index.intValue());
            DynamicObject material = entryRowEntity.getDynamicObject("material");
            if (material == null) continue;
            materialIds.add(material.getLong("id"));
        }
        QFilter qFilter = new QFilter("material.id", "in", materialIds);
        qFilter.and(new QFilter("standard.id", "=", (Object)BillAssistConstant.MATERIAL_STANDARD_ID));
        HashSet<Long> materialGroupIds = new HashSet<Long>(materialIds.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_materialgroupdetail", (String)"group.id group", (QFilter[])qFilter.toArray(), null);){
            dataSet.forEach(row -> materialGroupIds.add(row.getLong("group")));
        }
        return materialGroupIds;
    }

    private Map<Long, List<Long>> getCategoryMatMappingByMaterialGroupIds(Set<Long> materialGroupIds) {
        HashMap<Long, List<Long>> categoryMatMapping = new HashMap<Long, List<Long>>(materialGroupIds.size());
        QFilter mappingQFilter = new QFilter("materialgroup.id", "in", materialGroupIds);
        mappingQFilter.and("goodscategory.standard.id", "=", (Object)944841720602823680L);
        mappingQFilter.and("goodscategory.enable", "=", (Object)BIZTYPE_UPLOAD);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pmm_categorymatmapping", (String)"materialgroup,goodscategory", (QFilter[])mappingQFilter.toArray(), null);){
            dataSet.forEach(row -> {
                List materialGroup = categoryMatMapping.computeIfAbsent(row.getLong("materialgroup"), k -> new ArrayList());
                materialGroup.add(row.getLong("goodscategory"));
            });
        }
        return categoryMatMapping;
    }

    private List<Long> getCategoryMappingsIntersection(Map<Long, List<Long>> categoryMatMapping) {
        List<Long> goodsCategoryIds = new ArrayList<Long>(categoryMatMapping.size());
        if (categoryMatMapping.isEmpty()) {
            return goodsCategoryIds;
        }
        int i = 0;
        for (Map.Entry<Long, List<Long>> entry : categoryMatMapping.entrySet()) {
            List<Long> value = entry.getValue();
            if (++i == 1) {
                goodsCategoryIds = value;
                continue;
            }
            goodsCategoryIds.retainAll(value);
        }
        return goodsCategoryIds;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"quickcreategoods", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.showGoodClass(true);
            } else {
                this.showGoodClass(false);
            }
        }
    }

    private void quickCreateGoods(Object classId) {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        long bizpartner = dataEntity.getDynamicObject(BIZPARTER).getLong("id");
        DynamicObject supplierDyn = this.getSupplier(bizpartner);
        ArrayList<DynamicObject> prods = new ArrayList<DynamicObject>(1024);
        HashMap<Integer, DynamicObject> seq_GoodsMap = new HashMap<Integer, DynamicObject>(1024);
        String indexstr = this.getPageCache().get("index");
        if (StringUtils.isEmpty((CharSequence)indexstr)) {
            this.getPageCache().remove("index");
            return;
        }
        List indexs = (List)SerializationUtils.fromJsonString((String)indexstr, List.class);
        Iterator iterator = indexs.iterator();
        while (iterator.hasNext()) {
            int seq = (Integer)iterator.next();
            DynamicObject row = (DynamicObject)entryCol.get(seq);
            DynamicObject protocolentry = row.getDynamicObject("protocolentry");
            if (null == protocolentry || protocolentry.getString("materialname").isEmpty()) continue;
            DynamicObject goods = this.createEntProdmanage(row, bizpartner, classId, supplierDyn);
            prods.add(goods);
            seq_GoodsMap.put(row.getInt("seq"), goods);
        }
        this.getPageCache().remove("index");
        if (prods.size() > 0) {
            OperateOption saveOption = OperateOption.create();
            saveOption.setVariableValue("isStrict", "false");
            saveOption.setVariableValue("ishasright", "true");
            OperationResult saveResullt = OperationServiceHelper.executeOperate((String)"save", (String)"pmm_prodmanage", (DynamicObject[])prods.toArray(new DynamicObject[0]), (OperateOption)saveOption);
            if (!saveResullt.isSuccess()) {
                log.info(ExceptionUtil.getErrorInfoDetails((List)saveResullt.getAllErrorOrValidateInfo()));
            } else {
                IDataModel entryOperate = this.getModel();
                for (Integer seq : indexs) {
                    if (null == seq_GoodsMap.get(seq + 1)) continue;
                    DynamicObject googds = (DynamicObject)seq_GoodsMap.get(seq + 1);
                    this.getModel().setValue("goods", (Object)googds, seq.intValue());
                    entryOperate.setEntryCurrentRowIndex(ENTRY_ENTITY, seq.intValue());
                    entryOperate.deleteEntryData("subentryentity");
                }
            }
        }
    }

    private DynamicObject getSupplier(long bizpartner) {
        QFilter qFilter = new QFilter(BIZPARTER, "=", (Object)bizpartner);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        if (null != dataEntity.get(SUPPLIER)) {
            if (dataEntity.get(SUPPLIER) instanceof DynamicObject) {
                qFilter.and(new QFilter("id", "=", (Object)dataEntity.getDynamicObject(SUPPLIER).getLong("id")));
            } else {
                Long supplierId = Long.parseLong(String.valueOf(dataEntity.get(SUPPLIER)));
                qFilter.and(new QFilter("id", "=", (Object)supplierId));
            }
        }
        DynamicObject supplier = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"id,createorg.id", (QFilter[])qFilter.toArray());
        return supplier;
    }

    private DynamicObject createEntProdmanage(DynamicObject row, long bizpartner, Object classId, DynamicObject supplier) {
        DynamicObject entGood = ORM.create().newDynamicObject("pmm_prodmanage");
        ORM.create().setPrimaryKey(entGood);
        DynamicObject protocolentry = row.getDynamicObject("protocolentry");
        entGood.set("name", (Object)protocolentry.getString("materialname"));
        String goodsbrand = "";
        entGood.set(PROD_PRICE, (Object)protocolentry.getBigDecimal(PROD_PRICE));
        if (null != protocolentry.getDynamicObject("taxrateid")) {
            entGood.set("taxrateid", (Object)protocolentry.getDynamicObject("taxrateid"));
            entGood.set(PROD_TAXRATE, (Object)protocolentry.getBigDecimal(PROD_TAXRATE));
        }
        entGood.set(PROD_TAXPRICE, (Object)protocolentry.getBigDecimal(PROD_TAXPRICE));
        entGood.set(PROD_UNIT, (Object)protocolentry.getDynamicObject(PROD_UNIT));
        entGood.set("category_id", (Object)Long.parseLong(String.valueOf(classId)));
        entGood.set("origin", (Object)BIZTYPE_DOWNLOAD);
        entGood.set("status", (Object)"A");
        entGood.set("enable", (Object)BIZTYPE_UPLOAD);
        entGood.set("mallstatus", (Object)"F");
        entGood.set("taxtype", (Object)BIZTYPE_UPLOAD);
        entGood.set("source", (Object)BIZTYPE_UPLOAD);
        entGood.set("standard", (Object)Long.parseLong("944841720602823680"));
        entGood.set(BIZPARTER, (Object)bizpartner);
        if (null != supplier) {
            entGood.set("supplier_id", (Object)supplier.getLong("id"));
            entGood.set("createorg_id", (Object)supplier.getLong("createorg.id"));
        }
        entGood.set("creator_id", (Object)RequestContext.get().getCurrUserId());
        DynamicObject protocolid = this.getModel().getDataEntity(true).getDynamicObject("protocolid");
        if (null != protocolid) {
            entGood.set("curr", (Object)protocolid.getDynamicObject("curr"));
        }
        return entGood;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String itemKey;
        super.afterDoOperation(args);
        switch (itemKey = args.getOperateKey()) {
            case "confirm": {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                boolean inProcess = WorkflowServiceHelper.inProcess((String)dataEntity.getString("id"));
                if (!inProcess) {
                    this.auditResult();
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u5728\u6d41\u7a0b\u4e2d\u6d41\u8f6c\uff0c\u4e0d\u80fd\u5ba1\u6279\u3002", (String)"PmmProdAuditEdit_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "submit": 
            case "cancel": {
                if (!args.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs arg0) {
        String property;
        super.propertyChanged(arg0);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (property = arg0.getProperty().getName()) {
            case "supplier": {
                DynamicObject[] suppliers;
                DynamicObject supplierdy = this.getModel().getDataEntity().getDynamicObject(SUPPLIER);
                if (supplierdy == null) {
                    return;
                }
                QFilter enterFilter = new QFilter("id", "=", supplierdy.get("id"));
                for (DynamicObject dyn : suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)"id,name,number,bizpartner", (QFilter[])new QFilter[]{enterFilter})) {
                    DynamicObject bizpartnerdy = (DynamicObject)dyn.get(BIZPARTER);
                    if (null == bizpartnerdy) continue;
                    model.setValue(BIZPARTER, bizpartnerdy.get("id"));
                }
                this.getModel().deleteEntryData(ENTRY_ENTITY);
                this.getModel().createNewEntryRow(ENTRY_ENTITY);
                break;
            }
            case "goods": {
                int rowIndex = arg0.getChangeSet()[0].getRowIndex();
                this.doProdChange(rowIndex, model, property);
                this.getView().updateView();
                break;
            }
            case "taxprice": {
                this.doTaxPriceChange(model, property, arg0, view);
                break;
            }
            case "pricetype": {
                this.doPriceTypeChange(arg0);
                break;
            }
        }
    }

    private void doPriceTypeChange(PropertyChangedArgs arg0) {
        Object newValue = arg0.getChangeSet()[0].getNewValue();
        int rowIndex = arg0.getChangeSet()[0].getRowIndex();
        if ("B".equals(newValue)) {
            this.setTaxpriceByLadprice(rowIndex);
        }
    }

    private void setTaxpriceByLadprice(int rowIndex) {
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        DynamicObject row = (DynamicObject)entryCol.get(rowIndex);
        DynamicObjectCollection subentryentity = row.getDynamicObjectCollection("subentryentity");
        if (subentryentity.size() > 1) {
            ArrayList<LadderPriceInfo> ladderPriceInfos = new ArrayList<LadderPriceInfo>(1024);
            for (DynamicObject subRow : subentryentity) {
                LadderPriceInfo info = new LadderPriceInfo(subRow.getBigDecimal("qtyfrom"), subRow.getBigDecimal("qtyto"), subRow.getBigDecimal("ladprice"), Long.valueOf(0L));
                ladderPriceInfos.add(info);
            }
            if (ladderPriceInfos.size() > 0) {
                this.getModel().setValue(PROD_TAXPRICE, (Object)((LadderPriceInfo)ladderPriceInfos.get(0)).getLadprice(), rowIndex);
            }
        }
    }

    private void doTaxPriceChange(IDataModel model, String property, PropertyChangedArgs arg0, IFormView view) {
        int rowIndex1 = arg0.getChangeSet()[0].getRowIndex();
        IDataModel entryOperate = this.getModel();
        DynamicObject entry = entryOperate.getEntryRowEntity(ENTRY_ENTITY, rowIndex1);
        DynamicObject entryprod = entry.getDynamicObject("goods");
        if (null == entryprod) {
            entry.set(PROD_TAXPRICE, null);
            return;
        }
        this.calTaxprice(model, rowIndex1, property);
    }

    private void calTaxprice(IDataModel model, int rowIndex1, String property) {
        BigDecimal taxPrice = (BigDecimal)model.getValue(property, rowIndex1);
        IDataModel entryOperate = this.getModel();
        DynamicObject entry = entryOperate.getEntryRowEntity(ENTRY_ENTITY, rowIndex1);
        DynamicObject entryprod = entry.getDynamicObject("goods");
        BigDecimal taxRate = entryprod.getBigDecimal(PROD_TAXRATE);
        BigDecimal price = BigDecimal.ZERO;
        int taxtype = entryprod.getInt("taxtype");
        price = 0 == taxtype ? CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)2) : CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)2);
        model.setValue(PROD_PRICE, (Object)price, rowIndex1);
        model.setValue(PROD_SHOPPRICE, (Object)taxPrice, rowIndex1);
    }

    private void doProdChange(int rowIndex, IDataModel model, String property) {
        DynamicObject prod = (DynamicObject)model.getValue(property, rowIndex);
        if (prod == null) {
            model.setValue(PROD_UNIT, null, rowIndex);
            model.setValue(PROD_PRICE, null, rowIndex);
            model.setValue(PROD_TAXPRICE, null, rowIndex);
            model.setValue(PROD_SHOPPRICE, null, rowIndex);
            model.setValue("class", null, rowIndex);
            if (null == model.getValue("protocolentry", rowIndex)) {
                model.setValue(PRICEEFFECTDATE, null, rowIndex);
                model.setValue(PRICEINVALIDDATE, null, rowIndex);
                model.setValue("minorderqty", null, rowIndex);
                model.setValue("leadtime", null, rowIndex);
            }
            model.setValue("barcode", null, rowIndex);
            String biztype = (String)this.getModel().getValue("biztype");
            if (BIZTYPE_DOWNLOAD.equals(biztype)) {
                model.setValue("protocolentry", null, rowIndex);
                model.setValue("material", null, rowIndex);
                model.setValue("auxpty", null, rowIndex);
            }
            return;
        }
        Object unit = prod.get("unit.id");
        if (null != unit) {
            model.setValue(PROD_UNIT, unit, rowIndex);
        }
        this.setProdPriceData(model, rowIndex, prod);
        DynamicObject cate = (DynamicObject)prod.get("category");
        if (null != cate) {
            model.setValue("class", cate.get("id"), rowIndex);
        }
        String barcode = prod.getString("barcode");
        model.setValue("barcode", (Object)barcode, rowIndex);
        Long goodsId = prod.getLong("id");
        Object protocolid = this.getModel().getValue("protocolid");
        QFilter qFilter = new QFilter("goods.id", "=", (Object)goodsId);
        if (null != protocolid) {
            Object protocolentry;
            DynamicObject protocolInfo = (DynamicObject)protocolid;
            qFilter.and(new QFilter("protocol.id", "=", (Object)protocolInfo.getLong("id")));
            if (protocolInfo.getBoolean("differentarea") && null != (protocolentry = this.getModel().getValue("protocolentry", rowIndex))) {
                DynamicObject protocolentryDyn = (DynamicObject)protocolentry;
                qFilter.and(new QFilter("protocolentry.id", "=", (Object)protocolentryDyn.getLong("id")));
            }
        }
        DynamicObjectCollection pmm_prodpool = QueryServiceHelper.query((String)"pmm_prodpool", (String)"priceentry.qtyto,priceentry.qtyfrom,priceentry.ladprice", (QFilter[])qFilter.toArray());
        IDataModel model1 = this.getModel();
        if (pmm_prodpool.size() > 1) {
            IDataModel entryOperate = this.getModel();
            entryOperate.setEntryCurrentRowIndex(ENTRY_ENTITY, rowIndex);
            entryOperate.deleteEntryData("subentryentity");
            for (DynamicObject pool : pmm_prodpool) {
                int subRow = entryOperate.createNewEntryRow("subentryentity");
                BigDecimal qtyto = pool.getBigDecimal("priceentry.qtyto");
                BigDecimal qtyfrom = pool.getBigDecimal("priceentry.qtyfrom");
                BigDecimal ladprice = pool.getBigDecimal("priceentry.ladprice");
                model1.setValue("qtyto", (Object)qtyto, subRow, rowIndex);
                model1.setValue("qtyfrom", (Object)qtyfrom, subRow, rowIndex);
                model1.setValue("ladprice", (Object)ladprice, subRow, rowIndex);
            }
            model1.setValue("pricetype", (Object)"B", rowIndex);
        } else if (pmm_prodpool.size() > 0) {
            model1.setValue("pricetype", (Object)"A", rowIndex);
        }
    }

    private void setProdPriceData(IDataModel model, int rowIndex, DynamicObject prod) {
        BigDecimal shopPrice;
        BigDecimal taxPrice;
        long prodId = prod.getLong("id");
        QFilter qFilter = new QFilter("goods", "=", (Object)prodId);
        QFilter mallstatusQFilter = new QFilter("mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal());
        mallstatusQFilter.or(new QFilter("mallstatus", "=", (Object)MallStatusEnum.UNSOLD.getVal()));
        qFilter.and(mallstatusQFilter);
        Object protocol = this.getModel().getValue("protocolid");
        if (protocol != null) {
            DynamicObject protocolDyn = (DynamicObject)protocol;
            qFilter.and(new QFilter("protocol_id", "=", (Object)protocolDyn.getLong("id")));
            Object protocolentry = this.getModel().getValue("protocolentry", rowIndex);
            long protocolEntryId = 0L;
            if (null != protocolentry) {
                DynamicObject protocolentryDyn = (DynamicObject)protocolentry;
                protocolEntryId = protocolentryDyn.getLong("id");
                qFilter.and(new QFilter("protocolentry.id", "=", (Object)protocolEntryId));
            }
            HashSet<Long> protocolEntryIds = new HashSet<Long>(1024);
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
            for (DynamicObject row : entryCol) {
                DynamicObject protocolentryDyn;
                if (null == row.get("protocolentry") || null == row.get("goods") || protocolEntryId == (protocolentryDyn = row.getDynamicObject("protocolentry")).getLong("id") && prodId == row.getDynamicObject("goods").getLong("id") || prodId != row.getDynamicObject("goods").getLong("id")) continue;
                protocolEntryIds.add(protocolentryDyn.getLong("id"));
            }
            if (protocolEntryIds.size() > 0) {
                qFilter.and(new QFilter("protocolentry.id", "not in", protocolEntryIds));
            }
        } else {
            qFilter.and(new QFilter("protocol_id", "is null", (Object)0L).or(new QFilter("protocol_id", "=", (Object)0L)));
        }
        String biztype = (String)this.getModel().getValue("biztype");
        DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"id,goods,unit,taxprice,price,priceeffectdate,priceinvaliddate,minorderqty,leadtime,protocolentry.id protocolentry,protocolentry.material material,protocolentry.auxpty auxpty", (QFilter[])qFilter.toArray());
        for (DynamicObject prodPool : prodPools) {
            model.setValue(PROD_PRICE, (Object)prodPool.getBigDecimal(PROD_PRICE), rowIndex);
            model.setValue(PROD_TAXPRICE, (Object)prodPool.getBigDecimal(PROD_TAXPRICE), rowIndex);
            model.setValue(PROD_SHOPPRICE, (Object)prodPool.getBigDecimal(PROD_TAXPRICE), rowIndex);
            model.setValue(PROD_UNIT, (Object)prodPool.getLong(PROD_UNIT), rowIndex);
            model.setValue(PRICEEFFECTDATE, (Object)prodPool.getDate(PRICEEFFECTDATE), rowIndex);
            model.setValue(PRICEINVALIDDATE, (Object)prodPool.getDate(PRICEEFFECTDATE), rowIndex);
            model.setValue("leadtime", prodPool.get("leadtime"), rowIndex);
            model.setValue("minorderqty", prodPool.get("minorderqty"), rowIndex);
            if (!BIZTYPE_DOWNLOAD.equals(biztype)) continue;
            model.setValue("protocolentry", (Object)prodPool.getLong("protocolentry"), rowIndex);
            model.setValue("material", (Object)prodPool.getLong("material"), rowIndex);
            model.setValue("auxpty", (Object)prodPool.getLong("auxpty"), rowIndex);
        }
        if (BIZTYPE_DOWNLOAD.equals(biztype) && prodPools.size() == 0) {
            model.setValue("protocolentry", null, rowIndex);
            model.setValue("material", null, rowIndex);
            model.setValue("auxpty", null, rowIndex);
        }
        BigDecimal taxpriceB = new BigDecimal(String.valueOf(model.getValue(PROD_TAXPRICE, rowIndex)));
        BigDecimal price = prod.getBigDecimal(PROD_PRICE);
        if ("A".equals(prod.getString("status"))) {
            taxpriceB = prod.getBigDecimal(PROD_TAXPRICE);
            DynamicObject unit = prod.getDynamicObject(PROD_UNIT);
            if (taxpriceB.compareTo(BigDecimal.ZERO) > 0) {
                model.setValue(PROD_TAXPRICE, (Object)taxpriceB, rowIndex);
                model.setValue(PROD_UNIT, (Object)unit, rowIndex);
                this.calTaxprice(model, rowIndex, PROD_TAXPRICE);
            }
        }
        if (null != price) {
            model.setValue(PROD_PRICE, (Object)price, rowIndex);
        }
        if (null != (taxPrice = prod.getBigDecimal(PROD_TAXPRICE))) {
            model.setValue(PROD_TAXPRICE, (Object)taxPrice, rowIndex);
        }
        if (null != (shopPrice = prod.getBigDecimal(PROD_SHOPPRICE))) {
            model.setValue(PROD_SHOPPRICE, (Object)shopPrice, rowIndex);
        }
        this.getModel().deleteEntryData("subentryentity");
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey = arg0.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        switch (fieldKey) {
            case "goods": {
                this.setGoodsFilter(showParameter, arg0);
                break;
            }
            case "org": {
                this.setOrgFilter(showParameter, arg0);
                break;
            }
            case "protocolid": {
                this.setProtocolFilter(showParameter);
                break;
            }
        }
    }

    private void setOrgFilter(ListShowParameter showParameter, BeforeF7SelectEvent arg0) {
        List userHasAllPurPermissionOrgs = OrgUtil.getUserHasAllPurPermissionOrgs();
        showParameter.getListFilterParameter().getQFilters().clear();
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)userHasAllPurPermissionOrgs));
    }

    private void setGoodsFilter(ListShowParameter showParameter, BeforeF7SelectEvent arg0) {
        DynamicObject supplierdy = this.getModel().getDataEntity().getDynamicObject(SUPPLIER);
        if (null == supplierdy) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u5546\u5bb6\u201d\uff0c\u518d\u5f55\u5165\u5546\u54c1\u660e\u7ec6\u3002", (String)"PmmProdAuditEdit_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            arg0.setCancel(true);
            return;
        }
        QFilter qfilter = new QFilter(SUPPLIER, "=", supplierdy.get("id"));
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection newObject = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
        if (null == dataEntity.getDynamicObject("protocolid") || !dataEntity.getDynamicObject("protocolid").getBoolean("differentarea")) {
            ArrayList<Object> list = new ArrayList<Object>(newObject.size());
            for (DynamicObject dyn : newObject) {
                Object goodsid = dyn.get("goods.id");
                if (null == goodsid) continue;
                list.add(dyn.get("goods.id"));
            }
            if (list.size() > 0) {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", list));
            }
        }
        String biztype = (String)this.getModel().getValue("biztype");
        if (null != dataEntity.getDynamicObject("protocolid") && dataEntity.getDynamicObject("protocolid").getBoolean("differentarea") && null != this.getModel().getValue("protocolentry", arg0.getRow())) {
            DynamicObject protocolentry = (DynamicObject)this.getModel().getValue("protocolentry", arg0.getRow());
            long purplanid = protocolentry.getDynamicObject("purplanid").getLong("id");
            ArrayList<Object> list = new ArrayList<Object>(newObject.size());
            for (Object dyn : newObject) {
                Object goodsid = dyn.get("goods.id");
                if (dyn.getDynamicObject("protocolentry") == null) continue;
                long tarPurPlanid = dyn.getDynamicObject("protocolentry").getDynamicObject("purplanid").getLong("id");
                if (null == goodsid || purplanid != tarPurPlanid) continue;
                list.add(dyn.get("goods.id"));
            }
            if (list.size() > 0) {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", list));
            }
            if (BIZTYPE_UPLOAD.equals(biztype)) {
                showParameter.setMultiSelect(false);
            }
        }
        HashSet<Long> goodsSet = new HashSet<Long>(1024);
        Object protocolid = this.getModel().getValue("protocolid");
        Object protocolentry = this.getModel().getValue("protocolentry", arg0.getRow());
        if (null != protocolid) {
            QFilter qFilter = new QFilter("protocolid", "=", ((DynamicObject)protocolid).getPkValue());
            qFilter.and("biztype", "=", (Object)biztype);
            qFilter.and(new QFilter(BIZSTATUS, "=", (Object)"A"));
            DynamicObjectCollection prodRequests = QueryServiceHelper.query((String)"pmm_prodaudit", (String)"billno,protocolid,entryentity.goods,entryentity.protocolentry", (QFilter[])qFilter.toArray());
            for (DynamicObject row : prodRequests) {
                if (((DynamicObject)protocolid).getBoolean("differentarea")) {
                    Long protocolentryId = ((DynamicObject)protocolentry).getLong("id");
                    if (!protocolentryId.equals(row.getLong("entryentity.protocolentry"))) continue;
                    goodsSet.add(row.getLong("entryentity.goods"));
                    continue;
                }
                goodsSet.add(row.getLong("entryentity.goods"));
            }
            if (BIZTYPE_UPLOAD.equals(biztype)) {
                Set<Long> goodsIdsByConflict;
                QFilter prodPoolQFilter = new QFilter("protocol", "=", ((DynamicObject)protocolid).getPkValue());
                prodPoolQFilter.and(new QFilter("mallstatus", "!=", (Object)MallStatusEnum.SOLDOUT.getVal()).and("mallstatus", "!=", (Object)MallStatusEnum.BACKMODIFY.getVal()));
                DynamicObjectCollection prodPools = QueryServiceHelper.query((String)"pmm_prodpool", (String)"goods,protocol,protocolentry,protocolentry.purplanid", (QFilter[])prodPoolQFilter.toArray());
                for (DynamicObject prodPool : prodPools) {
                    if (((DynamicObject)protocolid).getBoolean("differentarea")) {
                        DynamicObject protocolentryDyn = (DynamicObject)protocolentry;
                        Long protocolentryId = protocolentryDyn.getLong("id");
                        Long purplanid = protocolentryDyn.getDynamicObject("purplanid").getLong("id");
                        if (!protocolentryId.equals(prodPool.getLong("protocolentry")) && !purplanid.equals(prodPool.getLong("protocolentry.purplanid"))) continue;
                        goodsSet.add(prodPool.getLong("goods"));
                        continue;
                    }
                    goodsSet.add(prodPool.getLong("goods"));
                }
                if (!(dataEntity.getDynamicObject("protocolid").getBoolean("differentarea") && null == this.getModel().getValue("protocolentry", arg0.getRow()) || (goodsIdsByConflict = this.getGoodsIdsByConflict(arg0.getRow())).size() <= 0)) {
                    qfilter.and(new QFilter("id", "not in", goodsIdsByConflict));
                }
            } else {
                qfilter.and(new QFilter("protocolentry.prodpool.mallstatus", "in", Arrays.asList(MallStatusEnum.SOLD.getVal(), MallStatusEnum.UNSOLD.getVal())));
                qfilter.and(new QFilter("protocolentry.protocol", "=", ((DynamicObject)protocolid).getPkValue()));
                if (dataEntity.getDynamicObject("protocolid").getBoolean("differentarea")) {
                    if (null != protocolentry) {
                        DynamicObject protocolentryDyn = (DynamicObject)protocolentry;
                        qfilter.and(new QFilter("protocolentry.prodpool.protocolentry", "=", (Object)protocolentryDyn.getLong("id")));
                    } else {
                        DynamicObjectCollection entProdmanages = QueryServiceHelper.query((String)"ent_prodmanage", (String)"protocolentry.prodpool,id,protocolentry.prodpool.protocolentry", (QFilter[])qfilter.toArray());
                        HashMap<String, Long> goods_poolIdMap = new HashMap<String, Long>(1024);
                        for (Object row : entProdmanages) {
                            String key = row.getString("id") + "_" + row.getString("protocolentry.prodpool.protocolentry");
                            goods_poolIdMap.put(key, row.getLong("protocolentry.prodpool"));
                        }
                        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection(ENTRY_ENTITY);
                        for (DynamicObject row : entryCol) {
                            if (null == row.get("goods") || null == row.get("protocolentry")) continue;
                            String key = row.getString("goods_id") + "_" + row.getString("protocolentry_id");
                            goods_poolIdMap.remove(key);
                        }
                        if (goods_poolIdMap.size() > 0) {
                            HashSet poolIds = new HashSet(1024);
                            for (Map.Entry map : goods_poolIdMap.entrySet()) {
                                poolIds.add(map.getValue());
                            }
                            qfilter.and(new QFilter("protocolentry.prodpool", "in", poolIds));
                        }
                    }
                }
            }
        } else {
            if (BIZTYPE_UPLOAD.equals(biztype)) {
                qfilter.and(new QFilter("protocolentry.prodpool.mallstatus", "=", (Object)MallStatusEnum.SOLDOUT.getVal()).or("protocolentry.prodpool.mallstatus", "=", (Object)MallStatusEnum.TEMPSTATUS.getVal()).or("protocolentry.prodpool.mallstatus", "=", (Object)MallStatusEnum.BACKMODIFY.getVal()));
            } else {
                qfilter.and(new QFilter("protocolentry.prodpool.mallstatus", "in", Arrays.asList(MallStatusEnum.SOLD.getVal(), MallStatusEnum.UNSOLD.getVal())));
            }
            qfilter.and(new QFilter("protocolentry.protocol", "=", (Object)0L));
        }
        showParameter.getListFilterParameter().getQFilters().add(qfilter);
        if (goodsSet.size() > 0) {
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", goodsSet));
        }
        showParameter.setCustomParam("ismergerows", (Object)Boolean.TRUE);
    }

    private Set<Long> getGoodsIdsByConflict(int rowIndex) {
        HashSet<Long> remoeGoodsIds = new HashSet<Long>(1024);
        DynamicObject protocol = (DynamicObject)this.getModel().getValue("protocolid");
        DynamicObject supplier = (DynamicObject)this.getModel().getValue(SUPPLIER);
        if (protocol == null || supplier == null) {
            return remoeGoodsIds;
        }
        Date effectdate = protocol.getDate("effectdate");
        Date invaliddate = DateUtil.string2date((String)DateUtil.getFormatEndDate((Date)protocol.getDate("invaliddate")), (String)"yyyy-MM-dd HH:mm:ss");
        QFilter qFilter = new QFilter("partyb.id", "=", (Object)supplier.getLong("id"));
        qFilter.and(new QFilter("effectdate", "<=", (Object)invaliddate));
        qFilter.and(new QFilter("invaliddate", ">=", (Object)effectdate));
        Map<Long, Map<String, Object>> protocolId_DynMap = this.getProtocolMap(qFilter);
        String purmode = protocol.getString("purmode");
        HashSet<Long> conflictIds = new HashSet<Long>(1024);
        Long srcProtocolId = protocol.getLong("id");
        Map<String, Object> srcDataMap = protocolId_DynMap.get(srcProtocolId);
        Set srcOrgSet = (Set)srcDataMap.get("orgs");
        for (Map.Entry<Long, Map<String, Object>> map : protocolId_DynMap.entrySet()) {
            Long id = map.getKey();
            if (srcProtocolId.equals(id)) continue;
            Map<String, Object> dataMap = map.getValue();
            Date tarEffectdate = (Date)dataMap.get("effectdate");
            Date tarInvaliddate = (Date)dataMap.get("invaliddate");
            Set tarOrgSet = (Set)dataMap.get("orgs");
            Set<Long> diffOrgIds = this.getDiffOrgId(srcOrgSet, tarOrgSet);
            if (null == tarEffectdate || null == tarInvaliddate || effectdate.after(tarInvaliddate) || invaliddate.before(tarEffectdate) || !purmode.equals(BIZTYPE_UPLOAD) && diffOrgIds.size() <= 0) continue;
            conflictIds.add(id);
        }
        boolean differentarea = protocol.getBoolean("differentarea");
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        if (conflictIds.size() > 0) {
            if (differentarea) {
                DynamicObject row = (DynamicObject)entryCol.get(rowIndex);
                Long protocolentryId = row.getDynamicObject("protocolentry").getLong("id");
                Map entryOrgs = (Map)srcDataMap.get("entryOrgs");
                if (null != entryOrgs.get(protocolentryId)) {
                    srcOrgSet = (Set)entryOrgs.get(protocolentryId);
                }
            }
            QFilter filter = new QFilter("protocol.id", "in", conflictIds);
            QFilter protocolStatus = new QFilter("protocol.protocolstatus", "=", (Object)"A");
            protocolStatus.or(new QFilter("protocol.protocolstatus", "=", (Object)"B"));
            QFilter malstatus = new QFilter("mallstatus", "=", (Object)"A");
            malstatus.or(new QFilter("mallstatus", "=", (Object)"B"));
            QFilter salestatus = new QFilter("salestatus", "=", (Object)"A");
            salestatus.or(new QFilter("salestatus", "=", (Object)"C"));
            filter.and(protocolStatus).and(malstatus).and(salestatus);
            String prodSectlors = "id,goods.id,entryentity.orgname,isgoodvisible";
            DynamicObjectCollection prodDynColl = QueryServiceHelper.query((String)"pmm_prodpool", (String)prodSectlors, (QFilter[])new QFilter[]{filter});
            boolean isgoodvisible = (Boolean)srcDataMap.get("isgoodvisible");
            for (DynamicObject row : prodDynColl) {
                if (!isgoodvisible && !srcOrgSet.contains(row.getLong("entryentity.orgname")) && !row.getBoolean("isgoodvisible")) continue;
                remoeGoodsIds.add(row.getLong("goods.id"));
            }
        }
        remoeGoodsIds.addAll(this.getGoodsIdsByProdRequest(supplier.getLong("id"), srcProtocolId, rowIndex));
        if (differentarea) {
            remoeGoodsIds.addAll(this.getConflictGoodsIdsByPurPlan(rowIndex, srcProtocolId));
        }
        return remoeGoodsIds;
    }

    private Set<Long> getConflictGoodsIdsByPurPlan(int rowIndex, Long srcProtocolId) {
        DynamicObjectCollection entryCols = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        QFilter qFilter1 = new QFilter("protocol.id", "=", (Object)srcProtocolId);
        String selectors = "id,entryentity.org";
        DynamicObjectCollection pmmPurPlans = QueryServiceHelper.query((String)"pmm_purchaseplan", (String)selectors, (QFilter[])qFilter1.toArray());
        HashMap purPlanMap = new HashMap(1024);
        for (DynamicObject row : pmmPurPlans) {
            List<Long> orgIds = new ArrayList<Long>(1024);
            if (null != purPlanMap.get(row.getLong("id"))) {
                orgIds = (List)purPlanMap.get(row.getLong("id"));
            }
            orgIds.add(row.getLong("entryentity.org"));
            purPlanMap.put(row.getLong("id"), orgIds);
        }
        HashSet<Long> goodsIds = new HashSet<Long>(1024);
        Long curPurPlanId = ((DynamicObject)entryCols.get(rowIndex)).getDynamicObject("protocolentry").getLong("purplanid.id");
        List curOrgIds = (List)purPlanMap.get(curPurPlanId);
        block1: for (DynamicObject row : entryCols) {
            if (null == row.get("goods") || row.getInt("seq") - 1 == rowIndex) continue;
            long purPlanId = row.getDynamicObject("protocolentry").getLong("purplanid.id");
            List tarOrgIds = (List)purPlanMap.get(purPlanId);
            for (Long orgId : curOrgIds) {
                if (!tarOrgIds.contains(orgId)) continue;
                goodsIds.add(row.getLong("goods.id"));
                continue block1;
            }
        }
        return goodsIds;
    }

    private Map<Long, Map<String, Object>> getProtocolMap(QFilter qFilter) {
        String selectors = "id,effectdate,invaliddate,purmode,entryentity.orgname,differentarea,isgoodvisible";
        HashMap<Long, Map<String, Object>> protocolId_DynMap = new HashMap<Long, Map<String, Object>>(1024);
        DynamicObjectCollection pmmProtocols = QueryServiceHelper.query((String)"pmm_protocol", (String)selectors, (QFilter[])qFilter.toArray());
        HashSet<Long> differentareaProtocolIds = new HashSet<Long>(1024);
        for (DynamicObject row : pmmProtocols) {
            Long id = row.getLong("id");
            if (row.getBoolean("differentarea")) {
                differentareaProtocolIds.add(id);
            }
            Date effectdate = row.getDate("effectdate");
            Date invaliddate = row.getDate("invaliddate");
            Map<String, Date> dataMap = new HashMap(1024);
            Set<Long> orgIDSet = new HashSet(1024);
            if (null != protocolId_DynMap.get(id)) {
                dataMap = (Map)protocolId_DynMap.get(id);
                orgIDSet = (Set)dataMap.get("orgs");
            }
            if (!BIZTYPE_UPLOAD.equals(row.getString("purmode")) && row.getLong("entryentity.orgname") != 0L) {
                orgIDSet.add(row.getLong("entryentity.orgname"));
            }
            dataMap.put("effectdate", effectdate);
            dataMap.put("invaliddate", invaliddate);
            dataMap.put("orgs", (Date)((Object)orgIDSet));
            dataMap.put("isgoodvisible", (Date)((Object)Boolean.valueOf(row.getBoolean("isgoodvisible"))));
            protocolId_DynMap.put(id, dataMap);
        }
        if (differentareaProtocolIds.size() > 0) {
            qFilter = new QFilter("id", "in", differentareaProtocolIds);
            selectors = "id,effectdate,invaliddate,purmode,entryentity1.id,entryentity1.purplanid,entryentity1.purorg,differentarea";
            pmmProtocols = QueryServiceHelper.query((String)"pmm_protocol", (String)selectors, (QFilter[])qFilter.toArray());
            HashMap purPlanId_OrgsMap = new HashMap(1024);
            HashMap<Long, Long> entryId_purPlanIdMap = new HashMap<Long, Long>(1024);
            HashMap protocolId_entrysMap = new HashMap(1024);
            for (DynamicObject row : pmmProtocols) {
                Long id = row.getLong("id");
                Long entryId = row.getLong("entryentity1.id");
                List<Long> entrys = new ArrayList<Long>(1024);
                if (null != protocolId_entrysMap.get(id)) {
                    entrys = (List)protocolId_entrysMap.get(id);
                }
                entrys.add(entryId);
                protocolId_entrysMap.put(id, entrys);
                Long purplanid = row.getLong("entryentity1.purplanid");
                Long purorg = row.getLong("entryentity1.purorg");
                Set<Long> orgIds = new HashSet<Long>(1024);
                if (null != purPlanId_OrgsMap.get(purplanid)) {
                    orgIds = (Set)purPlanId_OrgsMap.get(purplanid);
                }
                orgIds.add(purorg);
                purPlanId_OrgsMap.put(purplanid, orgIds);
                entryId_purPlanIdMap.put(entryId, purplanid);
            }
            for (Map.Entry map : protocolId_DynMap.entrySet()) {
                Map value = (Map)map.getValue();
                if (!differentareaProtocolIds.contains(map.getKey())) continue;
                List protocolEntryIds = (List)protocolId_entrysMap.get(map.getKey());
                HashMap<Long, Set> newValueMap = new HashMap<Long, Set>(1024);
                for (Long entryId : protocolEntryIds) {
                    Long purPlanId = (Long)entryId_purPlanIdMap.get(entryId);
                    Set orgIds = (Set)purPlanId_OrgsMap.get(purPlanId);
                    newValueMap.put(entryId, orgIds);
                }
                value.put("entryOrgs", newValueMap);
                protocolId_DynMap.put((Long)map.getKey(), value);
            }
        }
        return protocolId_DynMap;
    }

    private Set<Long> getGoodsIdsByProdRequest(long supId, Long srcProtocolId, int rowIndex) {
        HashSet<Long> removeGoodsIds = new HashSet<Long>(1024);
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        DynamicObject protocol = (DynamicObject)this.getModel().getValue("protocolid");
        if (protocol == null) {
            return removeGoodsIds;
        }
        boolean differentarea = protocol.getBoolean("differentarea");
        QFilter filter = new QFilter("supplier.id", "in", (Object)supId);
        QFilter statusFilter = new QFilter(BIZSTATUS, "=", (Object)"A");
        statusFilter.or(new QFilter("billstatus", "=", (Object)"A"));
        filter.and(statusFilter);
        filter.and(new QFilter("biztype", "=", (Object)BIZTYPE_UPLOAD));
        String prodSectlors = "id,entryentity.goods.id,protocolid,billno,protocolid.differentarea,entryentity.protocolentry";
        DynamicObjectCollection prodDynColl = QueryServiceHelper.query((String)"ent_prodrequest", (String)prodSectlors, (QFilter[])new QFilter[]{filter});
        HashMap protocolId_GoodsIdMap = new HashMap(1024);
        HashSet<Long> differentAreaProtocols = new HashSet<Long>(1024);
        HashMap<Long, Long> protocolEntryId_GoodsIdMap = new HashMap<Long, Long>(1024);
        for (DynamicObject prod : prodDynColl) {
            Long protocolId = prod.getLong("protocolid");
            Long goodsId = prod.getLong("entryentity.goods.id");
            if (null == protocolId || protocolId.equals(0L) || null == goodsId || goodsId.equals(0L)) continue;
            List<Long> goodsIds = new ArrayList<Long>(1024);
            if (null != protocolId_GoodsIdMap.get(protocolId)) {
                goodsIds = (List)protocolId_GoodsIdMap.get(protocolId);
            }
            goodsIds.add(goodsId);
            protocolId_GoodsIdMap.put(protocolId, goodsIds);
            if (!prod.getBoolean("protocolid.differentarea")) continue;
            differentAreaProtocols.add(protocolId);
            protocolEntryId_GoodsIdMap.put(prod.getLong("entryentity.protocolentry"), goodsId);
        }
        if (protocolId_GoodsIdMap.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", protocolId_GoodsIdMap.keySet());
            qFilter.or(new QFilter("id", "=", (Object)srcProtocolId));
            Map<Long, Map<String, Object>> protocolId_DynMap = this.getProtocolMap(qFilter);
            Map<String, Object> srcDataMap = protocolId_DynMap.get(srcProtocolId);
            Date effectdate = (Date)srcDataMap.get("effectdate");
            Date invaliddate = (Date)srcDataMap.get("invaliddate");
            Set srcOrgSet = (Set)srcDataMap.get("orgs");
            if (differentarea) {
                DynamicObject row = (DynamicObject)entryCol.get(rowIndex);
                Long protocolentryId = row.getDynamicObject("protocolentry").getLong("id");
                Map entryOrgs = (Map)srcDataMap.get("entryOrgs");
                if (null != entryOrgs.get(protocolentryId)) {
                    srcOrgSet = (Set)entryOrgs.get(protocolentryId);
                }
            }
            String purmode = protocol.getString("purmode");
            for (Map.Entry<Long, Map<String, Object>> map : protocolId_DynMap.entrySet()) {
                Long id = map.getKey();
                if (srcProtocolId.equals(id)) continue;
                Map<String, Object> dataMap = map.getValue();
                Date tarEffectdate = (Date)dataMap.get("effectdate");
                Date tarInvaliddate = (Date)dataMap.get("invaliddate");
                Set tarOrgSet = (Set)dataMap.get("orgs");
                Set<Long> diffOrgIds = this.getDiffOrgId(srcOrgSet, tarOrgSet);
                if (null == tarEffectdate || null == tarInvaliddate || effectdate.after(tarInvaliddate) || invaliddate.before(tarEffectdate)) continue;
                if (differentAreaProtocols.contains(map.getKey())) {
                    Map entryOrgs = (Map)dataMap.get("entryOrgs");
                    for (Map.Entry entryOrgsMap : entryOrgs.entrySet()) {
                        Set orgs = (Set)entryOrgsMap.getValue();
                        diffOrgIds = this.getDiffOrgId(srcOrgSet, orgs);
                        if (diffOrgIds.size() <= 0 || null == protocolEntryId_GoodsIdMap.get(entryOrgsMap.getKey())) continue;
                        removeGoodsIds.add((Long)protocolEntryId_GoodsIdMap.get(entryOrgsMap.getKey()));
                    }
                    continue;
                }
                if (!purmode.equals(BIZTYPE_UPLOAD) && diffOrgIds.size() <= 0 || null == protocolId_GoodsIdMap.get(id)) continue;
                removeGoodsIds.addAll((Collection)protocolId_GoodsIdMap.get(id));
            }
        }
        return removeGoodsIds;
    }

    private Set<Long> getDiffOrgId(Set<Long> srcOrgs, Set<Long> tarOrgs) {
        HashSet<Long> differOrgIds = new HashSet<Long>(1024);
        if (tarOrgs.size() == 0) {
            return srcOrgs;
        }
        for (Long id : srcOrgs) {
            if (!tarOrgs.contains(id)) continue;
            differOrgIds.add(id);
        }
        return differOrgIds;
    }

    private void setProtocolFilter(ListShowParameter showParameter) {
        QFilter qFilter = new QFilter("confirmstatus", "=", (Object)"C");
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        QFilter cfmStatusQFilter = new QFilter("protocolstatus", "=", (Object)"A");
        cfmStatusQFilter.or(new QFilter("protocolstatus", "=", (Object)"B"));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qFilter.and(cfmStatusQFilter);
        if (null != this.getModel().getValue(SUPPLIER)) {
            DynamicObject supplier = (DynamicObject)this.getModel().getValue(SUPPLIER);
            qFilter.and(new QFilter("partyb", "=", (Object)supplier.getLong("id")));
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        qFilter.and(new QFilter("org", "=", (Object)org.getLong("id")));
        HashSet<Long> protocolIDS = new HashSet<Long>(1024);
        DynamicObjectCollection protocolCols = QueryServiceHelper.query((String)"pmm_protocol", (String)"id", (QFilter[])qFilter.toArray());
        for (DynamicObject info : protocolCols) {
            protocolIDS.add(info.getLong("id"));
        }
        qFilter = new QFilter("protocolid", "in", protocolIDS);
        QFilter entReqcfmStatusQFilter = new QFilter(BIZSTATUS, "=", (Object)"E");
        entReqcfmStatusQFilter.or(new QFilter(BIZSTATUS, "=", (Object)"A"));
        qFilter.and(entReqcfmStatusQFilter);
        DynamicObjectCollection prodrequestCols = QueryServiceHelper.query((String)"pmm_prodaudit", (String)"protocolid", (QFilter[])qFilter.toArray());
        for (DynamicObject info : prodrequestCols) {
            protocolIDS.remove(info.getLong("protocolid"));
        }
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", protocolIDS));
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        IDataModel model = this.getModel();
        DynamicObjectCollection billentrys = (DynamicObjectCollection)model.getValue(ENTRY_ENTITY);
        List dataList = (List)e.getSourceData().get(ENTRY_ENTITY);
        for (DynamicObject row : billentrys) {
            int seq = row.getInt("seq") - 1;
            for (Object obj : dataList) {
                Map entry = (Map)obj;
                if (!row.getString("id").equals(entry.get("id")) || entry.get("goods") != null) continue;
                model.setValue("goods", null, seq);
                row.set("goods", null);
            }
            BigDecimal taxprice = row.getBigDecimal(PROD_TAXPRICE);
            this.doProdChange(seq, model, "goods");
            if (null == row.getDynamicObject("goods")) continue;
            model.setValue(PROD_TAXPRICE, (Object)taxprice, seq);
            this.calTaxprice(model, seq, PROD_TAXPRICE);
        }
    }

    public void queryImportBasedata(QueryImportBasedataEventArgs e) {
        super.queryImportBasedata(e);
        Map searchResult = e.getSearchResult();
        for (Map.Entry map : searchResult.entrySet()) {
            if (!"goods".equals(((BasedataItem)map.getKey()).getFieldKey())) continue;
            String searchKey = ((BasedataItem)map.getKey()).getSearchKey();
            String searchValue = ((BasedataItem)map.getKey()).getSearchValue();
            QFilter qFilter = new QFilter(searchKey, "=", (Object)searchValue);
            DynamicObjectCollection prods = QueryServiceHelper.query((String)((BasedataItem)map.getKey()).getEntityNumber(), (String)"id", (QFilter[])qFilter.toArray());
            if (prods.size() <= 0) continue;
            ((List)map.getValue()).add(((DynamicObject)prods.get(0)).getLong("id"));
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map supplierCOl = (Map)e.getSourceData().get(SUPPLIER);
        Map protocolidCol = (Map)e.getSourceData().get("protocolid");
        Object supNumber = supplierCOl.get("number");
        Object proBillno = protocolidCol.get("billno");
        Object billno = e.getSourceData().get("billno");
        QFilter prodFilter = new QFilter("billno", "=", billno);
        DynamicObjectCollection prodreques = QueryServiceHelper.query((String)"ent_prodrequest", (String)"bizpartner,curr,supplier.number,protocolid.billno,protocolid.effectdate,protocolid.invaliddate", (QFilter[])prodFilter.toArray());
        if (prodreques.size() == 0) {
            String msg = ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff1a\u8be5\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"PmmProdAuditEdit_5", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            e.setCancel(true);
            e.setCancelMessage(String.format(msg, new Object[0]));
            e.setFireAfterImportData(false);
            return;
        }
        String srcNumber = ((DynamicObject)prodreques.get(0)).getString("supplier.number");
        String srcBillno = ((DynamicObject)prodreques.get(0)).getString("protocolid.billno");
        Date proEffectDate = ((DynamicObject)prodreques.get(0)).getDate("protocolid.effectdate");
        Date proInvalidDate = ((DynamicObject)prodreques.get(0)).getDate("protocolid.invaliddate");
        if (null == supNumber || !supNumber.equals(srcNumber)) {
            String msg = ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff1a\u5f15\u5165\u5546\u5bb6\u7f16\u7801\u4e0e\u5f53\u524d\u5355\u636e\u5546\u5bb6\u7f16\u7801\u4e0d\u4e00\u81f4\u3002", (String)"PmmProdAuditEdit_6", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            e.setCancel(true);
            e.setCancelMessage(String.format(msg, new Object[0]));
            e.setFireAfterImportData(false);
            return;
        }
        if (null == proBillno || !proBillno.equals(srcBillno)) {
            String msg = ResManager.loadKDString((String)"\u5f15\u5165\u5931\u8d25\uff1a\u5f15\u5165\u534f\u8bae\u7f16\u7801\u4e0e\u5f53\u524d\u5355\u636e\u534f\u8bae\u7f16\u7801\u4e0d\u4e00\u81f4\u3002", (String)"PmmProdAuditEdit_7", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            e.setCancel(true);
            e.setCancelMessage(String.format(msg, new Object[0]));
            e.setFireAfterImportData(false);
            return;
        }
        List entryCOl = (List)e.getSourceData().get(ENTRY_ENTITY);
        for (int i = 0; i < entryCOl.size(); ++i) {
            Date priceInvalidDate;
            Date priceInvalidDate2;
            String msg;
            Date priceEffectDate;
            Map row = (Map)entryCOl.get(i);
            String priceEffectDateStr = (String)row.get(PRICEEFFECTDATE);
            String priceInvalidDateStr = (String)row.get(PRICEINVALIDDATE);
            if (null != priceEffectDateStr && (priceEffectDate = DateUtil.string2date((String)priceEffectDateStr, (String)"yyyy-MM-dd")).before(proEffectDate)) {
                msg = ResManager.loadKDString((String)"\u4ef7\u683c\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u534f\u8bae\u751f\u6548\u65e5\u671f\u3002", (String)"PmmProdAuditEdit_8", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(i), msg);
                e.setFireAfterImportData(false);
                return;
            }
            if (null != priceInvalidDateStr && (priceInvalidDate2 = DateUtil.string2date((String)priceInvalidDateStr, (String)"yyyy-MM-dd")).after(proInvalidDate)) {
                msg = ResManager.loadKDString((String)"\u4ef7\u683c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u534f\u8bae\u5931\u6548\u65e5\u671f\u3002", (String)"PmmProdAuditEdit_9", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                e.setCancel(true);
                e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(i), msg);
                e.setFireAfterImportData(false);
                return;
            }
            if (null == priceEffectDateStr || null == priceInvalidDateStr || !(priceEffectDate = DateUtil.string2date((String)priceEffectDateStr, (String)"yyyy-MM-dd")).after(priceInvalidDate = DateUtil.string2date((String)priceInvalidDateStr, (String)"yyyy-MM-dd"))) continue;
            String msg2 = ResManager.loadKDString((String)"\u4ef7\u683c\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u4ef7\u683c\u5931\u6548\u65e5\u671f\u3002", (String)"PmmProdAuditEdit_10", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            e.setCancel(true);
            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(i), msg2);
            e.setFireAfterImportData(false);
            return;
        }
    }

    public void handleData(BasedataFuzzySearchEvent arg0) {
        List queryData = arg0.getQueryData();
        MalFuzzySearchUtil.queryDataDuplicatesRemoveByNumber((List)queryData);
    }
}

