/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.OpenFormUtil;
import kd.scm.malcore.util.prodinfochange.MalProdInfoChangeUtil;

public class PmmProdChangeManageEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.buttonView();
        this.entryView();
        this.pictureView();
        this.contentView();
    }

    private void buttonView() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        String cfmStatus = (String)this.getModel().getValue("cfmstatus");
        String origin = (String)this.getModel().getValue("origin");
        if (!(BillStatusEnum.AUDIT.getVal().equals(billStatus) && "A".equals(cfmStatus) && "1".equals(origin))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_confirm"});
        }
        if ("1".equals(origin)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_check"});
        }
    }

    private void entryView() {
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entryentity");
        HashMap<String, String> contentValue = new HashMap<String, String>(8);
        HashMap<String, String> specificationValue = new HashMap<String, String>(8);
        DynamicObjectCollection entryClone = (DynamicObjectCollection)entrys.clone();
        Iterator iterator = entrys.iterator();
        while (iterator.hasNext()) {
            DynamicObject entry = (DynamicObject)iterator.next();
            if ("prodattributeentry".equals(entry.getString("entryname"))) {
                iterator.remove();
                continue;
            }
            if ("content_tag".equals(entry.getString("fieldname"))) {
                contentValue.put("oldValue", entry.getString("oldvalue"));
                contentValue.put("newValue", entry.getString("newvalue"));
                iterator.remove();
                continue;
            }
            if (!"specification_tag".equals(entry.getString("fieldname"))) continue;
            specificationValue.put("oldValue", entry.getString("oldvalue"));
            specificationValue.put("newValue", entry.getString("newvalue"));
            iterator.remove();
        }
        if (entrys.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap"});
        }
        this.getModel().getDataEntity(true).set("entryentity", (Object)entrys);
        this.getView().updateView("entryentity");
        this.getModel().getDataEntity(true).set("entryentity", (Object)entryClone);
        if (contentValue.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"contentcontainer"});
        } else {
            this.richTextView("content", contentValue);
        }
        if (specificationValue.isEmpty()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"specificationcontainer"});
        } else {
            this.richTextView("specification", specificationValue);
        }
    }

    private void pictureView() {
        boolean hasPictureChange = false;
        List<String> pictureList = Arrays.asList("thumbnail", "picture1", "picture2", "picture3", "picture4");
        for (String picture : pictureList) {
            if (this.pictureValueIsBlank(picture)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{picture + "container"});
                continue;
            }
            hasPictureChange = true;
        }
        if (!hasPictureChange) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"picturecontainer"});
        }
    }

    private boolean pictureValueIsBlank(String fieldName) {
        String newValue = (String)this.getModel().getValue(fieldName);
        String oldValue = (String)this.getModel().getValue("old" + fieldName);
        return StringUtils.isBlank((CharSequence)newValue) && StringUtils.isBlank((CharSequence)oldValue);
    }

    private void contentView() {
        boolean attributeHasChange = false;
        List<String> attributes = Arrays.asList("attributeadd", "attributedelete", "attributeupdate");
        for (String attribute : attributes) {
            String attributeValue = (String)this.getModel().getValue(attribute);
            if (StringUtils.isBlank((CharSequence)attributeValue)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{attribute + "container"});
                continue;
            }
            attributeHasChange = true;
        }
        if (!attributeHasChange) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"attributecontainer"});
        }
    }

    private void richTextView(String fieldName, Map<String, String> textValue) {
        RichTextEditor oldRichText = (RichTextEditor)this.getControl("old" + fieldName + "richtext");
        RichTextEditor newRichText = (RichTextEditor)this.getControl(fieldName + "richtext");
        oldRichText.setText(textValue.get("oldValue"));
        newRichText.setText(textValue.get("newValue"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        DynamicObject prodChgDyn = this.getModel().getDataEntity(true);
        if ("submit".equals(operateKey) && MalProdInfoChangeUtil.checkAttributeChangeInfluenceSPU((DynamicObject)prodChgDyn)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u53d8\u66f4\u5185\u5bb9\u6d89\u53caSPU\u4fe1\u606f\uff0c\u53d8\u66f4\u540e\u5c06\u6e05\u7a7a\u5173\u8054SPU\uff0c\u8bf7\u77e5\u6089\u3002", (String)"PmmProdChangeManageEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK, null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("confirm".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
            ArrayList<Long> prodChgIds = new ArrayList<Long>(8);
            prodChgIds.add((Long)this.getModel().getValue("id"));
            paramMap.put("prodChgIds", prodChgIds);
            paramMap.put("origin", "pmm");
            OpenFormUtil.openDynamicPage((IFormView)this.getView(), (String)"pbd_goodschgcfm", (ShowType)ShowType.Modal, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "callbackid"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("callbackid")) {
            Map paramMap = (Map)closedCallBackEvent.getReturnData();
            if (paramMap != null && "confirm".equals(paramMap.get("opKey"))) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue("opinion", (String)paramMap.get("opinion"));
                if ("B".equals(paramMap.get("result"))) {
                    this.getView().invokeOperation("cfmagree", operateOption);
                } else {
                    this.getView().invokeOperation("cfmdisagree", operateOption);
                }
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        if ("org".equalsIgnoreCase(fieldKey)) {
            this.setOrgFilter(showParameter);
        }
    }

    private void setOrgFilter(ListShowParameter showParameter) {
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)Long.valueOf(RequestContext.get().getUserId()), null, (String)"pmm_prodchange_manage", (String)"47156aff000000ac");
        showParameter.getListFilterParameter().getQFilters().clear();
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs()));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(Boolean.FALSE.booleanValue());
    }
}

