/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.MutexUtil;
import kd.scm.malcore.util.MalFuzzySearchUtil;
import kd.scm.pmm.business.service.impl.ProdMatMappingServiceImpl;

public class PmmProdMatMappingEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
BasedataFuzzySearchListener {
    private static final String KEY_GOODS = "goods";
    private static final String KEY_ECGOODS = "ecgoods";
    private static final String KEY_MATERIAL = "material";
    private static final String KEY_CATEGORY = "category";
    private static final String KEY_PURCHASETYPE = "purchasetype";
    private static final String RADIO_GOODS = "1";
    private static final String RADIO_CATEGORY = "2";
    private static final String RADIO_PURCHASETYPE = "3";
    private static final String BAR_SAVE = "bar_save";
    private static final String RADIOGROUPFIELD = "radiogroupfield";
    private static final String PLATFORM = "platform";

    public void initialize() {
        super.initialize();
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new"});
        this.fromProdMapping();
        this.materialEnableControl();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        this.getPageCache().put("open_afterBindData", RADIO_GOODS);
        this.fromProdMapping();
        if (null != model.getValue(KEY_GOODS) || null != model.getValue(KEY_ECGOODS)) {
            model.setValue(RADIOGROUPFIELD, (Object)RADIO_GOODS);
        } else if (null != model.getValue(KEY_CATEGORY)) {
            model.setValue(RADIOGROUPFIELD, (Object)RADIO_CATEGORY);
        } else if (null != model.getValue(KEY_PURCHASETYPE)) {
            model.setValue(RADIOGROUPFIELD, (Object)RADIO_PURCHASETYPE);
        }
        this.getPageCache().remove("open_afterBindData");
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (operateKey = afterDoOperationEventArgs.getOperateKey()) {
            case "save": {
                Map params = this.getView().getFormShowParameter().getCustomParams();
                Object openStyle = params.get("openStyle");
                DynamicObject dynamicObject = this.getModel().getDataEntity();
                DynamicObject categoryDyn = dynamicObject.getDynamicObject(KEY_CATEGORY);
                if (null != categoryDyn) {
                    QFilter qFilter = new QFilter("goods.category.id", "=", (Object)categoryDyn.getLong("id"));
                    boolean exists = QueryServiceHelper.exists((String)"pmm_prodmatmapping", (QFilter[])qFilter.toArray());
                    if (exists) {
                        String confirmTip = ResManager.loadKDString((String)"\u5df2\u6709\u5546\u54c1\u5b58\u5728\u5176\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\uff0c\u786e\u8ba4\u8981\u66f4\u65b0\u5417\uff1f", (String)"PmmProdMatMappingEdit_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                        this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("updateMaterialMappingConfirm", (IFormPlugin)this));
                        break;
                    }
                    if (!"setmaterialmapping".equals(openStyle)) break;
                    this.getView().close();
                    break;
                }
                if (!"setmaterialmapping".equals(openStyle)) break;
                this.getView().close();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        Map params;
        Object openStyle;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("updateMaterialMappingConfirm".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            DynamicObject[] prodMatMappings;
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            DynamicObject categoryDyn = dynamicObject.getDynamicObject(KEY_CATEGORY);
            QFilter qFilter = new QFilter("goods.category.id", "=", (Object)categoryDyn.getLong("id"));
            String properties = "id,goods,material";
            for (DynamicObject prodMatMapping : prodMatMappings = BusinessDataServiceHelper.load((String)"pmm_prodmatmapping", (String)properties, (QFilter[])qFilter.toArray())) {
                prodMatMapping.set(KEY_MATERIAL, (Object)this.getModel().getDataEntity().getLong("material_id"));
            }
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])prodMatMappings);
        }
        if ("setmaterialmapping".equals(openStyle = (params = this.getView().getFormShowParameter().getCustomParams()).get("openStyle"))) {
            this.getView().close();
        }
    }

    private void fromProdMapping() {
        IDataModel model = this.getModel();
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object openStyle = params.get("openStyle");
        if ("setmaterialmapping".equals(openStyle)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"radio_purchasetype"});
            Object selectType = params.get("selectType");
            Long id = Long.valueOf((String)params.get("id"));
            if ("dynamicObject".equals(selectType)) {
                model.setValue(KEY_GOODS, (Object)id);
                model.setValue(RADIOGROUPFIELD, (Object)RADIO_GOODS);
                this.getView().setEnable(Boolean.FALSE, new String[]{KEY_GOODS});
            } else if ("treeNode".equals(selectType)) {
                model.setValue(KEY_CATEGORY, (Object)id);
                model.setValue(RADIOGROUPFIELD, (Object)RADIO_CATEGORY);
                this.getView().setEnable(Boolean.FALSE, new String[]{KEY_CATEGORY});
            } else if (KEY_ECGOODS.equals(selectType)) {
                model.setValue(KEY_ECGOODS, (Object)id);
                model.setValue(RADIOGROUPFIELD, (Object)RADIO_GOODS);
                if (null != params.get("source")) {
                    model.setValue(PLATFORM, params.get("source"));
                }
                this.getView().setEnable(Boolean.FALSE, new String[]{KEY_ECGOODS, PLATFORM});
            }
            this.getView().setEnable(Boolean.FALSE, new String[]{"radio_prod"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"radio_sort"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_del"});
            this.getView().setEnable(Boolean.FALSE, new String[]{PLATFORM});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit goodsEdit = (BasedataEdit)this.getView().getControl(KEY_GOODS);
        goodsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        goodsEdit.addBasedataFuzzySearchListener((BasedataFuzzySearchListener)this);
        BasedataEdit ecGoodsEdit = (BasedataEdit)this.getView().getControl(KEY_ECGOODS);
        ecGoodsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit categoryEdit = (BasedataEdit)this.getView().getControl(KEY_CATEGORY);
        categoryEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit purchasetypeEdit = (BasedataEdit)this.getView().getControl(KEY_PURCHASETYPE);
        purchasetypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit material = (BasedataEdit)this.getView().getControl(KEY_MATERIAL);
        material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(operateKey)) {
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(this.getModel().getValue(PLATFORM))) {
                this.getModel().setValue("ecgoods_id", (Object)0L);
                this.getModel().setValue(KEY_ECGOODS, null);
            } else if (StringUtils.isNotBlank((Object)this.getModel().getValue(PLATFORM))) {
                this.getModel().setValue("goods_id", (Object)0);
                this.getModel().setValue(KEY_GOODS, null);
            }
        }
    }

    private QFilter getCategoryFilter() {
        QFilter leafFilter = new QFilter("isleaf", "=", (Object)RADIO_GOODS);
        DynamicObjectCollection existDyoCol = this.getExistDyoCol();
        List<Long> categoryIdList = this.getListByProperty(existDyoCol, KEY_CATEGORY);
        return new QFilter("id", "not in", categoryIdList).and(leafFilter);
    }

    private QFilter getGoodsFilter() {
        DynamicObjectCollection existDyoCol = this.getExistDyoCol();
        List<Long> goodsIdList = this.getListByProperty(existDyoCol, KEY_GOODS);
        return new QFilter("id", "not in", goodsIdList);
    }

    private QFilter getEcGoodsFilter() {
        DynamicObjectCollection existDyoCol = this.getExistDyoCol();
        List<Long> ecGoodsIdList = this.getListByProperty(existDyoCol, KEY_ECGOODS);
        return new QFilter("id", "not in", ecGoodsIdList).and("source", "=", this.getModel().getValue(PLATFORM));
    }

    private QFilter getPurchaseTypeFilter() {
        DynamicObjectCollection existDyoCol = this.getExistDyoCol();
        List<Long> purchaseTypeIdList = this.getListByProperty(existDyoCol, KEY_PURCHASETYPE);
        return new QFilter("id", "not in", purchaseTypeIdList);
    }

    private QFilter getMaterialFilter() {
        Object radio = this.getModel().getValue(RADIOGROUPFIELD);
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        long goodsCategoryId = 0L;
        if (RADIO_GOODS.equals(radio)) {
            String source = (String)this.getModel().getValue(PLATFORM);
            if (StringUtils.equals((CharSequence)source, (CharSequence)EcPlatformEnum.ECPLATFORM_SELF.getVal())) {
                DynamicObject goods = dynamicObject.getDynamicObject(KEY_GOODS);
                if (goods != null) {
                    goodsCategoryId = goods.getLong("category_id");
                }
            } else {
                DynamicObject ecGoods = dynamicObject.getDynamicObject(KEY_ECGOODS);
                if (ecGoods != null) {
                    goodsCategoryId = ecGoods.getLong("group_id");
                }
            }
        } else if (RADIO_CATEGORY.equals(radio)) {
            goodsCategoryId = dynamicObject.getLong("category_id");
        } else if (RADIO_PURCHASETYPE.equals(radio)) {
            return null;
        }
        ProdMatMappingServiceImpl prodMatMappingService = new ProdMatMappingServiceImpl();
        Map materialIdsByGoodsCategoryMapping = prodMatMappingService.getMaterialIdsByGoodsCategoryMapping(Long.valueOf(goodsCategoryId));
        List materials = (List)materialIdsByGoodsCategoryMapping.get(goodsCategoryId);
        if (materials == null) {
            return null;
        }
        return new QFilter("id", "in", (Object)materials);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        ListShowParameter showParameter;
        QFilter qFilter;
        String fieldKey = arg0.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)KEY_GOODS)) {
            qFilter = this.getGoodsFilter();
            showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
            this.setF7OpenStyle(showParameter);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)KEY_ECGOODS)) {
            ListShowParameter showParameter2 = (ListShowParameter)arg0.getFormShowParameter();
            showParameter2.getListFilterParameter().getQFilters().add(this.getEcGoodsFilter());
            String platform = (String)this.getModel().getValue(PLATFORM);
            String standardId = EcApiUtil.getStandard((String)platform);
            showParameter2.setCustomParam("groupStandard", (Object)standardId);
            this.setF7OpenStyle(showParameter2);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)KEY_CATEGORY)) {
            qFilter = this.getCategoryFilter();
            showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)KEY_PURCHASETYPE)) {
            qFilter = this.getPurchaseTypeFilter();
            showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.setCaption(ResManager.loadKDString((String)"\u91c7\u8d2d\u7c7b\u578b", (String)"PmmProdMatMappingEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)KEY_MATERIAL)) {
            QFilter materialFilter = this.getMaterialFilter();
            showParameter = (ListShowParameter)arg0.getFormShowParameter();
            if (materialFilter != null) {
                showParameter.getListFilterParameter().getQFilters().add(materialFilter);
            }
        }
    }

    private void setF7OpenStyle(ListShowParameter showParameter) {
        showParameter.setCustomParam("ismergerows", (Object)true);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)KEY_GOODS, (CharSequence)fieldKey) || StringUtils.equals((CharSequence)KEY_ECGOODS, (CharSequence)fieldKey) || StringUtils.equals((CharSequence)KEY_CATEGORY, (CharSequence)fieldKey)) {
            this.materialEnableControl();
        }
        if (StringUtils.equals((CharSequence)RADIOGROUPFIELD, (CharSequence)fieldKey) && !RADIO_GOODS.equals(this.getPageCache().get("open_afterBindData"))) {
            this.getModel().beginInit();
            this.getModel().setValue(KEY_MATERIAL, null);
            this.getModel().setValue(PLATFORM, (Object)EcPlatformEnum.ECPLATFORM_SELF.getVal());
            this.getModel().endInit();
            this.materialEnableControl();
        }
    }

    private void materialEnableControl() {
        this.getModel().beginInit();
        String radiogroupfield = (String)this.getModel().getValue(RADIOGROUPFIELD);
        if (RADIO_GOODS.equals(radiogroupfield)) {
            if (this.getModel().getValue(KEY_GOODS) == null && this.getModel().getValue(KEY_ECGOODS) == null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{KEY_MATERIAL});
                this.getModel().setValue(KEY_MATERIAL, null);
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{KEY_MATERIAL});
            }
        } else if (RADIO_CATEGORY.equals(radiogroupfield)) {
            if (this.getModel().getValue(KEY_CATEGORY) == null) {
                this.getView().setEnable(Boolean.FALSE, new String[]{KEY_MATERIAL});
                this.getModel().setValue(KEY_MATERIAL, null);
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{KEY_MATERIAL});
            }
        } else if (RADIO_PURCHASETYPE.equals(radiogroupfield)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{KEY_MATERIAL});
        }
        this.getModel().endInit();
        this.getView().updateView(KEY_MATERIAL);
    }

    private DynamicObjectCollection getExistDyoCol() {
        String selectFields = "goods,ecgoods,category,purchasetype";
        return QueryServiceHelper.query((String)"pmm_prodmatmapping", (String)selectFields, null);
    }

    public void itemClick(ItemClickEvent evt) {
        if (evt.getItemKey().equals(BAR_SAVE)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_new"});
        }
        if (evt.getItemKey().equals("bar_new")) {
            this.getModel().setValue(KEY_GOODS, null);
            this.getModel().setValue(KEY_ECGOODS, null);
            this.getModel().setValue(KEY_CATEGORY, null);
            this.getModel().setValue(KEY_PURCHASETYPE, null);
            this.getModel().setValue("modifier", null);
            this.getModel().setValue("modifytime", null);
        }
    }

    private List<Long> getListByProperty(DynamicObjectCollection dyObjects, String property) {
        ArrayList<Long> proList = new ArrayList<Long>();
        for (DynamicObject dyObj : dyObjects) {
            proList.add(dyObj.getLong(property));
        }
        return proList;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)key, (CharSequence)BAR_SAVE)) {
            if (null == this.getModel().getValue(KEY_MATERIAL)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"ERP\u7269\u6599\u662f\u5fc5\u5f55\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"PmmProdMatMappingEdit_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (model.getValue(RADIOGROUPFIELD).equals(RADIO_GOODS)) {
                model.setValue(KEY_CATEGORY, null);
                model.setValue(KEY_PURCHASETYPE, null);
            } else if (model.getValue(RADIOGROUPFIELD).equals(RADIO_CATEGORY)) {
                model.setValue(KEY_GOODS, null);
                model.setValue(KEY_ECGOODS, null);
                model.setValue(KEY_PURCHASETYPE, null);
            } else if (model.getValue(RADIOGROUPFIELD).equals(RADIO_PURCHASETYPE)) {
                model.setValue(KEY_CATEGORY, null);
                model.setValue(KEY_GOODS, null);
                model.setValue(KEY_ECGOODS, null);
            }
        }
    }

    public void pageRelease(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params.get("id") != null) {
            MutexUtil.release((String)params.get("id").toString(), (String)"pmm_prodmanage", (String)"tblquickset");
        }
    }

    public void handleData(BasedataFuzzySearchEvent arg0) {
        List queryData = arg0.getQueryData();
        MalFuzzySearchUtil.queryDataDuplicatesRemoveByNumber((List)queryData);
    }
}

