/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.PictureEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermDimObjResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.StringConversionUtil;
import kd.scm.common.util.cal.CalculateUtils;
import kd.scm.pmm.business.service.impl.PmmSpuValidatorServiceImpl;

public class PmmProdSpuEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
RowClickEventListener,
HyperLinkClickListener {
    private static final Log log = LogFactory.getLog(PmmProdSpuEdit.class);
    private static final String NEWSKU = "newsku";
    private static final String SKUMAPINIT = "skumapinit";
    private static final String NEWENTRY_SALEATR = "newentry_saleatr";
    private static final String DELETEENTRY_SALEATR = "deleteentry_saleatr";
    private static final String DELETEENTRY_SALEVAL = "deleteentry_saleval";
    private static final String DELETEENTRY_MAP = "deleteentry_map";
    private static final String NEWENTRY = "newentry";
    private final BigDecimal ZERO = BigDecimal.ZERO;
    private boolean flag = false;
    private final String PRICE = "price";
    private final String TAXPRICE = "taxprice";
    private final String TAXTYPE = "taxtype";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (this.flag) {
            this.flag = true;
            return;
        }
        String ignoretextchange = this.getPageCache().get("ignoretextchange");
        if (!StringUtils.isEmpty((CharSequence)ignoretextchange)) {
            this.getPageCache().remove("ignoretextchange");
            return;
        }
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        String fieldName = e.getProperty().getName();
        IDataModel model = this.getModel();
        switch (fieldName) {
            case "price": {
                this.calTaxPriceByPrice(model, rowIndex);
                break;
            }
            case "taxprice": 
            case "taxrateid": {
                this.calPriceByTaxPrice(model, rowIndex);
                break;
            }
            case "goods": {
                this.doGoodsChange(e, rowIndex);
                break;
            }
            case "thumbnail": 
            case "picture1": 
            case "picture2": 
            case "picture3": 
            case "picture4": {
                this.updatePictureSkuPage(fieldName, rowIndex);
                break;
            }
            case "prodattributetext": {
                this.doProdArributeTextChange(e, rowIndex);
                break;
            }
            case "prodattributevaluetext": {
                this.doProdAttributeValueTextChange(e, rowIndex);
                break;
            }
            case "saleprodattributetext": {
                this.doSaleProdattributeTextChange(e, rowIndex);
                break;
            }
            case "saleprodattrvaluetext": {
                this.doSaleProdAttrValueTextChange(e, rowIndex);
                break;
            }
            case "prodattributegrouptext": {
                this.doProdAttributeGroupTextChange(e, rowIndex);
                break;
            }
            case "saleprodattrgrouptext": {
                this.doSaleProdAttrGroupTextChange(e, rowIndex);
                break;
            }
            case "supplier": {
                this.doSupplierChange(e);
                break;
            }
        }
    }

    private void doSaleProdAttrGroupTextChange(PropertyChangedArgs e, int rowIndex) {
        DynamicObject prodattributegroup;
        DynamicObject prodattributeDyn;
        Object saleprodattribute = this.getModel().getValue("saleprodattribute", rowIndex);
        Object saleprodattributetext = this.getModel().getValue("saleprodattributetext", rowIndex);
        Object newValue = e.getChangeSet()[0].getNewValue();
        String saleprodattrgrouptext = "";
        if (!ObjectUtils.isEmpty((Object)newValue)) {
            saleprodattrgrouptext = String.valueOf(newValue);
        }
        if (null != saleprodattribute && saleprodattributetext.equals((prodattributeDyn = (DynamicObject)saleprodattribute).getString("name")) && null != (prodattributegroup = prodattributeDyn.getDynamicObject("prodattributegroup")) && !saleprodattrgrouptext.equals(prodattributegroup.getString("name"))) {
            String msg = ResManager.loadKDString((String)"\u89c4\u683c\u540d\u79f0\u201c{0}\u201d\u5df2\u5b58\u5728\u5173\u8054\u7684\u89c4\u683c\u5206\u7ec4\u201c{1}\u201d\u3002", (String)"PmmProdSpuEdit_50", (String)"scm-pmm-formplugin", (Object[])new Object[]{prodattributeDyn.getString("name"), prodattributegroup.getString("name")});
            this.getView().showErrorNotification(msg);
            this.getPageCache().put("ignoretextchange", "true");
            this.getModel().setValue("saleprodattrgrouptext", e.getChangeSet()[0].getOldValue(), rowIndex);
        }
    }

    private void doProdAttributeGroupTextChange(PropertyChangedArgs e, int rowIndex) {
        DynamicObject prodattributegroup;
        DynamicObject prodattributeDyn;
        Object prodattribute = this.getModel().getValue("prodattribute", rowIndex);
        Object prodattributetext = this.getModel().getValue("prodattributetext", rowIndex);
        Object newValue = e.getChangeSet()[0].getNewValue();
        String prodattributegrouptext = "";
        if (!ObjectUtils.isEmpty((Object)newValue)) {
            prodattributegrouptext = String.valueOf(newValue);
        }
        if (null != prodattribute && prodattributetext.equals((prodattributeDyn = (DynamicObject)prodattribute).getString("name")) && null != (prodattributegroup = prodattributeDyn.getDynamicObject("prodattributegroup")) && !prodattributegrouptext.equals(prodattributegroup.getString("name"))) {
            String msg = ResManager.loadKDString((String)"\u89c4\u683c\u540d\u79f0\u201c{0}\u201d\u5df2\u5b58\u5728\u5173\u8054\u7684\u89c4\u683c\u5206\u7ec4\u201c{1}\u201d\u3002", (String)"PmmProdSpuEdit_50", (String)"scm-pmm-formplugin", (Object[])new Object[]{prodattributeDyn.getString("name"), prodattributegroup.getString("name")});
            this.getView().showErrorNotification(msg);
            this.getPageCache().put("ignoretextchange", "true");
            this.getModel().setValue("prodattributegrouptext", e.getChangeSet()[0].getOldValue(), rowIndex);
        }
    }

    private void doSupplierChange(PropertyChangedArgs e) {
        DynamicObjectCollection spuskumapentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("spuskumapentry");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("goodsspu")) {
            return;
        }
        if (spuskumapentry.size() > 0) {
            String msg = ResManager.loadKDString((String)"\u5207\u6362\u540e\u5c06\u81ea\u52a8\u6e05\u7a7a\u5173\u8054SKU\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PmmProdSpuEdit_49", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("supplier", (IFormPlugin)this);
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (null != oldValue) {
                DynamicObject oldSUpplier = (DynamicObject)oldValue;
                this.getPageCache().put("oldsupplier", oldSUpplier.getString("id"));
            }
            this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        } else {
            this.deleteSpuMapBySupplierChange();
        }
    }

    private void deleteSpuMapBySupplierChange() {
        DynamicObjectCollection spuskumapentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("spuskumapentry");
        HashSet<Long> goodsIds = new HashSet<Long>(16);
        for (DynamicObject row : spuskumapentry) {
            DynamicObject goods = row.getDynamicObject("goods");
            if (null == goods) continue;
            goodsIds.add(goods.getLong("id"));
        }
        this.getModel().deleteEntryData("spuskumapentry");
        if (goodsIds.size() > 0) {
            DynamicObject[] pmm_prodmanages;
            QFilter qFilter = new QFilter("id", "in", goodsIds);
            for (DynamicObject goods : pmm_prodmanages = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)"mulmodel,spunumber", (QFilter[])qFilter.toArray())) {
                goods.set("mulmodel", (Object)false);
                goods.set("spunumber", null);
            }
            if (pmm_prodmanages.length > 0) {
                SaveServiceHelper.save((DynamicObject[])pmm_prodmanages);
            }
        }
    }

    private void doSaleProdAttrValueTextChange(PropertyChangedArgs e, int rowIndex) {
        DynamicObject dataEntity;
        DynamicObjectCollection spuskumapentry;
        Object newValue = e.getChangeSet()[0].getNewValue();
        String fieldName = e.getProperty().getName();
        int salerowIndex = this.getCacheSaleRowIndex();
        Object prodattributetext = this.getModel().getValue("saleprodattributetext", salerowIndex);
        if (!ObjectUtils.isEmpty((Object)newValue) && StringUtils.isEmpty((CharSequence)String.valueOf(prodattributetext).trim())) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u89c4\u683c\u540d\u79f0\u201d\uff0c\u518d\u5f55\u5165\u89c4\u683c\u503c\u3002", (String)"PmmProdSpuEdit_33", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("saleprodattrvaluetext", null, rowIndex, salerowIndex);
        }
        if ((spuskumapentry = (dataEntity = this.getModel().getDataEntity(true)).getDynamicObjectCollection("spuskumapentry")).size() > 0) {
            if (this.checkAtrVal("modify")) {
                int saleRowIndex = this.getCacheSaleRowIndex();
                this.getPageCache().put("ignoretextchange", "true");
                this.getModel().setValue(fieldName, e.getChangeSet()[0].getOldValue(), rowIndex, saleRowIndex);
                return;
            }
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (this.isExistAtrVal()) {
                ConfirmCallBackListener confirmCallBacks;
                if (ObjectUtils.isEmpty((Object)e.getChangeSet()[0].getOldValue())) {
                    this.getPageCache().put("oldvaluetext", "");
                } else {
                    this.getPageCache().put("oldvaluetext", String.valueOf(e.getChangeSet()[0].getOldValue()));
                }
                String msg = "";
                if (null == customParams.get("goodsspu")) {
                    msg = ResManager.loadKDString((String)"\u4fee\u6539\u9500\u552e\u89c4\u683c\u5185\u5bb9\u7684\u89c4\u683c\u503c\u5c06\u6e05\u7a7a\u5173\u8054SKU\u5206\u5f55\uff0c\u9700\u91cd\u65b0\u5173\u8054SKU\u5e76\u786e\u8ba4\uff0c\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"PmmProdSpuEdit_28", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                } else {
                    msg = ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u683c\u503c\u5df2\u5b58\u5728\u5173\u8054SKU,\u662f\u5426\u66f4\u65b0\u5173\u8054SKU\u4fe1\u606f\uff1f", (String)"PmmProdSpuEdit_32", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                    if (null != newValue && !StringUtils.isEmpty((CharSequence)String.valueOf(newValue))) {
                        boolean isExists;
                        QFilter qFilter = new QFilter("name", "=", (Object)String.valueOf(newValue));
                        Object prodattributevaluetext = this.getModel().getValue("saleprodattributetext", salerowIndex);
                        if (!ObjectUtils.isEmpty((Object)prodattributevaluetext)) {
                            qFilter.and(new QFilter("group.name", "=", (Object)String.valueOf(prodattributevaluetext)));
                        }
                        if (!(isExists = QueryServiceHelper.exists((String)"pmm_prodattributevalue", (QFilter[])qFilter.toArray()))) {
                            msg = ResManager.loadKDString((String)"\u5f53\u524d\u89c4\u683c\u503c\u5df2\u5173\u8054SKU\uff0c\u8bf7\u5220\u9664\u5173\u8054SKU\u518d\u4fee\u6539\u3002", (String)"PmmProdSpuEdit_43", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                            this.getView().showErrorNotification(msg);
                            this.revertOldValueText("saleprodattrvaluetext", rowIndex);
                            return;
                        }
                    }
                }
                if (null == customParams.get("goodsspu")) {
                    confirmCallBacks = new ConfirmCallBackListener(fieldName, (IFormPlugin)this);
                    this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                } else {
                    confirmCallBacks = new ConfirmCallBackListener(fieldName, (IFormPlugin)this);
                    HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u66f4\u65b0\u5173\u8054SKU", (String)"PmmProdSpuEdit_34", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u5220\u9664\u5173\u8054SKU", (String)"PmmProdSpuEdit_35", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                    this.getView().showConfirm(msg, "", MessageBoxOptions.YesNoCancel, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
                }
            }
        } else {
            this.updateSaleProdAttrValDynByText(rowIndex);
        }
    }

    private void doSaleProdattributeTextChange(PropertyChangedArgs e, int rowIndex) {
        String fieldName = e.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DynamicObjectCollection saleattributeentry = dataEntity.getDynamicObjectCollection("saleattributeentry");
        Object newValue = e.getChangeSet()[0].getNewValue();
        for (Object row : saleattributeentry) {
            int index = row.getInt("seq") - 1;
            if (index == rowIndex) continue;
            String tarProdattributetext = row.getString("saleprodattributetext").trim();
            if (null == newValue || StringUtils.isEmpty((CharSequence)tarProdattributetext) || !tarProdattributetext.equals(String.valueOf(newValue).trim())) continue;
            String msg = ResManager.loadKDString((String)"\u9500\u552e\u89c4\u683c\u7b2c{0}\u884c\u5b58\u5728\u91cd\u590d\u7684\u89c4\u683c\u540d\u79f0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PmmProdSpuEdit_48", (String)"scm-pmm-formplugin", (Object[])new Object[]{row.getInt("seq")});
            this.getView().showErrorNotification(msg);
            this.getPageCache().put("ignoretextchange", "true");
            this.getModel().setValue("saleprodattributetext", e.getChangeSet()[0].getOldValue(), rowIndex);
            return;
        }
        DynamicObjectCollection baseattributeentry = dataEntity.getDynamicObjectCollection("baseattributeentry");
        for (DynamicObject row : baseattributeentry) {
            String prodattributetext = row.getString("prodattributetext").trim();
            if (null == newValue || StringUtils.isEmpty((CharSequence)prodattributetext) || !prodattributetext.equals(String.valueOf(newValue).trim())) continue;
            String msg = ResManager.loadKDString((String)"\u57fa\u672c\u89c4\u683c\u7b2c{0}\u884c\u5b58\u5728\u91cd\u590d\u7684\u89c4\u683c\u540d\u79f0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PmmProdSpuEdit_47", (String)"scm-pmm-formplugin", (Object[])new Object[]{row.getInt("seq")});
            this.getView().showErrorNotification(msg);
            this.getPageCache().put("ignoretextchange", "true");
            this.getModel().setValue("saleprodattributetext", e.getChangeSet()[0].getOldValue(), rowIndex);
            return;
        }
        if (null == customParams.get("goodsspu")) {
            DynamicObjectCollection spuskumapentry = dataEntity.getDynamicObjectCollection("spuskumapentry");
            if (spuskumapentry.size() > 0) {
                if (ObjectUtils.isEmpty((Object)e.getChangeSet()[0].getOldValue())) {
                    this.getPageCache().put("oldvaluetext", "");
                } else {
                    this.getPageCache().put("oldvaluetext", String.valueOf(e.getChangeSet()[0].getOldValue()));
                }
                String msg = ResManager.loadKDString((String)"\u4fee\u6539\u9500\u552e\u89c4\u683c\u5185\u5bb9\u7684\u89c4\u683c\u503c\u5c06\u6e05\u7a7a\u5173\u8054SKU\u5206\u5f55\uff0c\u9700\u91cd\u65b0\u5173\u8054SKU\u5e76\u786e\u8ba4\uff0c\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"PmmProdSpuEdit_28", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(fieldName, (IFormPlugin)this);
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            } else {
                this.updateSaleProdAttrDynByText(rowIndex);
            }
        } else {
            this.updateSaleProdAttrDynByText(rowIndex);
        }
    }

    private void doProdAttributeValueTextChange(PropertyChangedArgs e, int rowIndex) {
        Object prodattributetext = this.getModel().getValue("prodattributetext", rowIndex);
        Object newValue = e.getChangeSet()[0].getNewValue();
        String fieldName = e.getProperty().getName();
        if (!ObjectUtils.isEmpty((Object)newValue) && ObjectUtils.isEmpty((Object)prodattributetext)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u89c4\u683c\u540d\u79f0\u201d\uff0c\u518d\u5f55\u5165\u89c4\u683c\u503c\u3002", (String)"PmmProdSpuEdit_33", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("prodattributevaluetext", null, rowIndex);
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null == customParams.get("goodsspu")) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection spuskumapentry = dataEntity.getDynamicObjectCollection("spuskumapentry");
            if (spuskumapentry.size() > 0) {
                if (ObjectUtils.isEmpty((Object)e.getChangeSet()[0].getOldValue())) {
                    this.getPageCache().put("oldvaluetext", "");
                } else {
                    this.getPageCache().put("oldvaluetext", String.valueOf(e.getChangeSet()[0].getOldValue()));
                }
                String msg = ResManager.loadKDString((String)"\u4fee\u6539\u57fa\u672c\u89c4\u683c\u7684\u89c4\u683c\u503c\u5c06\u6e05\u7a7a\u5173\u8054SKU\u5206\u5f55\uff0c\u9700\u91cd\u65b0\u5173\u8054SKU\u5e76\u786e\u8ba4\uff0c\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"PmmProdSpuEdit_27", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(fieldName, (IFormPlugin)this);
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            } else {
                this.updateProAttrValDynByText(rowIndex);
            }
        } else {
            this.updateProAttrValDynByText(rowIndex);
        }
    }

    private void doProdArributeTextChange(PropertyChangedArgs e, int rowIndex) {
        String fieldName = e.getProperty().getName();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection spuskumapentry = dataEntity.getDynamicObjectCollection("spuskumapentry");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        DynamicObjectCollection baseattributeentry = dataEntity.getDynamicObjectCollection("baseattributeentry");
        DynamicObjectCollection saleattributeentry = dataEntity.getDynamicObjectCollection("saleattributeentry");
        Object newValue = e.getChangeSet()[0].getNewValue();
        for (DynamicObject row : baseattributeentry) {
            int index = row.getInt("seq") - 1;
            if (index == rowIndex) continue;
            String tarProdattributetext = row.getString("prodattributetext");
            if (null == newValue || StringUtils.isEmpty((CharSequence)tarProdattributetext) || !tarProdattributetext.equals(String.valueOf(newValue).trim())) continue;
            String msg = ResManager.loadKDString((String)"\u57fa\u672c\u89c4\u683c\u7b2c{0}\u884c\u5b58\u5728\u91cd\u590d\u7684\u89c4\u683c\u540d\u79f0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PmmProdSpuEdit_47", (String)"scm-pmm-formplugin", (Object[])new Object[]{row.getInt("seq")});
            this.getView().showErrorNotification(msg);
            this.getPageCache().put("ignoretextchange", "true");
            this.getModel().setValue("prodattributetext", e.getChangeSet()[0].getOldValue(), rowIndex);
            return;
        }
        for (DynamicObject row : saleattributeentry) {
            String saleprodattributetext = row.getString("saleprodattributetext").trim();
            if (null == newValue || StringUtils.isEmpty((CharSequence)saleprodattributetext) || !saleprodattributetext.equals(String.valueOf(newValue).trim())) continue;
            String msg = ResManager.loadKDString((String)"\u9500\u552e\u89c4\u683c\u7b2c{0}\u884c\u5b58\u5728\u91cd\u590d\u7684\u89c4\u683c\u540d\u79f0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PmmProdSpuEdit_48", (String)"scm-pmm-formplugin", (Object[])new Object[]{row.getInt("seq")});
            this.getView().showErrorNotification(msg);
            this.getPageCache().put("ignoretextchange", "true");
            this.getModel().setValue("prodattributetext", e.getChangeSet()[0].getOldValue(), rowIndex);
            return;
        }
        if (null == customParams.get("goodsspu")) {
            if (spuskumapentry.size() > 0) {
                if (ObjectUtils.isEmpty((Object)e.getChangeSet()[0].getOldValue())) {
                    this.getPageCache().put("oldvaluetext", "");
                } else {
                    this.getPageCache().put("oldvaluetext", String.valueOf(e.getChangeSet()[0].getOldValue()));
                }
                String msg = ResManager.loadKDString((String)"\u4fee\u6539\u57fa\u672c\u89c4\u683c\u7684\u89c4\u683c\u7f16\u7801\u5c06\u6e05\u7a7a\u5173\u8054SKU\u5206\u5f55\uff0c\u9700\u91cd\u65b0\u5173\u8054SKU\u5e76\u786e\u8ba4\uff0c\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"PmmProdSpuEdit_26", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(fieldName, (IFormPlugin)this);
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            } else {
                this.updateProdAttrDynByText(rowIndex);
            }
        } else {
            this.updateProdAttrDynByText(rowIndex);
        }
    }

    private void updatePictureSkuPage(String fieldName, int rowIndex) {
        IFormView parentView;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("goodsspu") && null != (parentView = this.getView().getParentView())) {
            IDataModel skuModel = parentView.getModel();
            skuModel.setValue(fieldName, this.getModel().getValue(fieldName, rowIndex));
            this.getView().sendFormAction(parentView);
        }
    }

    private void doGoodsChange(PropertyChangedArgs e, int rowIndex) {
        Object goods = this.getModel().getValue("goods", rowIndex);
        if (null == goods) {
            this.getModel().setValue("skuname", null, rowIndex);
            this.getModel().setValue("skunumber", null, rowIndex);
            this.getModel().setValue("taxprice", (Object)BigDecimal.ZERO, rowIndex);
            this.getModel().setValue("taxrateid", null, rowIndex);
            this.getModel().setValue("price", (Object)BigDecimal.ZERO, rowIndex);
            this.getModel().setValue("thumbnail", null, rowIndex);
            this.getModel().setValue("picture1", null, rowIndex);
            this.getModel().setValue("picture2", null, rowIndex);
            this.getModel().setValue("picture3", null, rowIndex);
            this.getModel().setValue("picture4", null, rowIndex);
            this.getModel().setValue("curr", null, rowIndex);
            this.getModel().setValue("taxtype", null, rowIndex);
            this.getModel().setValue("entryresult", null, rowIndex);
            this.getModel().setValue("confirmstatus", (Object)"C", rowIndex);
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (null != oldValue) {
                DynamicObject oldGoods = (DynamicObject)oldValue;
                this.clearSkuSpu(oldGoods);
            }
        } else {
            DynamicObject goodsDyn = (DynamicObject)this.getModel().getValue("goods", rowIndex);
            this.getModel().setValue("skuname", (Object)goodsDyn.getString("name"), rowIndex);
            this.getModel().setValue("skunumber", (Object)goodsDyn.getString("number"), rowIndex);
            this.getModel().setValue("taxprice", (Object)goodsDyn.getBigDecimal("taxprice"), rowIndex);
            this.getModel().setValue("taxrateid", (Object)goodsDyn.getDynamicObject("taxrateid"), rowIndex);
            this.getModel().setValue("price", (Object)goodsDyn.getBigDecimal("price"), rowIndex);
            this.getModel().setValue("thumbnail", (Object)goodsDyn.getString("thumbnail"), rowIndex);
            this.getModel().setValue("picture1", (Object)goodsDyn.getString("picture1"), rowIndex);
            this.getModel().setValue("picture2", (Object)goodsDyn.getString("picture2"), rowIndex);
            this.getModel().setValue("picture3", (Object)goodsDyn.getString("picture3"), rowIndex);
            this.getModel().setValue("picture4", (Object)goodsDyn.getString("picture4"), rowIndex);
            this.getModel().setValue("curr", (Object)goodsDyn.getDynamicObject("curr"), rowIndex);
            this.getModel().setValue("taxtype", (Object)goodsDyn.getString("taxtype"), rowIndex);
            this.getModel().setValue("entryresult", null, rowIndex);
            this.getModel().setValue("confirmstatus", (Object)"C", rowIndex);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
    }

    private void clearSkuSpu(DynamicObject oldGoods) {
        DynamicObject[] skus;
        QFilter qFilter = new QFilter("id", "=", (Object)oldGoods.getLong("id"));
        String seletors = "spunumber,mulmodel";
        for (DynamicObject sku : skus = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)seletors, (QFilter[])qFilter.toArray())) {
            sku.set("spunumber", null);
            sku.set("mulmodel", (Object)false);
        }
        if (skus.length > 0) {
            SaveServiceHelper.save((DynamicObject[])skus);
        }
    }

    public void calPriceByTaxPrice(IDataModel model, int rowIndex) {
        String taxType = (String)model.getValue("taxtype", rowIndex);
        BigDecimal taxPrice = null == model.getValue("taxprice", rowIndex) ? this.ZERO : (BigDecimal)model.getValue("taxprice", rowIndex);
        BigDecimal taxRate = this.ZERO;
        if (null != model.getValue("taxrateid", rowIndex)) {
            DynamicObject taxrateDyn = (DynamicObject)model.getValue("taxrateid", rowIndex);
            taxRate = taxrateDyn.getBigDecimal("taxrate");
        }
        int scale = this.getPricePrecision(model);
        BigDecimal price = BigDecimal.ZERO;
        price = "1".equals(taxType) ? CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)scale) : CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)scale);
        this.flag = true;
        model.setValue("price", (Object)price, rowIndex);
    }

    private void calTaxPriceByPrice(IDataModel model, int rowIndex) {
        BigDecimal price = null == model.getValue("price", rowIndex) ? this.ZERO : (BigDecimal)model.getValue("price", rowIndex);
        BigDecimal taxRate = this.ZERO;
        if (null != model.getValue("taxrateid", rowIndex)) {
            DynamicObject taxrateDyn = (DynamicObject)model.getValue("taxrateid", rowIndex);
            taxRate = taxrateDyn.getBigDecimal("taxrate");
        }
        int scale = this.getPricePrecision(model);
        BigDecimal taxPrice = CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxRate, (int)scale);
        this.flag = true;
        model.setValue("taxprice", (Object)taxPrice, rowIndex);
    }

    protected int getPricePrecision(IDataModel datamodel) {
        int pricePrecision = 6;
        Object currency = datamodel.getValue("curr");
        if (null != currency && currency instanceof DynamicObject) {
            DynamicObject curr = (DynamicObject)currency;
            pricePrecision = curr.getInt("priceprecision");
        }
        return pricePrecision;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String status = String.valueOf(this.getModel().getValue("status"));
        if ("E".equals(status)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"fs_baseinfo", "newentry_atrval", SKUMAPINIT, DELETEENTRY_SALEVAL, DELETEENTRY_MAP, NEWENTRY, "deleteentry", NEWENTRY_SALEATR, DELETEENTRY_SALEATR});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_submit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"operationcolumnap"});
        }
        if ("A".equals(status)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"fs_baseinfo", NEWENTRY, "deleteentry", NEWENTRY_SALEATR, DELETEENTRY_SALEATR, "bar_submit", "specadv1", "specadv"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_delete"});
        }
        if ("A".equals(status) || "C".equals(status) || "D".equals(status)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"newentry_atrval", SKUMAPINIT, DELETEENTRY_SALEVAL, DELETEENTRY_MAP, "bar_submit", "bar_save"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
        }
        if ("B".equals(status)) {
            this.setBtnEnableByStatus();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"void"});
        }
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection spuskumapentry = dynamicObject.getDynamicObjectCollection("spuskumapentry");
        for (DynamicObject entry : spuskumapentry) {
            if (!"A".equals(entry.getString("confirmstatus"))) continue;
            entry.set("entryresult", (Object)"1");
        }
        this.getView().updateView("spuskumapentry");
        Object origin = this.getModel().getValue("origin");
        if ("2".equals(origin)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"entryresult", "note"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "bar_submit", "bar_disable", "bar_delete", "void"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"basetoolbarap", "saletoolbar", "salevartoolbar", "sputoolbarap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"operationcolumnap"});
            ComboEdit ComboEdit2 = (ComboEdit)this.getControl("entryresult");
            ComboEdit2.setMustInput(true);
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("goodsspu")) {
            this.setProsStatusBySku();
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"skunumber", "skuname", "taxprice", "taxrateid", "taxrate", "price", "thumbnail", "picture1", "picture2", "picture3", "picture4"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"content", "specification", "packinglist", "guarantee"});
    }

    private void setProsStatusBySku() {
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection spuskumapentry = dynamicObject.getDynamicObjectCollection("spuskumapentry");
        this.getView().setVisible(Boolean.TRUE, new String[]{"skunumber", "skuname", "taxprice", "taxrateid", "taxrate", "price", "thumbnail", "picture1", "picture2", "picture3", "picture4"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"fs_baseinfo", "fieldsetpanelap", "titleapanel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"goodsname", "confirmstatus", "entryresult", "note", "goods"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"operationcolumnap"});
        this.getView().setEnable(Boolean.TRUE, new String[]{NEWENTRY, "deleteentry", NEWENTRY_SALEATR, DELETEENTRY_SALEATR});
        boolean isExistGoods = false;
        for (DynamicObject row : spuskumapentry) {
            if (null == row.get("goods")) continue;
            isExistGoods = true;
            this.getView().setEnable(Boolean.FALSE, row.getInt("seq") - 1, new String[]{"skunumber"});
        }
        if (isExistGoods && null != this.getView().getParentView()) {
            this.getView().getParentView().setEnable(Boolean.FALSE, new String[]{"mulmodel"});
            this.getView().sendFormAction(this.getView().getParentView());
        }
        this.setBaseProsBySku();
        this.setSaleProsBySku();
        this.setMustInpurBySKu();
    }

    private void setMustInpurBySKu() {
        TextEdit skunameEdit = (TextEdit)this.getControl("skuname");
        skunameEdit.setMustInput(true);
        AmountEdit taxpriceEdit = (AmountEdit)this.getControl("taxprice");
        taxpriceEdit.setMustInput(true);
        PictureEdit thumbnailEdit = (PictureEdit)this.getControl("thumbnail");
        thumbnailEdit.setMustInput(true);
        TextEdit skunumber = (TextEdit)this.getControl("skunumber");
        skunumber.setMustInput(true);
    }

    private void setSaleProsBySku() {
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection spuskumapentry = dynamicObject.getDynamicObjectCollection("spuskumapentry");
        DynamicObjectCollection saleattributeentry = dynamicObject.getDynamicObjectCollection("saleattributeentry");
        HashMap<String, Integer> saleAtrMap = new HashMap<String, Integer>(16);
        for (Object row : saleattributeentry) {
            if (null == row.get("saleprodattribute")) continue;
            saleAtrMap.put(row.getString("saleprodattribute.id"), row.getInt("seq") - 1);
        }
        if (saleAtrMap.size() > 0) {
            int[] lockRowIndexs;
            HashSet lockIndexs = new HashSet(16);
            for (Map.Entry entry : saleAtrMap.entrySet()) {
                for (DynamicObject row : spuskumapentry) {
                    String spuMapIds = row.getString("spumapids");
                    if (!spuMapIds.contains((CharSequence)entry.getKey())) continue;
                    lockIndexs.add(entry.getValue());
                }
            }
            HashSet<Integer> nolockIndexs = new HashSet<Integer>(16);
            for (DynamicObject row : saleattributeentry) {
                int index = row.getInt("seq") - 1;
                if (lockIndexs.contains(index)) continue;
                nolockIndexs.add(index);
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl("saleattributeentry");
            if (lockIndexs.size() > 0) {
                lockRowIndexs = lockIndexs.stream().mapToInt(Integer::intValue).toArray();
                entryGrid.setRowLock(Boolean.TRUE.booleanValue(), lockRowIndexs);
            }
            if (nolockIndexs.size() > 0) {
                lockRowIndexs = nolockIndexs.stream().mapToInt(Integer::intValue).toArray();
                entryGrid.setRowLock(Boolean.FALSE.booleanValue(), lockRowIndexs);
            }
        }
    }

    private void setBaseProsBySku() {
        DynamicObjectCollection baseAttributeEntry;
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        String baseProsIndex = this.getPageCache().get("baseprosIndex");
        List<Integer> indexs = new ArrayList(16);
        EntryGrid baseAttribueEntry = (EntryGrid)this.getControl("baseattributeentry");
        if (StringUtils.isEmpty((CharSequence)baseProsIndex)) {
            DynamicObjectCollection spuskumapentry = dynamicObject.getDynamicObjectCollection("spuskumapentry");
            if (spuskumapentry.size() != 0) {
                baseAttributeEntry = dynamicObject.getDynamicObjectCollection("baseattributeentry");
                for (Object row : baseAttributeEntry) {
                    indexs.add(row.getInt("seq") - 1);
                }
                if (indexs.size() > 0) {
                    this.getPageCache().put("baseprosIndex", SerializationUtils.toJsonString(indexs));
                }
            }
        } else {
            indexs = (List)SerializationUtils.fromJsonString((String)baseProsIndex, List.class);
        }
        if (indexs.size() > 0) {
            int[] lockRowIndexs = indexs.stream().mapToInt(Integer::intValue).toArray();
            baseAttribueEntry.setRowLock(Boolean.TRUE.booleanValue(), lockRowIndexs);
            baseAttributeEntry = dynamicObject.getDynamicObjectCollection("baseattributeentry");
            ArrayList<Integer> noLockIndex = new ArrayList<Integer>(16);
            for (DynamicObject row : baseAttributeEntry) {
                Integer seqIndex = row.getInt("seq") - 1;
                if (indexs.contains(seqIndex)) continue;
                noLockIndex.add(seqIndex);
            }
            if (noLockIndex.size() > 0) {
                int[] noLockRowIndexs = noLockIndex.stream().mapToInt(Integer::intValue).toArray();
                baseAttribueEntry.setRowLock(Boolean.FALSE.booleanValue(), noLockRowIndexs);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView parentView = this.getView().getParentView();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        IDataModel model = this.getModel();
        if (null != parentView && null != customParams.get("goodsspu")) {
            IDataModel prodModel = parentView.getModel();
            model.setValue("name", prodModel.getValue("name"));
            model.setValue("group", prodModel.getValue("category"));
            model.setValue("supplier", prodModel.getValue("supplier"));
            model.setValue("orgfield", prodModel.getValue("createorg"));
        } else {
            this.initOrg();
        }
    }

    private void initOrg() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object org = customParams.get("orgs");
        List<Long> orgIds = new ArrayList();
        if (ObjectUtils.isEmpty(org)) {
            HasPermDimObjResult hasPermDimObjResult = PermissionServiceHelper.getHasPermDimObjs((long)RequestContext.get().getCurrUserId(), (String)"/FQ504NB63AY", (String)"pmm_spu", (String)"47150e89000000ac");
            if (!hasPermDimObjResult.hasAllDimObjPerm()) {
                if (hasPermDimObjResult.getHasPermDimObjs().size() > 0) {
                    orgIds.addAll(hasPermDimObjResult.getHasPermDimObjs());
                } else {
                    orgIds.add(RequestContext.get().getOrgId());
                }
            } else {
                orgIds.add(RequestContext.get().getOrgId());
            }
        } else {
            orgIds = (List)SerializationUtils.fromJsonString((String)String.valueOf(org), List.class);
        }
        if (orgIds.size() > 0) {
            QFilter qFilter = new QFilter("id", "in", orgIds);
            qFilter.and(new QFilter("fispurchase", "=", (Object)true));
            DynamicObjectCollection orgDyns = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])qFilter.toArray());
            if (orgDyns.size() > 0) {
                this.getModel().setValue("orgfield", (Object)((DynamicObject)orgDyns.get(0)).getLong("id"));
            }
        }
    }

    private void setBtnEnableByStatus() {
        this.getView().setEnable(Boolean.FALSE, new String[]{NEWENTRY, "deleteentry", NEWENTRY_SALEATR, DELETEENTRY_SALEATR});
        this.getView().setEnable(Boolean.FALSE, new String[]{"fs_baseinfo", NEWENTRY_SALEATR, DELETEENTRY_SALEATR});
        EntryGrid spuSkuMapEntry = (EntryGrid)this.getControl("spuskumapentry");
        DynamicObject[] datas = spuSkuMapEntry.getEntryData().getDataEntitys();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null == customParams.get("goodsspu")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"baseattributeentry", "saleattributeentry"});
        }
        ArrayList<Integer> tagRow = new ArrayList<Integer>();
        ArrayList<Integer> tagNoLockRow = new ArrayList<Integer>();
        for (DynamicObject dynamicObject : datas) {
            String confirmstatus = dynamicObject.getString("confirmstatus");
            if (null == customParams.get("goodsspu")) {
                if ("B".equals(confirmstatus)) {
                    tagRow.add(dynamicObject.getInt("seq") - 1);
                    continue;
                }
                tagNoLockRow.add(dynamicObject.getInt("seq") - 1);
                continue;
            }
            if ("B".equals(confirmstatus) && null != dynamicObject.get("goods") && !"A".equals(dynamicObject.get("goods.status"))) {
                tagRow.add(dynamicObject.getInt("seq") - 1);
                continue;
            }
            tagNoLockRow.add(dynamicObject.getInt("seq") - 1);
        }
        int[] lockRows = tagRow.stream().mapToInt(Integer::intValue).toArray();
        int[] noLockRows = tagNoLockRow.stream().mapToInt(Integer::intValue).toArray();
        spuSkuMapEntry.setRowLock(Boolean.TRUE.booleanValue(), lockRows);
        spuSkuMapEntry.setRowLock(Boolean.FALSE.booleanValue(), noLockRows);
        this.getView().setVisible(Boolean.TRUE, new String[]{"void"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_delete"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.beforeItemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "newentry_saleatr": 
            case "deleteentry_saleatr": 
            case "newentry": {
                this.confirmDelete(itemKey, evt);
                break;
            }
            case "deleteentry_saleval": {
                if (this.checkAtrVal("delete")) {
                    evt.setCancel(true);
                    break;
                }
                this.confirmDelete(itemKey, evt);
                break;
            }
        }
    }

    private boolean checkAtrVal(String option) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        EntryGrid saleAtrValueEntry = (EntryGrid)this.getControl("saleatrvalueentry");
        int[] selectRows = saleAtrValueEntry.getSelectRows();
        ArrayList<String> atrVal = new ArrayList<String>(selectRows.length);
        block0: for (int i : selectRows) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("saleatrvalueentry", i);
            long atrValueId = DynamicObjectUtil.getDynamicObjectPk((DynamicObject)entryRowEntity, (String)"saleprodattributevalue");
            if (atrValueId == 0L) continue;
            DynamicObjectCollection mapEntry = this.getModel().getEntryEntity("spuskumapentry");
            for (DynamicObject dynamicObject : mapEntry) {
                String mapJson = dynamicObject.getString("spumapids");
                String confirmstatus = dynamicObject.getString("confirmstatus");
                if (null == customParams.get("goodsspu")) {
                    if (!mapJson.contains(String.valueOf(atrValueId)) || !Arrays.asList("A", "B").contains(confirmstatus)) continue;
                    atrVal.add(String.valueOf(entryRowEntity.getDynamicObject("saleprodattributevalue").get("name")));
                    continue block0;
                }
                if (!mapJson.contains(String.valueOf(atrValueId)) || null == dynamicObject.get("goods") || "A".equals(dynamicObject.getString("goods.status"))) continue;
                atrVal.add(String.valueOf(entryRowEntity.getDynamicObject("saleprodattributevalue").get("name")));
                continue block0;
            }
        }
        if (!CollectionUtils.isEmpty(atrVal)) {
            if (null == customParams.get("goodsspu")) {
                if ("delete".equals(option)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"{0}\u89c4\u683c\u503c\u5df2\u4f7f\u7528\u4e14\u5f85\u786e\u8ba4/\u5df2\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PmmProdSpuEdit_7", (String)"scm-pmm-formplugin", (Object[])new Object[]{atrVal}));
                } else if ("modify".equals(option)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"{0}\u89c4\u683c\u503c\u5df2\u4f7f\u7528\u4e14\u5f85\u786e\u8ba4/\u5df2\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"PmmProdSpuEdit_8", (String)"scm-pmm-formplugin", (Object[])new Object[]{atrVal}));
                }
            } else if ("delete".equals(option)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"{0}\u89c4\u683c\u503c\u5173\u8054SKU\u5df2\u63d0\u4ea4/\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PmmProdSpuEdit_30", (String)"scm-pmm-formplugin", (Object[])new Object[]{atrVal}));
            } else if ("modify".equals(option)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"{0}\u89c4\u683c\u503c\u5173\u8054SKU\u5df2\u63d0\u4ea4/\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"PmmProdSpuEdit_31", (String)"scm-pmm-formplugin", (Object[])new Object[]{atrVal}));
            }
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void confirmDelete(String operateKey, BeforeItemClickEvent evt) {
        EntryGrid grid;
        EntryGrid grid2;
        String msg = "";
        if (DELETEENTRY_SALEATR.equals(operateKey) && (grid2 = (EntryGrid)this.getView().getControl("saleattributeentry")).getSelectRows().length == 0) {
            msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PmmProdSpuEdit_9", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
        }
        if (DELETEENTRY_SALEVAL.equals(operateKey) && (grid2 = (EntryGrid)this.getView().getControl("saleatrvalueentry")).getSelectRows().length == 0) {
            msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PmmProdSpuEdit_9", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
        }
        if (NEWENTRY.equals(operateKey) && (grid2 = (EntryGrid)this.getView().getControl("baseattributeentry")).getSelectRows().length == 0) {
            msg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PmmProdSpuEdit_9", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
        }
        if (msg.length() > 0) {
            this.getView().showTipNotification(msg);
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (NEWENTRY_SALEATR.equals(operateKey) && null != customParams.get("goodsspu")) {
            this.getView().invokeOperation(NEWENTRY_SALEATR);
            this.getView().updateView();
            return;
        }
        if (DELETEENTRY_SALEATR.equals(operateKey) && null != customParams.get("goodsspu")) {
            return;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection spuskumapentry = dataEntity.getDynamicObjectCollection("spuskumapentry");
        DynamicObjectCollection saleattributeentry = dataEntity.getDynamicObjectCollection("saleattributeentry");
        if (NEWENTRY_SALEATR.equals(operateKey) && saleattributeentry.size() > 0 && spuskumapentry.size() > 0 && null == customParams.get("goodsspu")) {
            msg = ResManager.loadKDString((String)"\u65b0\u589e\u9500\u552e\u89c4\u683c\u5c06\u6e05\u7a7a\u5173\u8054SKU\u5206\u5f55\uff0c\u9700\u91cd\u65b0\u5173\u8054SKU\u5e76\u786e\u8ba4\uff0c\u786e\u5b9a\u65b0\u589e\u5417\uff1f", (String)"PmmProdSpuEdit_10", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
        }
        if (DELETEENTRY_SALEATR.equals(operateKey) && saleattributeentry.size() > 0 && spuskumapentry.size() > 0 && null == customParams.get("goodsspu")) {
            msg = ResManager.loadKDString((String)"\u5220\u9664\u9500\u552e\u89c4\u683c\u5c06\u6e05\u7a7a\u5173\u8054SKU\u5206\u5f55\uff0c\u9700\u91cd\u65b0\u5173\u8054SKU\u5e76\u786e\u8ba4\uff0c\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"PmmProdSpuEdit_11", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
        }
        if (NEWENTRY.equals(operateKey) && saleattributeentry.size() > 0 && spuskumapentry.size() > 0) {
            msg = ResManager.loadKDString((String)"\u65b0\u589e\u57fa\u672c\u89c4\u683c\u5c06\u6e05\u7a7a\u5173\u8054SKU\u5206\u5f55\uff0c\u9700\u91cd\u65b0\u5173\u8054SKU\u5e76\u786e\u8ba4\uff0c\u786e\u5b9a\u65b0\u589e\u5417\uff1f", (String)"PmmProdSpuEdit_12", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            evt.setCancel(true);
        }
        if (DELETEENTRY_SALEVAL.equals(operateKey) && spuskumapentry.size() > 0 && this.isExistAtrVal()) {
            msg = ResManager.loadKDString((String)"\u5220\u9664\u9500\u552e\u89c4\u683c\u503c\u5c06\u6e05\u7a7a\u5173\u8054SKU\u5206\u5f55\uff0c\u9700\u91cd\u65b0\u5173\u8054SKU\u5e76\u786e\u8ba4\uff0c\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"PmmProdSpuEdit_13", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            if (null != customParams.get("goodsspu")) {
                msg = ResManager.loadKDString((String)"\u5220\u9664\u9500\u552e\u89c4\u683c\u503c\u5c06\u6e05\u7a7a\u5173\u8054SKU\u5206\u5f55\uff0c\u9700\u91cd\u65b0\u5173\u8054SKU\u5e76\u786e\u8ba4\uff0c\u786e\u5b9a\u5220\u9664\u5417\uff1f", (String)"PmmProdSpuEdit_13", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            }
        }
        if (msg.length() > 0) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operateKey, (IFormPlugin)this);
            this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            return;
        }
        if (spuskumapentry.size() == 0) {
            if (NEWENTRY_SALEATR.equals(operateKey)) {
                this.getModel().deleteEntryData("spuskumapentry");
                this.getView().invokeOperation(NEWENTRY_SALEATR);
            }
            if (DELETEENTRY_SALEATR.equals(operateKey)) {
                grid = (EntryGrid)this.getView().getControl("saleattributeentry");
                this.getModel().deleteEntryRows("saleattributeentry", grid.getSelectRows());
            }
        }
        if ((spuskumapentry.size() == 0 || !this.isExistAtrVal()) && DELETEENTRY_SALEVAL.equals(operateKey)) {
            this.deleteAtrVal();
            grid = (EntryGrid)this.getView().getControl("saleatrvalueentry");
            this.getModel().deleteEntryRows("saleatrvalueentry", grid.getSelectRows());
        }
    }

    private void deleteAtrVal() {
        EntryGrid saleAtrValueEntry = (EntryGrid)this.getControl("saleatrvalueentry");
        int[] selectRows = saleAtrValueEntry.getSelectRows();
        ArrayList<Integer> delRow = new ArrayList<Integer>();
        ArrayList<Long> goodsIds = new ArrayList<Long>(16);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object goodsspu = customParams.get("goodsspu");
        for (int i : selectRows) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("saleatrvalueentry", i);
            long atrValueId = DynamicObjectUtil.getDynamicObjectPk((DynamicObject)entryRowEntity, (String)"saleprodattributevalue");
            if (atrValueId == 0L) continue;
            delRow.clear();
            DynamicObjectCollection mapEntry = this.getModel().getEntryEntity("spuskumapentry");
            for (DynamicObject dynamicObject : mapEntry) {
                String mapJson = dynamicObject.getString("spumapids");
                if (!mapJson.contains(String.valueOf(atrValueId))) continue;
                delRow.add(dynamicObject.getInt("seq"));
                if (null == dynamicObject.get("goods") || !"A".equals(dynamicObject.getString("goods.status"))) continue;
                goodsIds.add(dynamicObject.getLong("goods.id"));
            }
            int[] delRow2 = new int[delRow.size()];
            int j = 0;
            for (Integer Row2 : delRow) {
                delRow2[j] = Row2 - 1;
                ++j;
            }
            this.getModel().deleteEntryRows("spuskumapentry", delRow2);
        }
        if (!ObjectUtils.isEmpty(goodsspu) && null != this.getView().getParentView()) {
            long id = this.getView().getParentView().getModel().getDataEntity(true).getLong("id");
            if (goodsIds.contains(id)) {
                goodsIds.remove(id);
                this.getPageCache().put("ignoremsg", "true");
                IDataModel skuModel = this.getView().getParentView().getModel();
                skuModel.setValue("spunumber", null);
                skuModel.setValue("mulmodel", (Object)Boolean.FALSE);
                skuModel.deleteEntryData("prodattributeentry");
                this.getView().sendFormAction(this.getView().getParentView());
            }
            if (goodsIds.size() > 0) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("isStrict", String.valueOf(false));
                OperationServiceHelper.executeOperate((String)"delete", (String)"pmm_prodmanage", (Object[])goodsIds.toArray(), (OperateOption)option);
            }
        }
    }

    private boolean isExistAtrVal() {
        EntryGrid saleAtrValueEntry = (EntryGrid)this.getControl("saleatrvalueentry");
        int[] selectRows = saleAtrValueEntry.getSelectRows();
        boolean isExist = false;
        block0: for (int i : selectRows) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("saleatrvalueentry", i);
            long atrValueId = DynamicObjectUtil.getDynamicObjectPk((DynamicObject)entryRowEntity, (String)"saleprodattributevalue");
            if (atrValueId == 0L) continue;
            DynamicObjectCollection mapEntry = this.getModel().getEntryEntity("spuskumapentry");
            for (DynamicObject dynamicObject : mapEntry) {
                String mapJson = dynamicObject.getString("spumapids");
                if (!mapJson.contains(String.valueOf(atrValueId))) continue;
                isExist = true;
                continue block0;
            }
        }
        return isExist;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        super.registerListener(e);
        BasedataEdit supplierEdit = (BasedataEdit)this.getView().getControl("supplier");
        supplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit prodAttribute = (BasedataEdit)this.getView().getControl("prodattribute");
        prodAttribute.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit prodattributevalue = (BasedataEdit)this.getView().getControl("prodattributevalue");
        prodattributevalue.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit saleProdAttribute = (BasedataEdit)this.getView().getControl("saleprodattribute");
        saleProdAttribute.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit saleprodattributevalue = (BasedataEdit)this.getView().getControl("saleprodattributevalue");
        saleprodattributevalue.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit goods = (BasedataEdit)this.getView().getControl("goods");
        goods.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("spuskumapentry");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"saletoolbar"});
        this.addItemClickListeners(new String[]{"salevartoolbar"});
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("orgfield");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit prodattributetext = (TextEdit)this.getControl("prodattributetext");
        prodattributetext.addButtonClickListener((ClickListener)this);
        TextEdit prodattributevaluetext = (TextEdit)this.getControl("prodattributevaluetext");
        prodattributevaluetext.addButtonClickListener((ClickListener)this);
        TextEdit prodattributegrouptext = (TextEdit)this.getControl("prodattributegrouptext");
        prodattributegrouptext.addButtonClickListener((ClickListener)this);
        TextEdit saleprodattributetext = (TextEdit)this.getControl("saleprodattributetext");
        saleprodattributetext.addButtonClickListener((ClickListener)this);
        TextEdit saleprodattrgrouptext = (TextEdit)this.getControl("saleprodattrgrouptext");
        saleprodattrgrouptext.addButtonClickListener((ClickListener)this);
        TextEdit saleprodattrvaluetext = (TextEdit)this.getControl("saleprodattrvaluetext");
        saleprodattrvaluetext.addButtonClickListener((ClickListener)this);
        EntryGrid baseattributeentry = (EntryGrid)this.getView().getControl("baseattributeentry");
        baseattributeentry.addRowClickListener((RowClickEventListener)this);
        baseattributeentry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid saleattributeentry = (EntryGrid)this.getView().getControl("saleattributeentry");
        saleattributeentry.addRowClickListener((RowClickEventListener)this);
        saleattributeentry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid saleatrvalueentry = (EntryGrid)this.getView().getControl("saleatrvalueentry");
        saleatrvalueentry.addRowClickListener((RowClickEventListener)this);
        saleatrvalueentry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void click(EventObject evt) {
        String formId;
        Object prodattributetext;
        String formId2;
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("prodattributetext")) {
            formId2 = "pmm_prodattribute";
            QFilter baseAttrQf = this.getBaseAttrQf();
            this.showF7Form(formId2, baseAttrQf, key, Boolean.TRUE, Boolean.TRUE);
        }
        if (key.equals("prodattributevaluetext")) {
            int baserowIndex = this.getCacheBaseRowIndex();
            prodattributetext = this.getModel().getValue("prodattributetext", baserowIndex);
            if (StringUtils.isEmpty((CharSequence)String.valueOf(prodattributetext).trim())) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u89c4\u683c\u540d\u79f0\u201d\uff0c\u518d\u5f55\u5165\u89c4\u683c\u503c\u3002", (String)"PmmProdSpuEdit_33", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return;
            }
            formId = "pmm_prodattributevalue";
            QFilter baseAttrValQf = this.getBaseAttrValQf();
            this.showF7Form(formId, baseAttrValQf, key, Boolean.FALSE, Boolean.TRUE);
        }
        if (key.equals("prodattributegrouptext")) {
            formId2 = "pmm_prodattributegroup";
            QFilter groupQf = this.getBaseAttrGroupQf();
            this.showF7Form(formId2, groupQf, key, Boolean.TRUE, Boolean.FALSE);
        }
        if (key.equals("saleprodattributetext")) {
            formId2 = "pmm_prodattribute";
            QFilter saleAtrrQf = this.getSaleAtrrQf();
            this.showF7Form(formId2, saleAtrrQf, key, Boolean.TRUE, Boolean.TRUE);
        }
        if (key.equals("saleprodattrgrouptext")) {
            formId2 = "pmm_prodattributegroup";
            QFilter saleAttrGroupQf = this.getSaleAttrGroupQf();
            this.showF7Form(formId2, saleAttrGroupQf, key, Boolean.TRUE, Boolean.FALSE);
        }
        if (key.equals("saleprodattrvaluetext")) {
            int salerowIndex = this.getCacheSaleRowIndex();
            prodattributetext = this.getModel().getValue("saleprodattributetext", salerowIndex);
            if (StringUtils.isEmpty((CharSequence)String.valueOf(prodattributetext).trim())) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u89c4\u683c\u540d\u79f0\u201d\uff0c\u518d\u5f55\u5165\u89c4\u683c\u503c\u3002", (String)"PmmProdSpuEdit_33", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return;
            }
            formId = "pmm_prodattributevalue";
            QFilter saleAttrValQf = this.getSaleAttrValQf();
            this.showF7Form(formId, saleAttrValQf, key, Boolean.TRUE, Boolean.TRUE);
        }
    }

    private QFilter getSaleAttrValQf() {
        QFilter qFilter = new QFilter("Status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        int salerowIndex = this.getCacheSaleRowIndex();
        Object prodattributetext = this.getModel().getValue("saleprodattributetext", salerowIndex);
        if (null != prodattributetext && !StringUtils.isEmpty((CharSequence)String.valueOf(prodattributetext).trim())) {
            qFilter.and(new QFilter("group.name", "=", (Object)String.valueOf(prodattributetext).trim()));
        }
        DynamicObjectCollection saleatrvalueentry = this.getModel().getEntryEntity("saleatrvalueentry");
        HashSet<String> attrNames = new HashSet<String>(16);
        for (DynamicObject row : saleatrvalueentry) {
            if (StringUtils.isEmpty((CharSequence)row.getString("saleprodattrvaluetext"))) continue;
            attrNames.add(row.getString("saleprodattrvaluetext"));
        }
        qFilter.and(new QFilter("name", "not in", attrNames));
        return qFilter;
    }

    private QFilter getSaleAttrGroupQf() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject group = dataEntity.getDynamicObject("group");
        QFilter groupQf = new QFilter("Status", "=", (Object)"C");
        groupQf.and(new QFilter("enable", "=", (Object)"1"));
        if (null != group) {
            long groupId = group.getLong("id");
            QFilter qFilter = new QFilter("group.id", "=", (Object)groupId);
            qFilter.and(new QFilter("attributetype", "=", (Object)"2"));
            int cacheBaseRowIndex = this.getCacheSaleRowIndex();
            Object prodattributetext = this.getModel().getValue("saleprodattributetext", cacheBaseRowIndex);
            if (null != prodattributetext && !StringUtils.isEmpty((CharSequence)String.valueOf(prodattributetext).trim())) {
                qFilter.and(new QFilter("prodattributename.name", "=", (Object)String.valueOf(prodattributetext).trim()));
            }
            DynamicObjectCollection pmm_prodattribute = QueryServiceHelper.query((String)"pmm_prodattribute", (String)"prodattributegroup.id", (QFilter[])qFilter.toArray());
            HashSet<Long> categoryIds = new HashSet<Long>(16);
            for (DynamicObject row : pmm_prodattribute) {
                categoryIds.add(row.getLong("prodattributegroup.id"));
            }
            if (categoryIds.size() > 0) {
                groupQf.and(new QFilter("id", "in", categoryIds));
            }
        }
        return groupQf;
    }

    private QFilter getSaleAtrrQf() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject group = dataEntity.getDynamicObject("group");
        QFilter qFilter = new QFilter("Status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("attributetype", "=", (Object)"2"));
        if (null != group) {
            long groupId = group.getLong("id");
            qFilter.and(new QFilter("group.id", "=", (Object)groupId));
        }
        int cacheBaseRowIndex = this.getCacheSaleRowIndex();
        Object prodattributegrouptext = this.getModel().getValue("saleprodattrgrouptext", cacheBaseRowIndex);
        if (null != prodattributegrouptext && !StringUtils.isEmpty((CharSequence)String.valueOf(prodattributegrouptext).trim())) {
            qFilter.and(new QFilter("prodattributegroup.name", "=", (Object)String.valueOf(prodattributegrouptext).trim()));
        }
        DynamicObjectCollection saleattributeentry = this.getModel().getEntryEntity("saleattributeentry");
        HashSet<String> attrNames = new HashSet<String>(16);
        for (DynamicObject row : saleattributeentry) {
            attrNames.add(row.getString("saleprodattributetext"));
        }
        qFilter.and(new QFilter("prodattributename.name", "not in", attrNames));
        return qFilter;
    }

    private QFilter getBaseAttrGroupQf() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject group = dataEntity.getDynamicObject("group");
        QFilter groupQf = new QFilter("Status", "=", (Object)"C");
        groupQf.and(new QFilter("enable", "=", (Object)"1"));
        if (null != group) {
            long groupId = group.getLong("id");
            QFilter qFilter = new QFilter("group.id", "=", (Object)groupId);
            qFilter.and(new QFilter("attributetype", "=", (Object)"1"));
            int cacheBaseRowIndex = this.getCacheBaseRowIndex();
            Object prodattributetext = this.getModel().getValue("prodattributetext", cacheBaseRowIndex);
            if (null != prodattributetext && !StringUtils.isEmpty((CharSequence)String.valueOf(prodattributetext).trim())) {
                qFilter.and(new QFilter("prodattributename.name", "=", (Object)String.valueOf(prodattributetext).trim()));
            }
            DynamicObjectCollection pmm_prodattribute = QueryServiceHelper.query((String)"pmm_prodattribute", (String)"prodattributegroup.id", (QFilter[])qFilter.toArray());
            HashSet<Long> categoryIds = new HashSet<Long>(16);
            for (DynamicObject row : pmm_prodattribute) {
                categoryIds.add(row.getLong("prodattributegroup.id"));
            }
            if (categoryIds.size() > 0) {
                groupQf.and(new QFilter("id", "in", categoryIds));
            }
        }
        return groupQf;
    }

    private QFilter getBaseAttrValQf() {
        int baserowIndex = this.getCacheBaseRowIndex();
        QFilter qFilter = new QFilter("Status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        Object prodattribute = this.getModel().getValue("prodattribute", baserowIndex);
        if (null != prodattribute && null != ((DynamicObject)prodattribute).get("prodattributename")) {
            DynamicObject attrDyn = ((DynamicObject)prodattribute).getDynamicObject("prodattributename");
            qFilter.and(new QFilter("group.id", "=", (Object)attrDyn.getLong("id")));
        }
        return qFilter;
    }

    private QFilter getBaseAttrQf() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject group = dataEntity.getDynamicObject("group");
        QFilter qFilter = new QFilter("Status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("attributetype", "=", (Object)"1"));
        if (null != group) {
            long groupId = group.getLong("id");
            qFilter.and(new QFilter("group.id", "=", (Object)groupId));
        }
        int cacheBaseRowIndex = this.getCacheBaseRowIndex();
        Object prodattributegrouptext = this.getModel().getValue("prodattributegrouptext", cacheBaseRowIndex);
        if (null != prodattributegrouptext && !StringUtils.isEmpty((CharSequence)String.valueOf(prodattributegrouptext).trim())) {
            qFilter.and(new QFilter("prodattributegroup.name", "=", (Object)String.valueOf(prodattributegrouptext).trim()));
        }
        DynamicObjectCollection baseAtrEntry = this.getModel().getEntryEntity("baseattributeentry");
        HashSet<String> attrNames = new HashSet<String>(16);
        for (DynamicObject row : baseAtrEntry) {
            attrNames.add(row.getString("prodattributetext"));
        }
        qFilter.and(new QFilter("prodattributename.name", "not in", attrNames));
        return qFilter;
    }

    private void showF7Form(String formId, QFilter qFilter, String key, boolean ismMulSelct, boolean isTree) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId(formId);
        if (isTree) {
            parameter.setFormId("bos_treelistf7");
        } else {
            parameter.setFormId("bos_listf7");
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        parameter.getOpenStyle().setInlineStyleCss(css);
        parameter.setShowTitle(false);
        parameter.setF7Style(2);
        parameter.setMultiSelect(ismMulSelct);
        parameter.setLookUp(true);
        parameter.setShowApproved(true);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.getQFilters().add(qFilter);
        parameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "confirm": {
                if (!this.checkBeforeAudit()) break;
                this.auditResult();
                break;
            }
            case "skumapinit": {
                boolean isCheck = this.dataCheck();
                if (isCheck) {
                    this.skuMapInit(args);
                    break;
                }
                args.setCancel(true);
                break;
            }
            case "deleteentry_map": {
                if (!this.checkSkuAtr()) break;
                args.setCancel(true);
                break;
            }
            case "newsku": {
                this.newSku();
                break;
            }
            case "submit": {
                this.submitOp();
                args.setCancel(true);
                break;
            }
            case "unsubmit": {
                this.unSubmitOp();
                args.setCancel(true);
                break;
            }
            case "deleteentry_base": {
                this.checkDeleteEntryBase(args);
                break;
            }
            case "deleteentry_saleno": {
                this.checkDelelesaleAttrentry(args);
                break;
            }
            case "newentry_base": 
            case "newentry_saleatr": 
            case "newentry_atrval": {
                this.checkCategory(args);
                break;
            }
        }
    }

    private void checkCategory(BeforeDoOperationEventArgs args) {
        Object group = this.getModel().getValue("group");
        if (ObjectUtils.isEmpty((Object)group)) {
            String msg = ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PmmProdSpuEdit_45", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
        }
    }

    private void checkDelelesaleAttrentry(BeforeDoOperationEventArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null == customParams.get("goodsspu")) {
            return;
        }
        EntryGrid grid = (EntryGrid)this.getView().getControl("saleattributeentry");
        int[] selectRows = grid.getSelectRows();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection saleattributeentry = dataEntity.getDynamicObjectCollection("saleattributeentry");
        HashMap<String, Integer> saleAtrMap = new HashMap<String, Integer>(16);
        for (DynamicObject row : saleattributeentry) {
            if (null == row.get("saleprodattribute")) continue;
            saleAtrMap.put(row.getString("saleprodattribute.id"), row.getInt("seq") - 1);
        }
        if (saleAtrMap.size() > 0) {
            DynamicObjectCollection spuskumapentry = dataEntity.getDynamicObjectCollection("spuskumapentry");
            HashSet lockIndexs = new HashSet(16);
            for (Map.Entry entry : saleAtrMap.entrySet()) {
                for (DynamicObject row : spuskumapentry) {
                    String spuMapIds = row.getString("spumapids");
                    if (!spuMapIds.contains((CharSequence)entry.getKey())) continue;
                    lockIndexs.add(entry.getValue());
                }
            }
            if (lockIndexs.size() > 0) {
                HashSet<Integer> selectLockIndex = new HashSet<Integer>(16);
                for (int selectIndex : selectRows) {
                    if (!lockIndexs.contains(selectIndex)) continue;
                    selectLockIndex.add(selectIndex);
                }
                if (selectLockIndex.size() > 0) {
                    if (selectLockIndex.size() == 1) {
                        Object object = selectLockIndex.toArray()[0];
                        String msg = ResManager.loadKDString((String)"\u9500\u552e\u89c4\u683c\u7b2c{0}\u884c,\u5df2\u5b58\u5728\u5173\u8054SKU\u5206\u5f55\u4e2d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PmmProdSpuEdit_25", (String)"scm-pmm-formplugin", (Object[])new Object[]{Integer.parseInt(String.valueOf(object)) + 1});
                        this.getView().showErrorNotification(msg);
                    } else {
                        StringBuilder stringBuilder = new StringBuilder();
                        Object msg = selectLockIndex.iterator();
                        while (msg.hasNext()) {
                            int lockIndex = (Integer)msg.next();
                            stringBuilder.append(ResManager.loadKDString((String)"\u9500\u552e\u89c4\u683c\u7b2c{0}\u884c,\u5df2\u5b58\u5728\u5173\u8054SKU\u5206\u5f55\u4e2d\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PmmProdSpuEdit_25", (String)"scm-pmm-formplugin", (Object[])new Object[]{lockIndex + 1})).append("\n");
                        }
                        if (stringBuilder.length() > 0) {
                            msg = ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"PmmProdSpuEdit_24", (String)"scm-pmm-formplugin", (Object[])new Object[]{stringBuilder.toString()});
                            this.getView().showMessage((String)msg, stringBuilder.toString(), MessageTypes.Default);
                        }
                    }
                    args.setCancel(true);
                    return;
                }
            }
        }
        this.getModel().deleteEntryRows("saleattributeentry", grid.getSelectRows());
    }

    private void checkDeleteEntryBase(BeforeDoOperationEventArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null == customParams.get("goodsspu")) {
            return;
        }
        DynamicObjectCollection spuskumapentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("spuskumapentry");
        if (spuskumapentry.size() == 0) {
            return;
        }
        String baseprosIndex = this.getPageCache().get("baseprosIndex");
        if (!StringUtils.isEmpty((CharSequence)baseprosIndex)) {
            EntryGrid grid = (EntryGrid)this.getView().getControl("baseattributeentry");
            int[] selectRows = grid.getSelectRows();
            List indexs = (List)SerializationUtils.fromJsonString((String)baseprosIndex, List.class);
            HashSet<Integer> lockIndexs = new HashSet<Integer>(16);
            for (int index : selectRows) {
                if (!indexs.contains(index)) continue;
                lockIndexs.add(index);
            }
            if (lockIndexs.size() > 0) {
                if (lockIndexs.size() == 1) {
                    Object index = lockIndexs.toArray()[0];
                    String msg = ResManager.loadKDString((String)"\u57fa\u672c\u89c4\u683c\u7b2c{0}\u884c,\u5df2\u5b58\u5728\u5bf9\u5e94\u89c4\u683c\u7684\u5173\u8054SKU\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PmmProdSpuEdit_23", (String)"scm-pmm-formplugin", (Object[])new Object[]{Integer.parseInt(String.valueOf(index)) + 1});
                    this.getView().showErrorNotification(msg);
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    Object msg = lockIndexs.iterator();
                    while (msg.hasNext()) {
                        int lockIndex = (Integer)msg.next();
                        stringBuilder.append(ResManager.loadKDString((String)"\u57fa\u672c\u89c4\u683c\u7b2c{0}\u884c,\u5df2\u5b58\u5728\u5bf9\u5e94\u89c4\u683c\u7684\u5173\u8054SKU\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PmmProdSpuEdit_23", (String)"scm-pmm-formplugin", (Object[])new Object[]{lockIndex + 1})).append("\n");
                    }
                    if (stringBuilder.length() > 0) {
                        msg = ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25", (String)"PmmProdSpuEdit_24", (String)"scm-pmm-formplugin", (Object[])new Object[]{stringBuilder.toString()});
                        this.getView().showMessage((String)msg, stringBuilder.toString(), MessageTypes.Default);
                    }
                }
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        int currentRowIndex;
        Map customParams;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("save".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.autoBaseByText();
            this.updateBaseAttrIndexCache();
            customParams = this.getView().getFormShowParameter().getCustomParams();
            if (null != customParams.get("goodsspu")) {
                DynamicObjectCollection spuskumapentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("spuskumapentry");
                DynamicObject skuInfo = this.getView().getParentView().getModel().getDataEntity(true);
                long currGoodsId = skuInfo.getLong("id");
                int index = 0;
                for (DynamicObject row : spuskumapentry) {
                    if (null != row.getDynamicObject("goods") && currGoodsId == row.getLong("goods.id") && index >= 0) {
                        this.switchGoods(index, false, false);
                        break;
                    }
                    ++index;
                }
            }
        }
        if (DELETEENTRY_MAP.equals(operateKey) && null != (customParams = this.getView().getFormShowParameter().getCustomParams()).get("goodsspu") && (currentRowIndex = this.getModel().getEntryCurrentRowIndex("spuskumapentry")) >= 0) {
            this.switchGoods(currentRowIndex, false, false);
        }
    }

    private void autoBaseByText() {
        this.getPageCache().put("autobaseedit", "true");
        HashSet<String> prodAttrGroupSet = new HashSet<String>(16);
        HashMap<String, String> prodAttrMap = new HashMap<String, String>(16);
        HashMap<String, List<String>> prodAttrValMap = new HashMap<String, List<String>>(16);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection baseattributeentry = dataEntity.getDynamicObjectCollection("baseattributeentry");
        for (Object row : baseattributeentry) {
            DynamicObject prodattribute = row.getDynamicObject("prodattribute");
            DynamicObject prodattributevalue = row.getDynamicObject("prodattributevalue");
            String prodattributetext = row.getString("prodattributetext").trim();
            String prodattributegrouptext = row.getString("prodattributegrouptext").trim();
            if (null == prodattribute || !prodattributetext.equals(prodattribute.getDynamicObject("prodattributename").getString("name"))) {
                prodAttrMap.put(prodattributetext, "1_" + prodattributegrouptext);
            }
            if (!(null != prodattribute && null != prodattribute.getDynamicObject("prodattributegroup") && (null == prodattribute.getDynamicObject("prodattributegroup") || prodattributegrouptext.equals(prodattribute.getDynamicObject("prodattributegroup").getString("name")) && prodattributetext.equals(prodattribute.getDynamicObject("prodattributename").getString("name"))) || StringUtils.isEmpty((CharSequence)prodattributegrouptext))) {
                prodAttrGroupSet.add(prodattributegrouptext);
            }
            String prodattributevaluetext = row.getString("prodattributevaluetext").trim();
            if (null != prodattributevalue && prodattributevaluetext.equals(prodattributevalue.getString("name")) && prodattributevalue.getString("group.name").equals(prodattributetext)) continue;
            Object atrrVals = new ArrayList(16);
            if (null != prodAttrValMap.get(prodattributetext)) {
                atrrVals = (List)prodAttrValMap.get(prodattributetext);
            }
            atrrVals.add(prodattributevaluetext);
            prodAttrValMap.put(prodattributetext, (List<String>)atrrVals);
        }
        DynamicObjectCollection saleattributeentry = dataEntity.getDynamicObjectCollection("saleattributeentry");
        for (DynamicObject row : saleattributeentry) {
            DynamicObject saleprodattribute = row.getDynamicObject("saleprodattribute");
            String saleprodattributetext = row.getString("saleprodattributetext").trim();
            String saleprodattrgrouptext = row.getString("saleprodattrgrouptext").trim();
            if (null == saleprodattribute || !saleprodattributetext.equals(saleprodattribute.getDynamicObject("prodattributename").getString("name"))) {
                prodAttrMap.put(saleprodattributetext, "2_" + saleprodattrgrouptext);
            }
            if (!(null != saleprodattribute && null != saleprodattribute.getDynamicObject("prodattributegroup") && (null == saleprodattribute.getDynamicObject("prodattributegroup") || saleprodattrgrouptext.equals(saleprodattribute.getDynamicObject("prodattributegroup").getString("name")) && saleprodattributetext.equals(saleprodattribute.getDynamicObject("prodattributename").getString("name"))) || StringUtils.isEmpty((CharSequence)saleprodattrgrouptext))) {
                prodAttrGroupSet.add(saleprodattrgrouptext);
            }
            DynamicObjectCollection saleatrvalueentry = row.getDynamicObjectCollection("saleatrvalueentry");
            for (DynamicObject subRow : saleatrvalueentry) {
                DynamicObject saleprodattributevalue = subRow.getDynamicObject("saleprodattributevalue");
                String saleprodattrvaluetext = subRow.getString("saleprodattrvaluetext").trim();
                if (null != saleprodattributevalue && saleprodattrvaluetext.equals(saleprodattributevalue.getString("name")) && saleprodattributevalue.getString("group.name").equals(saleprodattributetext)) continue;
                List<String> atrrVals = new ArrayList<String>(16);
                if (null != prodAttrValMap.get(saleprodattributetext)) {
                    atrrVals = (List)prodAttrValMap.get(saleprodattributetext);
                }
                atrrVals.add(saleprodattrvaluetext);
                prodAttrValMap.put(saleprodattributetext, atrrVals);
            }
        }
        Map<String, Long> atrrGroupMap = this.getAttrGroupMap(prodAttrGroupSet);
        Map<String, Long> atrrclassMap = this.getAttrClassMap(prodAttrValMap.keySet());
        Map<String, Long> atrrMap = this.getAttrMap(prodAttrMap, atrrclassMap, atrrGroupMap);
        Map<String, Long> atrrValMap = this.getAttrValMap(prodAttrValMap, atrrclassMap);
        for (DynamicObject row : baseattributeentry) {
            DynamicObject prodattribute = row.getDynamicObject("prodattribute");
            DynamicObject prodattributevalue = row.getDynamicObject("prodattributevalue");
            if (null == prodattribute || !row.getString("prodattributetext").equals(prodattribute.getDynamicObject("prodattributename").getString("name"))) {
                this.getModel().setValue("prodattribute", (Object)atrrMap.get(row.getString("prodattributetext")), row.getInt("seq") - 1);
            }
            if (null != prodattributevalue && row.getString("prodattributevaluetext").equals(prodattributevalue.getString("name"))) continue;
            this.getModel().setValue("prodattributevalue", (Object)atrrValMap.get(row.getString("prodattributevaluetext")), row.getInt("seq") - 1);
        }
        saleattributeentry = dataEntity.getDynamicObjectCollection("saleattributeentry");
        for (DynamicObject row : saleattributeentry) {
            DynamicObject saleprodattribute = row.getDynamicObject("saleprodattribute");
            int index = row.getInt("seq") - 1;
            if (null == saleprodattribute || !row.getString("saleprodattributetext").equals(saleprodattribute.getDynamicObject("prodattributename").getString("name"))) {
                this.getModel().setValue("saleprodattribute", (Object)atrrMap.get(row.getString("saleprodattributetext")), index);
            }
            DynamicObjectCollection saleatrvalueentry = row.getDynamicObjectCollection("saleatrvalueentry");
            for (DynamicObject subRow : saleatrvalueentry) {
                DynamicObject saleprodattributevalue = subRow.getDynamicObject("saleprodattributevalue");
                if (null != saleprodattributevalue && subRow.getString("saleprodattrvaluetext").equals(saleprodattributevalue.getString("name"))) continue;
                this.getModel().setValue("saleprodattributevalue", (Object)atrrValMap.get(subRow.getString("saleprodattrvaluetext")), subRow.getInt("seq") - 1, index);
            }
        }
        this.getPageCache().remove("autobaseedit");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
    }

    private Map<String, Long> getAttrValMap(Map<String, List<String>> prodAttrValMap, Map<String, Long> atrrclassMap) {
        HashMap<String, Long> attrValMap = new HashMap<String, Long>(16);
        if (prodAttrValMap.size() == 0) {
            return attrValMap;
        }
        QFilter qFilter = new QFilter("group.name", "in", prodAttrValMap.keySet());
        DynamicObjectCollection pmmProdattributeGroups = QueryServiceHelper.query((String)"pmm_prodattributevalue", (String)"id,name,group.name", (QFilter[])qFilter.toArray());
        for (Object row : pmmProdattributeGroups) {
            List<String> atrrVals;
            String string = row.getString("group.name");
            String attrValName = row.getString("name");
            if (null == prodAttrValMap.get(string) || !(atrrVals = prodAttrValMap.get(string)).contains(attrValName)) continue;
            attrValMap.put(attrValName, row.getLong("id"));
            atrrVals.remove(attrValName);
        }
        ArrayList<DynamicObject> addDyns = new ArrayList<DynamicObject>(16);
        for (Map.Entry entry : prodAttrValMap.entrySet()) {
            List attrVals = (List)entry.getValue();
            String atrrClassName = (String)entry.getKey();
            for (String atrtVal : attrVals) {
                DynamicObject newDyn = BusinessDataServiceHelper.newDynamicObject((String)"pmm_prodattributevalue");
                newDyn.set("name", (Object)atrtVal);
                newDyn.set("createorg", (Object)RequestContext.get().getOrgId());
                newDyn.set("group", (Object)atrrclassMap.get(atrrClassName));
                newDyn.set("origin", (Object)"2");
                newDyn.set("status", (Object)"A");
                newDyn.set("enable", (Object)"1");
                newDyn.set("creator", (Object)RequestContext.get().getCurrUserId());
                ORM.create().setPrimaryKey(newDyn);
                addDyns.add(newDyn);
                attrValMap.put(atrtVal, newDyn.getLong("id"));
            }
        }
        if (addDyns.size() > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"pmm_prodattributevalue", (DynamicObject[])addDyns.toArray(new DynamicObject[0]), (OperateOption)option);
            if (!operationResult.isSuccess()) {
                log.info(ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo()));
            } else {
                List successPkIds = operationResult.getSuccessPkIds();
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"pmm_prodattributevalue", (Object[])successPkIds.toArray(), (OperateOption)option);
                if (!submitResult.isSuccess()) {
                    log.info(ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo()));
                } else {
                    List submitSuccessPkIds = submitResult.getSuccessPkIds();
                    OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"pmm_prodattributevalue", (Object[])submitSuccessPkIds.toArray(), (OperateOption)option);
                    if (!auditResult.isSuccess()) {
                        log.info(ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo()));
                    }
                }
            }
        }
        return attrValMap;
    }

    private Map<String, Long> getAttrMap(Map<String, String> prodAttrValMap, Map<String, Long> atrrclassMap, Map<String, Long> atrrGroupMap) {
        HashMap<String, Long> attrMap = new HashMap<String, Long>(16);
        if (prodAttrValMap.size() == 0) {
            return attrMap;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject group = dataEntity.getDynamicObject("group");
        QFilter qFilter = new QFilter("prodattributename.name", "in", prodAttrValMap.keySet());
        DynamicObjectCollection pmmProdattributeGroups = QueryServiceHelper.query((String)"pmm_prodattribute", (String)"id,name,prodattributegroup.name,attributetype", (QFilter[])qFilter.toArray());
        for (Object row : pmmProdattributeGroups) {
            String key;
            String string = row.getString("prodattributegroup.name");
            String attributetype = row.getString("attributetype");
            if (null == prodAttrValMap.get(row.getString("name")) || !(key = prodAttrValMap.get(row.getString("name"))).equals(attributetype + "_" + string)) continue;
            attrMap.put(row.getString("name"), row.getLong("id"));
            prodAttrValMap.remove(row.getString("name"));
        }
        ArrayList<DynamicObject> addDyns = new ArrayList<DynamicObject>(16);
        for (Map.Entry entry : prodAttrValMap.entrySet()) {
            String atrrClassName = (String)entry.getKey();
            String[] values = ((String)entry.getValue()).split("_");
            DynamicObject newDyn = BusinessDataServiceHelper.newDynamicObject((String)"pmm_prodattribute");
            newDyn.set("prodattributename_id", (Object)atrrclassMap.get(atrrClassName));
            newDyn.set("createorg", (Object)RequestContext.get().getOrgId());
            if (values.length > 1 && null != atrrGroupMap.get(values[1])) {
                newDyn.set("prodattributegroup_id", (Object)atrrGroupMap.get(values[1]));
            }
            newDyn.set("attributetype", (Object)values[0]);
            newDyn.set("name", (Object)atrrClassName);
            newDyn.set("origin", (Object)"2");
            newDyn.set("group", (Object)group);
            newDyn.set("status", (Object)"A");
            newDyn.set("enable", (Object)"1");
            newDyn.set("creator", (Object)RequestContext.get().getCurrUserId());
            ORM.create().setPrimaryKey(newDyn);
            addDyns.add(newDyn);
            attrMap.put(atrrClassName, newDyn.getLong("id"));
        }
        if (addDyns.size() > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"pmm_prodattribute", (DynamicObject[])addDyns.toArray(new DynamicObject[0]), (OperateOption)option);
            if (!operationResult.isSuccess()) {
                log.info(ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo()));
            } else {
                List successPkIds = operationResult.getSuccessPkIds();
                OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)"pmm_prodattribute", (Object[])successPkIds.toArray(), (OperateOption)option);
                if (!submitResult.isSuccess()) {
                    log.info(ExceptionUtil.getErrorInfoDetails((List)submitResult.getAllErrorOrValidateInfo()));
                } else {
                    List submitSuccessPkIds = submitResult.getSuccessPkIds();
                    OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)"pmm_prodattribute", (Object[])submitSuccessPkIds.toArray(), (OperateOption)option);
                    if (!auditResult.isSuccess()) {
                        log.info(ExceptionUtil.getErrorInfoDetails((List)auditResult.getAllErrorOrValidateInfo()));
                    }
                }
            }
        }
        return attrMap;
    }

    private Map<String, Long> getAttrClassMap(Set<String> attrSet) {
        HashMap<String, Long> atrrMap = new HashMap<String, Long>(16);
        if (attrSet.size() == 0) {
            return atrrMap;
        }
        QFilter qFilter = new QFilter("name", "in", attrSet);
        DynamicObjectCollection pmmProdattributeGroups = QueryServiceHelper.query((String)"pmm_prodattributeclass", (String)"id,name", (QFilter[])qFilter.toArray());
        for (Object row : pmmProdattributeGroups) {
            atrrMap.put(row.getString("name"), row.getLong("id"));
        }
        if (attrSet.size() > 0) {
            ArrayList<DynamicObject> addDyns = new ArrayList<DynamicObject>(16);
            for (String attrGroupName : attrSet) {
                if (atrrMap.containsKey(attrGroupName)) continue;
                DynamicObject newDyn = BusinessDataServiceHelper.newDynamicObject((String)"pmm_prodattributeclass");
                newDyn.set("name", (Object)attrGroupName);
                newDyn.set("createorg", (Object)RequestContext.get().getOrgId());
                newDyn.set("status", (Object)"C");
                newDyn.set("enable", (Object)"1");
                newDyn.set("origin", (Object)"2");
                ORM.create().setPrimaryKey(newDyn);
                addDyns.add(newDyn);
                atrrMap.put(attrGroupName, newDyn.getLong("id"));
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"pmm_prodattributeclass", (DynamicObject[])addDyns.toArray(new DynamicObject[0]), (OperateOption)option);
            if (!operationResult.isSuccess()) {
                log.info(ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo()));
            }
        }
        return atrrMap;
    }

    private Map<String, Long> getAttrGroupMap(Set<String> prodAttrGroupSet) {
        HashMap<String, Long> atrrGroupMap = new HashMap<String, Long>(16);
        if (prodAttrGroupSet.size() == 0) {
            return atrrGroupMap;
        }
        QFilter qFilter = new QFilter("name", "in", prodAttrGroupSet);
        DynamicObjectCollection pmmProdattributeGroups = QueryServiceHelper.query((String)"pmm_prodattributegroup", (String)"id,name", (QFilter[])qFilter.toArray());
        for (Object row : pmmProdattributeGroups) {
            atrrGroupMap.put(row.getString("name"), row.getLong("id"));
            prodAttrGroupSet.remove(row.getString("name"));
        }
        if (prodAttrGroupSet.size() > 0) {
            ArrayList<DynamicObject> addDyns = new ArrayList<DynamicObject>(16);
            for (String attrGroupName : prodAttrGroupSet) {
                DynamicObject newDyn = BusinessDataServiceHelper.newDynamicObject((String)"pmm_prodattributegroup");
                newDyn.set("name", (Object)attrGroupName);
                newDyn.set("createorg", (Object)RequestContext.get().getOrgId());
                newDyn.set("status", (Object)"C");
                newDyn.set("enable", (Object)"1");
                newDyn.set("origin", (Object)"2");
                ORM.create().setPrimaryKey(newDyn);
                addDyns.add(newDyn);
                atrrGroupMap.put(attrGroupName, newDyn.getLong("id"));
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"pmm_prodattributegroup", (DynamicObject[])addDyns.toArray(new DynamicObject[0]), (OperateOption)option);
            if (!operationResult.isSuccess()) {
                log.info(ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo()));
            }
        }
        return atrrGroupMap;
    }

    private void updateBaseAttrIndexCache() {
        ArrayList<Integer> indexs = new ArrayList<Integer>(16);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection spuskumapentry = dataEntity.getDynamicObjectCollection("spuskumapentry");
        if (spuskumapentry.size() == 0) {
            this.getPageCache().remove("baseprosIndex");
        } else {
            DynamicObjectCollection baseAttributeEntry = dataEntity.getDynamicObjectCollection("baseattributeentry");
            for (DynamicObject row : baseAttributeEntry) {
                indexs.add(row.getInt("seq") - 1);
            }
            if (indexs.size() > 0) {
                this.getPageCache().put("baseprosIndex", SerializationUtils.toJsonString(indexs));
            }
        }
    }

    private void unSubmitOp() {
        this.getView().invokeOperation("refresh");
        DynamicObject[] spus = new DynamicObject[]{this.getModel().getDataEntity(true)};
        PmmSpuValidatorServiceImpl entSpuValidatorService = new PmmSpuValidatorServiceImpl();
        Map<Long, Integer> selectEntryIdAndRowIndexs = this.getSelectEntryIdAndRowIndexs();
        Map res = entSpuValidatorService.unSubmitHandleAndValid(spus, selectEntryIdAndRowIndexs);
        entSpuValidatorService.unSubmitMessageShow(res, this.getView(), selectEntryIdAndRowIndexs);
        int successNum = (Integer)res.get("successNum");
        int failNum = (Integer)res.get("failNum");
        OperateOption option = OperateOption.create();
        option.setVariableValue("isshowmessage", String.valueOf(Boolean.FALSE));
        if (successNum > 0 && (failNum == 0 || selectEntryIdAndRowIndexs.isEmpty())) {
            this.getView().invokeOperation("save", option);
        } else if (successNum > 0 && failNum > 0) {
            this.getView().invokeOperation("save", option);
        }
        this.getView().invokeOperation("refresh");
    }

    private Map<Long, Integer> getSelectEntryIdAndRowIndexs() {
        EntryGrid spuSkuMapEntry = (EntryGrid)this.getControl("spuskumapentry");
        int[] select = spuSkuMapEntry.getSelectRows();
        HashMap<Long, Integer> selectEntryIdAndRowIndexs = new HashMap<Long, Integer>(select.length);
        for (int selectRow : select) {
            selectEntryIdAndRowIndexs.put(this.getModel().getEntryRowEntity("spuskumapentry", selectRow).getLong("id"), selectRow);
        }
        return selectEntryIdAndRowIndexs;
    }

    private void submitOp() {
        DynamicObject[] spus = new DynamicObject[]{this.getModel().getDataEntity(true)};
        PmmSpuValidatorServiceImpl entSpuValidatorService = new PmmSpuValidatorServiceImpl();
        Map<Long, Integer> selectEntryIdAndRowIndexs = this.getSelectEntryIdAndRowIndexs();
        Map res = entSpuValidatorService.submitHandleAndValid(spus, selectEntryIdAndRowIndexs);
        entSpuValidatorService.submitMessageShow(res, this.getView(), selectEntryIdAndRowIndexs);
        int successNum = (Integer)res.get("successNum");
        if (successNum > 0) {
            SaveServiceHelper.save((DynamicObject[])spus);
        }
        this.getView().updateView();
    }

    private void newSku() {
        DynamicObject entryRowEntity;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String supplierId = String.valueOf(this.getModel().getValue("supplier_id"));
        String orgId = String.valueOf(this.getModel().getValue("orgfield_id"));
        String categoryId = String.valueOf((Long)this.getModel().getValue("group_id"));
        String number = String.valueOf(this.getModel().getValue("number"));
        paramMap.put("categoryId", categoryId);
        paramMap.put("orgId", orgId);
        paramMap.put("supplierId", supplierId);
        paramMap.put("number", number);
        DynamicObjectCollection baseAtrEntry = this.getModel().getEntryEntity("baseattributeentry");
        if (baseAtrEntry.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u57fa\u672c\u89c4\u683c\u5206\u5f55\u3002", (String)"PmmProdSpuEdit_14", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> atrMap = new HashMap<String, String>(baseAtrEntry.size());
        for (int row = 0; row < baseAtrEntry.size(); ++row) {
            DynamicObject baseDyn = (DynamicObject)baseAtrEntry.get(row);
            if (baseDyn.getDynamicObject("prodattribute") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u57fa\u672c\u89c4\u683c\u7b2c{0}\u884c\u7684\u89c4\u683c\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u5148\u586b\u5199\u3002", (String)"PmmProdSpuEdit_15", (String)"scm-pmm-formplugin", (Object[])new Object[]{row + 1}));
                return;
            }
            if (baseDyn.getDynamicObject("prodattributevalue") == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u57fa\u672c\u89c4\u683c\u7b2c{0}\u884c\u7684\u89c4\u683c\u503c\u4e3a\u7a7a\uff0c\u8bf7\u5148\u586b\u5199\u3002", (String)"PmmProdSpuEdit_16", (String)"scm-pmm-formplugin", (Object[])new Object[]{row + 1}));
                return;
            }
            String attributeId = baseDyn.getDynamicObject("prodattribute").getPkValue().toString();
            String attributeValId = baseDyn.getDynamicObject("prodattributevalue").getPkValue().toString();
            atrMap.put(attributeId, attributeValId);
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isshowmessage", "false");
        this.getView().invokeOperation("save", operateOption);
        EntryGrid saleAtrValueEntry = (EntryGrid)this.getControl("spuskumapentry");
        int[] selectRows = saleAtrValueEntry.getSelectRows();
        int rowIndex = selectRows[0];
        if (null != this.getPageCache().get("row")) {
            rowIndex = Integer.parseInt(this.getPageCache().get("row"));
            this.getPageCache().remove("row");
        }
        if ((entryRowEntity = this.getModel().getEntryRowEntity("spuskumapentry", rowIndex)).getDynamicObject("goods") != null && Arrays.asList("A", "B").contains(entryRowEntity.getString("confirmstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5173\u8054SKU\uff0c\u4e0d\u652f\u6301\u65b0\u589eSKU\u3002", (String)"PmmProdSpuEdit_17", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection spuAtrDetailCol = entryRowEntity.getDynamicObjectCollection("spuatrdetailentry");
        for (DynamicObject saleDyn : spuAtrDetailCol) {
            String attributeId = saleDyn.getDynamicObject("saleprodattributeid").getPkValue().toString();
            String attributeValId = saleDyn.getDynamicObject("saleprodattributevalueid").getPkValue().toString();
            atrMap.put(attributeId, attributeValId);
        }
        paramMap.put("atrMap", SerializationUtils.toJsonString(atrMap));
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"pmm_prodmanage", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.ADDNEW, (long)0L, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "newSku")));
    }

    private boolean checkSkuAtr() {
        EntryGrid spuSkuMapEntry = (EntryGrid)this.getControl("spuskumapentry");
        int[] selectRows = spuSkuMapEntry.getSelectRows();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object goodsspu = customParams.get("goodsspu");
        if (!ObjectUtils.isEmpty(goodsspu)) {
            HashMap<Integer, String> seq_prodNoMap = new HashMap<Integer, String>(16);
            ArrayList<Long> goodsIds = new ArrayList<Long>(16);
            for (int i : selectRows) {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("spuskumapentry", i);
                if (null == entryRowEntity.get("goods")) continue;
                String status = entryRowEntity.getString("goods.status");
                if ("A".equals(status)) {
                    goodsIds.add(entryRowEntity.getLong("goods.id"));
                    continue;
                }
                seq_prodNoMap.put(entryRowEntity.getInt("seq"), entryRowEntity.getString("goods.number"));
            }
            if (seq_prodNoMap.size() > 0) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Map.Entry map : seq_prodNoMap.entrySet()) {
                    stringBuilder.append(map.getKey()).append(",");
                }
                if (stringBuilder.length() > 0) {
                    String index = stringBuilder.substring(0, stringBuilder.length() - 1);
                    String msg = ResManager.loadKDString((String)"\u5173\u8054SKU\u5206\u5f55\u7b2c{0}\u884c\u975e\u4fdd\u5b58\u72b6\u6001\u7684\u5546\u54c1\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PmmProdSpuEdit_29", (String)"scm-pmm-formplugin", (Object[])new Object[]{index});
                    this.getView().showTipNotification(msg);
                    return Boolean.TRUE;
                }
            }
            if (null != this.getView().getParentView()) {
                long id = this.getView().getParentView().getModel().getDataEntity(true).getLong("id");
                if (goodsIds.contains(id)) {
                    goodsIds.remove(id);
                    this.getPageCache().put("deletegoodIds", SerializationUtils.toJsonString(goodsIds));
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("deletecurgoods", (IFormPlugin)this);
                    String confirmTip = ResManager.loadKDString((String)"\u5220\u9664\u5f53\u524d\u5546\u54c1\u5bf9\u5e94\u884c\uff0c\u5c06\u89e3\u9664\u5f53\u524d\u5546\u54c1\u591a\u89c4\u683c\u5c5e\u6027\uff0c\u4e0d\u5173\u8054SPU\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PmmProdSpuEdit_46", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                    this.getView().showConfirm(confirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
                    return Boolean.TRUE;
                }
                if (goodsIds.size() > 0) {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("ishasright", String.valueOf(true));
                    option.setVariableValue("isStrict", String.valueOf(false));
                    OperationServiceHelper.executeOperate((String)"delete", (String)"pmm_prodmanage", (Object[])goodsIds.toArray(), (OperateOption)option);
                }
            }
        } else {
            ArrayList<String> atrVal = new ArrayList<String>(selectRows.length);
            for (int i : selectRows) {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("spuskumapentry", i);
                String confirmstatus = entryRowEntity.getString("confirmstatus");
                if (!"B".equals(confirmstatus) && !"A".equals(confirmstatus)) continue;
                atrVal.add(String.valueOf(entryRowEntity.getPkValue()));
                break;
            }
            if (!CollectionUtils.isEmpty(atrVal)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u884c\u5f85\u786e\u8ba4/\u5df2\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PmmProdSpuEdit_18", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private void skuMapInit(BeforeDoOperationEventArgs args) {
        Object specList;
        Object allSaleAtrValList = new ArrayList(1024);
        ArrayList<Object> saleAtrValList = new ArrayList<Object>(1024);
        DynamicObjectCollection saleAtrEntry = this.getModel().getEntryEntity("saleattributeentry");
        HashMap atrMap = new HashMap(saleAtrEntry.size());
        for (DynamicObject dynamicObject : saleAtrEntry) {
            DynamicObjectCollection saleAtrValueEntry = dynamicObject.getDynamicObjectCollection("saleatrvalueentry");
            ArrayList list = new ArrayList(saleAtrValueEntry.size());
            list.addAll(saleAtrValueEntry);
            saleAtrValList.add(list);
            String atrId = dynamicObject.getString("saleprodattribute.id");
            List atrValIdList = list.stream().map(m -> m.getDynamicObject("saleprodattributevalue").getPkValue()).collect(Collectors.toList());
            atrMap.put(atrId, atrValIdList);
        }
        for (List list : saleAtrValList) {
            int size = allSaleAtrValList.size();
            if (size == 0) {
                for (DynamicObject specDy : list) {
                    ArrayList specDyList = new ArrayList(list.size());
                    specDyList.add(specDy);
                    allSaleAtrValList.add(specDyList);
                }
                continue;
            }
            ArrayList newAllSaleAtrValList = new ArrayList(1024);
            for (int i = 0; i < size; ++i) {
                for (DynamicObject specDy : list) {
                    specList = new ArrayList<DynamicObject>((Collection)allSaleAtrValList.get(i));
                    specList.add(specDy);
                    newAllSaleAtrValList.add(specList);
                }
            }
            allSaleAtrValList = newAllSaleAtrValList;
        }
        int size = allSaleAtrValList.size();
        if (size == 0) {
            this.getModel().deleteEntryData("spuskumapentry");
            return;
        }
        ArrayList<List> arrayList = new ArrayList<List>();
        DynamicObjectCollection spuSkuMapCol = this.getModel().getEntryEntity("spuskumapentry");
        for (DynamicObject entry : spuSkuMapCol) {
            DynamicObjectCollection spuAtrDetailEntry = entry.getDynamicObjectCollection("spuatrdetailentry");
            List collect = spuAtrDetailEntry.stream().map(m -> m.getDynamicObject("saleprodattributevalueid").getPkValue()).collect(Collectors.toList());
            specList = allSaleAtrValList.iterator();
            while (specList.hasNext()) {
                List collect2;
                List list = (List)specList.next();
                if (CollectionUtils.isEmpty((Collection)list) || !(collect2 = list.stream().map(m -> m.getDynamicObject("saleprodattributevalue").getPkValue()).collect(Collectors.toList())).toString().equals(collect.toString())) continue;
                arrayList.add(list);
            }
        }
        allSaleAtrValList.removeAll(arrayList);
        size = allSaleAtrValList.size();
        if (size > 0) {
            int[] spuSkuMapRowIds = this.getModel().batchCreateNewEntryRow("spuskumapentry", size);
            StringBuilder mapName = new StringBuilder();
            StringBuilder mapids = new StringBuilder();
            for (int i = 0; i < spuSkuMapRowIds.length; ++i) {
                List skuMapList = (List)allSaleAtrValList.get(i);
                mapName.setLength(0);
                mapids.setLength(0);
                mapids.append("[");
                this.getModel().setEntryCurrentRowIndex("spuskumapentry", spuSkuMapRowIds[i]);
                this.getModel().deleteEntryData("spuatrdetailentry");
                int[] spuAtrdtlRowIds = this.getModel().batchCreateNewEntryRow("spuatrdetailentry", skuMapList.size());
                for (int j = 0; j < spuAtrdtlRowIds.length; ++j) {
                    Object saleAtrValueId = null;
                    String attributId = null;
                    DynamicObject detailValueRow = (DynamicObject)skuMapList.get(j);
                    if (detailValueRow != null && detailValueRow.getDynamicObject("saleprodattributevalue") != null) {
                        saleAtrValueId = detailValueRow.getDynamicObject("saleprodattributevalue").getPkValue();
                        mapName.append(detailValueRow.getDynamicObject("saleprodattributevalue").getString("name")).append('+');
                        for (Map.Entry entry : atrMap.entrySet()) {
                            String atrId = (String)entry.getKey();
                            List atrValList = (List)entry.getValue();
                            if (!atrValList.contains(detailValueRow.getDynamicObject("saleprodattributevalue").getPkValue())) continue;
                            attributId = atrId;
                        }
                        this.getModel().setValue("saleprodattributeid", attributId, spuAtrdtlRowIds[j]);
                        mapids.append("{\"key\":").append((Object)attributId).append(",").append("\"value\":").append(saleAtrValueId).append("}").append(",");
                    }
                    this.getModel().setValue("saleprodattributevalueid", saleAtrValueId, spuAtrdtlRowIds[j]);
                }
                mapName.setLength(mapName.lastIndexOf("+"));
                mapids.setLength(mapids.lastIndexOf(","));
                mapids.append("]");
                this.getModel().setValue("atrvaluename", (Object)mapName.toString(), spuSkuMapRowIds[i]);
                this.getModel().setValue("spumapids", (Object)mapids.toString(), spuSkuMapRowIds[i]);
                if ("2".equals(this.getModel().getValue("origin"))) {
                    this.getModel().setValue("entryresult", (Object)"1");
                }
                this.initSpuSkuMapEntryByProd();
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u4ee5\u751f\u6210\u7684\u89c4\u683c\u503c\u7ec4\u5408\u3002", (String)"PmmProdSpuEdit_6", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void initSpuSkuMapEntryByProd() {
        IFormView parentView = this.getView().getParentView();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != parentView && null != customParams.get("goodsspu")) {
            IDataModel prodModel = parentView.getModel();
            DynamicObjectCollection spuskumapentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("spuskumapentry");
            IDataModel model = this.getModel();
            boolean isExistGoods = false;
            long goodsId = prodModel.getDataEntity(true).getLong("id");
            DynamicObject curRow = null;
            for (DynamicObject row : spuskumapentry) {
                DynamicObject goods = row.getDynamicObject("goods");
                if (null == goods || goodsId != goods.getLong("id")) continue;
                curRow = row;
                break;
            }
            for (DynamicObject row : spuskumapentry) {
                int index = row.getInt("seq") - 1;
                if (null != model.getValue("goods", index)) {
                    isExistGoods = true;
                    continue;
                }
                Object atrvaluename = this.getModel().getValue("atrvaluename", index);
                model.setValue("skuname", (Object)(this.getModel().getValue("name") + " " + String.valueOf(atrvaluename).replace("+", " ")), index);
                model.setValue("taxprice", prodModel.getValue("taxprice"), index);
                model.setValue("taxrateid", prodModel.getValue("taxrateid"), index);
                model.setValue("price", prodModel.getValue("price"), index);
                model.setValue("curr", prodModel.getValue("curr"), index);
                model.setValue("taxtype", prodModel.getValue("taxtype"), index);
                if (null != curRow) {
                    model.setValue("thumbnail", (Object)curRow.getString("thumbnail"), index);
                    model.setValue("picture1", (Object)curRow.getString("picture1"), index);
                    model.setValue("picture2", (Object)curRow.getString("picture2"), index);
                    model.setValue("picture3", (Object)curRow.getString("picture3"), index);
                    model.setValue("picture4", (Object)curRow.getString("picture4"), index);
                    model.setValue("content", (Object)curRow.getString("picture4"), index);
                    model.setValue("content_tag", (Object)curRow.getString("content_tag"), index);
                    model.setValue("specification", (Object)curRow.getString("specification"), index);
                    model.setValue("specification_tag", (Object)curRow.getString("specification_tag"), index);
                    model.setValue("packinglist", (Object)curRow.getString("packinglist"), index);
                    model.setValue("guarantee", (Object)curRow.getString("guarantee"), index);
                    continue;
                }
                model.setValue("thumbnail", prodModel.getValue("thumbnail"), index);
                model.setValue("picture1", prodModel.getValue("picture1"), index);
                model.setValue("picture2", prodModel.getValue("picture2"), index);
                model.setValue("picture3", prodModel.getValue("picture3"), index);
                model.setValue("picture4", prodModel.getValue("picture4"), index);
                RichTextEditor content = (RichTextEditor)this.getView().getParentView().getControl("richtexteditorap");
                RichTextEditor specification = (RichTextEditor)this.getView().getParentView().getControl("richtexteditorap1");
                Object packinglist = prodModel.getValue("packinglist");
                Object guarantee = prodModel.getValue("guarantee");
                model.setValue("content", (Object)content.getText(), index);
                model.setValue("content_tag", (Object)content.getText(), index);
                model.setValue("specification", (Object)specification.getText(), index);
                model.setValue("specification_tag", (Object)specification.getText(), index);
                model.setValue("packinglist", packinglist, index);
                model.setValue("guarantee", guarantee, index);
            }
            if (!isExistGoods && spuskumapentry.size() > 0) {
                DynamicObject dataEntity = prodModel.getDataEntity(true);
                if (0L != prodModel.getDataEntity(true).getLong("id")) {
                    model.setValue("goods", (Object)prodModel.getDataEntity(true), 0);
                }
                if (!ObjectUtils.isEmpty((Object)prodModel.getValue("number"))) {
                    model.setValue("skunumber", prodModel.getValue("number"), 0);
                }
                if (!"A".equals(dataEntity.getString("status"))) {
                    EntryGrid saleAtrEntryGrid = (EntryGrid)this.getControl("spuskumapentry");
                    saleAtrEntryGrid.setRowLock(Boolean.TRUE.booleanValue(), new int[]{0});
                }
            }
        }
    }

    private boolean dataCheck() {
        OperationResult operationResult;
        DynamicObjectCollection attributeCol = this.getModel().getEntryEntity("saleattributeentry");
        if (attributeCol == null || attributeCol.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u89c4\u683c", (String)"PmmProdSpuEdit_19", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("goodsspu") && null != this.getView().getParentView()) {
            IDataModel skuModel = this.getView().getParentView().getModel();
            DynamicObject skuDataEntity = skuModel.getDataEntity();
            String name = skuDataEntity.getString("name");
            if (StringUtils.isEmpty((CharSequence)name)) {
                this.getView().getParentView().getPageCache().put("mulmodelcache", "true");
                skuModel.setValue("mulmodel", (Object)false);
                String msg = ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u57fa\u672c\u4fe1\u606f\uff1a\u5546\u54c1\u540d\u79f0\u3002", (String)"PmmProdSpuEdit_51", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                return false;
            }
            DynamicObject supplier = skuDataEntity.getDynamicObject("supplier");
            if (null == supplier) {
                this.getView().getParentView().getPageCache().put("mulmodelcache", "true");
                skuModel.setValue("mulmodel", (Object)false);
                String msg = ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u57fa\u672c\u4fe1\u606f\uff1a\u6240\u5c5e\u5546\u5bb6\u3002", (String)"PmmProdSpuEdit_52", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                return false;
            }
            DynamicObject createorg = skuDataEntity.getDynamicObject("createorg");
            if (null == createorg) {
                this.getView().getParentView().getPageCache().put("mulmodelcache", "true");
                skuModel.setValue("mulmodel", (Object)false);
                String msg = ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u57fa\u672c\u4fe1\u606f\uff1a\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"PmmProdSpuEdit_53", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(msg);
                return false;
            }
        }
        for (int i = 0; i < attributeCol.size(); ++i) {
            String saleprodattributetext = ((DynamicObject)attributeCol.get(i)).getString("saleprodattributetext").trim();
            if (StringUtils.isEmpty((CharSequence)saleprodattributetext.trim())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u89c4\u683c\u540d\u79f0\u4e3a\u7a7a\u3002", (String)"PmmProdSpuEdit_41", (String)"scm-pmm-formplugin", (Object[])new Object[]{i + 1}));
                return false;
            }
            DynamicObjectCollection subRowObjs = ((DynamicObject)attributeCol.get(i)).getDynamicObjectCollection("saleatrvalueentry");
            if (subRowObjs == null || subRowObjs.size() == 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u8bf7\u5148\u6dfb\u89c4\u683c\u503c\u3002", (String)"PmmProdSpuEdit_21", (String)"scm-pmm-formplugin", (Object[])new Object[0]), saleprodattributetext));
                return false;
            }
            for (int j = 0; j < subRowObjs.size(); ++j) {
                String saleprodattrvaluetext = ((DynamicObject)subRowObjs.get(j)).getString("saleprodattrvaluetext").trim();
                if (!StringUtils.isEmpty((CharSequence)saleprodattrvaluetext.trim())) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u89c4\u683c\u503c\u4e3a\u7a7a\u3002", (String)"PmmProdSpuEdit_22", (String)"scm-pmm-formplugin", (Object[])new Object[]{j + 1}));
                return false;
            }
        }
        OperateOption option = OperateOption.create();
        if (null != customParams.get("goodsspu") || 0L != this.getModel().getDataEntity(true).getLong("id")) {
            option.setVariableValue("isshowmessage", String.valueOf(Boolean.FALSE));
        }
        if (!(operationResult = this.getView().invokeOperation("save", option)).isSuccess()) {
            String errorInfoDetails;
            if (null != customParams.get("goodsspu") && (errorInfoDetails = ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo())).length() > 0) {
                String msg = ResManager.loadKDString((String)"\u81ea\u52a8\u751f\u6210\u5931\u8d25", (String)"PmmProdSpuEdit_44", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showMessage(msg, errorInfoDetails, MessageTypes.Default);
            }
            return false;
        }
        return true;
    }

    private boolean checkBeforeAudit() {
        if ("0".equals(this.getModel().getValue("enable"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u5ba1\u6838\u3002", (String)"PmmProdSpuEdit_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        EntryGrid spuSkuMapEntry = (EntryGrid)this.getControl("spuskumapentry");
        int[] selectRows = spuSkuMapEntry.getSelectRows();
        if (selectRows.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u52fe\u9009\u5173\u8054SKU\u5206\u5f55\u3002", (String)"PmmProdSpuEdit_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList<String> entryIdList = new ArrayList<String>(selectRows.length);
        StringBuilder sb = new StringBuilder();
        boolean hasMaintain = false;
        for (int i : selectRows) {
            DynamicObject entry = this.getModel().getEntryRowEntity("spuskumapentry", i);
            if (!"A".equals(entry.getString("confirmstatus"))) {
                sb.append(ResManager.loadKDString((String)"{0}\uff1a\u7b2c{1}\u884c\u5206\u5f55\u786e\u8ba4\u72b6\u6001\u4e0d\u662f\u5f85\u786e\u8ba4\uff0c\u4e0d\u80fd\u5ba1\u6279\u3002", (String)"PmmProdSpuEdit_3", (String)"scm-pmm-formplugin", (Object[])new Object[]{this.getModel().getDataEntity().getString("number"), i + 1})).append("\n");
                continue;
            }
            if ("0".equals(entry.getString("entryresult"))) {
                hasMaintain = true;
            }
            String entryId = String.valueOf(entry.getPkValue());
            entryIdList.add(entryId);
        }
        this.getPageCache().put("hasMaintain", String.valueOf(hasMaintain));
        this.getPageCache().put("entryIdList", String.join((CharSequence)",", entryIdList));
        if (sb.length() > 0 && entryIdList.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5ba1\u6838\u5931\u8d25", (String)"PmmProdSpuEdit_4", (String)"scm-pmm-formplugin", (Object[])new Object[0]), String.valueOf(sb), MessageTypes.Default);
            return false;
        }
        if (sb.length() > 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4ec5\u5f85\u786e\u8ba4\u7684\u5206\u5f55\u53ef\u4ee5\u5ba1\u6838\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PmmProdSpuEdit_5", (String)"scm-pmm-formplugin", (Object[])new Object[0]), String.valueOf(sb), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("auditCfm"));
            return false;
        }
        return true;
    }

    private void auditResult() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String hasMaintain = this.getPageCache().get("hasMaintain");
        ArrayList entryIds = StringConversionUtil.conversion((String)this.getPageCache().get("entryIdList"));
        String billid = String.valueOf(this.getModel().getDataEntity().getPkValue());
        paramMap.put("ids", billid);
        paramMap.put("entryIds", String.join((CharSequence)",", entryIds));
        if (!Boolean.parseBoolean(hasMaintain)) {
            this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)"pmm_spuauditcfm", paramMap, (CloseCallBack)new CloseCallBack(this.getPluginName(), "confirmActionId"), (ShowType)ShowType.Modal));
        } else {
            this.updateConfirmStatus();
        }
    }

    private void updateConfirmStatus() {
        DynamicObject[] prods;
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        EntryGrid spuSkuMapEntry = (EntryGrid)this.getControl("spuskumapentry");
        int[] select = spuSkuMapEntry.getSelectRows();
        HashSet<Integer> selectRows = new HashSet<Integer>(select.length);
        for (int selectRow : select) {
            selectRows.add(selectRow);
        }
        DynamicObjectCollection spuskumapentry = dynamicObject.getDynamicObjectCollection("spuskumapentry");
        HashSet<Long> goodsIds = new HashSet<Long>(spuskumapentry.size());
        for (int index = 0; index < spuskumapentry.size(); ++index) {
            DynamicObject entry = (DynamicObject)spuskumapentry.get(index);
            if (selectRows.contains(index) && "A".equals(entry.getString("confirmstatus"))) {
                if ("1".equals(entry.getString("entryresult"))) {
                    entry.set("confirmstatus", (Object)"B");
                    goodsIds.add(entry.getLong("goods_id"));
                    continue;
                }
                entry.set("confirmstatus", (Object)"D");
                continue;
            }
            if (!"A".equals(entry.getString("confirmstatus"))) continue;
            entry.set("entryresult", (Object)" ");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
        this.getView().updateView();
        QFilter idFilter = new QFilter("id", "in", goodsIds);
        for (DynamicObject prod : prods = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)"id,spunumber", (QFilter[])idFilter.toArray())) {
            prod.set("spunumber", (Object)dynamicObject.getString("number"));
        }
        SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])prods);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5ba1\u6279\u6210\u529f\u3002", (String)"PmmProdSpuEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        EntryGrid grid;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("auditCfm".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.auditResult();
        }
        if (StringUtils.equals((CharSequence)DELETEENTRY_SALEVAL, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.deleteAtrVal();
            grid = (EntryGrid)this.getView().getControl("saleatrvalueentry");
            this.getModel().deleteEntryRows("saleatrvalueentry", grid.getSelectRows());
        }
        if (StringUtils.equals((CharSequence)NEWENTRY_SALEATR, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getModel().deleteEntryData("spuskumapentry");
            this.getView().invokeOperation(NEWENTRY_SALEATR);
        }
        if (StringUtils.equals((CharSequence)NEWENTRY, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getModel().deleteEntryData("baseattributeentry");
            this.getView().invokeOperation(NEWENTRY);
        }
        if (StringUtils.equals((CharSequence)DELETEENTRY_SALEATR, (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            grid = (EntryGrid)this.getView().getControl("saleattributeentry");
            this.getModel().deleteEntryRows("saleattributeentry", grid.getSelectRows());
            this.getModel().deleteEntryData("spuskumapentry");
        }
        if (StringUtils.equals((CharSequence)"prodattributetext", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            this.doProdAttributeTextConfirmBack(messageBoxClosedEvent);
        }
        if (StringUtils.equals((CharSequence)"prodattributevaluetext", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            this.doProdAttributeValueTextConfirmBack(messageBoxClosedEvent);
        }
        if (StringUtils.equals((CharSequence)"saleprodattributetext", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            this.doSaleProdAttributeTextConfirmBack(messageBoxClosedEvent);
        }
        if (StringUtils.equals((CharSequence)"saleprodattrvaluetext", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            this.doSaleProdAttrvalTextConfirmBack(messageBoxClosedEvent);
        }
        if (StringUtils.equals((CharSequence)"deletecurgoods", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            this.doDeleteCurrGoodsConfirmBack(messageBoxClosedEvent);
        }
        if (StringUtils.equals((CharSequence)"supplier", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            this.doSupplierConfirmBack(messageBoxClosedEvent);
        }
    }

    private void doSupplierConfirmBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.deleteSpuMapBySupplierChange();
        } else {
            String oldsupplier = this.getPageCache().get("oldsupplier");
            this.getPageCache().put("ignoretextchange", "true");
            if (!StringUtils.isEmpty((CharSequence)oldsupplier)) {
                this.getModel().setValue("supplier", (Object)Long.parseLong(oldsupplier));
            } else {
                this.getModel().setValue("supplier", null);
            }
        }
    }

    private void doDeleteCurrGoodsConfirmBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        Map customParams;
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && null != (customParams = this.getView().getFormShowParameter().getCustomParams()).get("goodsspu")) {
            IDataModel skuModel = this.getView().getParentView().getModel();
            this.getPageCache().put("ignoremsg", "true");
            skuModel.setValue("mulmodel", (Object)false);
            skuModel.setValue("spunumber", null);
            this.getView().sendFormAction(this.getView().getParentView());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{skuModel.getDataEntity(true)});
            EntryGrid spuSkuMapEntry = (EntryGrid)this.getControl("spuskumapentry");
            int[] selectRows = spuSkuMapEntry.getSelectRows();
            DynamicObject skuInfo = this.getView().getParentView().getModel().getDataEntity(true);
            long currGoodsId = skuInfo.getLong("id");
            for (int i : selectRows) {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("spuskumapentry", i);
                if (null == entryRowEntity.getDynamicObject("goods") || currGoodsId != entryRowEntity.getLong("goods.id") || i < 0) continue;
                this.switchGoods(i, false, true);
                break;
            }
            this.getModel().deleteEntryRows("spuskumapentry", selectRows);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
            List goodsIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("deletegoodIds"), List.class);
            if (goodsIds.size() > 0) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("isStrict", String.valueOf(false));
                OperationServiceHelper.executeOperate((String)"delete", (String)"pmm_prodmanage", (Object[])goodsIds.toArray(), (OperateOption)option);
            }
        }
    }

    private void doSaleProdAttrvalTextConfirmBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        int salevalrowIndex = this.getCacheSaleValRowIndex();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("goodsspu")) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.updateSkuEntryBySaleAttrchanage();
            } else if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
                this.deleteAtrVal();
                this.updateSaleProdAttrValDynByText(salevalrowIndex);
            } else {
                this.revertOldValueText("saleprodattrvaluetext", salevalrowIndex);
            }
        } else if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.deleteAtrVal();
            this.updateSaleProdAttrValDynByText(salevalrowIndex);
        } else {
            this.revertOldValueText("saleprodattrvaluetext", salevalrowIndex);
        }
    }

    private void updateSaleProdAttrValDynByText(int rowIndex) {
        int salerowIndex = this.getCacheSaleRowIndex();
        Object newValue = this.getModel().getValue("saleprodattrvaluetext", rowIndex);
        if (!ObjectUtils.isEmpty((Object)newValue) && !StringUtils.isEmpty((CharSequence)String.valueOf(newValue).trim())) {
            DynamicObjectCollection pmmAtrrs;
            QFilter qFilter = new QFilter("name", "=", (Object)String.valueOf(newValue));
            Object prodattributevaluetext = this.getModel().getValue("saleprodattributetext", salerowIndex);
            if (!ObjectUtils.isEmpty((Object)prodattributevaluetext)) {
                qFilter.and(new QFilter("group.name", "=", (Object)String.valueOf(prodattributevaluetext)));
            }
            if ((pmmAtrrs = QueryServiceHelper.query((String)"pmm_prodattributevalue", (String)"id", (QFilter[])qFilter.toArray())).size() > 0) {
                long atrrId = ((DynamicObject)pmmAtrrs.get(0)).getLong("id");
                this.getPageCache().put("ignoretextchange", "true");
                this.getModel().setValue("saleprodattributevalue", (Object)atrrId, rowIndex, salerowIndex);
            }
        }
    }

    private void doSaleProdAttributeTextConfirmBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        int salerowIndex = this.getCacheSaleRowIndex();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getModel().deleteEntryData("spuskumapentry");
            this.getModel().deleteEntryData("saleatrvalueentry");
            this.updateSaleProdAttrDynByText(salerowIndex);
        } else {
            this.revertOldValueText("saleprodattributetext", salerowIndex);
        }
    }

    private void updateSaleProdAttrDynByText(int rowIndex) {
        Object newValue = this.getModel().getValue("saleprodattributetext", rowIndex);
        if (!ObjectUtils.isEmpty((Object)newValue) && !StringUtils.isEmpty((CharSequence)String.valueOf(newValue).trim())) {
            QFilter qFilter = new QFilter("prodattributename.name", "=", (Object)String.valueOf(newValue));
            DynamicObject group = this.getModel().getDataEntity(true).getDynamicObject("group");
            if (null != group) {
                qFilter.and(new QFilter("group.id", "=", (Object)group.getLong("id")));
            }
            qFilter.and(new QFilter("attributetype", "=", (Object)"2"));
            DynamicObjectCollection pmmAtrrs = QueryServiceHelper.query((String)"pmm_prodattribute", (String)"id,prodattributegroup.name", (QFilter[])qFilter.toArray());
            if (pmmAtrrs.size() > 0) {
                long atrrId = ((DynamicObject)pmmAtrrs.get(0)).getLong("id");
                this.getPageCache().put("ignoretextchange", "true");
                this.getModel().setValue("saleprodattribute", (Object)atrrId, rowIndex);
                if (!StringUtils.isEmpty((CharSequence)((DynamicObject)pmmAtrrs.get(0)).getString("prodattributegroup.name"))) {
                    this.getModel().setValue("saleprodattrgrouptext", (Object)((DynamicObject)pmmAtrrs.get(0)).getString("prodattributegroup.name"), rowIndex);
                } else {
                    this.getModel().setValue("saleprodattrgrouptext", null, rowIndex);
                }
            }
        }
    }

    private void doProdAttributeValueTextConfirmBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        int baseIndex = this.getCacheBaseRowIndex();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.updateProAttrValDynByText(baseIndex);
            this.getModel().deleteEntryData("spuskumapentry");
        } else {
            this.revertOldValueText("prodattributevaluetext", baseIndex);
        }
    }

    private void updateProAttrValDynByText(int rowIndex) {
        Object newValue = this.getModel().getValue("prodattributevaluetext", rowIndex);
        Object prodattributetext = this.getModel().getValue("prodattributetext", rowIndex);
        if (!ObjectUtils.isEmpty((Object)newValue) && !StringUtils.isEmpty((CharSequence)String.valueOf(newValue).trim())) {
            DynamicObjectCollection pmmAtrrs;
            QFilter qFilter = new QFilter("name", "=", (Object)String.valueOf(newValue));
            if (!ObjectUtils.isEmpty((Object)prodattributetext) && !StringUtils.isEmpty((CharSequence)String.valueOf(prodattributetext).trim())) {
                qFilter.and(new QFilter("group.name", "=", (Object)String.valueOf(prodattributetext).trim()));
            }
            if ((pmmAtrrs = QueryServiceHelper.query((String)"pmm_prodattributevalue", (String)"id", (QFilter[])qFilter.toArray())).size() > 0) {
                long atrrId = ((DynamicObject)pmmAtrrs.get(0)).getLong("id");
                this.getPageCache().put("ignoretextchange", "true");
                this.getModel().setValue("prodattributevalue", (Object)atrrId, rowIndex);
            }
        }
    }

    private void doProdAttributeTextConfirmBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        int baseIndex = this.getCacheBaseRowIndex();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getModel().deleteEntryData("spuskumapentry");
            this.updateProdAttrDynByText(baseIndex);
        } else {
            this.revertOldValueText("prodattributetext", baseIndex);
        }
    }

    private void updateProdAttrDynByText(int rowIndex) {
        Object prodattributetext = this.getModel().getValue("prodattributetext", rowIndex);
        if (null == prodattributetext || StringUtils.isEmpty((CharSequence)String.valueOf(prodattributetext))) {
            return;
        }
        QFilter qFilter = new QFilter("prodattributename.name", "=", (Object)String.valueOf(prodattributetext));
        DynamicObject group = this.getModel().getDataEntity(true).getDynamicObject("group");
        if (null != group) {
            qFilter.and(new QFilter("group.id", "=", (Object)group.getLong("id")));
        }
        qFilter.and(new QFilter("attributetype", "=", (Object)"1"));
        DynamicObjectCollection pmmAtrrs = QueryServiceHelper.query((String)"pmm_prodattribute", (String)"id,prodattributegroup.name", (QFilter[])qFilter.toArray());
        if (pmmAtrrs.size() > 0) {
            long atrrId = ((DynamicObject)pmmAtrrs.get(0)).getLong("id");
            this.getPageCache().put("ignoretextchange", "true");
            this.getModel().setValue("prodattribute", (Object)atrrId, rowIndex);
            if (!StringUtils.isEmpty((CharSequence)((DynamicObject)pmmAtrrs.get(0)).getString("prodattributegroup.name"))) {
                this.getModel().setValue("prodattributegrouptext", (Object)((DynamicObject)pmmAtrrs.get(0)).getString("prodattributegroup.name"), rowIndex);
            } else {
                this.getModel().setValue("prodattributegrouptext", null, rowIndex);
            }
        }
    }

    private void revertOldValueText(String fieldName, int rowIndex) {
        String oldvaluetext = this.getPageCache().get("oldvaluetext");
        this.getPageCache().put("ignoretextchange", "true");
        if (StringUtils.isEmpty((CharSequence)oldvaluetext)) {
            this.getModel().setValue(fieldName, null, rowIndex);
        } else {
            this.getModel().setValue(fieldName, (Object)oldvaluetext, rowIndex);
        }
    }

    private void updateSkuEntryBySaleAttrchanage() {
        DynamicObject entryRowEntity;
        long atrValueId;
        ArrayList<Long> deleteGoodsIds = new ArrayList<Long>(16);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object goodsspu = customParams.get("goodsspu");
        int salerowIndex = this.getCacheSaleRowIndex();
        int salevalrowIndex = this.getCacheSaleValRowIndex();
        Object newValue = this.getModel().getValue("saleprodattrvaluetext", salevalrowIndex);
        long newAtrrId = 0L;
        if (!ObjectUtils.isEmpty((Object)newValue) && !StringUtils.isEmpty((CharSequence)String.valueOf(newValue).trim())) {
            DynamicObjectCollection pmmAtrrs;
            QFilter qFilter = new QFilter("name", "=", (Object)String.valueOf(newValue));
            Object prodattributevaluetext = this.getModel().getValue("saleprodattributetext", salerowIndex);
            if (!ObjectUtils.isEmpty((Object)prodattributevaluetext)) {
                qFilter.and(new QFilter("group.name", "=", (Object)String.valueOf(prodattributevaluetext)));
            }
            if ((pmmAtrrs = QueryServiceHelper.query((String)"pmm_prodattributevalue", (String)"id", (QFilter[])qFilter.toArray())).size() > 0) {
                newAtrrId = ((DynamicObject)pmmAtrrs.get(0)).getLong("id");
            }
        }
        if ((atrValueId = DynamicObjectUtil.getDynamicObjectPk((DynamicObject)(entryRowEntity = this.getModel().getEntryRowEntity("saleatrvalueentry", salevalrowIndex)), (String)"saleprodattributevalue")) != 0L) {
            ArrayList<Integer> delRow = new ArrayList<Integer>();
            DynamicObjectCollection mapEntry = this.getModel().getEntryEntity("spuskumapentry");
            for (DynamicObject dynamicObject : mapEntry) {
                String mapJson = dynamicObject.getString("spumapids");
                int seq = dynamicObject.getInt("seq");
                if (!mapJson.contains(String.valueOf(atrValueId))) continue;
                delRow.add(seq - 1);
                if (null == dynamicObject.get("goods") || !"A".equals(dynamicObject.getString("goods.status")) || null != newValue && !StringUtils.isEmpty((CharSequence)String.valueOf(newValue).trim())) continue;
                deleteGoodsIds.add(dynamicObject.getLong("goods.id"));
            }
            if (null == newValue || StringUtils.isEmpty((CharSequence)String.valueOf(newValue).trim())) {
                int[] seqs = delRow.stream().mapToInt(Integer::intValue).toArray();
                this.getModel().deleteEntryRows("spuskumapentry", seqs);
            } else {
                if (0L == newAtrrId) {
                    return;
                }
                String attrValueName = String.valueOf(newValue).trim();
                for (Integer seq : delRow) {
                    Object spumapids = this.getModel().getValue("spumapids", seq.intValue());
                    String newSpuMapIds = String.valueOf(spumapids).replace(String.valueOf(atrValueId), String.valueOf(newAtrrId));
                    this.getModel().setValue("spumapids", (Object)newSpuMapIds, seq.intValue());
                    Object atrvaluename = this.getModel().getValue("atrvaluename", seq.intValue());
                    String newAttrValeName = String.valueOf(atrvaluename).replace(entryRowEntity.getString("saleprodattributevalue.name"), String.valueOf(attrValueName));
                    this.getModel().setValue("atrvaluename", (Object)newAttrValeName, seq.intValue());
                    Object skuName = this.getModel().getValue("skuname", seq.intValue());
                    String newSkuName = String.valueOf(skuName).replace(entryRowEntity.getString("saleprodattributevalue.name"), String.valueOf(attrValueName));
                    this.getModel().setValue("skuname", (Object)newSkuName, seq.intValue());
                    DynamicObjectCollection spuatrdetailentry = (DynamicObjectCollection)this.getModel().getValue("spuatrdetailentry", seq.intValue());
                    for (DynamicObject subRow : spuatrdetailentry) {
                        DynamicObject saleprodattributevalueid = subRow.getDynamicObject("saleprodattributevalueid");
                        if (atrValueId != saleprodattributevalueid.getLong("id")) continue;
                        this.getModel().setValue("saleprodattributevalueid_id", (Object)newAtrrId, subRow.getInt("seq") - 1, seq.intValue());
                    }
                }
            }
        }
        if (!ObjectUtils.isEmpty(goodsspu) && null != this.getView().getParentView()) {
            long id = this.getView().getParentView().getModel().getDataEntity(true).getLong("id");
            deleteGoodsIds.remove(id);
            if (deleteGoodsIds.size() > 0) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", String.valueOf(true));
                option.setVariableValue("isStrict", String.valueOf(false));
                OperationServiceHelper.executeOperate((String)"delete", (String)"pmm_prodmanage", (Object[])deleteGoodsIds.toArray(), (OperateOption)option);
            }
        }
        this.getPageCache().put("ignoretextchange", "true");
        if (0L != newAtrrId) {
            this.getModel().setValue("saleprodattributevalue", (Object)newAtrrId, salevalrowIndex, salerowIndex);
        } else {
            this.getModel().setValue("saleprodattributevalue", null, salevalrowIndex, salerowIndex);
        }
        this.getView().sendFormAction(this.getView().getParentView());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "confirmActionId": 
            case "newSku": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "prodattributegrouptext": {
                this.dealBaseAttrGroupCloseCallBack(closedCallBackEvent, "baserowIndex", "baseattributeentry", "prodattributegrouptext");
                break;
            }
            case "prodattributetext": {
                this.dealBaseAttrGroupCloseCallBack(closedCallBackEvent, "baserowIndex", "baseattributeentry", "prodattributetext");
                break;
            }
            case "prodattributevaluetext": {
                this.dealBaseAttrGroupCloseCallBack(closedCallBackEvent, "baserowIndex", "baseattributeentry", "prodattributevaluetext");
                break;
            }
            case "saleprodattributetext": {
                this.dealBaseAttrGroupCloseCallBack(closedCallBackEvent, "salerowIndex", "saleattributeentry", "saleprodattributetext");
                break;
            }
            case "saleprodattrgrouptext": {
                this.dealBaseAttrGroupCloseCallBack(closedCallBackEvent, "salerowIndex", "saleattributeentry", "saleprodattrgrouptext");
                break;
            }
            case "saleprodattrvaluetext": {
                this.dealBaseAttrGroupCloseCallBack(closedCallBackEvent, "salevalrowIndex", "saleatrvalueentry", "saleprodattrvaluetext");
                break;
            }
        }
    }

    private void dealBaseAttrGroupCloseCallBack(ClosedCallBackEvent closedCallBackEvent, String indexCache, String entryKey, String fieldname) {
        if (null != closedCallBackEvent.getReturnData()) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            String baseRowIndex = this.getPageCache().get(indexCache);
            if (StringUtils.isEmpty((CharSequence)baseRowIndex)) {
                baseRowIndex = "0";
            }
            int index = Integer.parseInt(baseRowIndex);
            if (fieldname.equals("prodattributetext") || fieldname.equals("saleprodattributetext")) {
                this.updateField(rows, index, entryKey, fieldname);
            } else {
                this.updateFieldValue(rows, index, entryKey, fieldname);
            }
        }
    }

    private void updateField(ListSelectedRowCollection rows, int index, String entryKey, String fieldname) {
        if (rows.size() > 1) {
            this.getModel().appendEntryRow(entryKey, index, rows.size() - 1);
            HashSet<Long> idSet = new HashSet<Long>();
            HashMap<Object, String> id2ProdAtrNameMap = new HashMap<Object, String>(16);
            for (ListSelectedRow row : rows) {
                idSet.add((Long)row.getPrimaryKeyValue());
            }
            QFilter qFilter = new QFilter("id", "in", idSet);
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"pmm_prodattribute", (String)"id,prodattributename.name", (QFilter[])qFilter.toArray());
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                id2ProdAtrNameMap.put(dynamicObject.get("id"), dynamicObject.getString("prodattributename.name"));
            }
            for (ListSelectedRow row : rows) {
                String name = (String)id2ProdAtrNameMap.get(row.getPrimaryKeyValue());
                this.getModel().setValue(fieldname, (Object)name, index++);
            }
        } else if (rows.size() == 1) {
            QFilter qFilter = new QFilter("id", "=", rows.get(0).getPrimaryKeyValue());
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"pmm_prodattribute", (String)"prodattributename.name", (QFilter[])qFilter.toArray());
            String name = ((DynamicObject)dynamicObjectCollection.get(0)).getString("prodattributename.name");
            this.getModel().setValue(fieldname, (Object)name, index);
        }
    }

    private void updateFieldValue(ListSelectedRowCollection rows, int index, String entryKey, String fieldname) {
        if (rows.size() > 1) {
            this.getModel().appendEntryRow(entryKey, index, rows.size() - 1);
            for (ListSelectedRow row : rows) {
                String name = row.getName();
                this.getModel().setValue(fieldname, (Object)name, index++);
            }
        } else if (rows.size() == 1) {
            String name = rows.get(0).getName();
            this.getModel().setValue(fieldname, (Object)name, index);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey = arg0.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        switch (fieldKey) {
            case "supplier": {
                Set<Long> supIdList = this.getSupplierIds();
                QFilter filter = new QFilter("id", "in", supIdList);
                showParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
            case "prodattribute": {
                this.getAtrFilters(showParameter, "prodattribute");
                break;
            }
            case "prodattributevalue": {
                DynamicObject prodAttribute = (DynamicObject)this.getModel().getValue("prodattribute");
                this.getAtrValFilters(showParameter, arg0, prodAttribute);
                break;
            }
            case "saleprodattribute": {
                this.getAtrFilters(showParameter, "saleprodattribute");
                break;
            }
            case "saleprodattributevalue": {
                DynamicObject prodAtribute = (DynamicObject)this.getModel().getValue("saleprodattribute");
                this.getAtrValFilters(showParameter, arg0, prodAtribute);
                break;
            }
            case "goods": {
                this.getGoodsFilters(showParameter, arg0);
                break;
            }
            case "orgfield": {
                this.showOrgFrom(arg0);
                break;
            }
        }
    }

    private Set<Long> getSupplierIds() {
        QFilter qFilter = new QFilter("mallstatus", "=", (Object)"B");
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection malSups = QueryServiceHelper.query((String)"bd_malsupplier", (String)"id", (QFilter[])qFilter.toArray());
        HashSet<Long> supIds = new HashSet<Long>(16);
        for (DynamicObject row : malSups) {
            supIds.add(row.getLong("id"));
        }
        return supIds;
    }

    private void showOrgFrom(BeforeF7SelectEvent arg0) {
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        List userHasAllPurPermissionOrgs = OrgUtil.getAllPurViewPermissionOrgs((String)"pmm_spu");
        showParameter.getListFilterParameter().getQFilters().clear();
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)userHasAllPurPermissionOrgs));
    }

    private void getGoodsFilters(ListShowParameter showParameter, BeforeF7SelectEvent arg0) {
        DynamicObjectCollection spuskumapentry = this.getModel().getEntryEntity("spuskumapentry");
        List choiceSkuList = spuskumapentry.stream().filter(k -> k.getDynamicObject("goods") != null).map(k -> k.getLong("goods_id")).collect(Collectors.toList());
        Long supplierId = (Long)this.getModel().getValue("supplier_id");
        Long categoryId = (Long)this.getModel().getValue("group_id");
        DynamicObjectCollection baseAtrEntry = this.getModel().getEntryEntity("baseattributeentry");
        List baseAtrValIdList = baseAtrEntry.stream().filter(m -> m.getDynamicObject("prodattributevalue") != null).map(m -> m.getDynamicObject("prodattributevalue").getLong("id")).collect(Collectors.toList());
        int selectRows = arg0.getRow();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("spuskumapentry", selectRows);
        DynamicObjectCollection spuAtrDetailEntry = entryRowEntity.getDynamicObjectCollection("spuatrdetailentry");
        List atrValIds = spuAtrDetailEntry.stream().map(m -> m.getDynamicObject("saleprodattributevalueid").getLong("id")).collect(Collectors.toList());
        ArrayList spuAtrList = new ArrayList(baseAtrValIdList.size() + atrValIds.size());
        spuAtrList.addAll(baseAtrValIdList);
        spuAtrList.addAll(atrValIds);
        QFilter prodFilter = new QFilter("supplier", "=", (Object)supplierId).and(new QFilter("category", "=", (Object)categoryId)).and(new QFilter("id", "not in", choiceSkuList)).and(new QFilter("spunumber", "is null", (Object)" ").or("spunumber", "=", (Object)" ").or("spunumber", "=", this.getModel().getValue("number")));
        HashMap prodIdAndAttrIdsMap = new HashMap();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"ent_prodmanage", (String)"id,prodattributeentry.prodattributevalue prodattributevalue", (QFilter[])new QFilter[]{prodFilter}, (String)"id");
        Object object = null;
        try {
            dataSet.forEach(row -> {
                List attrIds = prodIdAndAttrIdsMap.computeIfAbsent(row.getLong("id"), k -> new ArrayList());
                attrIds.add(row.getLong("prodattributevalue"));
            });
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList<Number> idList = new ArrayList<Number>(prodIdAndAttrIdsMap.size());
        for (Map.Entry entry : prodIdAndAttrIdsMap.entrySet()) {
            Long prodId = (Long)entry.getKey();
            List attrIds = (List)entry.getValue();
            if (!attrIds.containsAll(spuAtrList)) continue;
            idList.add(prodId);
        }
        if (prodIdAndAttrIdsMap.isEmpty()) {
            idList.add(0);
        }
        QFilter filter = new QFilter("id", "in", idList);
        showParameter.setCustomParam("ismergerows", (Object)Boolean.TRUE);
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }

    private void getAtrValFilters(ListShowParameter showParameter, BeforeF7SelectEvent arg0, DynamicObject prodAttribute) {
        if ("true".equals(this.getPageCache().get("hasChecked"))) {
            this.getPageCache().remove("hasChecked");
            arg0.setCancel(true);
            return;
        }
        if (null == prodAttribute) {
            if ("getLookUpList".equals(arg0.getSourceMethod()) || "setItemByNumber".equals(arg0.getSourceMethod())) {
                this.getPageCache().put("hasChecked", "true");
            }
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u89c4\u683c\u540d\u79f0\u201d\uff0c\u518d\u5f55\u5165\u89c4\u683c\u503c\u3002", (String)"PmmProdSpuEdit_33", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            arg0.setCancel(true);
        } else {
            Long prodAttributeClassId = prodAttribute.getLong("prodattributename.id");
            QFilter prodAttributeFilter = new QFilter("group", "=", (Object)prodAttributeClassId).and(new QFilter("enable", "=", (Object)"1"));
            DynamicObjectCollection prodAttributeDyoCol = QueryServiceHelper.query((String)"ent_prodattributevalue", (String)"id", (QFilter[])new QFilter[]{prodAttributeFilter});
            List idList = prodAttributeDyoCol.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
            DynamicObjectCollection saleAtrValEntry = this.getModel().getEntryEntity("saleatrvalueentry");
            QFilter filter = new QFilter("id", "in", idList);
            if (saleAtrValEntry != null) {
                List attrValIdList = saleAtrValEntry.stream().filter(m -> m.getDynamicObject("saleprodattributevalue") != null).map(m -> m.getDynamicObject("saleprodattributevalue").getPkValue()).collect(Collectors.toList());
                filter.and(new QFilter("id", "not in", attrValIdList));
            }
            showParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    private void getAtrFilters(ListShowParameter showParameter, String attrTag) {
        DynamicObjectCollection baseAtrEntry;
        DynamicObject category = (DynamicObject)this.getModel().getValue("group");
        Long categoryId = category != null ? category.getLong("id") : 0L;
        QFilter prodAttributeFilter = new QFilter("group", "=", (Object)categoryId);
        DynamicObjectCollection prodAttributeDyoCol = QueryServiceHelper.query((String)"ent_prodattribute", (String)"id", (QFilter[])new QFilter[]{prodAttributeFilter});
        List idList = prodAttributeDyoCol.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
        List<Object> attrIdList = new ArrayList(16);
        if ("prodattribute".equals(attrTag)) {
            baseAtrEntry = this.getModel().getEntryEntity("baseattributeentry");
            attrIdList = baseAtrEntry.stream().filter(m -> m.getDynamicObject("prodattribute") != null).map(m -> m.getDynamicObject("prodattribute").getPkValue()).collect(Collectors.toList());
        } else {
            baseAtrEntry = this.getModel().getEntryEntity("saleattributeentry");
            attrIdList = baseAtrEntry.stream().filter(m -> m.getDynamicObject("saleprodattribute") != null).map(m -> m.getDynamicObject("saleprodattribute").getPkValue()).collect(Collectors.toList());
        }
        QFilter filter = new QFilter("id", "in", idList).and(new QFilter("id", "not in", attrIdList));
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        DynamicObject info;
        Object prodattribute;
        String fieldName = e.getFieldName();
        int rowIndex = e.getRowIndex();
        if ("skunumber".equals(fieldName) && null != this.getModel().getValue("goods", rowIndex)) {
            DynamicObject goods = (DynamicObject)this.getModel().getValue("goods", rowIndex);
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("pmm_prodmanage");
            showParameter.setPkId((Object)goods.getLong("id"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            HashMap<String, String> paramMap = new HashMap<String, String>(16);
            paramMap.put("source", "spulink");
            showParameter.setCustomParams(paramMap);
            this.getView().showForm((FormShowParameter)showParameter);
        }
        if ("prodattributetext".equals(fieldName)) {
            int cacheBaseRowIndex = this.getCacheBaseRowIndex();
            prodattribute = this.getModel().getValue("prodattribute", cacheBaseRowIndex);
            if (null != prodattribute) {
                info = (DynamicObject)prodattribute;
                this.showBaseF7ByLink("pmm_prodattribute", info.getLong("id"));
            }
        }
        if ("prodattributevaluetext".equals(fieldName)) {
            int cacheBaseRowIndex = this.getCacheBaseRowIndex();
            Object prodattributevalue = this.getModel().getValue("prodattributevalue", cacheBaseRowIndex);
            if (null != prodattributevalue) {
                info = (DynamicObject)prodattributevalue;
                this.showBaseF7ByLink("pmm_prodattributevalue", info.getLong("id"));
            }
        }
        if ("saleprodattributetext".equals(fieldName)) {
            int cacheBaseRowIndex = this.getCacheSaleRowIndex();
            prodattribute = this.getModel().getValue("saleprodattribute", cacheBaseRowIndex);
            if (null != prodattribute) {
                info = (DynamicObject)prodattribute;
                this.showBaseF7ByLink("pmm_prodattribute", info.getLong("id"));
            }
        }
        if ("saleprodattrvaluetext".equals(fieldName)) {
            int cacheBaseRowIndex = this.getCacheSaleValRowIndex();
            Object saleprodattributevalue = this.getModel().getValue("saleprodattributevalue", cacheBaseRowIndex);
            if (null != saleprodattributevalue) {
                info = (DynamicObject)saleprodattributevalue;
                this.showBaseF7ByLink("pmm_prodattributevalue", info.getLong("id"));
            }
        }
    }

    private void showBaseF7ByLink(String formId, long pk) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(formId);
        showParameter.setPkId((Object)pk);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void entryRowClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        int rowIndex = evt.getRow();
        if (rowIndex == -1) {
            return;
        }
        if (StringUtils.equals((CharSequence)"spuskumapentry", (CharSequence)source.getKey())) {
            if (!StringUtils.isEmpty((CharSequence)this.getPageCache().get("rowIndex"))) {
                this.getPageCache().put("lastrowIndex", this.getPageCache().get("rowIndex"));
            } else {
                this.getPageCache().put("lastrowIndex", "0");
            }
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (null != customParams.get("goodsspu")) {
                this.switchGoods(rowIndex, true, false);
            }
            this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
        }
        if (StringUtils.equals((CharSequence)"baseattributeentry", (CharSequence)source.getKey())) {
            this.getPageCache().put("baserowIndex", String.valueOf(rowIndex));
        }
        if (StringUtils.equals((CharSequence)"saleattributeentry", (CharSequence)source.getKey())) {
            this.getPageCache().put("salerowIndex", String.valueOf(rowIndex));
        }
        if (StringUtils.equals((CharSequence)"saleatrvalueentry", (CharSequence)source.getKey())) {
            this.getPageCache().put("salevalrowIndex", String.valueOf(rowIndex));
        }
    }

    private int getCacheBaseRowIndex() {
        String baserowIndex = this.getPageCache().get("baserowIndex");
        if (StringUtils.isEmpty((CharSequence)baserowIndex)) {
            baserowIndex = "0";
        }
        return Integer.parseInt(baserowIndex);
    }

    private int getCacheSaleRowIndex() {
        DynamicObject dataEntity;
        DynamicObjectCollection saleattributeentry;
        String salerowIndex = this.getPageCache().get("salerowIndex");
        if (StringUtils.isEmpty((CharSequence)salerowIndex)) {
            salerowIndex = "0";
        }
        if ((saleattributeentry = (dataEntity = this.getModel().getDataEntity(true)).getDynamicObjectCollection("saleattributeentry")).size() > 0 && saleattributeentry.size() <= Integer.parseInt(salerowIndex)) {
            return saleattributeentry.size() - 1;
        }
        return Integer.parseInt(salerowIndex);
    }

    private int getCacheSaleValRowIndex() {
        String salevalrowIndex = this.getPageCache().get("salevalrowIndex");
        if (StringUtils.isEmpty((CharSequence)salevalrowIndex)) {
            salevalrowIndex = "0";
        }
        return Integer.parseInt(salevalrowIndex);
    }

    private void switchGoods(int rowIndex, boolean isUpdate, boolean isignoreMulmode) {
        String oldIndexStr = this.getPageCache().get("rowIndex");
        if (!StringUtils.isEmpty((CharSequence)oldIndexStr)) {
            if (Integer.parseInt(oldIndexStr) == rowIndex) {
                this.getPageCache().remove("entryRowClick");
                return;
            }
            DynamicObjectCollection spuskumapentry = this.getModel().getDataEntity(true).getDynamicObjectCollection("spuskumapentry");
            if (Integer.parseInt(oldIndexStr) + 1 > spuskumapentry.size()) {
                oldIndexStr = String.valueOf(rowIndex);
            }
        } else {
            oldIndexStr = "0";
            this.getPageCache().put("rowIndex", oldIndexStr);
        }
        IFormView parentView = this.getView().getParentView();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null == parentView || null == customParams.get("goodsspu")) {
            return;
        }
        this.getView().getParentView().updateView("guarantee");
        IDataModel prodModel = this.getView().getParentView().getModel();
        Object mulmodel = prodModel.getValue("mulmodel");
        if (Boolean.parseBoolean(String.valueOf(mulmodel)) || isignoreMulmode) {
            this.getPageCache().put("updateSkuField", "false");
            IDataModel model = this.getModel();
            RichTextEditor content = (RichTextEditor)this.getView().getParentView().getControl("richtexteditorap");
            RichTextEditor specification = (RichTextEditor)this.getView().getParentView().getControl("richtexteditorap1");
            if (isUpdate) {
                Object packinglist = prodModel.getValue("packinglist");
                Object guarantee = prodModel.getValue("guarantee");
                int oldIndex = Integer.parseInt(oldIndexStr);
                model.setValue("content", (Object)content.getText(), oldIndex);
                model.setValue("content_tag", (Object)content.getText(), oldIndex);
                model.setValue("specification", (Object)specification.getText(), oldIndex);
                model.setValue("specification_tag", (Object)specification.getText(), oldIndex);
                model.setValue("packinglist", packinglist, oldIndex);
                model.setValue("guarantee", guarantee, oldIndex);
                model.setValue("thumbnail", prodModel.getValue("thumbnail"), oldIndex);
                model.setValue("picture1", prodModel.getValue("picture1"), oldIndex);
                model.setValue("picture2", prodModel.getValue("picture2"), oldIndex);
                model.setValue("picture3", prodModel.getValue("picture3"), oldIndex);
                model.setValue("picture4", prodModel.getValue("picture4"), oldIndex);
            }
            prodModel.setValue("content", model.getValue("content", rowIndex));
            prodModel.setValue("content_tag", model.getValue("content_tag", rowIndex));
            prodModel.setValue("specification", model.getValue("specification", rowIndex));
            prodModel.setValue("specification_tag", model.getValue("specification_tag", rowIndex));
            prodModel.setValue("packinglist", model.getValue("packinglist", rowIndex));
            prodModel.setValue("guarantee", model.getValue("guarantee", rowIndex));
            prodModel.setValue("thumbnail", model.getValue("thumbnail", rowIndex));
            prodModel.setValue("picture1", model.getValue("picture1", rowIndex));
            prodModel.setValue("picture2", model.getValue("picture2", rowIndex));
            prodModel.setValue("picture3", model.getValue("picture3", rowIndex));
            prodModel.setValue("picture4", model.getValue("picture4", rowIndex));
            if (null != model.getValue("content_tag", rowIndex)) {
                content.setText(String.valueOf(model.getValue("content_tag", rowIndex)));
            }
            if (null != model.getValue("specification_tag", rowIndex)) {
                specification.setText(String.valueOf(model.getValue("specification_tag", rowIndex)));
            }
            if (null != this.getView().getParentView()) {
                if (null != model.getValue("goods")) {
                    DynamicObject goods = (DynamicObject)model.getValue("goods");
                    if ("A".equals(goods.getString("status"))) {
                        this.getView().getParentView().setEnable(Boolean.TRUE, new String[]{"flexpanelap", "pl_bizinfo"});
                    } else {
                        this.getView().getParentView().setEnable(Boolean.FALSE, new String[]{"flexpanelap", "pl_bizinfo"});
                    }
                }
                this.getView().sendFormAction(this.getView().getParentView());
            }
            this.getPageCache().remove("updateSkuField");
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection baseattributeentry = dataEntity.getDynamicObjectCollection("baseattributeentry");
        for (DynamicObject row : baseattributeentry) {
            DynamicObject prodattributevalue;
            int index = row.getInt("seq") - 1;
            DynamicObject prodattribute = row.getDynamicObject("prodattribute");
            if (null != prodattribute) {
                this.getModel().setValue("prodattributetext", (Object)prodattribute.getString("name"), index);
                DynamicObject prodattributegroup = prodattribute.getDynamicObject("prodattributegroup");
                if (null != prodattributegroup) {
                    this.getModel().setValue("prodattributegrouptext", (Object)prodattributegroup.getString("name"), index);
                }
            }
            if (null == (prodattributevalue = row.getDynamicObject("prodattributevalue"))) continue;
            this.getModel().setValue("prodattributevaluetext", (Object)prodattributevalue.getString("name"), index);
        }
        DynamicObjectCollection saleattributeentry = dataEntity.getDynamicObjectCollection("saleattributeentry");
        for (DynamicObject row : saleattributeentry) {
            int index = row.getInt("seq") - 1;
            DynamicObject saleprodattribute = row.getDynamicObject("saleprodattribute");
            if (null != saleprodattribute) {
                this.getModel().setValue("saleprodattributetext", (Object)saleprodattribute.getString("name"), index);
                DynamicObject prodattributegroup = saleprodattribute.getDynamicObject("prodattributegroup");
                if (null != prodattributegroup) {
                    this.getModel().setValue("saleprodattrgrouptext", (Object)prodattributegroup.getString("name"), index);
                }
            }
            DynamicObjectCollection saleatrvalueentry = row.getDynamicObjectCollection("saleatrvalueentry");
            for (DynamicObject subRow : saleatrvalueentry) {
                int subIndex = subRow.getInt("seq") - 1;
                DynamicObject saleprodattributevalue = subRow.getDynamicObject("saleprodattributevalue");
                if (null == saleprodattributevalue) continue;
                this.getModel().setValue("saleprodattrvaluetext", (Object)saleprodattributevalue.getString("name"), subIndex, index);
            }
        }
    }
}

