/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FilterFieldBuildOption;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.util.EmalParamsUtil;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.malcore.enums.MallStatusEnum;
import kd.scm.malcore.enums.SaleStatusEnum;
import kd.scm.pmm.business.service.impl.AcquisitionModeEnum;

public class PmmProductObtainEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String FILTERGRIDAP = "filtergridap";
    private static final String FILTERCONDITION = "filtercondition";
    private static final String PLATFORM = "platform";
    private static final String ACQUISITION_MODE = "acquisition_mode";
    private static final String IDE_LARGERTEXTEDIT = "ide_largertextedit";
    private static final String LARGE_TEXT_VALUE = "largeTextValue";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit goodsEdit = (BasedataEdit)this.getControl("goods");
        goodsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        MulBasedataEdit categoryEdit = (MulBasedataEdit)this.getControl("categorys");
        categoryEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (AcquisitionModeEnum.CUSTOM_FILTER.getVal().equals(this.getModel().getValue(ACQUISITION_MODE))) {
            this.initFilterGrid();
            this.bindFilterGrid();
        }
        this.fillGoodsEntryInfo();
        this.initPlatformComboEdit();
    }

    private void initPlatformComboEdit() {
        ComboEdit platformComb = (ComboEdit)this.getControl(PLATFORM);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(EcPlatformEnum.values().length);
        ArrayList<String> openedMalNos = EmalParamsUtil.getOpenedEmalNumberList();
        if (openedMalNos == null) {
            openedMalNos = new ArrayList<String>();
        }
        openedMalNos.add(EcPlatformEnum.ECPLATFORM_SELF.getVal());
        for (EcPlatformEnum platformEnum : EcPlatformEnum.values()) {
            if (!openedMalNos.contains(platformEnum.getVal())) continue;
            ComboItem comboItem = new ComboItem(new LocaleString(platformEnum.getName()), platformEnum.getVal());
            items.add(comboItem);
        }
        platformComb.setComboItems(items);
    }

    private void bindFilterGrid() {
        String filterConditonJson = (String)this.getModel().getValue(FILTERCONDITION);
        if (StringUtils.isBlank((CharSequence)filterConditonJson)) {
            return;
        }
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditonJson, FilterCondition.class);
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTERGRIDAP);
        filterGrid.SetValue(filterCondition);
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey = arg0.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"goods")) {
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            showParameter.setMultiSelect(true);
            qFilters.clear();
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", this.getModel().getEntryCurrentRowIndex("entryentity"));
            if (entryRowEntity.getString("source").equalsIgnoreCase("pmm_prodmanage")) {
                qFilters.add(new QFilter("protocolentry.prodpool.mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal()).and(new QFilter("source", "=", (Object)"1")));
                qFilters.add(new QFilter("protocolentry.prodpool.salestatus", "=", (Object)SaleStatusEnum.SALE.getVal()).or(new QFilter("protocolentry.prodpool.salestatus", "=", (Object)SaleStatusEnum.PARTSALE.getVal())));
            } else {
                List<Long> malIdList = this.getEcGoodsIdList();
                qFilters.add(new QFilter("id", "in", malIdList));
            }
            DynamicObjectCollection entryentityCol = this.getModel().getEntryEntity("entryentity");
            ArrayList<Long> prodList = new ArrayList<Long>(entryentityCol.size());
            for (DynamicObject dyn : entryentityCol) {
                DynamicObject goods = (DynamicObject)dyn.get("goods");
                if (null == goods) continue;
                prodList.add(goods.getLong("id"));
            }
            qFilters.add(new QFilter("id", "not in", prodList));
            this.setF7OpenStyle(showParameter);
        }
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"categorys")) {
            arg0.addCustomQFilter(new QFilter("level", "=", (Object)3));
            Long standardId = MalOrderUtil.getDefualtStandard((String)String.valueOf(this.getModel().getValue(PLATFORM)));
            if (standardId == 0L) {
                standardId = Long.valueOf("944841720602823680");
            }
            arg0.addCustomQFilter(new QFilter("standard.id", "=", (Object)standardId));
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            showParameter.setCustomParam("cmbstandardlst", (Object)String.valueOf(standardId));
        }
    }

    private void setF7OpenStyle(ListShowParameter showParameter) {
        showParameter.setCustomParam("ismergerows", (Object)true);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("1152px");
        styleCss.setHeight("696px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        HashSet<String> hideFields = new HashSet<String>(8);
        hideFields.add("status");
        hideFields.add("prodmatmappingstatus");
        hideFields.add("protocol.effectdate");
        hideFields.add("protocol.invaliddate");
        showParameter.setCustomParam("hideFields", (Object)SerializationUtils.toJsonString(hideFields));
    }

    private List<Long> getEcGoodsIdList() {
        QFilter filter = new QFilter("mallstatus", "=", (Object)"1");
        DynamicObjectCollection mallGoodsStatusDynCol = QueryServiceHelper.query((String)"pbd_mallgoods_status", (String)"mallgoods.id", (QFilter[])new QFilter[]{filter});
        ArrayList<Long> res = new ArrayList<Long>(mallGoodsStatusDynCol.size());
        for (DynamicObject mallGoodsStatusDyn : mallGoodsStatusDynCol) {
            res.add(mallGoodsStatusDyn.getLong("mallgoods.id"));
        }
        return res;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        int index;
        ChangeData[] changeData;
        if (ACQUISITION_MODE.equals(e.getProperty().getName())) {
            String newValue = (String)e.getChangeSet()[0].getNewValue();
            if (AcquisitionModeEnum.CUSTOM_FILTER.getVal().equals(newValue)) {
                this.initFilterGrid();
            }
        }
        if (PLATFORM.equals(e.getProperty().getName())) {
            this.initFilterGrid();
            this.getModel().beginInit();
            this.getModel().setValue("categorys", null);
            this.getModel().endInit();
            this.getView().updateView("categorys");
        }
        if ("range".equals(e.getProperty().getName())) {
            this.getModel().setValue("limit", e.getChangeSet()[0].getNewValue());
        }
        if ("goods".equals(e.getProperty().getName())) {
            changeData = e.getChangeSet();
            index = -1;
            if (changeData.length > 0) {
                index = changeData[0].getRowIndex();
            }
            DynamicObject goods = (DynamicObject)this.getModel().getValue("goods", index);
            DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (null != goods) {
                String source = this.getModel().getValue("source", index).toString();
                int tempIndex = index;
                while (StringUtils.isEmpty((CharSequence)source)) {
                    source = this.getModel().getValue("source", --tempIndex).toString();
                }
                ((DynamicObject)entryCol.get(index)).set("source", (Object)source);
            }
            this.getView().updateView();
        }
        if ("source".equals(e.getProperty().getName())) {
            changeData = e.getChangeSet();
            index = changeData[0].getRowIndex();
            this.getModel().setValue("goodsname", null, index);
            this.getModel().setValue("picture", null, index);
            this.getModel().setValue("unit", null, index);
            this.getModel().setValue("shopprice", null, index);
            this.getModel().setValue("goodssupplier", null, index);
            this.getModel().setValue("categoryname", null, index);
            this.getView().updateView("entryentity");
        }
    }

    private void fillGoodsEntryInfo() {
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        ArrayList<Long> selfGoodsIds = new ArrayList<Long>(entryCol.size());
        ArrayList<Long> ecGoodsIds = new ArrayList<Long>(entryCol.size());
        for (Object entry : entryCol) {
            Long goodsId = entry.getLong("goods.id");
            String source = entry.getString("source");
            if (!StringUtils.isNotBlank((CharSequence)source)) continue;
            if ("pmm_prodmanage".equals(source)) {
                selfGoodsIds.add(goodsId);
                continue;
            }
            ecGoodsIds.add(goodsId);
        }
        if (!selfGoodsIds.isEmpty()) {
            DynamicObjectCollection selfGoodsEntryCol = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,name,unit.name,supplier.name,thumbnail,shopprice,category.name categoryname", (QFilter[])new QFilter[]{new QFilter("id", "in", selfGoodsIds)});
            for (DynamicObject entry : entryCol) {
                for (DynamicObject selfGoodsEntry : selfGoodsEntryCol) {
                    if (entry.getLong("goods.id") != selfGoodsEntry.getLong("id")) continue;
                    entry.set("goodsname", (Object)selfGoodsEntry.getString("name"));
                    entry.set("unit", (Object)selfGoodsEntry.getString("unit.name"));
                    entry.set("picture", (Object)selfGoodsEntry.getString("thumbnail"));
                    entry.set("shopprice", selfGoodsEntry.get("shopprice"));
                    entry.set("categoryname", selfGoodsEntry.get("categoryname"));
                    entry.set("goodssupplier", (Object)selfGoodsEntry.getString("supplier.name"));
                }
            }
        }
        if (!ecGoodsIds.isEmpty()) {
            DynamicObjectCollection ecGoodsPriceEntryCol = QueryServiceHelper.query((String)"pbd_mallgoods_price", (String)"mallgoods.id id, mallgoods.name name,mallgoods.unitid.name unit.name,mallgoods.mainpic thumbnail,mallgoods.source,price shopprice, mallgoods.group.name categoryname", (QFilter[])new QFilter[]{new QFilter("mallgoods", "in", ecGoodsIds)});
            HashMap<String, String> sourceToSupplierNameMap = new HashMap<String, String>(16);
            for (DynamicObject entry : entryCol) {
                for (DynamicObject ecGoodsEntry : ecGoodsPriceEntryCol) {
                    String source;
                    if (entry.getLong("goods.id") != ecGoodsEntry.getLong("id")) continue;
                    entry.set("goodsname", (Object)ecGoodsEntry.getString("name"));
                    entry.set("unit", (Object)ecGoodsEntry.getString("unit.name"));
                    entry.set("picture", (Object)ecGoodsEntry.getString("thumbnail"));
                    entry.set("shopprice", ecGoodsEntry.get("shopprice"));
                    entry.set("categoryname", ecGoodsEntry.get("categoryname"));
                    String supplierName = (String)sourceToSupplierNameMap.get(ecGoodsEntry.getString("mallgoods.source"));
                    if (StringUtils.isBlank((CharSequence)supplierName) && StringUtils.isNotBlank((CharSequence)(source = ecGoodsEntry.getString("mallgoods.source")))) {
                        supplierName = EcApiUtil.getMalName((String)source);
                        sourceToSupplierNameMap.put(source, supplierName);
                    }
                    entry.set("goodssupplier", (Object)supplierName);
                }
            }
        }
    }

    private void initFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        String entityKey = this.getEntityKey();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityKey);
        if (mainType == null) {
            return;
        }
        FilterFieldBuildOption option = new FilterFieldBuildOption();
        option.setCompatibleProductMode(true);
        List cols = FormTreeBuilder.buildFilterColumns((MainEntityType)mainType, (FilterFieldBuildOption)option);
        HashMap mappingField2EsFieldMap = new HashMap(64);
        QFilter indexentityFilter = new QFilter("indexentity.id", "=", (Object)entityKey);
        try (DataSet esMappingPropDs = QueryServiceHelper.queryDataSet((String)RequestContext.get().getTraceId(), (String)"pbd_esmapping_property", (String)"number,mappingfield", (QFilter[])new QFilter[]{indexentityFilter}, null);){
            esMappingPropDs.forEach(row -> mappingField2EsFieldMap.put(row.getString("mappingfield"), row.getString("number")));
        }
        cols.removeIf(fieldInfo -> !mappingField2EsFieldMap.containsKey(fieldInfo.get("fieldName")));
        filterGrid.setEntityNumber(entityKey);
        filterGrid.setFilterColumns(cols);
        filterGrid.SetValue(new ArrayList());
        this.getView().updateView(FILTERGRIDAP);
    }

    private String getEntityKey() {
        String platform = (String)this.getModel().getValue(PLATFORM);
        if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platform)) {
            return "pmm_prodpool";
        }
        return "pbd_mallgoods_status";
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            this.fillFilterConditon();
        }
        if ("copy".equals(operateKey) && !"1".equals(this.getModel().getValue("type"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65b9\u6848\u7c7b\u578b\u975e\u697c\u5c42\u5c55\u793a\u7684\u65b9\u6848\u4e0d\u80fd\u8fdb\u884c\u590d\u5236\u3002", (String)"PmmProductObtainEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
            args.setCancel(true);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setValue("type", (Object)"1");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("obtain".equals(args.getOperateKey())) {
            OperationResult operationResult = args.getOperationResult();
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId(IDE_LARGERTEXTEDIT);
            fsp.setCustomParam(LARGE_TEXT_VALUE, (Object)operationResult.getMessage());
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        }
    }

    private void fillFilterConditon() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        this.getModel().setValue(FILTERCONDITION, (Object)SerializationUtils.toJsonString((Object)filterCondition));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }
}

