/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scm.common.store.SRMStoreDataTraceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.cal.ICal;
import kd.scm.malcore.domain.LadderPriceInfo;
import kd.scm.pmm.business.model.protocol.ProtocolInfo;
import kd.scm.pmm.business.validator.PmmProtocolValidatorService;
import kd.scm.pmm.common.util.PmmProtocolCalImpl;

public class PmmProtocolEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
TabSelectListener,
HyperLinkClickListener,
RowClickEventListener {
    private static Log log = LogFactory.getLog(PmmProtocolEdit.class);
    private static ICal cal = new PmmProtocolCalImpl();
    private static String KEY_ALL = "A";
    private static String KEY_PART = "B";
    private static String KEY_AREA = "C";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        block39: for (ChangeData changeData : e.getChangeSet()) {
            int rowIndex = changeData.getRowIndex();
            int currentRowIndex = model.getEntryCurrentRowIndex("entryentity1");
            if (rowIndex >= 0 && currentRowIndex != rowIndex) {
                EntryGrid grid = (EntryGrid)this.getControl("entryentity1");
                grid.selectRows(rowIndex, true);
            }
            switch (name) {
                case "partyb": {
                    this.doSupplierChange(model);
                    continue block39;
                }
                case "handlor": {
                    this.doHandlorChange(model);
                    continue block39;
                }
                case "invaliddate": 
                case "effectdate": {
                    this.doDateChange(model, e, name);
                    continue block39;
                }
                case "material": {
                    this.doMaterialChange(model, rowIndex);
                    continue block39;
                }
                case "materialname": {
                    this.doCheckMaterialChange(model, rowIndex);
                    continue block39;
                }
                case "taxrateid": {
                    this.doTaxrateidChange(model, rowIndex);
                    continue block39;
                }
                case "qty": {
                    Object oldValue = changeData.getOldValue();
                    this.doQtyChange(model, rowIndex, "entryentity1", oldValue);
                    continue block39;
                }
                case "taxprice": {
                    this.doTaxpriceChange(model, "entryentity1", rowIndex, e);
                    continue block39;
                }
                case "discounttype": 
                case "dctrate": {
                    this.doDctrateChange(model, "entryentity1", rowIndex, e, name);
                    continue block39;
                }
                case "purmode": {
                    this.doCheckEntryByDifferentareaChangeByPurMode(changeData);
                    continue block39;
                }
                case "exratetable": 
                case "curr": {
                    this.doCurrChange(model);
                    continue block39;
                }
                case "differentarea": {
                    this.doCheckEntryByDifferentareaChange(changeData);
                    continue block39;
                }
                case "priceeffectdate": {
                    this.doPriceEffectDateChange(changeData);
                    continue block39;
                }
                case "priceinvaliddate": {
                    this.doPriceInvalidDateChange(changeData);
                    continue block39;
                }
                case "minorderqty": {
                    this.doMinorderqtyChange(changeData);
                    continue block39;
                }
                case "entrypricetype": {
                    this.doPriceTypeChange(changeData);
                    continue block39;
                }
            }
        }
        this.saveAndRemoveCache();
    }

    private void doPriceTypeChange(ChangeData arg0) {
        Object newValue = arg0.getNewValue();
        int rowIndex = arg0.getRowIndex();
        if ("B".equals(newValue)) {
            this.setTaxpriceByLadprice(rowIndex);
        }
    }

    private void setTaxpriceByLadprice(int rowIndex) {
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity1");
        DynamicObject row = (DynamicObject)entryCol.get(rowIndex);
        DynamicObjectCollection subentryentity = row.getDynamicObjectCollection("subentryentity");
        if (subentryentity.size() > 1) {
            ArrayList<LadderPriceInfo> ladderPriceInfos = new ArrayList<LadderPriceInfo>(1024);
            for (DynamicObject subRow : subentryentity) {
                LadderPriceInfo info = new LadderPriceInfo(subRow.getBigDecimal("qtyfrom"), subRow.getBigDecimal("qtyto"), subRow.getBigDecimal("ladprice"), Long.valueOf(0L));
                ladderPriceInfos.add(info);
            }
            if (ladderPriceInfos.size() > 0) {
                this.getModel().setValue("taxprice", (Object)((LadderPriceInfo)ladderPriceInfos.get(0)).getLadprice(), rowIndex);
            }
        }
    }

    private void doMinorderqtyChange(ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        BigDecimal newMinOrderQty = CommonUtil.getBigDecimalPro((Object)newValue).setScale(0, RoundingMode.FLOOR);
        if (CommonUtil.getBigDecimalPro((Object)newValue).compareTo(CommonUtil.getBigDecimalPro((Object)oldValue)) == 0) {
            return;
        }
        int rowIndex = changeData.getRowIndex();
        IDataModel model = this.getModel();
        BigDecimal qty = CommonUtil.getBigDecimalPro((Object)model.getValue("qty", rowIndex));
        if (qty.compareTo(BigDecimal.ZERO) > 0 && newMinOrderQty.compareTo(BigDecimal.ZERO) > 0 && newMinOrderQty.compareTo(qty) > 0) {
            String msg = ResManager.loadKDString((String)"\u8d77\u8ba2\u91cf\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u6570\u91cf\u3002", (String)"PmmProtocolEdit_25", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            model.setValue("minorderqty", oldValue, rowIndex);
            return;
        }
        model.setValue("minorderqty", (Object)newMinOrderQty, rowIndex);
        DynamicObjectCollection entryCol = model.getDataEntity(true).getDynamicObjectCollection("entryentity1");
        DynamicObject row = (DynamicObject)entryCol.get(rowIndex);
        DynamicObjectCollection subentryentity = row.getDynamicObjectCollection("subentryentity");
        if (subentryentity.size() > 1) {
            DynamicObject subrow = (DynamicObject)subentryentity.get(0);
            if (newMinOrderQty.compareTo(BigDecimal.ZERO) == 0) {
                model.setValue("qtyfrom", (Object)BigDecimal.ZERO, 0, rowIndex);
            } else {
                BigDecimal minqty = new BigDecimal(String.valueOf(newValue)).setScale(0, RoundingMode.FLOOR);
                BigDecimal qtyto = subrow.getBigDecimal("qtyto");
                if (minqty.compareTo(BigDecimal.ZERO) == 0) {
                    model.setValue("qtyfrom", (Object)BigDecimal.ZERO, 0, rowIndex);
                    return;
                }
                if (minqty.compareTo(qtyto) < 0) {
                    model.setValue("qtyfrom", (Object)minqty, 0, rowIndex);
                } else if ("A".equals(model.getValue("entrypricetype"))) {
                    IDataModel entryOperate = this.getModel();
                    entryOperate.deleteEntryData("subentryentity");
                } else {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("minorderqty", (IFormPlugin)this);
                    String confirmTip = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u9636\u68af\u4ef7\uff0c\u4fee\u6539\u8d77\u8ba2\u91cf\u540e\u6e05\u7a7a\u9636\u68af\u4ef7\uff0c\u9700\u91cd\u8bbe\u3002", (String)"PmmProtocolEdit_27", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                    this.getPageCache().put("minorderqty", String.valueOf(oldValue));
                    this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
                    this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                }
            }
        }
    }

    private void doPriceEffectDateChange(ChangeData changeData) {
        Date entryPriceinvaliddate;
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        if (null == newValue) {
            return;
        }
        Object effectdate = this.getModel().getValue("effectdate");
        Object invaliddate = this.getModel().getValue("invaliddate");
        Object priceinvaliddate = this.getModel().getValue("priceinvaliddate", rowIndex);
        if (null != effectdate) {
            Date protocolEffectDate = DateUtil.getDayStart((Date)((Date)effectdate));
            if (protocolEffectDate.after((Date)newValue)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u534f\u8bae\u751f\u6548\u65e5\u671f\u3002", (String)"PmmProtocolEdit_17", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("priceeffectdate", oldValue, rowIndex);
                return;
            }
        } else {
            if (null == this.getPageCache().get("addrow")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u534f\u8bae\u751f\u6548\u65e5\u671f\u3002", (String)"PmmProtocolEdit_20", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            } else {
                this.getPageCache().remove("addrow");
            }
            this.getModel().setValue("priceeffectdate", oldValue, rowIndex);
            return;
        }
        if (invaliddate != null) {
            Date protocolInvaliDate = DateUtil.getEndDate((Date)((Date)invaliddate));
            if (protocolInvaliDate.before((Date)newValue)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u534f\u8bae\u5931\u6548\u65e5\u671f\u3002", (String)"PmmProtocolEdit_18", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("priceeffectdate", oldValue, rowIndex);
                return;
            }
        } else {
            if (null == this.getPageCache().get("addrow")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u534f\u8bae\u5931\u6548\u65e5\u671f\u3002", (String)"PmmProtocolEdit_21", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            } else {
                this.getPageCache().remove("addrow");
            }
            this.getModel().setValue("priceeffectdate", oldValue, rowIndex);
            return;
        }
        if (priceinvaliddate != null && (entryPriceinvaliddate = DateUtil.getEndDate((Date)((Date)priceinvaliddate))).before((Date)newValue)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u4ef7\u683c\u5931\u6548\u65e5\u671f\u3002", (String)"PmmProtocolEdit_19", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("priceeffectdate", oldValue, rowIndex);
        }
    }

    private void doPriceInvalidDateChange(ChangeData changeData) {
        Date entryPriceeffectdate;
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        Object effectdate = this.getModel().getValue("effectdate");
        Object invaliddate = this.getModel().getValue("invaliddate");
        Object priceeffectdate = this.getModel().getValue("priceeffectdate", rowIndex);
        if (null == newValue) {
            return;
        }
        if (null != effectdate) {
            Date protocolEffectDate = DateUtil.getDayStart((Date)((Date)effectdate));
            if (protocolEffectDate.after((Date)newValue)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u534f\u8bae\u751f\u6548\u65e5\u671f\u3002", (String)"PmmProtocolEdit_22", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("priceinvaliddate", oldValue, rowIndex);
                return;
            }
        } else {
            if (null == this.getPageCache().get("addrow")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u534f\u8bae\u751f\u6548\u65e5\u671f\u3002", (String)"PmmProtocolEdit_20", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            } else {
                this.getPageCache().remove("addrow");
            }
            this.getModel().setValue("priceinvaliddate", oldValue, rowIndex);
            return;
        }
        if (invaliddate != null) {
            Date protocolInvaliDate = DateUtil.getEndDate((Date)((Date)invaliddate));
            if (protocolInvaliDate.before((Date)newValue)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u534f\u8bae\u5931\u6548\u65e5\u671f\u3002", (String)"PmmProtocolEdit_23", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("priceinvaliddate", oldValue, rowIndex);
                return;
            }
        } else {
            if (null == this.getPageCache().get("addrow")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u534f\u8bae\u5931\u6548\u65e5\u671f\u3002", (String)"PmmProtocolEdit_21", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("priceinvaliddate", oldValue, rowIndex);
            } else {
                this.getPageCache().remove("addrow");
            }
            this.getModel().setValue("priceeffectdate", oldValue, rowIndex);
            return;
        }
        if (priceeffectdate != null && (entryPriceeffectdate = DateUtil.getDayStart((Date)((Date)priceeffectdate))).after((Date)newValue)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u751f\u6548\u65e5\u671f\u3002", (String)"PmmProtocolEdit_24", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("priceinvaliddate", oldValue, rowIndex);
            return;
        }
    }

    private void doCheckEntryByDifferentareaChangeByPurMode(ChangeData changeData) {
        String oldPurMode;
        IDataModel model = this.getModel();
        if (null != this.getPageCache().get("oldPurMode") && (oldPurMode = this.getPageCache().get("oldPurMode")).equals(model.getValue("purmode"))) {
            this.getPageCache().remove("oldPurMode");
            return;
        }
        this.getPageCache().put("oldPurMode", String.valueOf(changeData.getOldValue()));
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity1");
        boolean isExistData = false;
        for (DynamicObject row : entryCol) {
            if (StringUtils.isEmpty((CharSequence)row.getString("materialname"))) continue;
            isExistData = true;
            break;
        }
        Object differentarea = this.getModel().getValue("differentarea");
        if (isExistData && Boolean.parseBoolean(String.valueOf(differentarea))) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("purmode", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u534f\u8bae\u6e05\u5355\uff0c\u5207\u6362\u91c7\u8d2d\u6a21\u5f0f\u4f1a\u540c\u6b65\u6e05\u9664\u6e05\u5355\uff0c\u8981\u5207\u6362\u5417\uff1f", (String)"PmmProtocolEdit_12", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        } else {
            this.doPurmodeChange(model);
            this.getPageCache().remove("oldPurMode");
            this.getView().setVisible(Boolean.valueOf(!Boolean.parseBoolean(String.valueOf(this.getModel().getValue("differentarea")))), new String[]{"advconap"});
            this.getModel().setValue("differentarea", (Object)Boolean.FALSE);
        }
    }

    private void doCheckEntryByDifferentareaChange(ChangeData changeData) {
        String differentareaVal;
        IDataModel model = this.getModel();
        if (null != this.getPageCache().get("oldPurMode")) {
            this.getPageCache().remove("oldPurMode");
            return;
        }
        if (null != this.getPageCache().get("differentareaVal") && Boolean.parseBoolean(differentareaVal = this.getPageCache().get("differentareaVal")) == Boolean.parseBoolean(String.valueOf(model.getValue("differentarea")))) {
            this.getPageCache().remove("differentareaVal");
            return;
        }
        this.getPageCache().put("differentareaVal", changeData.getNewValue().equals(Boolean.TRUE) ? String.valueOf(Boolean.FALSE) : String.valueOf(Boolean.TRUE));
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity1");
        boolean isExistData = false;
        for (DynamicObject row : entryCol) {
            if (StringUtils.isEmpty((CharSequence)row.getString("materialname"))) continue;
            isExistData = true;
            break;
        }
        if (isExistData) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("differentarea", (IFormPlugin)this);
            String confirmTip = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u534f\u8bae\u6e05\u5355\uff0c\u4fee\u6539\u53c2\u6570\u4f1a\u540c\u6b65\u6e05\u9664\u6e05\u5355\uff0c\u8981\u5207\u6362\u5417\uff1f", (String)"PmmProtocolEdit_11", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
        } else {
            this.getPageCache().remove("differentareaVal");
            this.getModel().deleteEntryData("entryentity");
            this.getModel().deleteEntryData("entryentity1");
            this.getView().setVisible(Boolean.valueOf(!Boolean.parseBoolean(String.valueOf(model.getValue("differentarea")))), new String[]{"advconap"});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (callBackId.equals("differentarea")) {
            if (e.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("entryentity1");
                this.getModel().deleteEntryData("entryentity");
                this.getPageCache().remove("differentareaVal");
            } else {
                this.getModel().setValue("differentarea", (Object)this.getPageCache().get("differentareaVal"));
            }
            this.getView().setVisible(Boolean.valueOf(!Boolean.parseBoolean(String.valueOf(this.getModel().getValue("differentarea")))), new String[]{"advconap"});
        }
        if (callBackId.equals("purmode")) {
            if (e.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("entryentity1");
                this.getModel().deleteEntryData("entryentity");
                this.doPurmodeChange(this.getModel());
                this.getModel().setValue("differentarea", (Object)Boolean.FALSE);
            } else {
                String oldPurMode = this.getPageCache().get("oldPurMode");
                this.getModel().setValue("purmode", (Object)oldPurMode);
            }
            this.getView().setVisible(Boolean.valueOf(!Boolean.parseBoolean(String.valueOf(this.getModel().getValue("differentarea")))), new String[]{"advconap"});
        }
        if (callBackId.equals("minorderqty")) {
            if (e.getResult() == MessageBoxResult.Yes) {
                IDataModel entryOperate = this.getModel();
                entryOperate.deleteEntryData("subentryentity");
            } else {
                String qtyStr = this.getPageCache().get("minorderqty");
                String rowIndex = this.getPageCache().get("rowIndex");
                this.getModel().setValue("minorderqty", (Object)new BigDecimal(qtyStr), Integer.parseInt(rowIndex));
            }
        }
    }

    private void doCurrChange(IDataModel model) {
        if (null != model.getValue("curr")) {
            DynamicObject curr = (DynamicObject)model.getValue("curr");
            if (null == model.getValue("loccurr")) {
                if (null != model.getValue("org")) {
                    DynamicObject org = (DynamicObject)model.getValue("org");
                    String msg = ResManager.loadKDString((String)"{0}\u672a\u7ef4\u62a4\u672c\u4f4d\u5e01\uff0c\u8bf7\u524d\u5f80\u201c\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u8bbe\u7f6e\u201d\u7ef4\u62a4\u3002", (String)"PmmProtocolEdit_6", (String)"scm-pmm-formplugin", (Object[])new Object[]{org.getString("name")});
                    this.getView().showErrorNotification(msg);
                    return;
                }
            } else {
                DynamicObject loccurr = (DynamicObject)model.getValue("loccurr");
                if (curr.getLong("id") == loccurr.getLong("id")) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"exchrate"});
                } else {
                    this.doExrateTable();
                }
            }
        } else {
            this.doExrateTable();
        }
    }

    private void doExrateTable() {
        Object exratetable = this.getModel().getValue("exratetable");
        if (null != exratetable) {
            DynamicObject exratetableDyn = (DynamicObject)exratetable;
            if (exratetableDyn.getBoolean("forbidmodifyrate")) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"exchrate"});
            } else {
                this.getView().setEnable(Boolean.TRUE, new String[]{"exchrate"});
            }
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"exchrate"});
        }
    }

    private void saveAndRemoveCache() {
        BusinessDataServiceHelper.removeCache((DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"ent_protocolentry_bd").getDynamicObjectType());
        BusinessDataServiceHelper.removeCache((DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"ent_priceprotocol_bd").getDynamicObjectType());
        BusinessDataServiceHelper.removeCache((DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"pmm_protocol_bd").getDynamicObjectType());
        BusinessDataServiceHelper.removeCache((DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"pmm_protocolentry_bd").getDynamicObjectType());
    }

    private void doCheckMaterialChange(IDataModel model, int rowIndex) {
        if (null != model.getValue("material", rowIndex)) {
            return;
        }
        Object materialName = model.getValue("materialname", rowIndex);
        DynamicObjectCollection entrys = model.getDataEntity(true).getDynamicObjectCollection("entryentity1");
        IFormView view = this.getView();
        for (DynamicObject row : entrys) {
            String srcMaterialName = row.getString("materialname");
            if (null == materialName || null != row.getDynamicObject("material") || !srcMaterialName.equals(materialName) || rowIndex + 1 == row.getInt("seq")) continue;
            String msg = ResManager.loadKDString((String)"\u5728\u7b2c{0}\u884c\u5b58\u5728\u76f8\u540c\u7684\u4ea7\u54c1\u540d\u79f0\u3002", (String)"PmmProtocolEdit_1", (String)"scm-pmm-formplugin", (Object[])new Object[]{row.getInt("seq")});
            view.showErrorNotification(msg);
            model.setValue("materialname", null);
            break;
        }
    }

    private void doPurmodeChange(IDataModel model) {
        if (null != model.getValue("purmode")) {
            Object purmode = model.getValue("purmode");
            if ("1".equals(purmode)) {
                model.setValue("isgoodvisible", (Object)Boolean.TRUE);
            } else {
                model.setValue("isgoodvisible", (Object)Boolean.FALSE);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operate = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("copy".equals(operate)) {
            this.clearData();
        }
        Object purmode = this.getModel().getValue("purmode");
        Object prosource = this.getModel().getValue("prosource");
        if ("2".equals(prosource) && ("2".equals(purmode) || "3".equals(purmode))) {
            this.setBtnStatusByComn();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        IDataModel model;
        super.beforeDoOperation(e);
        String operateKey = ((AbstractOperate)e.getSource()).getOperateKey();
        if (("save".equals(operateKey) || "submit".equals(operateKey)) && null != (model = this.getModel()).getValue("partyb") && null != model.getValue("effectdate") && null != model.getValue("invaliddate") && null != model.getValue("purmode")) {
            DynamicObject partyb = (DynamicObject)model.getValue("partyb");
            Long partbId = partyb.getLong("id");
            String purmode = (String)model.getValue("purmode");
            DynamicObject dataEntity = model.getDataEntity(true);
            DynamicObjectCollection materialEntry = dataEntity.getDynamicObjectCollection("entryentity1");
            if (materialEntry.size() == 0) {
                return;
            }
            HashMap<Long, DynamicObject> materialMap = new HashMap<Long, DynamicObject>(1024);
            for (DynamicObject row : materialEntry) {
                if (null == row.getDynamicObject("material")) continue;
                Long materialId = row.getDynamicObject("material").getLong("id");
                materialMap.put(materialId, row.getDynamicObject("material"));
            }
            PmmProtocolValidatorService service = new PmmProtocolValidatorService();
            HashSet<Long> supIds = new HashSet<Long>();
            supIds.add(partbId);
            ArrayList protocolInfoList = service.getProtocolList(supIds);
            Map protocolGroupInfos = service.getProtocolGroupInfosByPurMode((List)protocolInfoList);
            boolean differentarea = dataEntity.getBoolean("differentarea");
            if (purmode.equals("1")) {
                this.checkAllOrgProtocol(protocolGroupInfos, e, materialMap);
            } else if (purmode.equals("2") && differentarea) {
                this.checkAreaProtocol(protocolGroupInfos, e, materialMap);
            } else {
                this.checkPartOrgProtocol(protocolGroupInfos, e, materialMap);
            }
        }
        if ("orgentryset".equals(operateKey)) {
            this.showPurOrgEntrySetForm(e);
        }
        if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"setladderprice")) {
            this.setLadderPrice(e);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"entryentity1", (CharSequence)source.getKey())) {
            int row = evt.getRow();
            this.getPageCache().put("row", String.valueOf(row));
        }
    }

    private void setLadderPrice(BeforeDoOperationEventArgs args) {
        DynamicObject row;
        EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity1");
        int[] selectRows = grid.getSelectRows();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entryCol = dataEntity.getDynamicObjectCollection("entryentity1");
        int rowIndex = selectRows[0];
        if (null != this.getPageCache().get("row")) {
            rowIndex = Integer.parseInt(this.getPageCache().get("row"));
        }
        if ("A".equals((row = (DynamicObject)entryCol.get(rowIndex)).getString("entrypricetype"))) {
            String msg = ResManager.loadKDString((String)"\u53ea\u6709\u4ef7\u683c\u7c7b\u578b\u4e3a\u9636\u68af\u4ef7\u624d\u80fd\u8bbe\u7f6e\u9636\u68af\u4ef7\u3002", (String)"PmmProtocolEdit_28", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            args.setCancel(true);
            return;
        }
        BigDecimal minorderqty = row.getBigDecimal("minorderqty");
        if (minorderqty.compareTo(BigDecimal.ZERO) == 0) {
            minorderqty = BigDecimal.ZERO;
        }
        DynamicObjectCollection subEntryRows = row.getDynamicObjectCollection("subentryentity");
        List<Object> ladderPriceInfos = new ArrayList<LadderPriceInfo>(1024);
        for (DynamicObject subrow : subEntryRows) {
            if (subrow.getBigDecimal("ladprice").compareTo(BigDecimal.ZERO) <= 0) continue;
            LadderPriceInfo info = new LadderPriceInfo(subrow.getBigDecimal("qtyfrom"), subrow.getBigDecimal("qtyto"), subrow.getBigDecimal("ladprice"), Long.valueOf(dataEntity.getDynamicObject("curr").getLong("id")));
            ladderPriceInfos.add(info);
        }
        BigDecimal price = row.getBigDecimal("taxprice");
        if (ladderPriceInfos.size() < 2) {
            ladderPriceInfos.clear();
            ladderPriceInfos.add(new LadderPriceInfo(minorderqty, minorderqty.add(BigDecimal.ONE), price, Long.valueOf(dataEntity.getDynamicObject("curr").getLong("id"))));
            ladderPriceInfos.add(new LadderPriceInfo(minorderqty.add(BigDecimal.ONE), BigDecimal.ZERO, price, Long.valueOf(dataEntity.getDynamicObject("curr").getLong("id"))));
        }
        ladderPriceInfos = ladderPriceInfos.stream().sorted(Comparator.comparing(LadderPriceInfo::getQtyfrom)).collect(Collectors.toList());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pbd_ladderprice");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, String> detailParamMap = new HashMap<String, String>();
        detailParamMap.put("ladderPrices", SerializationUtils.toJsonString(ladderPriceInfos));
        Object billstatus = this.getModel().getValue("billstatus");
        boolean differentarea = Boolean.parseBoolean(String.valueOf(this.getModel().getValue("differentarea")));
        if (!differentarea && ("A".equals(billstatus) || this.getModel().getDataEntity().getLong("id") == 0L)) {
            detailParamMap.put("status", "0");
        } else {
            detailParamMap.put("status", "1");
        }
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "setladderprice"));
        showParameter.setCustomParams(detailParamMap);
        this.getView().showForm(showParameter);
    }

    private void checkPartOrgProtocol(Map<String, ArrayList<ProtocolInfo>> protocolGroupInfos, BeforeDoOperationEventArgs e, Map<Long, DynamicObject> materialMap) {
        String content;
        String msg;
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection materialEntrys = dynamicObject.getDynamicObjectCollection("entryentity1");
        HashSet<Long> materialSet = new HashSet<Long>(1024);
        for (DynamicObject row : materialEntrys) {
            if (null == row.getDynamicObject("material")) continue;
            materialSet.add(row.getDynamicObject("material").getLong("id"));
        }
        DynamicObjectCollection orgEntrys = dynamicObject.getDynamicObjectCollection("entryentity");
        HashSet<Long> orgIdSet = new HashSet<Long>(1024);
        HashMap<Long, DynamicObject> orgMap = new HashMap<Long, DynamicObject>(1024);
        for (DynamicObject row : orgEntrys) {
            if (null == row.getDynamicObject("orgname")) continue;
            orgIdSet.add(row.getDynamicObject("orgname").getLong("id"));
            orgMap.put(row.getDynamicObject("orgname").getLong("id"), row.getDynamicObject("orgname"));
        }
        PmmProtocolValidatorService service = new PmmProtocolValidatorService();
        ArrayList protocolInfoAllOrgs = service.filterProtocol(protocolGroupInfos.get(KEY_ALL), dynamicObject);
        ArrayList protocolInfoPartOrgs = service.filterProtocol(protocolGroupInfos.get(KEY_PART), dynamicObject);
        ArrayList protocolInfoAreas = service.filterProtocol(protocolGroupInfos.get(KEY_AREA), dynamicObject);
        boolean isExit = false;
        if (protocolInfoAllOrgs.size() > 0) {
            for (ProtocolInfo info : protocolInfoAllOrgs) {
                Set<Long> diffMaterialIdSet;
                if (materialSet.size() <= 0 || null == info.getMaterialIds() || info.getMaterialIds().size() <= 0 || (diffMaterialIdSet = this.getDiffIdSet(materialSet, info.getMaterialIds())).size() <= 0) continue;
                String msg2 = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5185\u5b58\u5728\u5168\u96c6\u56e2\u5171\u4eab\u4e14\u7269\u6599\u6e05\u5355\u91cd\u590d\u7684\u534f\u8bae\uff08{0}\uff09\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolEdit_13", (String)"scm-pmm-formplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                String content2 = this.getMaterialNumber(diffMaterialIdSet, materialMap);
                this.getView().showMessage(msg2, content2, MessageTypes.Default);
                e.setCancel(true);
                isExit = true;
                break;
            }
            if (isExit) {
                return;
            }
        }
        if (protocolInfoPartOrgs.size() > 0) {
            for (ProtocolInfo info : protocolInfoPartOrgs) {
                Set<Long> diffMaterialIdSet;
                List orgIds = info.getOrgIds();
                Set<Long> diffOrgIdSet = this.getDiffIdSet(orgIdSet, orgIds);
                if (diffOrgIdSet.size() <= 0 || materialSet.size() <= 0 || null == info.getMaterialIds() || info.getMaterialIds().size() <= 0 || (diffMaterialIdSet = this.getDiffIdSet(materialSet, info.getMaterialIds())).size() <= 0) continue;
                msg = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5185\u5b58\u5728\u6309\u7ec4\u7ec7\u9694\u79bb\u53ca\u7269\u6599\u6e05\u5355\u91cd\u590d\u7684\u534f\u8bae\uff08{0}\uff09\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolEdit_8", (String)"scm-pmm-formplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                content = this.getMaterialNumber(diffMaterialIdSet, materialMap);
                this.getView().showMessage(msg, content, MessageTypes.Default);
                e.setCancel(true);
                isExit = true;
                break;
            }
            if (isExit) {
                return;
            }
        }
        if (protocolInfoAreas.size() > 0 && materialSet.size() > 0) {
            List<String> srcOrgId_materialIds = this.getOrgIdMaterialIds(materialSet, orgIdSet);
            for (ProtocolInfo info : protocolInfoAreas) {
                List orgId_materialIds = info.getOrgId_materialIds();
                List<String> diffMaterialOrgId = this.getDiffMaterialOrgId(srcOrgId_materialIds, orgId_materialIds);
                if (diffMaterialOrgId.size() <= 0) continue;
                msg = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5185\u5b58\u5728\u6309\u7ec4\u7ec7\u9694\u79bb\u53ca\u7269\u6599\u6e05\u5355\u91cd\u590d\u7684\u534f\u8bae\uff08{0}\uff09\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolEdit_8", (String)"scm-pmm-formplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                content = this.getOrgMaterialNumber(diffMaterialOrgId, materialMap, orgMap);
                this.getView().showMessage(msg, content, MessageTypes.Default);
                e.setCancel(true);
                break;
            }
        }
    }

    private List<String> getDiffMaterialOrgId(List<String> srcIdList, List<String> tarIdList) {
        ArrayList<String> diffMaterialIds = new ArrayList<String>(1024);
        if (tarIdList == null || tarIdList.size() == 0) {
            return srcIdList;
        }
        for (String key : srcIdList) {
            if (!tarIdList.contains(key)) continue;
            diffMaterialIds.add(key);
        }
        return diffMaterialIds;
    }

    private List<String> getOrgIdMaterialIds(Set<Long> materialSet, Set<Long> orgSet) {
        StringBuilder strBuffer = new StringBuilder();
        ArrayList<String> srcOrgId_materialIds = new ArrayList<String>(1024);
        for (Long materialId : materialSet) {
            for (Long orgId : orgSet) {
                strBuffer.setLength(0);
                strBuffer.append(orgId).append('_').append(materialId);
                srcOrgId_materialIds.add(strBuffer.toString());
            }
        }
        return srcOrgId_materialIds;
    }

    private void checkAreaProtocol(Map<String, ArrayList<ProtocolInfo>> protocolGroupInfos, BeforeDoOperationEventArgs e, Map<Long, DynamicObject> materialMap) {
        String content;
        String msg;
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection materialEntrys = dynamicObject.getDynamicObjectCollection("entryentity1");
        HashSet<Long> materialSet = new HashSet<Long>(1024);
        HashSet<Long> orgSet = new HashSet<Long>(1024);
        HashMap<Long, DynamicObject> orgMap = new HashMap<Long, DynamicObject>(1024);
        ArrayList<String> srcOrgId_materialIds = new ArrayList<String>(1024);
        StringBuilder strBuffer = new StringBuilder();
        for (DynamicObject row : materialEntrys) {
            if (null != row.getDynamicObject("material")) {
                long materialId = row.getDynamicObject("material").getLong("id");
                materialSet.add(row.getDynamicObject("material").getLong("id"));
                strBuffer.setLength(0);
                strBuffer.append(row.getDynamicObject("purorg").getLong("id")).append('_').append(materialId);
                srcOrgId_materialIds.add(strBuffer.toString());
            }
            if (null == row.getDynamicObject("purorg") || 0L == row.getDynamicObject("purorg").getLong("id")) continue;
            orgSet.add(row.getDynamicObject("purorg").getLong("id"));
            orgMap.put(row.getDynamicObject("purorg").getLong("id"), row.getDynamicObject("purorg"));
        }
        PmmProtocolValidatorService service = new PmmProtocolValidatorService();
        ArrayList protocolInfoAllOrgs = service.filterProtocol(protocolGroupInfos.get(KEY_ALL), dynamicObject);
        ArrayList protocolInfoPartOrgs = service.filterProtocol(protocolGroupInfos.get(KEY_PART), dynamicObject);
        ArrayList protocolInfoAreas = service.filterProtocol(protocolGroupInfos.get(KEY_AREA), dynamicObject);
        boolean isExit = false;
        if (protocolInfoAllOrgs.size() > 0) {
            for (ProtocolInfo info : protocolInfoAllOrgs) {
                Set<Long> diffMaterialIdSet;
                if (info.getMaterialIds() == null || info.getMaterialIds().size() <= 0 || (diffMaterialIdSet = this.getDiffIdSet(materialSet, info.getMaterialIds())).size() <= 0) continue;
                msg = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5185\u5b58\u5728\u5168\u96c6\u56e2\u5171\u4eab\u4e14\u7269\u6599\u6e05\u5355\u91cd\u590d\u7684\u534f\u8bae\uff08{0}\uff09\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolEdit_13", (String)"scm-pmm-formplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                content = this.getMaterialNumber(diffMaterialIdSet, materialMap);
                this.getView().showMessage(msg, content, MessageTypes.Default);
                e.setCancel(true);
                isExit = true;
                break;
            }
            if (isExit) {
                return;
            }
        }
        if (protocolInfoPartOrgs.size() > 0) {
            for (ProtocolInfo info : protocolInfoPartOrgs) {
                List<String> tarOrgId_materialIds;
                List<String> diffOrgMaterials;
                Set<Long> diffOrgIdSet = this.getDiffIdSet(orgSet, info.getOrgIds());
                if (diffOrgIdSet.size() <= 0 || null == info.getMaterialIds() || info.getMaterialIds().size() <= 0 || (diffOrgMaterials = this.getDiffMaterialOrgId(srcOrgId_materialIds, tarOrgId_materialIds = this.getOrgIdMaterialIds(new HashSet<Long>(info.getMaterialIds()), new HashSet<Long>(info.getOrgIds())))).size() <= 0) continue;
                String msg2 = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5185\u5b58\u5728\u6309\u7ec4\u7ec7\u9694\u79bb\u53ca\u7269\u6599\u6e05\u5355\u91cd\u590d\u7684\u534f\u8bae\uff08{0}\uff09\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolEdit_8", (String)"scm-pmm-formplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                String content2 = this.getOrgMaterialNumber(diffOrgMaterials, materialMap, orgMap);
                this.getView().showMessage(msg2, content2, MessageTypes.Default);
                e.setCancel(true);
                isExit = true;
                break;
            }
            if (isExit) {
                return;
            }
        }
        if (protocolInfoAreas.size() > 0) {
            for (ProtocolInfo info : protocolInfoAreas) {
                List<String> diffOrgMaterials = this.getDiffMaterialOrgId(srcOrgId_materialIds, info.getOrgId_materialIds());
                if (diffOrgMaterials.size() <= 0) continue;
                msg = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5185\u5b58\u5728\u6309\u7ec4\u7ec7\u9694\u79bb\u53ca\u7269\u6599\u6e05\u5355\u91cd\u590d\u7684\u534f\u8bae\uff08{0}\uff09\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolEdit_8", (String)"scm-pmm-formplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                content = this.getOrgMaterialNumber(diffOrgMaterials, materialMap, orgMap);
                this.getView().showMessage(msg, content, MessageTypes.Default);
                e.setCancel(true);
                break;
            }
        }
    }

    private void checkAllOrgProtocol(Map<String, ArrayList<ProtocolInfo>> protocolGroupInfos, BeforeDoOperationEventArgs e, Map<Long, DynamicObject> materialMap) {
        String content;
        String msg;
        DynamicObject dynamicObject = this.getModel().getDataEntity(true);
        DynamicObjectCollection materialEntrys = dynamicObject.getDynamicObjectCollection("entryentity1");
        HashSet<Long> materialSet = new HashSet<Long>(1024);
        for (DynamicObject row : materialEntrys) {
            if (null == row.getDynamicObject("material")) continue;
            materialSet.add(row.getDynamicObject("material").getLong("id"));
        }
        PmmProtocolValidatorService service = new PmmProtocolValidatorService();
        ArrayList protocolInfoAllOrgs = service.filterProtocol(protocolGroupInfos.get(KEY_ALL), dynamicObject);
        ArrayList protocolInfoPartOrgs = service.filterProtocol(protocolGroupInfos.get(KEY_PART), dynamicObject);
        ArrayList protocolInfoAreas = service.filterProtocol(protocolGroupInfos.get(KEY_AREA), dynamicObject);
        boolean isExit = false;
        if (protocolInfoAllOrgs.size() > 0) {
            for (ProtocolInfo info : protocolInfoAllOrgs) {
                Set<Long> diffMaterialIdSet;
                if (materialSet.size() <= 0 || null == info.getMaterialIds() || info.getMaterialIds().size() <= 0 || (diffMaterialIdSet = this.getDiffIdSet(materialSet, info.getMaterialIds())).size() <= 0) continue;
                msg = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5185\u5b58\u5728\u7269\u6599\u6e05\u5355\u91cd\u590d\u7684\u534f\u8bae\uff08{0}\uff09\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolEdit_7", (String)"scm-pmm-formplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                content = this.getMaterialNumber(diffMaterialIdSet, materialMap);
                this.getView().showMessage(msg, content, MessageTypes.Default);
                e.setCancel(true);
                isExit = true;
                break;
            }
            if (isExit) {
                return;
            }
        }
        if ((protocolInfoPartOrgs.size() > 0 || protocolInfoAreas.size() > 0) && materialSet.size() > 0) {
            Set<Long> diffIdSet;
            for (ProtocolInfo info : protocolInfoPartOrgs) {
                if (null == info.getMaterialIds() || info.getMaterialIds().size() == 0 || (diffIdSet = this.getDiffIdSet(materialSet, info.getMaterialIds())).size() <= 0) continue;
                msg = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5185\u5b58\u5728\u7269\u6599\u6e05\u5355\u91cd\u590d\u7684\u534f\u8bae\uff08{0}\uff09\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolEdit_7", (String)"scm-pmm-formplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                content = this.getMaterialNumber(diffIdSet, materialMap);
                this.getView().showMessage(msg, content, MessageTypes.Default);
                e.setCancel(true);
                isExit = true;
                break;
            }
            if (isExit) {
                return;
            }
            for (ProtocolInfo info : protocolInfoAreas) {
                diffIdSet = this.getDiffIdSet(materialSet, info.getMaterialIds());
                if (diffIdSet.size() <= 0) continue;
                msg = ResManager.loadKDString((String)"\u534f\u8bae\u6709\u6548\u671f\u5185\u5b58\u5728\u7269\u6599\u6e05\u5355\u91cd\u590d\u7684\u534f\u8bae\uff08{0}\uff09\uff0c\u4e0d\u5141\u8bb8\u4ea4\u53c9\u3002", (String)"PmmProtocolEdit_7", (String)"scm-pmm-formplugin", (Object[])new Object[]{info.getProtocolBillNo()});
                content = this.getMaterialNumber(diffIdSet, materialMap);
                this.getView().showMessage(msg, content, MessageTypes.Default);
                e.setCancel(true);
                break;
            }
        }
    }

    private void showPurOrgEntrySetForm(BeforeDoOperationEventArgs e) {
        if (0L == this.getModel().getDataEntity().getLong("id")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u534f\u8bae\u3002", (String)"PmmProtocolEdit_15", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity1");
        HashMap purPlan_rowProsMap = new HashMap(1024);
        if (entryCol.size() > 0) {
            HashMap purPlanOrg_rowProsMap = new HashMap(1024);
            HashSet<String> purPlanIds = new HashSet<String>(1024);
            for (DynamicObject row : entryCol) {
                Map objectMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)row);
                DynamicObjectCollection subEntry = row.getDynamicObjectCollection("subentryentity");
                ArrayList<Map> subRows = new ArrayList<Map>(1024);
                for (DynamicObject subRow : subEntry) {
                    Map subRowMap = DynamicObjectUtil.object2MapByQuery((DynamicObject)subRow);
                    subRows.add(subRowMap);
                }
                String purPlanId = row.getString("purplanid.id");
                String purorgId = row.getString("purorg.id");
                String key = purPlanId + "_" + purorgId;
                List<Map> rowsPros = new ArrayList();
                if (null != purPlanOrg_rowProsMap.get(key)) {
                    rowsPros = (List)purPlanOrg_rowProsMap.get(key);
                }
                objectMap.put("subentryentity", subRows);
                rowsPros.add(objectMap);
                purPlanOrg_rowProsMap.put(key, rowsPros);
                purPlanIds.add(purPlanId);
            }
            for (String purPlanId : purPlanIds) {
                for (Map.Entry map : purPlanOrg_rowProsMap.entrySet()) {
                    if (!((String)map.getKey()).contains(purPlanId)) continue;
                    ArrayList rowsPros = new ArrayList();
                    if (null != purPlan_rowProsMap.get(Long.parseLong(purPlanId))) continue;
                    rowsPros.addAll((Collection)map.getValue());
                    purPlan_rowProsMap.put(Long.parseLong(purPlanId), rowsPros);
                }
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("pmm_purorgentryset");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> detailParamMap = new HashMap<String, Object>();
        DynamicObject info = this.getModel().getDataEntity();
        detailParamMap.put("entrypros", purPlan_rowProsMap);
        detailParamMap.put("orgId", info.getDynamicObject("org").getLong("id"));
        detailParamMap.put("protocolId", info.getPkValue());
        detailParamMap.put("loccurr", info.getDynamicObject("loccurr") == null ? Long.valueOf(0L) : info.getDynamicObject("loccurr").getPkValue());
        detailParamMap.put("curr", info.getDynamicObject("curr") == null ? Long.valueOf(0L) : info.getDynamicObject("curr").getPkValue());
        detailParamMap.put("effectdate", info.getDate("effectdate"));
        detailParamMap.put("invaliddate", info.getDate("invaliddate"));
        String billstatus = this.getModel().getDataEntity().getString("billstatus");
        if (billstatus.equals("B") || billstatus.equals("C")) {
            detailParamMap.put("lock", true);
        } else {
            detailParamMap.put("lock", false);
        }
        showParameter.setCustomParams(detailParamMap);
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "orgentryset"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private String getMaterialNumber(Set<Long> diffMaterialIdSet, Map<Long, DynamicObject> materialMap) {
        StringBuilder stringBuilder = new StringBuilder();
        String msg = ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\uff1a", (String)"PmmProtocolEdit_9", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
        for (Long id : diffMaterialIdSet) {
            if (null == materialMap.get(id)) continue;
            DynamicObject material = materialMap.get(id);
            stringBuilder.append(msg).append(material.getString("number")).append('\n');
        }
        return stringBuilder.toString();
    }

    private String getOrgMaterialNumber(List<String> diffMaterialIdSet, Map<Long, DynamicObject> materialMap, Map<Long, DynamicObject> orgMap) {
        StringBuilder stringBuilder = new StringBuilder();
        String msg = ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\uff1a", (String)"PmmProtocolEdit_9", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
        String orgMsg = ResManager.loadKDString((String)"\u7ec4\u7ec7\u540d\u79f0\uff1a", (String)"PmmProtocolEdit_14", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
        for (String key : diffMaterialIdSet) {
            String[] keyArr = key.split("_");
            Long orgId = Long.parseLong(keyArr[0]);
            Long materialId = Long.parseLong(keyArr[1]);
            if (null == materialMap.get(materialId)) continue;
            DynamicObject material = materialMap.get(materialId);
            DynamicObject org = orgMap.get(orgId);
            stringBuilder.append(msg).append(material.getString("number")).append(' ').append(orgMsg).append(org.getString("name")).append('\n');
        }
        return stringBuilder.toString();
    }

    private Set<Long> getDiffIdSet(Set<Long> srcMaterialIdSet, List<Long> tarMaterials) {
        HashSet<Long> diffMaterialIds = new HashSet<Long>(1024);
        if (null == tarMaterials || tarMaterials.size() == 0) {
            return srcMaterialIdSet;
        }
        for (Long id : srcMaterialIdSet) {
            if (!tarMaterials.contains(id)) continue;
            diffMaterialIds.add(id);
        }
        return diffMaterialIds;
    }

    private void clearData() {
        IDataModel model = this.getModel();
        this.clearSrcData(model);
    }

    private void clearSrcData(IDataModel model) {
        model.setValue("srcbilltype", null);
        model.setValue("srcbillbillno", null);
        model.setValue("srcid", null);
        model.setValue("continueprobillno", null);
        DynamicObjectCollection entry = model.getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (int i = 0; i < entry.size(); ++i) {
            if (null != model.getValue("srcbillentity", i)) {
                model.setValue("srcbillentity", null, i);
            }
            if (null != model.getValue("srcbillid", i)) {
                model.setValue("srcbillid", null, i);
            }
            if (null != model.getValue("srcbillentryid", i)) {
                model.setValue("srcbillentryid", null, i);
            }
            if (null == model.getValue("srcbillentryseq", i)) continue;
            model.setValue("srcbillentryseq", null, i);
        }
    }

    private void doDctrateChange(IDataModel model, String entryKey, int rowIndex, PropertyChangedArgs e, String name) {
        BigDecimal dctrate;
        if ("NULL".equals(model.getValue("discounttype", rowIndex)) || "".equals(model.getValue("discounttype", rowIndex))) {
            model.setValue("dctrate", null, rowIndex);
            model.setValue("dctamount", null, rowIndex);
        }
        if ("A".equals(model.getValue("discounttype", rowIndex)) && (dctrate = new BigDecimal(String.valueOf(model.getValue("dctrate", rowIndex)))).compareTo(new BigDecimal("100")) > 0) {
            String msg = ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u503c\u8303\u56f4[0,100]\u3002", (String)"PmmProtocolEdit_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            model.setValue("dctrate", e.getChangeSet()[0].getOldValue(), rowIndex);
        }
        if ("B".equals(model.getValue("discounttype", rowIndex))) {
            BigDecimal taxprice = new BigDecimal(String.valueOf(model.getValue("taxprice", rowIndex)));
            BigDecimal dctrate2 = new BigDecimal(String.valueOf(model.getValue("dctrate", rowIndex)));
            if (dctrate2.compareTo(taxprice) > 0) {
                String msg = ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PmmProtocolEdit_4", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                model.setValue("dctrate", e.getChangeSet()[0].getOldValue(), rowIndex);
            }
        }
        cal.calEntryDiscountAmount(model, entryKey);
        cal.calEntryTaxAmount(model, entryKey);
        cal.calEntryTax(model, entryKey);
        cal.calEntryAmount(model, entryKey);
    }

    protected int getAmtPrecision(IDataModel datamodel, String entryKey) {
        int amtPrecision = 6;
        Object currency = datamodel.getValue("curr");
        if (null != currency && currency instanceof DynamicObject) {
            DynamicObject curr = (DynamicObject)currency;
            amtPrecision = curr.getInt("amtprecision");
        }
        return amtPrecision;
    }

    protected BigDecimal getEntryBigDecimalValue(IDataModel datamodel, int index, String fieldName) {
        if (StringUtils.equals(null, (CharSequence)fieldName)) {
            return BigDecimal.ZERO;
        }
        Object obj = datamodel.getValue(fieldName, index);
        return null == obj ? BigDecimal.ZERO : (BigDecimal)obj;
    }

    private void doTaxpriceChange(IDataModel model, String entryKey, int rowIndex, PropertyChangedArgs e) {
        if ("B".equals(model.getValue("discounttype", rowIndex))) {
            BigDecimal taxprice = new BigDecimal(String.valueOf(model.getValue("taxprice", rowIndex)));
            BigDecimal dctrate = new BigDecimal(String.valueOf(model.getValue("dctrate", rowIndex)));
            if (dctrate.compareTo(taxprice) > 0) {
                String msg = ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PmmProtocolEdit_4", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                model.setValue("taxprice", e.getChangeSet()[0].getOldValue(), rowIndex);
            }
        }
        this.doTaxpriceCal(model, entryKey);
    }

    private void doTaxpriceCal(IDataModel model, String entryKey) {
        cal.calEntryPriceByTaxPrice(model, entryKey);
        cal.calEntryTaxAmount(model, entryKey);
        cal.calEntryTax(model, entryKey);
        cal.calEntryAmount(model, entryKey);
        cal.calEntryDiscountAmount(model, entryKey);
    }

    private void doQtyChange(IDataModel model, int rowIndex, String entryKey, Object oldValue) {
        if (null != model.getValue("qty", rowIndex)) {
            BigDecimal qty = new BigDecimal(String.valueOf(model.getValue("qty")));
            BigDecimal minorderqty = CommonUtil.getBigDecimalPro((Object)model.getValue("minorderqty", rowIndex));
            if (qty.compareTo(BigDecimal.ZERO) > 0 && minorderqty.compareTo(BigDecimal.ZERO) > 0 && minorderqty.compareTo(qty) > 0) {
                String msg = ResManager.loadKDString((String)"\u6570\u91cf\u5e94\u5927\u4e8e\u7b49\u4e8e\u8d77\u8ba2\u91cf\u3002", (String)"PmmProtocolEdit_26", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                this.getModel().setValue("qty", oldValue, rowIndex);
                return;
            }
            String param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice");
            if ("B".equals(model.getValue("entrypricetype", rowIndex)) && Boolean.parseBoolean(param)) {
                DynamicObjectCollection entryCol = model.getDataEntity(true).getDynamicObjectCollection("entryentity1");
                DynamicObject row = (DynamicObject)entryCol.get(rowIndex);
                DynamicObjectCollection subentryentity = row.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subrow : subentryentity) {
                    BigDecimal qtyfrom = subrow.getBigDecimal("qtyfrom");
                    BigDecimal qtyto = subrow.getBigDecimal("qtyto");
                    BigDecimal ladprice = subrow.getBigDecimal("ladprice");
                    if (qty.compareTo(qtyfrom) < 0 || qty.compareTo(qtyto) >= 0 && qtyto.compareTo(BigDecimal.ZERO) != 0) continue;
                    this.getModel().setValue("taxprice", (Object)ladprice, rowIndex);
                }
            }
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            DynamicObject basicunit = (DynamicObject)model.getValue("baseunit", rowIndex);
            BigDecimal baseQty = BigDecimal.ZERO;
            if (null != material && null != unit && null != basicunit) {
                baseQty = CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)basicunit);
            }
            model.setValue("baseqty", (Object)baseQty, rowIndex);
            cal.calEntryDiscountAmount(model, entryKey);
            cal.calEntryTaxAmount(model, entryKey);
            cal.calEntryTax(model, entryKey);
            cal.calEntryAmount(model, entryKey);
        }
    }

    private void doTaxrateidChange(IDataModel model, int rowIndex) {
        if (null != model.getValue("taxrateid", rowIndex)) {
            DynamicObject taxrateid = (DynamicObject)model.getValue("taxrateid");
            BigDecimal taxrate = taxrateid.getBigDecimal("taxrate");
            model.setValue("taxrate", (Object)taxrate, rowIndex);
        } else {
            model.setValue("taxrate", null, rowIndex);
        }
        String entryKey = "entryentity1";
        cal.calEntryPriceByTaxPrice(model, entryKey);
        cal.calEntryTax(model, entryKey);
        cal.calEntryAmount(model, entryKey);
    }

    private void doMaterialChange(IDataModel model, int rowIndex) {
        if (null != model.getValue("material", rowIndex)) {
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject group = material.getDynamicObject("group");
            DynamicObject baseunit = material.getDynamicObject("baseunit");
            String name = material.getString("name");
            model.setValue("materialname", (Object)name, rowIndex);
            model.setValue("materialgroup", (Object)group, rowIndex);
            model.setValue("baseunit", (Object)baseunit, rowIndex);
            model.setValue("unit", (Object)baseunit, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"materialname", "materialgroup"});
        } else {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"materialname", "materialgroup"});
            model.setValue("materialname", null, rowIndex);
            model.setValue("materialgroup", null, rowIndex);
            model.setValue("baseunit", null, rowIndex);
            model.setValue("unit", null, rowIndex);
            model.setValue("auxpty", null, rowIndex);
        }
    }

    private void doDateChange(IDataModel model, PropertyChangedArgs e, String name) {
        if (null != model.getValue("effectdate") && null != model.getValue("invaliddate")) {
            Date effectdate = (Date)this.getModel().getValue("effectdate");
            Date invaliddate = (Date)this.getModel().getValue("invaliddate");
            if (effectdate.after(invaliddate = DateUtil.string2date((String)DateUtil.getFormatEndDate((Date)invaliddate), (String)"yyyy-MM-dd HH:mm:ss"))) {
                model.setValue(name, e.getChangeSet()[0].getOldValue());
                String msg = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u5931\u6548\u65e5\u671f\u3002", (String)"PmmProtocolEdit_5", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
            }
        }
    }

    private void doHandlorChange(IDataModel model) {
        Object value = model.getValue("handlor");
        if (null != value) {
            DynamicObject user = (DynamicObject)value;
            DynamicObjectCollection entrys = user.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (entry.getBoolean("ispartjob") || null == entry.getDynamicObject("dpt")) continue;
                model.setValue("handledept", (Object)entry.getDynamicObject("dpt"));
                break;
            }
            this.getView().setEnable(Boolean.TRUE, new String[]{"handledept"});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"handledept"});
            model.setValue("handledept", null);
        }
    }

    private void doSupplierChange(IDataModel model) {
        if (null != model.getValue("partyb")) {
            DynamicObject partyb = (DynamicObject)model.getValue("partyb");
            boolean issuppcolla = partyb.getBoolean("issuppcolla");
            model.setValue("issrm", (Object)issuppcolla);
            model.setValue("bizpartner_id", (Object)BizPartnerUtil.getBizPartnerBySupplier((Object)partyb.getPkValue()));
            IFormView view = this.getView();
            if (issuppcolla) {
                view.setVisible(Boolean.TRUE, new String[]{"issupgood"});
                model.setValue("issupgood", (Object)Boolean.TRUE);
            } else {
                view.setVisible(Boolean.FALSE, new String[]{"issupgood"});
                model.setValue("issupgood", (Object)Boolean.FALSE);
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit handlor = (BasedataEdit)this.getView().getControl("handlor");
        handlor.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit partyb = (BasedataEdit)this.getView().getControl("partyb");
        partyb.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgname = (BasedataEdit)this.getView().getControl("orgname");
        orgname.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit handledept = (BasedataEdit)this.getView().getControl("handledept");
        handledept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit material = (BasedataEdit)this.getView().getControl("material");
        material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addTabSelectListener(this, "tabmain");
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity1");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    protected void addTabSelectListener(TabSelectListener form, String ... tabName) {
        Tab tab = null;
        int len = tabName.length;
        for (int i = 0; i < len; ++i) {
            tab = (Tab)this.getControl(tabName[i]);
            if (tab == null) continue;
            tab.addTabSelectListener(form);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        switch (name) {
            case "handlor": {
                this.doHandlorBeforeF7Select(e, model);
                break;
            }
            case "partyb": {
                this.doPartybBeforeF7Select(e, model);
                break;
            }
            case "orgname": {
                this.doOrgnameBeforeF7Select(e, model);
                break;
            }
            case "handledept": {
                this.doHandledeptBeforeF7Select(e, model);
                break;
            }
            case "material": {
                this.doMaterialBeforeF7Select(e, model);
            }
        }
    }

    private void doMaterialBeforeF7Select(BeforeF7SelectEvent e, IDataModel model) {
        DynamicObjectCollection entrys = model.getDataEntity(true).getDynamicObjectCollection("entryentity1");
        IFormView view = this.getView();
        HashSet<Long> idSet = new HashSet<Long>(1024);
        for (DynamicObject row : entrys) {
            DynamicObject srcMaterial = row.getDynamicObject("material");
            if (null == srcMaterial) continue;
            idSet.add(srcMaterial.getLong("id"));
        }
        if (idSet.size() > 0) {
            ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", idSet));
        }
    }

    private void doHandledeptBeforeF7Select(BeforeF7SelectEvent e, IDataModel model) {
        Object value = model.getValue("handlor");
        if (null != value) {
            DynamicObject user = (DynamicObject)value;
            DynamicObjectCollection entrys = user.getDynamicObjectCollection("entryentity");
            HashSet<Long> deptIdSet = new HashSet<Long>(1024);
            for (DynamicObject entry : entrys) {
                if (null == entry.getDynamicObject("dpt")) continue;
                deptIdSet.add(entry.getDynamicObject("dpt").getLong("id"));
            }
            ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", deptIdSet));
        }
    }

    private void doOrgnameBeforeF7Select(BeforeF7SelectEvent e, IDataModel model) {
        if (this.getAllOrgIDs().size() > 0) {
            ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", this.getAllOrgIDs()));
        }
    }

    private Set<Long> getAllOrgIDs() {
        IDataModel model = this.getModel();
        DynamicObject pricePro = model.getDataEntity(true);
        DynamicObjectCollection entrys = pricePro.getDynamicObjectCollection("entryentity");
        HashSet<Long> orgIds = new HashSet<Long>(1024);
        for (DynamicObject entry : entrys) {
            DynamicObject org = entry.getDynamicObject("orgname");
            if (null == org) continue;
            orgIds.add(org.getLong("id"));
        }
        return orgIds;
    }

    private List<Long> getAllOrgIDsByRowIndex(int index) {
        IDataModel model = this.getModel();
        ArrayList<Long> orgIncludeIds = new ArrayList<Long>(1024);
        if (null == model.getValue("orgname", index)) {
            return orgIncludeIds;
        }
        DynamicObject org = (DynamicObject)model.getValue("orgname", index);
        Object iscontainorg = model.getValue("iscontainorg", index);
        if (Boolean.parseBoolean(String.valueOf(iscontainorg))) {
            orgIncludeIds.add(org.getLong("id"));
            List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"15", orgIncludeIds, (boolean)Boolean.TRUE);
            orgIncludeIds.addAll(allSubordinateOrgs);
        } else {
            orgIncludeIds.add(org.getLong("id"));
        }
        return orgIncludeIds;
    }

    private void doPartybBeforeF7Select(BeforeF7SelectEvent e, IDataModel model) {
    }

    private void updateTabMainHideNavigation(boolean bool) {
        Tab tab;
        if (bool && (tab = (Tab)this.getControl("tabmain")) != null && !"tabcontent".equals(tab.getCurrentTab())) {
            tab.selectTab("tabcontent");
            tab.activeTab("tabcontent");
        }
        HashMap<String, Boolean> propertiesMap = new HashMap<String, Boolean>();
        propertiesMap.put("hideNav", bool);
        this.getView().updateControlMetadata("tabmain", propertiesMap);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object handlor = this.getModel().getValue("handlor");
        if (null == handlor) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"handledept"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"handledept"});
        }
        Object prosource = this.getModel().getValue("prosource");
        if ("2".equals(prosource)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"attachmentpanel"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"attachmentpanel"});
        }
        if ("1".equals(prosource)) {
            if (null != this.getView().getParentView() && null != AppCache.get((String)this.getView().getParentView().getPageId()) && Boolean.parseBoolean((String)AppCache.get((String)this.getView().getParentView().getPageId()).get("continue", String.class)) && AppCache.get((String)this.getView().getParentView().getPageId()).get("option", String.class) == null) {
                String id = String.valueOf(AppCache.get((String)this.getView().getParentView().getPageId()).get("protocolnum", String.class));
                this.clearSrcData(this.getModel());
                this.getModel().setValue("continueprobillno", (Object)Long.parseLong(id));
                AppCache.get((String)this.getView().getParentView().getPageId()).clear();
            }
            if (null != this.getView().getParentView() && String.valueOf(AppCache.get((String)this.getView().getParentView().getPageId()).get("option", String.class)).equals("copy")) {
                this.clearData();
                AppCache.get((String)this.getView().getParentView().getPageId()).clear();
            }
        }
        if (null != this.getModel().getValue("id") && this.getReject() > 0) {
            this.updateTabMainHideNavigation(false);
        } else {
            this.updateTabMainHideNavigation(true);
        }
        IDataModel model = this.getModel();
        if (null != model.getValue("partyb")) {
            boolean issuppcolla = Boolean.parseBoolean(String.valueOf(model.getValue("issrm")));
            IFormView view = this.getView();
            if (issuppcolla) {
                view.setVisible(Boolean.TRUE, new String[]{"issupgood"});
            } else {
                view.setVisible(Boolean.FALSE, new String[]{"issupgood"});
            }
        }
        Object purmode = model.getValue("purmode");
        if ("2".equals(prosource) && ("2".equals(purmode) || "3".equals(purmode))) {
            this.setBtnStatusByComn();
        }
        this.getView().setVisible(Boolean.valueOf(!Boolean.parseBoolean(String.valueOf(this.getModel().getValue("differentarea")))), new String[]{"advconap"});
        String param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice");
        if (Boolean.parseBoolean(param)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"entrypricetype", "ladderprice"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrypricetype", "ladderprice"});
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        if (rowDataEntities.length > 0 && rowDataEntities[0].getDataEntity().getDataEntityType().getName().equals("entryentity1")) {
            DynamicObjectCollection entryentity1;
            DynamicObject row;
            this.getPageCache().put("addrow", "addrow");
            int firstIndex = rowDataEntities[0].getRowIndex();
            Object effectdate = this.getModel().getValue("effectdate");
            Object invaliddate = this.getModel().getValue("invaliddate");
            for (RowDataEntity row2 : rowDataEntities) {
                int rowIndex = row2.getRowIndex();
                this.getModel().setValue("priceeffectdate", effectdate, rowIndex);
                this.getModel().setValue("priceinvaliddate", invaliddate, rowIndex);
            }
            if (firstIndex > 0 && null == (row = (DynamicObject)(entryentity1 = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity1")).get(firstIndex - 1)).get("priceeffectdate") && null == row.get("priceinvaliddate")) {
                this.getModel().setValue("priceeffectdate", effectdate, firstIndex - 1);
                this.getModel().setValue("priceinvaliddate", invaliddate, firstIndex - 1);
            }
        }
    }

    private void setBtnStatusByComn() {
        Object srcid = this.getModel().getValue("srcid");
        QFilter qFilter = new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(srcid)));
        DynamicObjectCollection conmPurcontracts = QueryServiceHelper.query((String)"conm_purcontract", (String)"suitentry.suitorg", (QFilter[])qFilter.toArray());
        HashSet<Long> comnOrgIds = new HashSet<Long>(1024);
        for (DynamicObject row : conmPurcontracts) {
            if (0L == row.getLong("suitentry.suitorg")) continue;
            comnOrgIds.add(row.getLong("suitentry.suitorg"));
        }
        if (comnOrgIds.size() > 0) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"tb_new", "tb_del", "advconap"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"tb_new", "tb_del", "advconap"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        Long orgID;
        Map<String, Long> currencyAndExRateMap;
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        DynamicObject bos_user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
        model.setValue("handlor", (Object)bos_user);
        this.doHandlorChange(this.getModel());
        this.doPurmodeChange(this.getModel());
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null && (currencyAndExRateMap = PmmProtocolEdit.getCurrencyAndExRateTable(orgID = (Long)org.getPkValue())) != null) {
            model.setValue("loccurr", (Object)currencyAndExRateMap.get("baseCurrencyID"));
            model.setValue("curr", (Object)currencyAndExRateMap.get("baseCurrencyID"));
            model.setValue("exratetable", (Object)currencyAndExRateMap.get("exchangeRateTableID"));
        }
    }

    public void afterCopyData(EventObject e) {
        IDataModel model;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        String proSource = (String)this.getModel().getValue("prosource");
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entryentity1");
        if ("1".equals(proSource) && entry.size() > 0) {
            this.getModel().setValue("taxtype", (Object)"1");
            this.doTaxpriceCal(this.getModel(), "entryentity1");
        }
        if (dataEntity.getBoolean("differentarea")) {
            this.doCopysetPurPlan();
            ArrayList<Integer> indexs = new ArrayList<Integer>(1024);
            for (DynamicObject row : entry) {
                if (null != row.getDynamicObject("purplanid")) continue;
                indexs.add(row.getInt("seq") - 1);
            }
            if (indexs.size() > 0) {
                this.getModel().deleteEntryRows("entryentity1", indexs.stream().mapToInt(Integer::intValue).toArray());
            }
        }
        if (null != (model = this.getModel()).getValue("effectdate") && null != model.getValue("invaliddate")) {
            Date invaliddate = (Date)model.getValue("invaliddate");
            model.setValue("effectdate", (Object)DateUtil.addDays((Date)invaliddate, (int)1));
            for (DynamicObject row : entry) {
                this.getModel().setValue("priceeffectdate", null, row.getInt("seq") - 1);
                this.getModel().setValue("priceinvaliddate", null, row.getInt("seq") - 1);
            }
        } else {
            model.setValue("effectdate", null);
        }
        model.setValue("invaliddate", null);
    }

    private void doCopysetPurPlan() {
        List orgIds;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("entryentity1");
        HashSet<Long> purPlanIds = new HashSet<Long>(1024);
        for (DynamicObject row : entry) {
            if (null == row.getDynamicObject("purplanid")) continue;
            purPlanIds.add(row.getDynamicObject("purplanid").getLong("id"));
        }
        QFilter qfilter = new QFilter("id", "in", purPlanIds);
        String selectors = "id,name,entryentity.org";
        DynamicObjectCollection pmm_purchaseplans = QueryServiceHelper.query((String)"pmm_purchaseplan", (String)selectors, (QFilter[])qfilter.toArray());
        HashMap name_orgsMap = new HashMap(1024);
        for (Object row : pmm_purchaseplans) {
            String string = row.getString("name");
            Long orgId = row.getLong("entryentity.org");
            orgIds = new ArrayList<Long>(1024);
            if (null != name_orgsMap.get(string)) {
                orgIds = (List)name_orgsMap.get(string);
            }
            orgIds.add(orgId);
            name_orgsMap.put(string, orgIds);
        }
        ArrayList<DynamicObject> purPlanDyn = new ArrayList<DynamicObject>(1024);
        for (Map.Entry entry2 : name_orgsMap.entrySet()) {
            String name = (String)entry2.getKey();
            orgIds = (List)entry2.getValue();
            DynamicObject purPlan = BusinessDataServiceHelper.newDynamicObject((String)"pmm_purchaseplan");
            purPlan.set("name", (Object)name);
            purPlan.set("enable", (Object)"1");
            DynamicObjectCollection purPlacEntrys = purPlan.getDynamicObjectCollection("entryentity");
            purPlacEntrys.clear();
            for (Long orgId : orgIds) {
                DynamicObject entryInfo = purPlacEntrys.addNew();
                entryInfo.set("org_id", (Object)orgId);
            }
            purPlanDyn.add(purPlan);
        }
        if (purPlanDyn.size() > 0) {
            OperateOption saveOption = OperateOption.create();
            saveOption.setVariableValue("isStrict", "false");
            saveOption.setVariableValue("ishasright", "true");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"pmm_purchaseplan", (DynamicObject[])purPlanDyn.toArray(new DynamicObject[0]), (OperateOption)saveOption);
            if (operationResult.isSuccess()) {
                List successPkIds = operationResult.getSuccessPkIds();
                QFilter qFilter = new QFilter("id", "in", (Object)successPkIds);
                DynamicObjectCollection pmm_purchaseplan = QueryServiceHelper.query((String)"pmm_purchaseplan", (String)"name,id", (QFilter[])qFilter.toArray());
                HashMap<String, Long> name_PurPlanIdMap = new HashMap<String, Long>(1024);
                for (DynamicObject info : pmm_purchaseplan) {
                    name_PurPlanIdMap.put(info.getString("name"), info.getLong("id"));
                }
                for (DynamicObject row : entry) {
                    String name;
                    if (null == row.getDynamicObject("purplanid") || null == name_PurPlanIdMap.get(name = row.getDynamicObject("purplanid").getString("name"))) continue;
                    this.getModel().setValue("purplanid_id", name_PurPlanIdMap.get(name), row.getInt("seq") - 1);
                }
            } else {
                log.error(ExceptionUtil.getErrorInfoDetails((List)operationResult.getAllErrorOrValidateInfo()));
                String msg = ResManager.loadKDString((String)"\u91c7\u4e70\u65b9\u6848\u4fdd\u5b58\u5931\u8d25,\u539f\u56e0\uff1a", (String)"PmmProtocolEdit_16", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                throw new KDBizException(msg + operationResult.getMessage());
            }
        }
    }

    private static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map map;
        Map mapOrg;
        if (orgId != null && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)) != null && mapOrg.get("id") != null && (map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")))) != null && map.size() != 0) {
            return map;
        }
        return null;
    }

    private void doHandlorBeforeF7Select(BeforeF7SelectEvent e, IDataModel model) {
        Object handledept = model.getValue("handledept");
        if (null != handledept) {
            DynamicObject dept = (DynamicObject)handledept;
            ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("entryentity.dpt", "=", (Object)dept.getLong("id")));
        }
    }

    private static DynamicObject createBdAttachment(Map<String, Object> attachment, String formId, String pageId) {
        ArrayList<Map<String, Object>> attachments = new ArrayList<Map<String, Object>>();
        attachments.add(attachment);
        List attObjs = AttachmentFieldServiceHelper.saveAttachments((String)formId, (String)pageId, attachments);
        return (DynamicObject)attObjs.get(0);
    }

    public void tabSelected(TabSelectEvent e) {
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        if (null != this.getModel().getValue("id") && this.getReject() > 0) {
            this.loadRejectData();
        }
    }

    private void loadRejectData() {
        String id = this.getModel().getDataEntity(true).getString("id");
        String selectors = "id,rejector,origin,priceproid,rejectdate,rejectreason,rejectphone";
        QFilter qFilter = new QFilter("priceproid", "=", (Object)id);
        DynamicObject[] rejects = BusinessDataServiceHelper.load((String)"ent_reject", (String)selectors, (QFilter[])qFilter.toArray());
        Map<String, List<Map<String, Object>>> attachments = this.getAttachmentMap();
        HashMap id_attachsMap = new HashMap(1024);
        List attachList = null;
        for (Map.Entry<String, List<Map<String, Object>>> bill : attachments.entrySet()) {
            attachList = id_attachsMap.containsKey(bill.getKey()) ? (List)id_attachsMap.get(bill.getKey()) : new ArrayList(1024);
            for (Map<String, Object> attachment : bill.getValue()) {
                DynamicObject attObj = AttachmentFieldServiceHelper.getAttCreatorByUID((String)((String)attachment.get("uid")));
                if (null == attObj) {
                    PmmProtocolEdit.createBdAttachment(attachment, this.getModel().getDataEntityType().getName(), this.getView().getPageId());
                    attObj = AttachmentFieldServiceHelper.getAttCreatorByUID((String)((String)attachment.get("uid")));
                }
                if (null == attObj) continue;
                attachList.add(attObj);
            }
            id_attachsMap.put(bill.getKey(), attachList);
        }
        IDataModel model = this.getModel();
        for (int i = 0; i < rejects.length; ++i) {
            DynamicObject tempRow = model.getDataEntity(true).getDynamicObjectCollection("entryentity2").addNew();
            DynamicObjectCollection attachRows = (DynamicObjectCollection)model.getValue("rejectattachment", i);
            DynamicObject dyn = rejects[i];
            if (id_attachsMap.containsKey(dyn.getString("id"))) {
                List srcattachs = (List)id_attachsMap.get(dyn.getString("id"));
                for (DynamicObject attDyn : srcattachs) {
                    DynamicObject attachRow = attachRows.addNew();
                    attachRow.set("fbasedataid", (Object)attDyn);
                }
                tempRow.set("rejectattachment", (Object)attachRows);
            }
            tempRow.set("rejector", (Object)dyn.getString("rejector"));
            tempRow.set("rejectorphone", (Object)dyn.getString("rejectphone"));
            tempRow.set("rejectdate", (Object)dyn.getDate("rejectdate"));
            tempRow.set("rejectreason", (Object)dyn.getString("rejectreason"));
        }
    }

    private Map<String, List<Map<String, Object>>> getAttachmentMap() {
        String id = this.getModel().getDataEntity(true).getString("id");
        String selectors = "id,rejector,origin,priceproid,rejectdate,rejectreason";
        QFilter qFilter = new QFilter("priceproid", "=", (Object)id);
        DynamicObject[] rejects = BusinessDataServiceHelper.load((String)"ent_reject", (String)selectors, (QFilter[])qFilter.toArray());
        HashSet<String> idSet = new HashSet<String>(1024);
        for (DynamicObject dyn : rejects) {
            idSet.add(dyn.getString("id"));
        }
        Map attachments = AttachmentServiceHelper.getAttachments((String)"ent_reject", (Object[])idSet.toArray(), (String)"attachmentpanelap1", (boolean)false);
        return attachments;
    }

    private int getReject() {
        String id = this.getModel().getDataEntity(true).getString("id");
        String selectors = "id,rejector,origin,priceproid,rejectdate,rejectreason";
        QFilter qFilter = new QFilter("priceproid", "=", (Object)id);
        return QueryServiceHelper.query((String)"ent_reject", (String)selectors, (QFilter[])qFilter.toArray()).size();
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Object effectdate = e.getSourceData().get("effectdate");
        Object invaliddate = e.getSourceData().get("invaliddate");
        if (null == effectdate) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u534f\u8bae\u751f\u6548\u65e5\u671f\u3002", (String)"PmmProtocolEdit_20", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            e.setFireAfterImportData(false);
        }
        if (null == invaliddate) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u534f\u8bae\u5931\u6548\u65e5\u671f\u3002", (String)"PmmProtocolEdit_21", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            e.setFireAfterImportData(false);
        }
        if (null != effectdate && null != invaliddate) {
            Object entryentity1;
            Date invalid;
            Date effect = DateUtil.string2date((String)String.valueOf(effectdate), (String)"yyyy-MM-dd");
            if (effect.after(invalid = DateUtil.getEndDate((Date)DateUtil.string2date((String)String.valueOf(invaliddate), (String)"yyyy-MM-dd")))) {
                e.setCancel(true);
                e.setCancelMessage(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5927\u4e8e\u5931\u6548\u65e5\u671f\u3002", (String)"PmmProtocolEdit_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                e.setFireAfterImportData(false);
            }
            if (null != (entryentity1 = e.getSourceData().get("entryentity1"))) {
                JSONArray entrys = (JSONArray)entryentity1;
                for (int i = 0; i < entrys.size(); ++i) {
                    Date priceinvaliddate;
                    BigDecimal dctrate;
                    BigDecimal minorderqty;
                    JSONObject row = (JSONObject)entrys.get(i);
                    String discounttype = row.getString("discounttype");
                    BigDecimal qty = row.getBigDecimal("qty");
                    if (null == qty) {
                        qty = BigDecimal.ZERO;
                    }
                    if (null == (minorderqty = row.getBigDecimal("minorderqty"))) {
                        minorderqty = BigDecimal.ZERO;
                    }
                    if (qty.compareTo(BigDecimal.ZERO) > 0 && minorderqty.compareTo(BigDecimal.ZERO) > 0 && minorderqty.compareTo(qty) > 0) {
                        String msg = ResManager.loadKDString((String)"\u6570\u91cf\u5e94\u5927\u4e8e\u7b49\u4e8e\u8d77\u8ba2\u91cf\u3002", (String)"PmmProtocolEdit_26", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                        e.setCancel(true);
                        e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(i), msg);
                        e.setFireAfterImportData(false);
                        continue;
                    }
                    if ("B".equals(discounttype)) {
                        BigDecimal taxprice = row.getBigDecimal("taxprice");
                        BigDecimal dctrate2 = row.getBigDecimal("dctrate");
                        if (null != taxprice && null != dctrate2 && dctrate2.compareTo(taxprice) > 0) {
                            String msg = ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PmmProtocolEdit_4", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                            e.setCancel(true);
                            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(i), msg);
                            e.setFireAfterImportData(false);
                            continue;
                        }
                    }
                    if ("A".equals(discounttype) && null != (dctrate = row.getBigDecimal("dctrate")) && dctrate.compareTo(new BigDecimal("100")) > 0) {
                        String msg = ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u503c\u8303\u56f4[0,100]\u3002", (String)"PmmProtocolEdit_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                        e.setCancel(true);
                        e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(i), msg);
                        e.setFireAfterImportData(false);
                        continue;
                    }
                    Date priceeffectdateStr = row.getDate("priceeffectdate");
                    Date priceinvaliddateStr = row.getDate("priceinvaliddate");
                    if (null != priceeffectdateStr) {
                        Date priceeffectdate = DateUtil.getDayStart((Date)priceeffectdateStr);
                        if (effect.after(priceeffectdate)) {
                            e.setCancel(true);
                            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(i), ResManager.loadKDString((String)"\u4ef7\u683c\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u534f\u8bae\u751f\u6548\u65e5\u671f\u3002", (String)"PmmProtocolEdit_17", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                            e.setFireAfterImportData(false);
                            continue;
                        }
                        if (invalid.before(priceeffectdate)) {
                            e.setCancel(true);
                            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(i), ResManager.loadKDString((String)"\u4ef7\u683c\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u534f\u8bae\u5931\u6548\u65e5\u671f\u3002", (String)"PmmProtocolEdit_18", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                            e.setFireAfterImportData(false);
                            continue;
                        }
                    }
                    if (null != priceinvaliddateStr) {
                        priceinvaliddate = DateUtil.getEndDate((Date)priceinvaliddateStr);
                        if (effect.after(priceinvaliddate)) {
                            e.setCancel(true);
                            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(i), ResManager.loadKDString((String)"\u4ef7\u683c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u534f\u8bae\u751f\u6548\u65e5\u671f\u3002", (String)"PmmProtocolEdit_22", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                            e.setFireAfterImportData(false);
                            continue;
                        }
                        if (invalid.before(priceinvaliddate)) {
                            e.setCancel(true);
                            e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(i), ResManager.loadKDString((String)"\u4ef7\u683c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u534f\u8bae\u5931\u6548\u65e5\u671f\u3002", (String)"PmmProtocolEdit_23", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                            e.setFireAfterImportData(false);
                            continue;
                        }
                    }
                    if (null == priceeffectdateStr || null == priceinvaliddateStr) continue;
                    priceinvaliddate = DateUtil.getEndDate((Date)priceinvaliddateStr);
                    Date priceeffectdate = DateUtil.getDayStart((Date)priceeffectdateStr);
                    if (!priceeffectdate.after(priceinvaliddate)) continue;
                    e.setCancel(true);
                    e.addCancelMessage(Integer.valueOf(0), Integer.valueOf(i), ResManager.loadKDString((String)"\u4ef7\u683c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u751f\u6548\u65e5\u671f\u3002", (String)"PmmProtocolEdit_24", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                    e.setFireAfterImportData(false);
                }
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        IDataModel model = this.getModel();
        Object purmode = model.getValue("purmode");
        if (null != purmode) {
            this.doPurmodeChange(model);
        }
        this.doSupplierChange(model);
        DynamicObjectCollection billentrys = (DynamicObjectCollection)model.getValue("entryentity1");
        for (DynamicObject row : billentrys) {
            int seq = row.getInt("seq") - 1;
            model.setEntryCurrentRowIndex("entryentity1", seq);
            if ("NULL".equals(model.getValue("discounttype", seq))) {
                model.setValue("dctrate", null, seq);
                model.setValue("dctamount", null, seq);
            }
            if (null != row.get("material")) {
                this.doMaterialChange(model, seq);
            }
            this.doTaxrateidChange(model, seq);
            this.doQtyChange(model, seq, "entryentity1", BigDecimal.ZERO);
            this.doTaxpriceCal(model, "entryentity1");
            BigDecimal minorderqty = row.getBigDecimal("minorderqty");
            if (null == minorderqty) continue;
            model.setValue("minorderqty", (Object)minorderqty.setScale(0, RoundingMode.FLOOR), seq);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returnData;
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("orgentryset".equals(actionId) && null != (returnData = e.getReturnData())) {
            Map paramMap = (Map)e.getReturnData();
            List allDataList = (List)paramMap.get("returnEntrys");
            this.allotEntryData(allDataList);
            SRMStoreDataTraceHelper.saveStoreData((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity(true)});
            this.getView().invokeOperation("refresh");
        }
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"setladderprice")) {
            this.doSetladderprice(e);
        }
    }

    private void doSetladderprice(ClosedCallBackEvent e) {
        Object returnData = e.getReturnData();
        if (null != returnData) {
            Map returnDataMap = (Map)returnData;
            List entryList = (List)returnDataMap.get("entry");
            TableValueSetter vs = new TableValueSetter(new String[0]);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData("subentryentity");
            EntryGrid grid = (EntryGrid)this.getView().getControl("entryentity1");
            int[] selectRows = grid.getSelectRows();
            int rowIndex = selectRows[0];
            if (null != this.getPageCache().get("row")) {
                rowIndex = Integer.parseInt(this.getPageCache().get("row"));
                this.getPageCache().remove("row");
            }
            int index = 0;
            BigDecimal price = BigDecimal.ZERO;
            BigDecimal qty = CommonUtil.getBigDecimalPro((Object)this.getModel().getValue("qty", rowIndex));
            for (LadderPriceInfo info : entryList) {
                vs.set("qtyfrom", (Object)info.getQtyfrom(), index);
                vs.set("qtyto", (Object)info.getQtyto(), index);
                vs.set("ladprice", (Object)info.getLadprice(), index);
                if (qty.compareTo(info.getQtyfrom()) >= 0 && (qty.compareTo(info.getQtyto()) < 0 || info.getQtyto().compareTo(BigDecimal.ZERO) == 0)) {
                    price = info.getLadprice();
                }
                ++index;
            }
            if (price.compareTo(BigDecimal.ZERO) == 0 && entryList.size() > 0) {
                entryList = entryList.stream().sorted(Comparator.comparing(LadderPriceInfo::getQtyfrom)).collect(Collectors.toList());
                price = ((LadderPriceInfo)entryList.get(0)).getLadprice();
            }
            model.beginInit();
            model.batchCreateNewEntryRow("subentryentity", vs);
            model.endInit();
            this.getView().updateView("subentryentity");
            this.getModel().setValue("taxprice", (Object)price, rowIndex);
        }
    }

    private void allotEntryData(List<Map<String, Object>> allDataList) {
        String entryEntityKey = "entryentity1";
        this.getModel().deleteEntryData(entryEntityKey);
        if (allDataList == null || allDataList.size() == 0) {
            this.getView().updateView(entryEntityKey);
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        List propertiesentity = DynamicObjectUtil.getEntryentityProperties((IDataEntityType)model.getEntityEntity(entryEntityKey).getDynamicObjectType());
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int rowCount = 0;
        HashMap<Integer, Object> seq_subrowsMap = new HashMap<Integer, Object>(1024);
        for (Map<String, Object> paramMap : allDataList) {
            for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                String entryKey;
                if (entry.getKey().contains("_id") || "id".equals(entry.getKey()) || "seq".equals(entry.getKey()) || "subentryentity".equals(entry.getKey()) || !propertiesentity.contains(entryKey = entry.getKey().replace("1", ""))) continue;
                vs.set(entryKey, entry.getValue(), rowCount);
            }
            vs.set("seq", (Object)(rowCount + 1), rowCount);
            if (null != paramMap.get("subentryentity")) {
                seq_subrowsMap.put(rowCount, paramMap.get("subentryentity"));
            }
            ++rowCount;
        }
        model.beginInit();
        model.batchCreateNewEntryRow(entryEntityKey, vs);
        model.endInit();
        this.getView().updateView(entryEntityKey);
        IDataModel entryOperate = this.getModel();
        for (Map.Entry map : seq_subrowsMap.entrySet()) {
            List subRows = (List)map.getValue();
            entryOperate.setEntryCurrentRowIndex(entryEntityKey, ((Integer)map.getKey()).intValue());
            entryOperate.deleteEntryData("subentryentity");
            for (Object subRow : subRows) {
                entryOperate.setEntryCurrentRowIndex(entryEntityKey, ((Integer)map.getKey()).intValue());
                Map subRowMap = (Map)subRow;
                String subDataIndex = "";
                if (!subRowMap.containsKey("qtyfrom")) {
                    subDataIndex = "1";
                }
                int subIndex = entryOperate.createNewEntryRow("subentryentity");
                this.getModel().setValue("qtyfrom", subRowMap.get("qtyfrom" + subDataIndex), subIndex, ((Integer)map.getKey()).intValue());
                this.getModel().setValue("qtyto", subRowMap.get("qtyto" + subDataIndex), subIndex, ((Integer)map.getKey()).intValue());
                this.getModel().setValue("ladprice", subRowMap.get("ladprice" + subDataIndex), subIndex, ((Integer)map.getKey()).intValue());
                this.getModel().setValue("subkey", subRowMap.get("qtyfrom" + subDataIndex), subIndex, ((Integer)map.getKey()).intValue());
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String fieldName = e.getFieldName();
        int rowIndex = e.getRowIndex();
        if ("purplanid".equals(fieldName)) {
            DynamicObject purplanDyn = (DynamicObject)this.getModel().getValue("purplanid", rowIndex);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("pmm_purchaseorgshow");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            HashMap<String, Long> detailParamMap = new HashMap<String, Long>();
            detailParamMap.put("purplanId", purplanDyn.getLong("id"));
            showParameter.setCustomParams(detailParamMap);
            showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "purplanid"));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }
}

