/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.cal.ICal;
import kd.scm.malcore.domain.LadderPriceInfo;
import kd.scm.pmm.common.util.PmmProtocolCalImpl;

public class PmmPurOrgEntrysetCalEdit
extends AbstractBillPlugIn
implements RowClickEventListener {
    private static ICal cal = new PmmProtocolCalImpl();
    private static final String ENTRY_PART = "entryentity";

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        block25: for (ChangeData changeData : e.getChangeSet()) {
            int rowIndex = changeData.getRowIndex();
            int currentRowIndex = model.getEntryCurrentRowIndex(ENTRY_PART);
            if (rowIndex >= 0 && currentRowIndex != rowIndex) {
                EntryGrid grid = (EntryGrid)this.getControl(ENTRY_PART);
                grid.selectRows(rowIndex, true);
            }
            switch (name) {
                case "material": {
                    this.doMaterialChange(model, rowIndex);
                    continue block25;
                }
                case "materialname": {
                    this.doCheckMaterialChange(model, rowIndex);
                    continue block25;
                }
                case "taxrateid": {
                    this.doTaxrateidChange(model, rowIndex);
                    continue block25;
                }
                case "qty": {
                    Object oldValue = changeData.getOldValue();
                    this.doQtyChange(model, rowIndex, ENTRY_PART, oldValue);
                    continue block25;
                }
                case "taxprice": {
                    this.doTaxpriceChange(model, ENTRY_PART, rowIndex, e);
                    continue block25;
                }
                case "discounttype": 
                case "dctrate": {
                    this.doDctrateChange(model, ENTRY_PART, rowIndex, e, name);
                    continue block25;
                }
                case "priceeffectdate": {
                    this.doPriceEffectDateChange(changeData);
                    continue block25;
                }
                case "priceinvaliddate": {
                    this.doPriceInvalidDateChange(changeData);
                    continue block25;
                }
                case "minorderqty": {
                    this.doMinorderqtyChange(changeData);
                    continue block25;
                }
                case "entrypricetype": {
                    this.doPriceTypeChange(changeData);
                    continue block25;
                }
            }
        }
    }

    private void doPriceTypeChange(ChangeData arg0) {
        Object newValue = arg0.getNewValue();
        int rowIndex = arg0.getRowIndex();
        if ("B".equals(newValue)) {
            this.setTaxpriceByLadprice(rowIndex);
        }
    }

    private void setTaxpriceByLadprice(int rowIndex) {
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_PART);
        DynamicObject row = (DynamicObject)entryCol.get(rowIndex);
        DynamicObjectCollection subentryentity = row.getDynamicObjectCollection("subentryentity");
        if (subentryentity.size() > 1) {
            ArrayList<LadderPriceInfo> ladderPriceInfos = new ArrayList<LadderPriceInfo>(1024);
            for (DynamicObject subRow : subentryentity) {
                LadderPriceInfo info = new LadderPriceInfo(subRow.getBigDecimal("qtyfrom"), subRow.getBigDecimal("qtyto"), subRow.getBigDecimal("ladprice"), Long.valueOf(0L));
                ladderPriceInfos.add(info);
            }
            if (ladderPriceInfos.size() > 0) {
                this.getModel().setValue("taxprice", (Object)((LadderPriceInfo)ladderPriceInfos.get(0)).getLadprice(), rowIndex);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        if (callBackId.equals("minorderqty")) {
            if (e.getResult() == MessageBoxResult.Yes) {
                IDataModel entryOperate = this.getModel();
                entryOperate.deleteEntryData("subentryentity");
            } else {
                String qtyStr = this.getPageCache().get("minorderqty");
                String rowIndex = this.getPageCache().get("rowIndex");
                this.getModel().setValue("minorderqty", (Object)new BigDecimal(qtyStr), Integer.parseInt(rowIndex));
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)ENTRY_PART, (CharSequence)source.getKey())) {
            int row = evt.getRow();
            this.getPageCache().put("row", String.valueOf(row));
        }
    }

    private void doMinorderqtyChange(ChangeData changeData) {
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        if (CommonUtil.getBigDecimalPro((Object)newValue).compareTo(CommonUtil.getBigDecimalPro((Object)oldValue)) == 0) {
            return;
        }
        BigDecimal newMinOrderQty = CommonUtil.getBigDecimalPro((Object)newValue).setScale(0, RoundingMode.FLOOR);
        int rowIndex = changeData.getRowIndex();
        IDataModel model = this.getModel();
        BigDecimal qty = CommonUtil.getBigDecimalPro((Object)model.getValue("qty", rowIndex));
        if (qty.compareTo(BigDecimal.ZERO) > 0 && newMinOrderQty.compareTo(BigDecimal.ZERO) > 0 && newMinOrderQty.compareTo(qty) > 0) {
            String msg = ResManager.loadKDString((String)"\u8d77\u8ba2\u91cf\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u6570\u91cf\u3002", (String)"PmmPurOrgEntrysetCalEdit_6", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            model.setValue("minorderqty", oldValue, rowIndex);
            return;
        }
        model.setValue("minorderqty", (Object)newMinOrderQty, rowIndex);
        DynamicObjectCollection entryCol = model.getDataEntity(true).getDynamicObjectCollection(ENTRY_PART);
        DynamicObject row = (DynamicObject)entryCol.get(rowIndex);
        DynamicObjectCollection subentryentity = row.getDynamicObjectCollection("subentryentity");
        if (subentryentity.size() > 1) {
            DynamicObject subrow = (DynamicObject)subentryentity.get(0);
            if (newMinOrderQty.compareTo(BigDecimal.ZERO) == 0) {
                model.setValue("qtyfrom", (Object)BigDecimal.ZERO, 0, rowIndex);
            } else {
                BigDecimal minqty = new BigDecimal(String.valueOf(newValue)).setScale(0, RoundingMode.FLOOR);
                BigDecimal qtyto = subrow.getBigDecimal("qtyto");
                if (minqty.compareTo(BigDecimal.ZERO) == 0) {
                    model.setValue("qtyfrom", (Object)BigDecimal.ZERO, 0, rowIndex);
                    return;
                }
                if (minqty.compareTo(qtyto) < 0) {
                    model.setValue("qtyfrom", (Object)minqty, 0, rowIndex);
                } else if ("A".equals(model.getValue("entrypricetype"))) {
                    IDataModel entryOperate = this.getModel();
                    entryOperate.deleteEntryData("subentryentity");
                } else {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("minorderqty", (IFormPlugin)this);
                    String confirmTip = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u9636\u68af\u4ef7\uff0c\u4fee\u6539\u8d77\u8ba2\u91cf\u540e\u6e05\u7a7a\u9636\u68af\u4ef7\uff0c\u9700\u91cd\u8bbe\u3002", (String)"PmmPurOrgEntrysetCalEdit_8", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                    this.getPageCache().put("minorderqty", String.valueOf(oldValue));
                    this.getPageCache().put("rowIndex", String.valueOf(rowIndex));
                    this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                }
            }
        }
    }

    private void doPriceInvalidDateChange(ChangeData changeData) {
        Date entryPriceeffectdate;
        Date protocolInvaliDate;
        Date protocolEffectDate;
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object effectdate = customParams.get("effectdate");
        Object invaliddate = customParams.get("invaliddate");
        Object priceeffectdate = this.getModel().getValue("priceeffectdate", rowIndex);
        if (null == newValue) {
            return;
        }
        if (null != effectdate && (protocolEffectDate = DateUtil.getDayStart((Date)DateUtil.string2date((String)String.valueOf(effectdate), (String)"yyyy-MM-dd HH:mm:ss"))).after((Date)newValue)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u534f\u8bae\u751f\u6548\u65e5\u671f\u3002", (String)"PmmPurOrgEntrysetCalEdit_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("priceinvaliddate", oldValue, rowIndex);
            return;
        }
        if (invaliddate != null && (protocolInvaliDate = DateUtil.getEndDate((Date)DateUtil.string2date((String)String.valueOf(invaliddate), (String)"yyyy-MM-dd HH:mm:ss"))).before((Date)newValue)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u534f\u8bae\u5931\u6548\u65e5\u671f\u3002", (String)"PmmPurOrgEntrysetCalEdit_4", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("priceinvaliddate", oldValue, rowIndex);
            return;
        }
        if (priceeffectdate != null && (entryPriceeffectdate = DateUtil.getDayStart((Date)((Date)priceeffectdate))).after((Date)newValue)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u5931\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u4ef7\u683c\u751f\u6548\u65e5\u671f\u3002", (String)"PmmPurOrgEntrysetCalEdit_5", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("priceinvaliddate", oldValue, rowIndex);
        }
    }

    private void doPriceEffectDateChange(ChangeData changeData) {
        Date entryPriceinvaliddate;
        Date protocolInvaliDate;
        Date protocolEffectDate;
        Object newValue = changeData.getNewValue();
        Object oldValue = changeData.getOldValue();
        int rowIndex = changeData.getRowIndex();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object effectdate = customParams.get("effectdate");
        Object invaliddate = customParams.get("invaliddate");
        Object priceinvaliddate = this.getModel().getValue("priceinvaliddate", rowIndex);
        if (null == newValue) {
            return;
        }
        if (null != effectdate && (protocolEffectDate = DateUtil.getDayStart((Date)DateUtil.string2date((String)String.valueOf(effectdate), (String)"yyyy-MM-dd HH:mm:ss"))).after((Date)newValue)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u65e9\u4e8e\u534f\u8bae\u751f\u6548\u65e5\u671f\u3002", (String)"PmmPurOrgEntrysetCalEdit_10", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("priceeffectdate", oldValue, rowIndex);
            return;
        }
        if (invaliddate != null && (protocolInvaliDate = DateUtil.getEndDate((Date)DateUtil.string2date((String)String.valueOf(invaliddate), (String)"yyyy-MM-dd HH:mm:ss"))).before((Date)newValue)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u534f\u8bae\u5931\u6548\u65e5\u671f\u3002", (String)"PmmPurOrgEntrysetCalEdit_11", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("priceeffectdate", oldValue, rowIndex);
            return;
        }
        if (priceinvaliddate != null && (entryPriceinvaliddate = DateUtil.getEndDate((Date)((Date)priceinvaliddate))).before((Date)newValue)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ef7\u683c\u751f\u6548\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u4ef7\u683c\u5931\u6548\u65e5\u671f\u3002", (String)"PmmPurOrgEntrysetCalEdit_12", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("priceeffectdate", oldValue, rowIndex);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        if (rowDataEntities.length > 0 && (rowDataEntities[0].getDataEntity().getDataEntityType().getName().equals(ENTRY_PART) || rowDataEntities[0].getDataEntity().getDataEntityType().getName().equals("entryentity1"))) {
            for (RowDataEntity row : rowDataEntities) {
                int rowIndex = row.getRowIndex();
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                Object effectdate = customParams.get("effectdate");
                Object invaliddate = customParams.get("invaliddate");
                this.getModel().setValue("priceeffectdate", effectdate, rowIndex);
                this.getModel().setValue("priceinvaliddate", invaliddate, rowIndex);
            }
        }
    }

    private void doCheckMaterialChange(IDataModel model, int rowIndex) {
        if (null != model.getValue("material", rowIndex)) {
            return;
        }
        Object materialName = model.getValue("materialname", rowIndex);
        DynamicObjectCollection entrys = model.getDataEntity(true).getDynamicObjectCollection(ENTRY_PART);
        IFormView view = this.getView();
        for (DynamicObject row : entrys) {
            String srcMaterialName = row.getString("materialname");
            if (null == materialName || null != row.getDynamicObject("material") || !srcMaterialName.equals(materialName) || rowIndex + 1 == row.getInt("seq")) continue;
            String msg = ResManager.loadKDString((String)"\u5728\u7b2c{0}\u884c\u5b58\u5728\u76f8\u540c\u7684\u4ea7\u54c1\u540d\u79f0\u3002", (String)"PmmPurOrgEntrysetCalEdit_0", (String)"scm-pmm-formplugin", (Object[])new Object[]{row.getInt("seq")});
            view.showErrorNotification(msg);
            model.setValue("materialname", null);
            break;
        }
    }

    private void doQtyChange(IDataModel model, int rowIndex, String entryKey, Object oldValue) {
        if (null != model.getValue("qty", rowIndex)) {
            BigDecimal qty = new BigDecimal(String.valueOf(model.getValue("qty")));
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            DynamicObject basicunit = (DynamicObject)model.getValue("baseunit", rowIndex);
            BigDecimal baseQty = BigDecimal.ZERO;
            BigDecimal minorderqty = CommonUtil.getBigDecimalPro((Object)model.getValue("minorderqty", rowIndex));
            if (qty.compareTo(BigDecimal.ZERO) > 0 && minorderqty.compareTo(BigDecimal.ZERO) > 0 && minorderqty.compareTo(qty) > 0) {
                String msg = ResManager.loadKDString((String)"\u6570\u91cf\u5e94\u5927\u4e8e\u7b49\u4e8e\u8d77\u8ba2\u91cf\u3002", (String)"PmmPurOrgEntrysetCalEdit_7", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                this.getModel().setValue("qty", oldValue, rowIndex);
                return;
            }
            String param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice");
            if ("B".equals(model.getValue("entrypricetype", rowIndex)) && Boolean.parseBoolean(param)) {
                DynamicObjectCollection entryCol = model.getDataEntity(true).getDynamicObjectCollection(entryKey);
                DynamicObject row = (DynamicObject)entryCol.get(rowIndex);
                DynamicObjectCollection subentryentity = row.getDynamicObjectCollection("subentryentity");
                for (DynamicObject subrow : subentryentity) {
                    BigDecimal qtyfrom = subrow.getBigDecimal("qtyfrom");
                    BigDecimal qtyto = subrow.getBigDecimal("qtyto");
                    BigDecimal ladprice = subrow.getBigDecimal("ladprice");
                    if (qty.compareTo(qtyfrom) < 0 || qty.compareTo(qtyto) >= 0 && qtyto.compareTo(BigDecimal.ZERO) != 0) continue;
                    this.getModel().setValue("taxprice", (Object)ladprice, rowIndex);
                }
            }
            if (null != material && null != unit && null != basicunit) {
                baseQty = CommonUtil.getDesQtyConv((DynamicObject)material, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)basicunit);
            }
            model.setValue("baseqty", (Object)baseQty, rowIndex);
            cal.calEntryDiscountAmount(model, entryKey);
            cal.calEntryTaxAmount(model, entryKey);
            cal.calEntryTax(model, entryKey);
            cal.calEntryAmount(model, entryKey);
        }
    }

    private void doTaxpriceChange(IDataModel model, String entryKey, int rowIndex, PropertyChangedArgs e) {
        if ("B".equals(model.getValue("discounttype", rowIndex))) {
            BigDecimal taxprice = new BigDecimal(String.valueOf(model.getValue("taxprice", rowIndex)));
            BigDecimal dctrate = new BigDecimal(String.valueOf(model.getValue("dctrate", rowIndex)));
            if (dctrate.compareTo(taxprice) > 0) {
                String msg = ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PmmPurOrgEntrysetCalEdit_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                model.setValue("taxprice", e.getChangeSet()[0].getOldValue(), rowIndex);
            }
        }
        this.doTaxpriceCal(model, entryKey);
    }

    private void doTaxpriceCal(IDataModel model, String entryKey) {
        cal.calEntryPriceByTaxPrice(model, entryKey);
        cal.calEntryTaxAmount(model, entryKey);
        cal.calEntryTax(model, entryKey);
        cal.calEntryAmount(model, entryKey);
        cal.calEntryDiscountAmount(model, entryKey);
    }

    private void doDctrateChange(IDataModel model, String entryKey, int rowIndex, PropertyChangedArgs e, String name) {
        BigDecimal dctrate;
        if ("NULL".equals(model.getValue("discounttype", rowIndex)) || "".equals(model.getValue("discounttype", rowIndex))) {
            model.setValue("dctrate", null, rowIndex);
            model.setValue("dctamount", null, rowIndex);
        }
        if ("A".equals(model.getValue("discounttype", rowIndex)) && (dctrate = new BigDecimal(String.valueOf(model.getValue("dctrate", rowIndex)))).compareTo(new BigDecimal("100")) > 0) {
            String msg = ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u7387(%)\u65f6\uff0c\u5355\u4f4d\u6298\u6263\u7387\u503c\u8303\u56f4\uff1a0\u2264\u5355\u4f4d\u6298\u6263(\u7387)\u2264100\u3002", (String)"PmmPurOrgEntrysetCalEdit_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            model.setValue("dctrate", e.getChangeSet()[0].getOldValue(), rowIndex);
        }
        if ("B".equals(model.getValue("discounttype", rowIndex))) {
            BigDecimal taxprice = new BigDecimal(String.valueOf(model.getValue("taxprice", rowIndex)));
            BigDecimal dctrate2 = new BigDecimal(String.valueOf(model.getValue("dctrate", rowIndex)));
            if (dctrate2.compareTo(taxprice) > 0) {
                String msg = ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u5355\u4f4d\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"PmmPurOrgEntrysetCalEdit_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                model.setValue("dctrate", e.getChangeSet()[0].getOldValue(), rowIndex);
            }
        }
        cal.calEntryDiscountAmount(model, entryKey);
        cal.calEntryTaxAmount(model, entryKey);
        cal.calEntryTax(model, entryKey);
        cal.calEntryAmount(model, entryKey);
    }

    private void doTaxrateidChange(IDataModel model, int rowIndex) {
        if (null != model.getValue("taxrateid", rowIndex)) {
            DynamicObject taxrateid = (DynamicObject)model.getValue("taxrateid");
            BigDecimal taxrate = taxrateid.getBigDecimal("taxrate");
            model.setValue("taxrate", (Object)taxrate, rowIndex);
        } else {
            model.setValue("taxrate", null, rowIndex);
        }
        String entryKey = ENTRY_PART;
        cal.calEntryPriceByTaxPrice(model, entryKey);
        cal.calEntryTax(model, entryKey);
        cal.calEntryAmount(model, entryKey);
    }

    private void doMaterialChange(IDataModel model, int rowIndex) {
        if (null != model.getValue("material", rowIndex)) {
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject group = material.getDynamicObject("group");
            DynamicObject baseunit = material.getDynamicObject("baseunit");
            String name = material.getString("name");
            model.setValue("materialname", (Object)name, rowIndex);
            model.setValue("materialgroup", (Object)group, rowIndex);
            model.setValue("baseunit", (Object)baseunit, rowIndex);
            model.setValue("unit", (Object)baseunit, rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"materialname", "materialgroup"});
        } else {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"materialname", "materialgroup"});
            model.setValue("materialname", null, rowIndex);
            model.setValue("materialgroup", null, rowIndex);
            model.setValue("baseunit", null, rowIndex);
            model.setValue("unit", null, rowIndex);
            model.setValue("auxpty", null, rowIndex);
        }
    }
}

