/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pmm.business.model.protocol.ProtocolInfo;
import kd.scm.pmm.business.validator.PmmProtocolValidatorService;

public class PmmPurPlanOrgChangeEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static Log log = LogFactory.getLog(PmmPurPlanOrgChangeEdit.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit settleOrg = (BasedataEdit)this.getControl("org");
        settleOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void initData() {
        ArrayList<Integer> indexs = new ArrayList<Integer>(1024);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("purplanid")) {
            Long purPlanId = Long.parseLong(String.valueOf(customParams.get("purplanid")));
            QFilter qFilter = new QFilter("id", "=", (Object)purPlanId);
            DynamicObjectCollection purPlans = QueryServiceHelper.query((String)"pmm_purchaseplan", (String)"protocol.id,entryentity.org", (QFilter[])qFilter.toArray());
            TableValueSetter vs = new TableValueSetter(new String[0]);
            int index = 0;
            for (DynamicObject row : purPlans) {
                vs.set("org_id", (Object)row.getLong("entryentity.org"), index);
                indexs.add(index);
                ++index;
            }
            this.getModel().beginInit();
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.batchCreateNewEntryRow("entryentity", vs);
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
        this.getPageCache().put("indexs", SerializationUtils.toJsonString(indexs));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String indexs = this.getPageCache().get("indexs");
        List objects = SerializationUtils.fromJsonStringToList((String)indexs, Integer.class);
        if (objects.size() > 0) {
            Iterator iterator = objects.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"org"});
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (operateKey.equals("confirm")) {
            this.checkConfirm(args);
        }
    }

    private void checkConfirm(BeforeDoOperationEventArgs args) {
        Long purPlanId;
        QFilter qFilter;
        DynamicObjectCollection purPlans;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("purplanid") && (purPlans = QueryServiceHelper.query((String)"pmm_purchaseplan", (String)"protocol.purmode,protocol.effectdate,protocol.invaliddate,protocol.partyb,protocol.differentarea,id,protocol.id,entryentity.org", (QFilter[])(qFilter = new QFilter("id", "=", (Object)(purPlanId = Long.valueOf(Long.parseLong(String.valueOf(customParams.get("purplanid"))))))).toArray())).size() > 0) {
            HasPermOrgResult hasPermOrgResult;
            List permOrgs;
            boolean superUser;
            Map<Long, DynamicObject> newOrgsMap = this.getNewOrgSet(purPlans);
            if (newOrgsMap.size() == 0) {
                String msg = ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u7ec4\u7ec7\u3002", (String)"PmmPurPlanOrgChangeEdit_7", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                args.setCancel(true);
                return;
            }
            DynamicObject purPlan = (DynamicObject)purPlans.get(0);
            HashSet<Long> supIdSet = new HashSet<Long>(1024);
            supIdSet.add(purPlan.getLong("protocol.partyb"));
            PmmProtocolValidatorService service = new PmmProtocolValidatorService();
            ArrayList protocolInfoList = service.getProtocolList(supIdSet);
            Map protocolGroupInfos = service.getProtocolGroupInfosByPurMode((List)protocolInfoList);
            String title = ResManager.loadKDString((String)"\u65b0\u589e\u7ec4\u7ec7\u5931\u8d25", (String)"PmmPurPlanOrgChangeEdit_4", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            String content = this.getProtocolsMsg(protocolGroupInfos, purPlans);
            if (content.length() > 0) {
                this.getView().showMessage(title, content, MessageTypes.Default);
                args.setCancel(true);
            }
            if (!(superUser = PermissionServiceHelper.isSuperUser((long)RequestContext.get().getCurrUserId())) && (permOrgs = (hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), null, null, (String)"pmm_purchaseplan", (String)"3I/XA4WQMK8B")).getHasPermOrgs()).size() == 0) {
                String msg = ResManager.loadKDString((String)"\u65e0\u201c\u91c7\u4e70\u65b9\u6848\u201d\u7684\u201c\u5feb\u901f\u53d8\u66f4\u91c7\u4e70\u7ec4\u7ec7\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PmmPurPlanOrgChangeEdit_6", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
                args.setCancel(true);
            }
        }
    }

    private String getProtocolsMsg(Map<String, ArrayList<ProtocolInfo>> protocolGroupInfos, DynamicObjectCollection purPlans) {
        String errmsg;
        Map orgId_orgNameMap;
        StringBuilder msg = new StringBuilder();
        Map<Long, DynamicObject> newOrgsMap = this.getNewOrgSet(purPlans);
        Set<Long> materialIds = this.getMaterialIds((DynamicObject)purPlans.get(0));
        materialIds.remove(0L);
        Date effectdate = ((DynamicObject)purPlans.get(0)).getDate("protocol.effectdate");
        Date invaliddate = ((DynamicObject)purPlans.get(0)).getDate("protocol.invaliddate");
        Long protocolId = ((DynamicObject)purPlans.get(0)).getLong("protocol.id");
        HashSet<Long> protocolIdLinkGoods = new HashSet<Long>(1024);
        HashSet purPlanIdLinkGoods = new HashSet(1024);
        ArrayList<ProtocolInfo> protocolInfoPartAll = protocolGroupInfos.get("A");
        ArrayList<ProtocolInfo> protocolInfoPartOrgs = protocolGroupInfos.get("B");
        ArrayList<ProtocolInfo> protocolInfoAreas = protocolGroupInfos.get("C");
        if (null != protocolInfoPartAll && protocolInfoPartAll.size() > 0) {
            for (ProtocolInfo info : protocolInfoPartAll) {
                List tarMaterialIds;
                if (null != info.getInvaliddate() && effectdate.after(info.getInvaliddate()) || null != effectdate && invaliddate.before(info.getEffectdate()) || info.getProtocolID().equals(protocolId) || (tarMaterialIds = info.getMaterialIds()).size() <= 0 || materialIds.size() <= 0) continue;
                HashSet<Long> diffMaterialId = new HashSet<Long>(1024);
                for (Long l : materialIds) {
                    if (!tarMaterialIds.contains(l)) continue;
                    diffMaterialId.add(l);
                }
                if (diffMaterialId.size() != 0) continue;
                protocolIdLinkGoods.add(info.getProtocolID());
            }
        }
        if (null != protocolInfoPartOrgs && protocolInfoPartOrgs.size() > 0) {
            for (ProtocolInfo info : protocolInfoPartOrgs) {
                if (null != info.getInvaliddate() && effectdate.after(info.getInvaliddate()) || null != effectdate && invaliddate.before(info.getEffectdate()) || info.getProtocolID().equals(protocolId)) continue;
                List orgIds = info.getOrgIds();
                List tarMaterialIds = info.getMaterialIds();
                orgId_orgNameMap = info.getOrgId_orgNameMap();
                if (tarMaterialIds == null || tarMaterialIds.size() == 0) {
                    for (Map.Entry<Long, DynamicObject> entry : newOrgsMap.entrySet()) {
                        if (!orgIds.contains(entry.getKey())) continue;
                        String string = ResManager.loadKDString((String)"\u7ec4\u7ec7{0}\u5df2\u5b58\u5728\u534f\u8bae\u7f16\u53f7\u4e3a{1}\u4e2d\uff0c\u4e3a\u65e0\u6e05\u5355\u534f\u8bae\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"PmmPurPlanOrgChangeEdit_1", (String)"scm-pmm-formplugin", (Object[])new Object[]{orgId_orgNameMap.get(entry.getKey()), info.getProtocolBillNo()});
                        msg.append(string).append('\n');
                    }
                }
                if (null == tarMaterialIds || tarMaterialIds.size() <= 0) continue;
                HashSet<Long> hashSet = new HashSet<Long>(1024);
                for (Map.Entry<Long, DynamicObject> entry : newOrgsMap.entrySet()) {
                    if (!orgIds.contains(entry.getKey())) continue;
                    hashSet.add(entry.getKey());
                }
                if (hashSet.size() > 0 && (null == materialIds || materialIds.size() == 0)) {
                    for (Long l : hashSet) {
                        String string = ResManager.loadKDString((String)"\u7ec4\u7ec7{0}\u5df2\u5b58\u5728\u534f\u8bae\u7f16\u53f7{1}\u4e2d\uff0c\u4e0d\u652f\u6301\u5b58\u5728\u591a\u4e2a\u65e0\u7269\u6599\u6e05\u5355\u3001\u6709\u7269\u6599\u6e05\u5355\u7684\u534f\u8bae;", (String)"PmmPurPlanOrgChangeEdit_8", (String)"scm-pmm-formplugin", (Object[])new Object[]{orgId_orgNameMap.get(l), info.getProtocolBillNo()});
                        msg.append(string).append('\n');
                    }
                    continue;
                }
                HashSet<Long> hashSet2 = new HashSet<Long>(1024);
                for (Long l : materialIds) {
                    if (!tarMaterialIds.contains(l)) continue;
                    hashSet2.add(l);
                }
                if (hashSet.size() > 0 && hashSet2.size() > 0) {
                    String string = this.getMaterialMalMsg(info.getMaterialId_materialNumberMap(), hashSet2);
                    for (Long orgId : hashSet) {
                        errmsg = ResManager.loadKDString((String)"\u7ec4\u7ec7{0}\u5df2\u5b58\u5728\u534f\u8bae\u7f16\u53f7\u4e3a{1}\u4e2d\uff0c\u90e8\u5206\u7269\u6599\u91cd\u590d\uff1a{2};", (String)"PmmPurPlanOrgChangeEdit_2", (String)"scm-pmm-formplugin", (Object[])new Object[]{orgId_orgNameMap.get(orgId), info.getProtocolBillNo(), string});
                        msg.append(errmsg).append('\n');
                    }
                }
                if (hashSet.size() <= 0 || hashSet2.size() != 0) continue;
                protocolIdLinkGoods.add(info.getProtocolID());
            }
        }
        if (null != protocolInfoAreas && protocolInfoAreas.size() > 0) {
            for (ProtocolInfo info : protocolInfoAreas) {
                if (null != info.getInvaliddate() && effectdate.after(info.getInvaliddate()) || null != effectdate && invaliddate.before(info.getEffectdate())) continue;
                Map purPlanId_orgId_materialIdsMap = info.getPurPlanId_orgId_materialIdsMap();
                List orgId_materialIds = info.getOrgId_materialIds();
                orgId_orgNameMap = info.getOrgId_orgNameMap();
                if (null == materialIds || materialIds.size() == 0) {
                    HashSet<Long> hashSet = new HashSet<Long>(104);
                    for (Map.Entry<Long, DynamicObject> entry : newOrgsMap.entrySet()) {
                        if (null == orgId_orgNameMap.get(entry.getKey()) || hashSet.contains(entry.getKey())) continue;
                        hashSet.add(entry.getKey());
                        String string = ResManager.loadKDString((String)"\u7ec4\u7ec7{0}\u5df2\u5b58\u5728\u534f\u8bae\u7f16\u53f7{1}\u4e2d\uff0c\u4e0d\u652f\u6301\u5b58\u5728\u591a\u4e2a\u65e0\u7269\u6599\u6e05\u5355\u3001\u6709\u7269\u6599\u6e05\u5355\u7684\u534f\u8bae;", (String)"PmmPurPlanOrgChangeEdit_8", (String)"scm-pmm-formplugin", (Object[])new Object[]{orgId_orgNameMap.get(entry.getKey()), info.getProtocolBillNo()});
                        msg.append(string).append('\n');
                    }
                }
                if (null == materialIds || materialIds.size() <= 0) continue;
                HashMap hashMap = new HashMap(1024);
                for (String string : orgId_materialIds) {
                    String[] stringArray = string.split("_");
                    long orgId = Long.parseLong(stringArray[0]);
                    long materialId = Long.parseLong(stringArray[1]);
                    if (null == newOrgsMap.get(Long.parseLong(stringArray[0]))) continue;
                    Set<Long> materialSet = new HashSet<Long>(1024);
                    if (!materialIds.contains(materialId)) continue;
                    if (null != hashMap.get(orgId)) {
                        materialSet = (Set)hashMap.get(orgId);
                    }
                    materialSet.add(materialId);
                    hashMap.put(orgId, materialSet);
                }
                HashSet hashSet = new HashSet(1024);
                for (Map.Entry entry : hashMap.entrySet()) {
                    if (((Set)entry.getValue()).size() > 0) {
                        String materialMalMsg = this.getMaterialMalMsg(info.getMaterialId_materialNumberMap(), (Set)entry.getValue());
                        errmsg = ResManager.loadKDString((String)"\u7ec4\u7ec7{0}\u5df2\u5b58\u5728\u534f\u8bae\u7f16\u53f7\u4e3a{1}\u4e2d\uff0c\u90e8\u5206\u7269\u6599\u91cd\u590d\uff1a{2};", (String)"PmmPurPlanOrgChangeEdit_2", (String)"scm-pmm-formplugin", (Object[])new Object[]{orgId_orgNameMap.get(entry.getKey()), info.getProtocolBillNo(), materialMalMsg});
                        msg.append(errmsg).append('\n');
                        continue;
                    }
                    hashSet.add(entry.getKey());
                }
                for (Map.Entry entry : purPlanId_orgId_materialIdsMap.entrySet()) {
                    for (String key3 : (List)entry.getValue()) {
                        String[] keys = key3.split("_");
                        long orgId = Long.parseLong(keys[0]);
                        if (!hashSet.contains(orgId)) continue;
                        purPlanIdLinkGoods.add(entry.getKey());
                        protocolIdLinkGoods.add(info.getProtocolID());
                    }
                }
            }
        }
        if (protocolIdLinkGoods.size() > 0) {
            QFilter qFilter = this.getQFilter(protocolIdLinkGoods);
            String selector = "protocol.id,purplan.id,protocolentry.id,entryentity.orgname,goods.number,protocol.billno";
            DynamicObjectCollection pmm_prodpools = QueryServiceHelper.query((String)"pmm_prodpool", (String)selector, (QFilter[])qFilter.toArray());
            HashMap protocolOrg_GoodsMap = new HashMap(1024);
            for (DynamicObject dynamicObject : pmm_prodpools) {
                long l = dynamicObject.getLong("purplan.id");
                if (0L == dynamicObject.getLong("entryentity.orgname") || 0L != l && !purPlanIdLinkGoods.contains(l) || null == newOrgsMap.get(dynamicObject.getLong("entryentity.orgname"))) continue;
                String string = dynamicObject.getLong("entryentity.orgname") + "_" + dynamicObject.getString("protocol.billno");
                List<String> goodsNumbers = new ArrayList<String>(1024);
                if (null != protocolOrg_GoodsMap.get(string)) {
                    goodsNumbers = (List)protocolOrg_GoodsMap.get(string);
                }
                goodsNumbers.add(dynamicObject.getString("goods.number"));
                protocolOrg_GoodsMap.put(string, goodsNumbers);
            }
            if (protocolOrg_GoodsMap.size() > 0) {
                for (Map.Entry entry : protocolOrg_GoodsMap.entrySet()) {
                    String[] stringArray = ((String)entry.getKey()).split("_");
                    String string = newOrgsMap.get(Long.parseLong(stringArray[0])).getString("name");
                    String string2 = stringArray[1];
                    String goodsMsg = this.getGoodsMsg((List)entry.getValue());
                    this.getGoodsMsg((List)entry.getValue());
                    errmsg = ResManager.loadKDString((String)"\u7ec4\u7ec7{0}\u5df2\u5b58\u5728\u534f\u8bae\u7f16\u53f7\u4e3a{1}\u4e2d\uff0c\u90e8\u5206\u5546\u54c1\u91cd\u590d\uff1a{2};", (String)"PmmPurPlanOrgChangeEdit_3", (String)"scm-pmm-formplugin", (Object[])new Object[]{string, string2, goodsMsg});
                    msg.append(errmsg).append('\n');
                }
            }
        }
        return msg.toString();
    }

    private String getGoodsMsg(List<String> goodsNumbers) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String goodsNo : goodsNumbers) {
            stringBuilder.append(goodsNo).append('\u3001');
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private String getMaterialMalMsg(Map<Long, String> getMaterialId_materialNumberMap, Set<Long> diffMaterialId) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Long id : diffMaterialId) {
            if (null == getMaterialId_materialNumberMap.get(id)) continue;
            stringBuilder.append(getMaterialId_materialNumberMap.get(id)).append('\u3001');
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private Set<Long> getMaterialIds(DynamicObject purPlan) {
        Long purPlanId = purPlan.getLong("id");
        HashSet<Long> materialIds = new HashSet<Long>(1024);
        if (purPlan.getBoolean("protocol.differentarea")) {
            QFilter qFilter1 = new QFilter("id", "=", (Object)purPlan.getLong("protocol.id"));
            String selector = "entryentity1.purplanid,entryentity1.purorg,entryentity1.material";
            DynamicObjectCollection pmm_protocols = QueryServiceHelper.query((String)"pmm_protocol", (String)selector, (QFilter[])qFilter1.toArray());
            for (DynamicObject row : pmm_protocols) {
                if (row.getLong("entryentity1.purplanid") != purPlanId.longValue()) continue;
                materialIds.add(row.getLong("entryentity1.material"));
            }
        } else {
            QFilter qFilter1 = new QFilter("id", "=", (Object)purPlan.getLong("protocol.id"));
            String selector = "entryentity1.material";
            DynamicObjectCollection pmm_protocols = QueryServiceHelper.query((String)"pmm_protocol", (String)selector, (QFilter[])qFilter1.toArray());
            for (DynamicObject row : pmm_protocols) {
                materialIds.add(row.getLong("entryentity1.material"));
            }
        }
        return materialIds;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (operateKey.equals("confirm") && args.getOperationResult().isSuccess()) {
            this.confirm();
            this.getView().close();
        }
    }

    private void confirm() {
        Long purPlanId;
        QFilter qFilter;
        DynamicObjectCollection purPlans;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("purplanid") && (purPlans = QueryServiceHelper.query((String)"pmm_purchaseplan", (String)"protocol.differentarea,id,protocol.id,entryentity.org", (QFilter[])(qFilter = new QFilter("id", "=", (Object)(purPlanId = Long.valueOf(Long.parseLong(String.valueOf(customParams.get("purplanid"))))))).toArray())).size() > 0) {
            Map<Long, DynamicObject> newOrgSet = this.getNewOrgSet(purPlans);
            if (newOrgSet.size() == 0) {
                return;
            }
            try (TXHandle t = TX.required();){
                this.writeProtocolEntry((DynamicObject)purPlans.get(0), newOrgSet.keySet());
                this.writeGoodsPool((DynamicObject)purPlans.get(0), newOrgSet.keySet());
                this.writePurPlan(purPlanId, newOrgSet.keySet());
            }
            catch (Exception e) {
                log.error(ExceptionUtil.getStackTrace((Throwable)e));
            }
        }
    }

    private void writePurPlan(Long purPlanId, Set<Long> diffOrgSet) {
        QFilter qFilter = new QFilter("id", "=", (Object)purPlanId);
        String selectors = "id,entryentity.org,entryentity.note";
        DynamicObject[] pmm_purchaseplans = BusinessDataServiceHelper.load((String)"pmm_purchaseplan", (String)selectors, (QFilter[])qFilter.toArray());
        String userName = RequestContext.get().getUserName();
        String date2str = DateUtil.date2str((Date)TimeServiceHelper.now(), (String)"yyyy-MM-dd HH:mm:ss");
        String addStr = ResManager.loadKDString((String)"\u65b0\u589e", (String)"PmmPurPlanOrgChangeEdit_5", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
        String note = date2str + "," + userName + addStr;
        for (DynamicObject prod : pmm_purchaseplans) {
            DynamicObjectCollection entryCol = prod.getDynamicObjectCollection("entryentity");
            for (Long orgId : diffOrgSet) {
                DynamicObject dynamicObject = entryCol.addNew();
                dynamicObject.set("org_id", (Object)orgId);
                dynamicObject.set("note", (Object)note);
            }
            prod.set("entryentity", (Object)entryCol);
        }
        if (pmm_purchaseplans.length > 0) {
            SaveServiceHelper.save((DynamicObject[])pmm_purchaseplans);
        }
    }

    private Map<Long, DynamicObject> getNewOrgSet(DynamicObjectCollection purPlans) {
        HashMap<Long, DynamicObject> newOrgIdMap = new HashMap<Long, DynamicObject>(1024);
        HashSet<Long> srcOrgIds = new HashSet<Long>(1024);
        for (DynamicObject row : purPlans) {
            srcOrgIds.add(row.getLong("entryentity.org"));
        }
        DynamicObjectCollection orgs = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        HashMap<Long, DynamicObject> orgIdMap = new HashMap<Long, DynamicObject>(1024);
        for (DynamicObject row : orgs) {
            if (null == row.get("org")) continue;
            orgIdMap.put(row.getLong("org.id"), row.getDynamicObject("org"));
        }
        for (Map.Entry map : orgIdMap.entrySet()) {
            if (srcOrgIds.contains(map.getKey())) continue;
            newOrgIdMap.put((Long)map.getKey(), (DynamicObject)map.getValue());
        }
        return newOrgIdMap;
    }

    private void writeGoodsPool(DynamicObject purPlan, Set<Long> diffOrgSet) {
        DynamicObject[] pmm_prodpools;
        Long protocolId = purPlan.getLong("protocol.id");
        Long purPlanId = purPlan.getLong("id");
        boolean differentarea = purPlan.getBoolean("protocol.differentarea");
        QFilter qFilter = new QFilter("protocol", "=", (Object)protocolId);
        if (differentarea) {
            qFilter.and(new QFilter("purplan", "=", (Object)purPlanId));
        }
        HashSet<Long> idSet = new HashSet<Long>(1024);
        String selectors = "id,entryentity.orgname";
        for (DynamicObject prod : pmm_prodpools = BusinessDataServiceHelper.load((String)"pmm_prodpool", (String)selectors, (QFilter[])qFilter.toArray())) {
            DynamicObjectCollection entryCol = prod.getDynamicObjectCollection("entryentity");
            for (Long orgId : diffOrgSet) {
                DynamicObject dynamicObject = entryCol.addNew();
                dynamicObject.set("orgname_id", (Object)orgId);
            }
            prod.set("entryentity", (Object)entryCol);
            idSet.add(prod.getLong("id"));
        }
        if (pmm_prodpools.length > 0) {
            SaveServiceHelper.save((DynamicObject[])pmm_prodpools);
            OperateOption saveOption = OperateOption.create();
            saveOption.setVariableValue("isStrict", "false");
            saveOption.setVariableValue("ishasright", "true");
            OperationResult soldResullt = OperationServiceHelper.executeOperate((String)"sold", (String)"pmm_prodpool", (Object[])idSet.toArray(new Object[0]), (OperateOption)saveOption);
            if (!soldResullt.isSuccess()) {
                log.info(ExceptionUtil.getErrorInfoDetails((List)soldResullt.getAllErrorOrValidateInfo()));
            }
        }
    }

    private void writeProtocolEntry(DynamicObject purPlan, Set<Long> diffOrgSet) {
        DynamicObject[] protocols;
        Long protocolId = purPlan.getLong("protocol.id");
        Long purPlanId = purPlan.getLong("id");
        QFilter qFilter = new QFilter("id", "=", (Object)protocolId);
        String selectors = DynamicObjectUtil.getSelectfields((String)"pmm_protocol", (boolean)false);
        selectors = DynamicObjectUtil.getEntrySelectfields((String)selectors, (String)"pmm_protocol", (String)"entryentity1", (boolean)false);
        selectors = DynamicObjectUtil.getEntrySelectfields((String)selectors, (String)"pmm_protocol", (String)"entryentity", (boolean)false);
        for (DynamicObject info : protocols = BusinessDataServiceHelper.load((String)"pmm_protocol", (String)selectors, (QFilter[])qFilter.toArray())) {
            DynamicObjectCollection entryCols = info.getDynamicObjectCollection("entryentity1");
            DynamicObjectCollection orgEntryCols = info.getDynamicObjectCollection("entryentity");
            if (info.getBoolean("differentarea")) {
                this.setDifferentAreaentrys(diffOrgSet, purPlanId, entryCols);
                continue;
            }
            for (Long orgId : diffOrgSet) {
                DynamicObject row = orgEntryCols.addNew();
                row.set("orgname_id", (Object)orgId);
            }
            info.set("entryentity", (Object)orgEntryCols);
        }
        if (protocols.length > 0) {
            SaveServiceHelper.save((DynamicObject[])protocols);
        }
    }

    private void setDifferentAreaentrys(Set<Long> diffOrgSet, Long purPlanId, DynamicObjectCollection entryCols) {
        HashMap pulanId_rowsMap = new HashMap(1024);
        for (Object row : entryCols) {
            String string = row.getString("purplanid.id");
            Long purOrgId = row.getLong("purorg.id");
            if (!purPlanId.equals(Long.parseLong(string))) continue;
            String key = string + String.valueOf(purOrgId);
            List<Object> rowCols = new ArrayList<Object>(1024);
            if (null != pulanId_rowsMap.get(key)) {
                rowCols = (List)pulanId_rowsMap.get(key);
            }
            rowCols.add(row);
            pulanId_rowsMap.put(key, rowCols);
        }
        List values = null;
        for (Map.Entry entry : pulanId_rowsMap.entrySet()) {
            values = (List)entry.getValue();
        }
        List entryAllPros = DynamicObjectUtil.getDynamicAllProperties((DynamicObject)((DynamicObject)entryCols.get(0)));
        for (Long orgId : diffOrgSet) {
            if (null == values) continue;
            for (DynamicObject row : values) {
                Map propertys = DynamicObjectUtil.object2MapByQuery((DynamicObject)row);
                DynamicObject dynamicObject = entryCols.addNew();
                for (Map.Entry mapEntry : propertys.entrySet()) {
                    if (!entryAllPros.contains(mapEntry.getKey())) continue;
                    dynamicObject.set((String)mapEntry.getKey(), mapEntry.getValue());
                }
                dynamicObject.set("purorg_id", (Object)orgId);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"org")) {
            HashSet<Long> allOrgIdsSet = new HashSet<Long>(1024);
            Set<Long> conflictOrgs = this.getConflictOrgs();
            Set<Long> entryOrgs = this.getCurrentEntryOrgs();
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            if (conflictOrgs.size() > 0) {
                allOrgIdsSet.addAll(conflictOrgs);
            }
            if (entryOrgs.size() > 0) {
                allOrgIdsSet.addAll(entryOrgs);
            }
            if (allOrgIdsSet.size() > 0) {
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", allOrgIdsSet));
            }
        }
    }

    private Set<Long> getConflictOrgs() {
        Long purPlanId;
        QFilter qFilter;
        DynamicObjectCollection purPlans;
        HashSet<Long> conflictOrgs = new HashSet<Long>(1024);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (null != customParams.get("purplanid") && (purPlans = QueryServiceHelper.query((String)"pmm_purchaseplan", (String)"id,protocol.invaliddate,protocol.effectdate,protocol.partyb,protocol.id,entryentity.org", (QFilter[])(qFilter = new QFilter("id", "=", (Object)(purPlanId = Long.valueOf(Long.parseLong(String.valueOf(customParams.get("purplanid"))))))).toArray())).size() > 0) {
            HashSet<Long> purPlanIds = new HashSet<Long>(1024);
            HashSet<Long> supIdSet = new HashSet<Long>(1024);
            supIdSet.add(((DynamicObject)purPlans.get(0)).getLong("protocol.partyb"));
            PmmProtocolValidatorService service = new PmmProtocolValidatorService();
            ArrayList protocolInfoList = service.getProtocolList(supIdSet);
            conflictOrgs.addAll(this.getOrgsByOrgConflict((DynamicObject)purPlans.get(0), purPlanIds, protocolInfoList));
            conflictOrgs.addAll(this.getConflictOrgsEntry((DynamicObject)purPlans.get(0), purPlanIds, protocolInfoList));
        }
        log.info("conflictOrgs=" + SerializationUtils.toJsonString(conflictOrgs));
        return conflictOrgs;
    }

    private Set<Long> getOrgsByOrgConflict(DynamicObject dynamicObject, Set<Long> purPlanIds, ArrayList<ProtocolInfo> protocolInfoList) {
        HashSet<Long> conflictOrgs = new HashSet<Long>(1024);
        List<Long> protocolIds = this.getProtocolListByOrgConflict(dynamicObject, purPlanIds, protocolInfoList);
        log.info("getOrgsByOrgConflict+protocolIds=" + SerializationUtils.toJsonString(protocolIds));
        log.info("getOrgsByOrgConflict+purPlanIds=" + SerializationUtils.toJsonString(purPlanIds));
        Set<Long> orgIdsByGoodsPool = this.getOrgsByGoodsPool(new HashSet<Long>(protocolIds), purPlanIds);
        conflictOrgs.addAll(orgIdsByGoodsPool);
        log.info("getOrgsByOrgConflict+conflictOrgs=" + SerializationUtils.toJsonString(conflictOrgs));
        return conflictOrgs;
    }

    private Set<Long> getConflictOrgsEntry(DynamicObject purPlan, Set<Long> purPlanIds, ArrayList<ProtocolInfo> protocolInfoList) {
        HashSet<Long> conflictOrgs = new HashSet<Long>(1024);
        List<Long> protocolIds = this.getProtocolList(purPlan, purPlanIds, protocolInfoList);
        log.info("protocolIds=" + SerializationUtils.toJsonString(protocolIds));
        log.info("purPlanIds=" + SerializationUtils.toJsonString(purPlanIds));
        Set<Long> orgIdsByProtocol = this.getOrgIdsByProtocol(new HashSet<Long>(protocolIds));
        conflictOrgs.addAll(orgIdsByProtocol);
        log.info("orgIdsByProtocol=" + SerializationUtils.toJsonString(orgIdsByProtocol));
        Set<Long> orgIdsByDifferentAreaProtocol = this.getOrgIdsByDifferentAreaProtocol(new HashSet<Long>(protocolIds), purPlanIds);
        conflictOrgs.addAll(orgIdsByDifferentAreaProtocol);
        log.info("orgIdsByDifferentAreaProtocol=" + SerializationUtils.toJsonString(orgIdsByDifferentAreaProtocol));
        return conflictOrgs;
    }

    private Set<Long> getOrgIdsByDifferentAreaProtocol(Set<Long> protocolIds, Set<Long> purPlanIds) {
        HashSet<Long> orgIds = new HashSet<Long>(1024);
        QFilter qFilter = new QFilter("id", "in", protocolIds);
        String selectors = "entryentity1.purorg,entryentity1.purplanid,differentarea";
        DynamicObjectCollection pmm_protocols = QueryServiceHelper.query((String)"pmm_protocol", (String)selectors, (QFilter[])qFilter.toArray());
        for (DynamicObject info : pmm_protocols) {
            if (!info.getBoolean("differentarea") || !purPlanIds.contains(info.getLong("entryentity1.purplanid"))) continue;
            orgIds.add(info.getLong("entryentity1.purorg"));
        }
        return orgIds;
    }

    private Set<Long> getOrgIdsByProtocol(Set<Long> protocolIds) {
        HashSet<Long> orgIds = new HashSet<Long>(1024);
        QFilter qFilter = new QFilter("id", "in", protocolIds);
        qFilter.and(new QFilter("purmode", "!=", (Object)"1"));
        String selectors = "entryentity.orgname,differentarea";
        DynamicObjectCollection pmm_protocols = QueryServiceHelper.query((String)"pmm_protocol", (String)selectors, (QFilter[])qFilter.toArray());
        for (DynamicObject info : pmm_protocols) {
            if (info.getBoolean("differentarea") || 0L == info.getLong("entryentity.orgname")) continue;
            orgIds.add(info.getLong("entryentity.orgname"));
        }
        return orgIds;
    }

    private QFilter getQFilter(Set<Long> protocolIds) {
        QFilter qFilter = new QFilter("protocol.id", "in", protocolIds);
        QFilter saleStatusQFilter = new QFilter("salestatus", "=", (Object)"A");
        saleStatusQFilter.or(new QFilter("salestatus", "=", (Object)"C"));
        qFilter.and(saleStatusQFilter);
        QFilter malStatusQFilter = new QFilter("salestatus", "=", (Object)"A");
        malStatusQFilter.or(new QFilter("mallstatus", "=", (Object)"B"));
        malStatusQFilter.or(new QFilter("mallstatus", "=", (Object)"F"));
        qFilter.and(malStatusQFilter);
        return qFilter;
    }

    private Set<Long> getOrgsByGoodsPool(Set<Long> protocolIds, Set<Long> purPlanIds) {
        QFilter qFilter = this.getQFilter(protocolIds);
        String selector = "protocol.id,purplan.id,protocolentry.id,entryentity.orgname";
        DynamicObjectCollection pmm_prodpools = QueryServiceHelper.query((String)"pmm_prodpool", (String)selector, (QFilter[])qFilter.toArray());
        HashSet<Long> orgIds = new HashSet<Long>(1024);
        for (DynamicObject row : pmm_prodpools) {
            long purPlanId = row.getLong("purplan.id");
            if (0L == row.getLong("entryentity.orgname") || 0L != purPlanId && !purPlanIds.contains(purPlanId)) continue;
            orgIds.add(row.getLong("entryentity.orgname"));
        }
        return orgIds;
    }

    private List<Long> getProtocolList(DynamicObject purPlan, Set<Long> purPlanIds, ArrayList<ProtocolInfo> protocolInfoList) {
        Date invaliddate = purPlan.getDate("protocol.invaliddate");
        Date effectdate = purPlan.getDate("protocol.effectdate");
        Long purPlanId = purPlan.getLong("id");
        ArrayList<Long> newProtocolInfoIdList = new ArrayList<Long>(1024);
        ProtocolInfo currentInfo = null;
        long curProtocolId = purPlan.getLong("protocol.id");
        List materialIds = new ArrayList(1024);
        for (ProtocolInfo info : protocolInfoList) {
            if (info.getProtocolID() != curProtocolId) continue;
            currentInfo = info;
            materialIds = currentInfo.getMaterialIds();
            break;
        }
        if (null != currentInfo && Boolean.parseBoolean(currentInfo.getDifferentAreaEntry())) {
            materialIds = (List)currentInfo.getPurPlanId_MaterialIdsMap().get(purPlanId);
        }
        block1: for (ProtocolInfo info : protocolInfoList) {
            if (info.getProtocolID() == curProtocolId || info.getInvaliddate().before(effectdate) || info.getEffectdate().after(invaliddate)) continue;
            if (null != materialIds && materialIds.size() > 0) {
                if (Boolean.parseBoolean(info.getDifferentAreaEntry())) {
                    Map purPlanId_materialIdsMap = info.getPurPlanId_MaterialIdsMap();
                    block2: for (Map.Entry map : purPlanId_materialIdsMap.entrySet()) {
                        List tarMaterialIds = (List)map.getValue();
                        for (Long materialId : materialIds) {
                            if (!tarMaterialIds.contains(materialId)) continue;
                            newProtocolInfoIdList.add(info.getProtocolID());
                            purPlanIds.add((Long)map.getKey());
                            continue block2;
                        }
                    }
                    continue;
                }
                List tarMaterialIds = info.getMaterialIds();
                if (null == tarMaterialIds || tarMaterialIds.size() == 0) {
                    newProtocolInfoIdList.add(info.getProtocolID());
                    continue;
                }
                for (Long materialId : materialIds) {
                    if (!tarMaterialIds.contains(materialId)) continue;
                    newProtocolInfoIdList.add(info.getProtocolID());
                    continue block1;
                }
                continue;
            }
            newProtocolInfoIdList.add(info.getProtocolID());
        }
        return newProtocolInfoIdList;
    }

    private List<Long> getProtocolListByOrgConflict(DynamicObject purPlan, Set<Long> purPlanIds, ArrayList<ProtocolInfo> protocolInfoList) {
        Date invaliddate = purPlan.getDate("protocol.invaliddate");
        Date effectdate = purPlan.getDate("protocol.effectdate");
        Long purPlanId = purPlan.getLong("id");
        ArrayList<Long> newProtocolInfoIdList = new ArrayList<Long>(1024);
        Object currentInfo = null;
        long curProtocolId = purPlan.getLong("protocol.id");
        List materialIds = new ArrayList(1024);
        List<Long> curOrgIds = new ArrayList(1024);
        for (ProtocolInfo protocolInfo : protocolInfoList) {
            if (protocolInfo.getProtocolID() != curProtocolId) continue;
            materialIds = protocolInfo.getMaterialIds();
            curOrgIds = protocolInfo.getOrgIds();
            break;
        }
        if (null != currentInfo && Boolean.parseBoolean(currentInfo.getDifferentAreaEntry())) {
            List curOrgId_materialIds = (List)currentInfo.getPurPlanId_orgId_materialIdsMap().get(purPlanId);
            curOrgIds = new ArrayList(1024);
            for (String key : curOrgId_materialIds) {
                String[] keys = key.split("_");
                curOrgIds.add(Long.parseLong(keys[0]));
            }
            materialIds = (List)currentInfo.getPurPlanId_MaterialIdsMap().get(purPlanId);
        }
        for (ProtocolInfo protocolInfo : protocolInfoList) {
            if (protocolInfo.getProtocolID() == curProtocolId || protocolInfo.getInvaliddate().before(effectdate) || protocolInfo.getEffectdate().after(invaliddate)) continue;
            if (Boolean.parseBoolean(protocolInfo.getDifferentAreaEntry())) {
                Map purPlanId_orgId_materialIdsMap = protocolInfo.getPurPlanId_orgId_materialIdsMap();
                if (null == materialIds || materialIds.size() == 0) {
                    newProtocolInfoIdList.add(protocolInfo.getProtocolID());
                    purPlanIds.addAll(purPlanId_orgId_materialIdsMap.keySet());
                    continue;
                }
                for (Map.Entry entry : purPlanId_orgId_materialIdsMap.entrySet()) {
                    List orgId_materialIds = (List)entry.getValue();
                    boolean iscontinue = true;
                    for (Long materialId : materialIds) {
                        if (!orgId_materialIds.contains(String.valueOf(materialId))) continue;
                        iscontinue = false;
                        break;
                    }
                    if (!iscontinue) continue;
                    for (Long orgId : curOrgIds) {
                        if (!orgId_materialIds.contains(String.valueOf(orgId))) continue;
                        newProtocolInfoIdList.add(protocolInfo.getProtocolID());
                        purPlanIds.add((Long)entry.getKey());
                    }
                }
                continue;
            }
            if (null == materialIds || materialIds.size() == 0) {
                newProtocolInfoIdList.add(protocolInfo.getProtocolID());
                continue;
            }
            List tarMaterialIds = protocolInfo.getMaterialIds();
            List tarOrgIds = protocolInfo.getOrgIds();
            if (null == tarMaterialIds || tarMaterialIds.size() == 0) continue;
            boolean bl = true;
            for (Long materialId : materialIds) {
                if (!tarMaterialIds.contains(materialId)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            for (Long orgId : curOrgIds) {
                if (!tarOrgIds.contains(orgId)) continue;
                newProtocolInfoIdList.add(protocolInfo.getProtocolID());
            }
        }
        return newProtocolInfoIdList;
    }

    private Set<Long> getCurrentEntryOrgs() {
        HashSet<Long> orgs = new HashSet<Long>(1024);
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject row : entryCol) {
            if (null == row.get("org")) continue;
            orgs.add(row.getLong("org.id"));
        }
        log.info("orgs=" + SerializationUtils.toJsonString(orgs));
        return orgs;
    }
}

