/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.edit;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Container;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.url.UrlService;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.malcore.enums.MallStatusEnum;
import kd.scm.malcore.enums.SaleStatusEnum;
import kd.scm.pmm.common.util.PmmGoodsUtil;

public class ScenarioSchemeEditPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit goodsEdit = (BasedataEdit)this.getControl("goods");
        goodsEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit scenariotag = (BasedataEdit)this.getControl("scenariotag");
        scenariotag.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"btn_updateimg"});
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        if (this.getModel().getDataEntity(true).getDynamicObjectCollection("tag_entryentity").size() > 0) {
            String msg = ResManager.loadKDString((String)"\u80cc\u666f\u56fe\u4e2d\u5df2\u5b58\u5728\u951a\u70b9\u6807\u7b7e\uff0c\u66ff\u6362\u56fe\u7247\u5c06\u5220\u9664\u5df2\u8bbe\u7f6e\u7684\u6807\u7b7e\u53ca\u5173\u8054\u7684\u5546\u54c1\u3002\u786e\u8ba4\u8981\u66ff\u6362\u5417\uff1f", (String)"ScenarioSchemeEditPlugin_6", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("updateimg"));
        } else {
            this.showUpateWindow();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        String fieldKey = arg0.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"goods")) {
            DynamicObjectCollection entryentityCol = this.getModel().getEntryEntity("entryentity");
            Long tagid = null;
            if (this.getModel().getValue("scenariotag", arg0.getRow()) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u6807\u7b7e\u5b57\u6bb5\u3002", (String)"ScenarioSchemeEditPlugin_5", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                arg0.setCancel(true);
                return;
            }
            tagid = ((DynamicObject)this.getModel().getValue("scenariotag", arg0.getRow())).getLong("id");
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            showParameter.setMultiSelect(true);
            qFilters.clear();
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", this.getModel().getEntryCurrentRowIndex("entryentity"));
            if (entryRowEntity.getString("source").equalsIgnoreCase("pmm_prodmanage")) {
                qFilters.add(new QFilter("protocolentry.prodpool.mallstatus", "=", (Object)MallStatusEnum.SOLD.getVal()).and(new QFilter("source", "=", (Object)"1")));
                qFilters.add(new QFilter("protocolentry.prodpool.salestatus", "=", (Object)SaleStatusEnum.SALE.getVal()).or(new QFilter("protocolentry.prodpool.salestatus", "=", (Object)SaleStatusEnum.PARTSALE.getVal())));
            } else {
                QFilter filter = new QFilter("statusinfo.mallstatus", "=", (Object)"1");
                qFilters.add(filter);
            }
            ArrayList<Long> prodList = new ArrayList<Long>(entryentityCol.size());
            for (DynamicObject dyn : entryentityCol) {
                DynamicObject goods = (DynamicObject)dyn.get("goods");
                if (null == goods || tagid == null || !tagid.equals(dyn.getLong("scenariotag.id"))) continue;
                prodList.add(goods.getLong("id"));
            }
            qFilters.add(new QFilter("id", "not in", prodList));
            this.setF7OpenStyle(showParameter);
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"scenariotag")) {
            DynamicObjectCollection entryentityCol = this.getModel().getEntryEntity("tag_entryentity");
            ArrayList<Long> prodList = new ArrayList<Long>(entryentityCol.size());
            for (DynamicObject dyn : entryentityCol) {
                DynamicObject goods = (DynamicObject)dyn.get("tag");
                if (null == goods) continue;
                prodList.add(goods.getLong("id"));
            }
            Iterator showParameter = (ListShowParameter)arg0.getFormShowParameter();
            List qFilters = showParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("id", "in", prodList));
        }
    }

    private void setF7OpenStyle(ListShowParameter showParameter) {
        showParameter.setCustomParam("ismergerows", (Object)true);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("1152px");
        styleCss.setHeight("696px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        HashSet<String> hideFields = new HashSet<String>(8);
        hideFields.add("status");
        hideFields.add("prodmatmappingstatus");
        hideFields.add("protocol.effectdate");
        hideFields.add("protocol.invaliddate");
        showParameter.setCustomParam("hideFields", (Object)SerializationUtils.toJsonString(hideFields));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if ("updateimg".equals(e.getCallBackId()) && MessageBoxResult.Yes.equals((Object)e.getResult())) {
            this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").clear();
            this.getModel().getDataEntity(true).getDynamicObjectCollection("tag_entryentity").clear();
            this.deleteAllTag();
            this.getView().updateView();
            this.showUpateWindow();
        } else if ("deletegoodsentry".equals(e.getCallBackId())) {
            String tagstr = this.getPageCache().get("deletetags");
            String[] tags = tagstr.split("@@");
            ArrayList<Long> tagids = new ArrayList<Long>();
            for (String id : tags) {
                if (!kd.bos.util.StringUtils.isNotEmpty((String)id)) continue;
                tagids.add(Long.parseLong(id));
            }
            if (MessageBoxResult.Yes.equals((Object)e.getResult())) {
                this.deleteTagAndGoodsEntry(tagids);
            } else {
                DynamicObjectCollection goodsEntrys = this.getModel().getEntryEntity("entryentity");
                for (DynamicObject goodsEntry : goodsEntrys) {
                    Long tagid;
                    if (goodsEntry.get("scenariotag") == null || !tagids.contains(tagid = Long.valueOf(goodsEntry.getLong("scenariotag.id")))) continue;
                    goodsEntry.set("goods", null);
                    goodsEntry.set("goodsneme", null);
                    goodsEntry.set("category", null);
                    goodsEntry.set("unit", null);
                    goodsEntry.set("picture", null);
                    goodsEntry.set("taxprice", null);
                    goodsEntry.set("supplier", null);
                }
            }
            this.getPageCache().remove("deletetags");
            this.getView().updateView("entryentity");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "insertentry": {
                Object scenarioimg = this.getModel().getValue("scenarioimg");
                if (StringUtils.isBlank((Object)scenarioimg)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u573a\u666f\u80cc\u666f\u56fe\uff0c\u8bbe\u7f6e\u6807\u7b7e\u540e\u518d\u63d2\u5165\u5546\u54c1\u3002", (String)"ScenarioSchemeEditPlugin_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows == null || selectRows.length <= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u9009\u4e2d\u4e00\u884c\uff0c\u63d2\u5165\u540c\u6807\u7b7e\u4e0b\u7684\u5176\u4ed6\u5546\u54c1\u3002", (String)"ScenarioSchemeEditPlugin_7", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "deletegoodsentry": {
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows != null && selectRows.length != 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ScenarioSchemeEditPlugin_9", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "delete": {
                this.deleteAllTag();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey;
        super.afterDoOperation(args);
        switch (operateKey = ((AbstractOperate)args.getSource()).getOperateKey()) {
            case "insertentry": {
                this.insertGoodsEntry();
                break;
            }
            case "deletegoodsentry": {
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                int[] selectRows = entryGrid.getSelectRows();
                this.deleteGoodsEntry(selectRows);
                break;
            }
            case "delete": {
                if (!args.getOperationResult().isSuccess()) break;
                this.deleteAllTag();
                break;
            }
            case "save": 
            case "submit": {
                if (!args.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("refresh");
                break;
            }
        }
        if (!("refresh".equals(operateKey) || "save".equals(operateKey) || "submit".equals(operateKey))) {
            CustomControl customcontrol = (CustomControl)this.getView().getControl("imageaddtag");
            customcontrol.setData(null);
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.fillGoodsEntryInfo();
    }

    private List getTagList() {
        DynamicObject info = this.getModel().getDataEntity(true);
        DynamicObjectCollection tagentrys = info.getDynamicObjectCollection("tag_entryentity");
        ArrayList tagList = new ArrayList();
        for (DynamicObject entry : tagentrys) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            if (entry.getDynamicObject("tag") != null) {
                data.put("tagid", entry.getDynamicObject("tag").getPkValue().toString());
                data.put("tagname", entry.getDynamicObject("tag").get("name").toString());
            }
            data.put("left", Integer.parseInt(entry.getString("left")));
            data.put("top", Integer.parseInt(entry.getString("top")));
            tagList.add(data);
        }
        return tagList;
    }

    private List getTagNames() {
        DynamicObject info = this.getModel().getDataEntity(true);
        DynamicObjectCollection tagentrys = info.getDynamicObjectCollection("tag_entryentity");
        ArrayList<String> tagList = new ArrayList<String>(tagentrys.size());
        for (DynamicObject entry : tagentrys) {
            if (entry.getDynamicObject("tag") == null) continue;
            tagList.add(entry.getDynamicObject("tag").get("name").toString());
        }
        return tagList;
    }

    public void afterBindData(EventObject e) {
        DynamicObject info;
        Container flexPanel;
        super.afterBindData(e);
        String url = null;
        if (this.getModel().getValue("scenarioimg") != null) {
            url = this.getUrl(this.getModel().getValue("scenarioimg").toString());
        }
        if ((flexPanel = (Container)this.getView().getControl("flexpanelap")) != null) {
            flexPanel.setBackgroundImg(url);
        }
        if ((info = this.getModel().getDataEntity(true)).getPkValue() != null && this.getView().getPageCache().get("isfirstLoad") != null) {
            List datas = this.getTagList();
            CustomControl customcontrol = (CustomControl)this.getView().getControl("imageaddtag");
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("tagdata", datas);
            data.put("isshowtag", "true");
            customcontrol.setData(data);
            this.getView().getPageCache().remove("isfirstLoad");
        }
        DateRangeEdit dateRangeEdit = (DateRangeEdit)this.getControl("validityperiod");
        dateRangeEdit.setMinDate(new Date());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        model.setValue("validityperiodfrom", (Object)new Date());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(2, 11);
        calendar.set(1, 2099);
        calendar.set(5, 31);
        model.setValue("validityperiodto", (Object)calendar.getTime());
    }

    public void loadData(LoadDataEventArgs e) {
        super.loadData(e);
        this.getView().getPageCache().put("isfirstLoad", "true");
    }

    public void customEvent(CustomEventArgs e) {
        String status;
        super.customEvent(e);
        if (this.getModel().getValue("status") != null && ((status = this.getModel().getValue("status").toString()).equalsIgnoreCase("B") || status.equalsIgnoreCase("C"))) {
            return;
        }
        Object scenarioimg = this.getModel().getValue("scenarioimg");
        if (StringUtils.isBlank((Object)scenarioimg)) {
            this.showUpateWindow();
        } else if ("addtag".equals(e.getEventName())) {
            this.doTag(e);
        } else if ("tagclick".equals(e.getEventName())) {
            String eventArgs = e.getEventArgs();
            Map data = (Map)JSON.parseObject((String)eventArgs, Map.class);
            if (StringUtils.isBlank(data.get("tagid"))) {
                return;
            }
            String tagid = data.get("tagid").toString();
            DynamicObject tagentry = this.getTag(tagid);
            if (tagentry == null) {
                return;
            }
            DynamicObject tag = tagentry.getDynamicObject("tag");
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("pmm_tagadd");
            parameter.setShowTitle(false);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.getOpenStyle().setTargetKey("imageaddtag");
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "tagnameedit"));
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            if (null != tag) {
                this.getPageCache().put("curtagid", tag.getString("id"));
                customParams.put("tagid", tag.getString("id"));
                customParams.put("tagname", tag.getString("name"));
                if (this.hasGoods(tag.getLong("id"))) {
                    customParams.put("hasGoods", "true");
                }
                customParams.put("tagnames", this.getTagNames());
            }
            parameter.setCustomParams(customParams);
            HashMap<String, String> panalParams = new HashMap<String, String>();
            panalParams.put("elementId", "tagpanal");
            parameter.getOpenStyle().setCustParam(panalParams);
            this.getView().showForm(parameter);
        }
    }

    private DynamicObject getTag(String tagid) {
        DynamicObject tag = null;
        DynamicObjectCollection tagEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("tag_entryentity");
        for (DynamicObject tagEntry : tagEntrys) {
            if (tagEntry.getDynamicObject("tag") == null || !tagid.equals(tagEntry.getDynamicObject("tag").getPkValue().toString())) continue;
            tag = tagEntry;
            break;
        }
        return tag;
    }

    private void showUpateWindow() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setFormId("pmm_uploadimage");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "scenarioimg"));
        this.getView().showForm(parameter);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
    }

    public void click(EventObject evt) {
        super.click(evt);
    }

    private void doTag(CustomEventArgs e) {
        String eventArgs = e.getEventArgs();
        Map data = (Map)JSON.parseObject((String)eventArgs, Map.class);
        BigDecimal leftbig = new BigDecimal(data.get("left").toString());
        BigDecimal topbig = new BigDecimal(data.get("top").toString());
        int left = leftbig.intValue();
        int top = topbig.intValue();
        if (left > 1151 && top > 332) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u533a\u57df\u4e0d\u80fd\u8bbe\u7f6e\u6807\u7b7e\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u533a\u57df\u3002", (String)"ScenarioSchemeEditPlugin_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return;
        }
        List tagNameList = this.getTagNames();
        this.getView().getPageCache().put("left", left + "");
        this.getView().getPageCache().put("top", top + "");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("pmm_tagadd");
        parameter.setShowTitle(false);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.getOpenStyle().setTargetKey("imageaddtag");
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addtag"));
        HashMap<String, List> customParams = new HashMap<String, List>();
        customParams.put("tagnames", tagNameList);
        parameter.setCustomParams(customParams);
        HashMap<String, String> panalParams = new HashMap<String, String>();
        panalParams.put("elementId", "tagpanal");
        parameter.getOpenStyle().setCustParam(panalParams);
        this.getView().showForm(parameter);
    }

    private boolean hasGoods(Long tagid) {
        boolean hasGoods = false;
        DynamicObjectCollection tagEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject goodsEntry : tagEntrys) {
            if (goodsEntry.getDynamicObject("scenariotag") == null || !tagid.equals(goodsEntry.getLong("scenariotag.id"))) continue;
            hasGoods = true;
            break;
        }
        return hasGoods;
    }

    private void addtagentry(DynamicObject tagvalue) {
        DynamicObject entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").addNew();
        entry.set("scenariotag", (Object)tagvalue);
        this.getView().updateView("entryentity");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String property = e.getProperty().getName();
        ChangeData[] changedData = e.getChangeSet();
        if ("goods".equals(property)) {
            this.doGoodsChange(changedData);
        } else if ("source".equals(property)) {
            for (ChangeData data : changedData) {
                int rowIndex = data.getRowIndex();
                this.clear(rowIndex);
            }
        } else if ("tag".equals(property)) {
            this.addtagentry((DynamicObject)changedData[0].getNewValue());
        }
    }

    private void doGoodsChange(ChangeData[] changedData) {
        ArrayList<Long> goodsIds = new ArrayList<Long>(changedData.length);
        int rowIndex = changedData[0].getRowIndex();
        for (ChangeData data : changedData) {
            DynamicObject newValue = (DynamicObject)data.getNewValue();
            if (newValue == null) {
                this.clear(rowIndex);
                continue;
            }
            goodsIds.add(((DynamicObject)data.getNewValue()).getLong("id"));
        }
        String source = this.getModel().getValue("source", rowIndex).toString();
        if (rowIndex > 0 && StringUtils.isBlank((CharSequence)source)) {
            source = (String)this.getModel().getValue("source", rowIndex - 1);
        }
        Map goodsMap = null;
        if ("pbd_mallgoods".equals(source)) {
            String mallSelector = "id,number,name,group.id,group.name,mainpic,unitid.id,unitid.name,priceinfo.price,source";
            goodsMap = PmmGoodsUtil.getGoodsDynMap(null, goodsIds, null, (String)mallSelector);
        } else {
            String selfSelector = "id,number,name,source,category.id,category.name,thumbnail,unit.id,unit.name,taxprice,supplier.id,supplier.name,curr,curr.name";
            goodsMap = PmmGoodsUtil.getGoodsDynMap(goodsIds, null, (String)selfSelector, null);
        }
        for (ChangeData data : changedData) {
            DynamicObject newValue = (DynamicObject)data.getNewValue();
            if (newValue == null) continue;
            DynamicObject goodsData = (DynamicObject)goodsMap.get(newValue.getPkValue());
            rowIndex = data.getRowIndex();
            this.setGoodsDataValue((DynamicObject)data.getNewValue(), goodsData, rowIndex);
        }
        this.getView().updateView("entryentity");
        this.getModel().setValue("malgoodscount", (Object)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").size());
    }

    private void clear(int rowIndex) {
        IDataModel model = this.getModel();
        model.setValue("goodsneme", null, rowIndex);
        model.setValue("category", null, rowIndex);
        model.setValue("unit", null, rowIndex);
        model.setValue("picture", null, rowIndex);
        model.setValue("taxprice", null, rowIndex);
        model.setValue("supplier", null, rowIndex);
    }

    private void fillGoodsEntryInfo() {
        DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        ArrayList<Long> selfGoodsIds = new ArrayList<Long>(entryCol.size());
        ArrayList<Long> ecGoodsIds = new ArrayList<Long>(entryCol.size());
        for (DynamicObject entry : entryCol) {
            Long goodsId = entry.getLong("goods.id");
            String source = entry.getString("source");
            if (!StringUtils.isNotBlank((CharSequence)source)) continue;
            if ("pmm_prodmanage".equals(source)) {
                selfGoodsIds.add(goodsId);
                continue;
            }
            ecGoodsIds.add(goodsId);
        }
        String mallSelector = " id, name,unitid.name unit.name,mainpic thumbnail,source,priceinfo.price shopprice, group.name categoryname";
        String selfSelector = "id,name,unit.name,supplier.name,thumbnail,shopprice,category.name categoryname";
        Map goodsMap = PmmGoodsUtil.getGoodsDynMap(selfGoodsIds, ecGoodsIds, (String)selfSelector, (String)mallSelector);
        for (DynamicObject entry : entryCol) {
            String malsource;
            String source = entry.getString("source");
            DynamicObject goodsEntry = (DynamicObject)goodsMap.get(entry.getLong("goods.id"));
            if (goodsEntry == null) continue;
            if ("pmm_prodmanage".equals(source)) {
                entry.set("goodsneme", (Object)goodsEntry.getString("name"));
                entry.set("unit", (Object)goodsEntry.getString("unit.name"));
                entry.set("picture", (Object)goodsEntry.getString("thumbnail"));
                entry.set("taxprice", goodsEntry.get("shopprice"));
                entry.set("category", goodsEntry.get("categoryname"));
                entry.set("supplier", (Object)goodsEntry.getString("supplier.name"));
                continue;
            }
            HashMap<String, String> sourceToSupplierNameMap = new HashMap<String, String>(16);
            entry.set("goodsneme", (Object)goodsEntry.getString("name"));
            entry.set("unit", (Object)goodsEntry.getString("unit.name"));
            entry.set("picture", (Object)goodsEntry.getString("thumbnail"));
            entry.set("taxprice", goodsEntry.get("shopprice"));
            entry.set("category", goodsEntry.get("categoryname"));
            String supplierName = (String)sourceToSupplierNameMap.get(goodsEntry.getString("source"));
            if (StringUtils.isBlank((CharSequence)supplierName) && StringUtils.isNotBlank((CharSequence)(malsource = goodsEntry.getString("source")))) {
                supplierName = EcApiUtil.getMalName((String)malsource);
                sourceToSupplierNameMap.put(malsource, supplierName);
            }
            entry.set("supplier", (Object)supplierName);
        }
        this.getView().updateView("entryentity");
    }

    private void setGoodsDataValue(DynamicObject newValue, DynamicObject goodsData, int rowIndex) {
        String source;
        IDataModel model = this.getModel();
        if (rowIndex > 0 && StringUtils.isBlank((Object)model.getValue("source", rowIndex))) {
            model.setValue("source", model.getValue("source", rowIndex - 1), rowIndex);
        }
        if (model.getValue("goods", rowIndex) == null) {
            model.setValue("goods", (Object)newValue, rowIndex);
        }
        if ("pbd_mallgoods".equals(source = model.getValue("source", rowIndex).toString())) {
            model.setValue("goodsneme", (Object)goodsData.getString("name"), rowIndex);
            model.setValue("category", (Object)goodsData.getString("group.name"), rowIndex);
            model.setValue("unit", (Object)goodsData.getString("unitid.name"), rowIndex);
            model.setValue("picture", (Object)goodsData.getString("mainpic"), rowIndex);
            model.setValue("taxprice", (Object)goodsData.getBigDecimal("priceinfo.price"), rowIndex);
            String supplierName = null;
            source = goodsData.getString("source");
            if (StringUtils.isNotBlank((CharSequence)source)) {
                supplierName = EcApiUtil.getMalName((String)source);
            }
            model.setValue("supplier", (Object)supplierName, rowIndex);
            if (rowIndex > 0 && model.getValue("scenariotag", rowIndex) == null) {
                model.setValue("scenariotag", model.getValue("scenariotag", rowIndex - 1), rowIndex);
                model.setValue("scenariotag_id", model.getValue("scenariotag_id", rowIndex - 1), rowIndex);
            }
        } else if ("pmm_prodmanage".equals(source)) {
            model.setValue("goodsneme", (Object)goodsData.getString("name"), rowIndex);
            model.setValue("category", (Object)goodsData.getString("category.name"), rowIndex);
            model.setValue("unit", (Object)goodsData.getString("unit.name"), rowIndex);
            model.setValue("picture", (Object)goodsData.getString("thumbnail"), rowIndex);
            model.setValue("taxprice", (Object)goodsData.getBigDecimal("taxprice"), rowIndex);
            model.setValue("supplier", (Object)goodsData.getString("supplier.name"), rowIndex);
            model.setValue("source", (Object)source, rowIndex);
            if (rowIndex > 0 && model.getValue("scenariotag", rowIndex) == null) {
                model.setValue("scenariotag", model.getValue("scenariotag", rowIndex - 1), rowIndex);
                model.setValue("scenariotag_id", model.getValue("scenariotag_id", rowIndex - 1), rowIndex);
            }
        }
    }

    private void deleteTagAndGoodsEntry(List<Long> detatetagids) {
        DynamicObjectCollection goodsEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        Iterator goodsEntrysit = goodsEntrys.iterator();
        while (goodsEntrysit.hasNext()) {
            Long tagid;
            DynamicObject goodsEntry = (DynamicObject)goodsEntrysit.next();
            if (goodsEntry.get("scenariotag") == null || !detatetagids.contains(tagid = Long.valueOf(goodsEntry.getLong("scenariotag.id")))) continue;
            goodsEntrysit.remove();
        }
        this.deleteTag(detatetagids);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object obj;
        if ("addtag".equals(e.getActionId())) {
            Object obj2 = e.getReturnData();
            if (obj2 != null) {
                Map returnData = (Map)obj2;
                String left = this.getView().getPageCache().get("left");
                String top = this.getView().getPageCache().get("top");
                if (returnData.get("isaddtag") != null && "true".equals(returnData.get("isaddtag").toString()) && !StringUtils.isBlank((CharSequence)left) && !StringUtils.isBlank((CharSequence)left)) {
                    Object name = returnData.get("name");
                    Object id = returnData.get("tagid");
                    DynamicObject tags = this.getModel().getDataEntity(true);
                    DynamicObject tagentry = tags.getDynamicObjectCollection("tag_entryentity").addNew();
                    DynamicObject tag = BusinessDataServiceHelper.newDynamicObject((String)"pmm_scenariotag");
                    tag.set("name", name);
                    tag.set("id", (Object)Long.parseLong(id.toString()));
                    tagentry.set("tag", (Object)tag);
                    tagentry.set("left", (Object)left);
                    tagentry.set("top", (Object)top);
                    DynamicObject entryentity = tags.getDynamicObjectCollection("entryentity").addNew();
                    entryentity.set("scenariotag", (Object)tag);
                    entryentity.set("scenariotag.id", (Object)Long.parseLong(id.toString()));
                    entryentity.set("source", (Object)"pmm_prodmanage");
                    CustomControl customcontrol = (CustomControl)this.getView().getControl("imageaddtag");
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("tagid", id.toString());
                    data.put("left", Integer.parseInt(left));
                    data.put("top", Integer.parseInt(top));
                    data.put("tagname", tag.getString("name"));
                    data.put("isdrawtag", "true");
                    customcontrol.setData(data);
                }
                this.getView().updateView("tag_entryentity");
                this.getView().updateView("entryentity");
                this.getView().getPageCache().remove("left");
                this.getView().getPageCache().remove("top");
                this.getView().getPageCache().remove("curtagid");
            }
        } else if ("scenarioimg".equals(e.getActionId())) {
            Object obj3 = e.getReturnData();
            if (obj3 != null) {
                Map imgData = (Map)obj3;
                this.getModel().setValue("scenarioimg", imgData.get("value"));
                Container flexPanel = (Container)this.getView().getControl("flexpanelap");
                String url = null;
                if (this.getModel().getValue("scenarioimg") != null) {
                    url = this.getUrl(this.getModel().getValue("scenarioimg").toString());
                }
                if (flexPanel != null) {
                    flexPanel.setBackgroundImg(url);
                }
            }
        } else if ("tagnameedit".equals(e.getActionId()) && (obj = e.getReturnData()) != null) {
            Map returnData = (Map)obj;
            if (returnData.get("isdeletetag") != null && "true".equals(returnData.get("isdeletetag").toString())) {
                if (this.getPageCache().get("curtagid") == null) {
                    return;
                }
                ArrayList<Long> list = new ArrayList<Long>();
                list.add(Long.parseLong(this.getPageCache().get("curtagid")));
                this.deleteTagAndGoodsEntry(list);
                this.getView().updateView("entryentity");
            } else if (returnData.get("isedittag") != null && "true".equals(returnData.get("isedittag").toString())) {
                CustomControl customcontrol = (CustomControl)this.getView().getControl("imageaddtag");
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("tagid", returnData.get("tagid").toString());
                data.put("tagname", returnData.get("tagname").toString());
                data.put("iseditdrawtag", "true");
                customcontrol.setData(data);
                this.getView().updateView("tag_entryentity");
                this.getView().updateView("entryentity");
            }
        }
    }

    private void deleteTag(List tagIds) {
        DynamicObjectCollection tagEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("tag_entryentity");
        Iterator it = tagEntrys.iterator();
        ArrayList<String> tags = new ArrayList<String>(tagIds.size());
        while (it.hasNext()) {
            DynamicObject tagEntry = (DynamicObject)it.next();
            if (tagEntry.get("tag.id") == null) {
                it.remove();
                continue;
            }
            Long tagid = tagEntry.getLong("tag.id");
            if (!tagIds.contains(tagid)) continue;
            tags.add(tagid.toString());
            it.remove();
        }
        if (tagIds.size() > 0) {
            this.clearTag(tags);
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("ignoreValidation", String.valueOf(true));
        option.setVariableValue("ignoreinteraction", String.valueOf(true));
        OperationServiceHelper.executeOperate((String)"delete", (String)"pmm_scenariotag", (Object[])tagIds.toArray(), (OperateOption)option);
    }

    private void deleteGoodsEntry(int[] selectRows) {
        StringBuilder tags = new StringBuilder(64);
        ArrayList<Integer> deleteRows = new ArrayList<Integer>(64);
        Map<Long, List<Integer>> tagIndexMap = this.getTagIndexMap();
        DynamicObjectCollection goodsEntrys = this.getModel().getEntryEntity("entryentity");
        DynamicObject goodsEntry = null;
        for (int index : selectRows) {
            goodsEntry = (DynamicObject)goodsEntrys.get(index);
            if (goodsEntry.get("scenariotag") == null) {
                deleteRows.add(index);
                continue;
            }
            Long tagid = goodsEntry.getLong("scenariotag.id");
            if (!tagIndexMap.containsKey(tagid)) continue;
            List<Integer> indexList = tagIndexMap.get(tagid);
            if (indexList.size() > 1) {
                deleteRows.add(index);
                indexList.removeIf(item -> item == index);
                continue;
            }
            tags.append(tagid).append("@@");
        }
        if (deleteRows.size() > 0) {
            this.getView().getModel().deleteEntryRows("entryentity", deleteRows.stream().mapToInt(Integer::intValue).toArray());
        }
        if (tags.length() > 0) {
            this.getPageCache().put("deletetags", tags.toString());
            String msg = ResManager.loadKDString((String)"\u5220\u9664\u5546\u54c1\u65f6\uff0c\u662f\u5426\u5c06\u6807\u7b7e\u4e00\u5e76\u5220\u9664\uff1f", (String)"ScenarioSchemeEditPlugin_8", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.YesNo, new ConfirmCallBackListener("deletegoodsentry"));
        }
    }

    private Map<Long, List<Integer>> getTagIndexMap() {
        HashMap<Long, List<Integer>> tagGoodsMap = new HashMap<Long, List<Integer>>();
        DynamicObjectCollection goodsEntrys = this.getModel().getEntryEntity("entryentity");
        List<Integer> indexList = new ArrayList();
        int index = 0;
        for (DynamicObject goodsEntry : goodsEntrys) {
            if (goodsEntry.get("scenariotag") == null) {
                ++index;
                continue;
            }
            Long tagid = goodsEntry.getLong("scenariotag.id");
            if (tagGoodsMap.containsKey(tagid)) {
                indexList = (List)tagGoodsMap.get(tagid);
                indexList.add(index);
            } else {
                indexList = new ArrayList();
                indexList.add(index);
                tagGoodsMap.put(tagid, indexList);
            }
            ++index;
        }
        return tagGoodsMap;
    }

    private void deleteAllTag() {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("imageaddtag");
        HashMap<String, String> data = new HashMap<String, String>(1);
        data.put("isclearall", "true");
        customcontrol.setData(data);
    }

    private void clearTag(List tagids) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl("imageaddtag");
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("tagids", tagids);
        data.put("isclear", "true");
        customcontrol.setData(data);
    }

    private String getUrl(String url) {
        if (StringUtils.isEmpty((CharSequence)url) || url.contains("http") || url.contains("https")) {
            return url;
        }
        return UrlService.getImageFullUrl((String)url);
    }

    private void insertGoodsEntry() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl("entryentity");
        int rowKey = grid.getEntryState().getFocusRow();
        if (rowKey >= 0) {
            IDataModel model = (IDataModel)this.getView().getService(IDataModel.class);
            int newRowKey = model.insertEntryRow("entryentity", rowKey + 1);
            model.setValue("scenariotag", model.getValue("scenariotag", rowKey), rowKey + 1);
            model.setValue("source", (Object)"pmm_prodmanage", rowKey + 1);
            grid.selectRows(newRowKey);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ScenarioSchemeEditPlugin_9", (String)"scm-pmm-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
        }
    }
}

