/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.list;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.parent.TreeListBuildTreePlugin;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.malcore.enums.MallStatusEnum;
import kd.scm.malcore.enums.SaleStatusEnum;
import kd.scm.pmm.business.model.prodpool.ProdPool;
import kd.scm.pmm.business.service.impl.ProdPoolCommandServiceImpl;

public class GoodsManageProdPoolList
extends TreeListBuildTreePlugin {
    private static final String ACTION_ORGSCPOESETTINE = "action_orgscpoesettine";
    private static final String RELATE_PROTOCOL_CONFIRM = "relateProtocolConfirm";
    private static final String OPEN_PROTOCOL_F7_CALL_BACK = "openProtocolF7CallBack";
    private static final String RELATE_PROTOCOL_OP_PROD_ID_SET = "relateProtocolOpProdIDSet";
    private static final String DOWNLOAD_CONFIRM = "downloadConfirm";
    private static final String KEY_TREEBUTTONPANEL = "flexpanel_treebtn";
    private static final String CACHE_ALL_PROD = "allProd";
    private static final String CACHE_SUPPLIER = "supplier";
    private static final String OP_UPLOAD = "upload";
    private static final String OP_DOWNLOAD = "download";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        this.hideFilterColumn(args.getCommonFilterColumns(), this.getHideCommonColumn());
        this.hideFilterColumn(args.getSchemeFilterColumns(), this.getHideSchemeColumn());
    }

    private Set<String> getHideCommonColumn() {
        HashSet<String> hideColumnsKey = new HashSet<String>(8);
        if (!MalOrderUtil.getDefaultMalVersion()) {
            hideColumnsKey.add("isprotocolprod");
        } else {
            hideColumnsKey.add("centralpurtype");
            hideColumnsKey.add("mallstatus");
        }
        return hideColumnsKey;
    }

    private Set<String> getHideSchemeColumn() {
        HashSet<String> hideColumnsKey = new HashSet<String>(8);
        if (!MalOrderUtil.getDefaultMalVersion()) {
            hideColumnsKey.add("prodpool.mallstatus");
            hideColumnsKey.add("prodpool.centralpurtype");
            hideColumnsKey.add("isprotocolprod");
            hideColumnsKey.add("barcode");
        } else {
            hideColumnsKey.add("centralpurtype");
            hideColumnsKey.add("mallstatus");
        }
        return hideColumnsKey;
    }

    private void hideFilterColumn(List<FilterColumn> filterColumns, Set<String> hideCommonColumn) {
        Iterator<FilterColumn> iterator = filterColumns.iterator();
        while (iterator.hasNext()) {
            FilterColumn filterColumn = iterator.next();
            String fieldName = filterColumn.getFieldName();
            if (!hideCommonColumn.contains(fieldName)) continue;
            iterator.remove();
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        if ("createorg.name".equals(args.getFieldName())) {
            args.addCustomQFilter(new QFilter("id", "in", (Object)OrgUtil.getAllPurViewPermissionOrgs((String)"pmm_prodmanage")));
        }
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.TRUE, new String[]{KEY_TREEBUTTONPANEL});
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if ("bos_org".equals(args.getRefEntityId())) {
            args.getQfilters().add(new QFilter("id", "in", (Object)OrgUtil.getAllPurViewPermissionOrgs((String)"pmm_prodmanage")));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        this.malVersionView(args);
    }

    private void malVersionView(BeforeCreateListColumnsArgs args) {
        boolean defaultMalVersion = MalOrderUtil.getDefaultMalVersion();
        Set<String> hideColumns = this.malVersionHideColumns(defaultMalVersion);
        Set<String> showColumns = this.malVersionShowColumns(defaultMalVersion);
        Set<String> fixedColumns = this.malVersionFixedColumns(defaultMalVersion);
        Map<String, String> columnsCaption = this.malVersionColumnsCaption(defaultMalVersion);
        List listColumns = args.getListColumns();
        for (IListColumn listColumn : listColumns) {
            if (!(listColumn instanceof ListColumn)) continue;
            String listFieldKey = listColumn.getListFieldKey();
            if (fixedColumns.contains(listFieldKey)) {
                ListColumn listOperationColumn = (ListColumn)listColumn;
                listOperationColumn.setFixed(true);
            }
            if (hideColumns.contains(listFieldKey)) {
                listColumn.setVisible(0);
            }
            if (showColumns.contains(listFieldKey)) {
                listColumn.setVisible(1);
            }
            if (columnsCaption.get(listFieldKey) == null) continue;
            LocaleString caption = listColumn.getCaption();
            caption.setLocaleValue(columnsCaption.get(listFieldKey));
        }
    }

    private Set<String> malVersionFixedColumns(boolean isNewMalVersion) {
        HashSet<String> fixedColumns = new HashSet<String>(16);
        if (isNewMalVersion) {
            fixedColumns.add("number");
            fixedColumns.add("name");
            fixedColumns.add("thumbnail");
        }
        return fixedColumns;
    }

    private Set<String> malVersionHideColumns(boolean isNewMalVersion) {
        Set<String> hideColumns = new HashSet<String>(16);
        if (!isNewMalVersion) {
            hideColumns.add("isprotocolprod");
            hideColumns.add("prodpool.mallstatus");
            hideColumns.add("prodpool.salestatus");
            hideColumns.add("prodpool.taxprice");
            hideColumns.add("prodpool.priceeffectdate");
            hideColumns.add("prodpool.priceinvaliddate");
            hideColumns.add("prodpool.effectstatus");
            hideColumns.add("protocol.protocolname");
            hideColumns.add("protocol.protocolstatus");
            hideColumns.add("prodpool.centralpurtype");
            hideColumns.add("brand.name");
            hideColumns.add("prodpool.minorderqty");
            hideColumns.add("prodpool.leadtime");
            hideColumns.add("barcode");
            hideColumns.add("prodpool.purplan.name");
        } else {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Object hideFieldJson = customParams.get("hideFields");
            if (hideFieldJson != null) {
                hideColumns = (Set)SerializationUtils.fromJsonString((String)((String)hideFieldJson), Set.class);
            }
        }
        return hideColumns;
    }

    private Set<String> malVersionShowColumns(boolean isNewMalVersion) {
        HashSet<String> showColumns = new HashSet<String>(16);
        if (!isNewMalVersion) {
            showColumns.add("taxprice");
            showColumns.add("mallstatus");
            showColumns.add("centralpurtype");
            showColumns.add("prodmatmapping.materielfield.number");
            showColumns.add("prodmatmapping.materielfield.name");
            showColumns.add("taxrate");
            showColumns.add("surchargename");
            showColumns.add("surchargeamount");
        }
        return showColumns;
    }

    private Map<String, String> malVersionColumnsCaption(boolean isNewMalVersion) {
        HashMap<String, String> columnsCation = new HashMap<String, String>(16);
        if (!isNewMalVersion) {
            columnsCation.put("supplier.name", ResManager.loadKDString((String)"\u6240\u5c5e\u5546\u5bb6", (String)"GoodsManageProdPoolList_37", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return columnsCation;
        }
        return columnsCation;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (!MalOrderUtil.getDefaultMalVersion()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblrelateprotocol", "tblsetorgscope", "tblimportimage", "tblinfochange", "materialmapping1", "setting"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tbladjust", "tblquickset"});
        }
        String param = ParamUtil.getSysCtrlParam((String)"UUPIH+47DAK", (String)"latestladderprice");
        if (Boolean.parseBoolean(param)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"ladderprice"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"ladderprice"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if (OP_UPLOAD.equals(operateKey)) {
            this.uploadOp(args);
        }
        if (OP_DOWNLOAD.equals(operateKey)) {
            this.downloadOp(args);
        }
    }

    private void uploadOp(BeforeDoOperationEventArgs args) {
        ArrayList<String> prodPoolIdList;
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectedRows = listview.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        if (primaryKeyValues.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4ef6\u5546\u54c1\u3002", (String)"GoodsManageProdPoolList_38", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObjectCollection prodDynArray = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,status,supplier,protocolentry.prodpool,protocolentry.protocol,protocolentry.id,protocolentry.prodpool.mallstatus,protocolentry.protocol.protocolstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
        Object[] entryPrimaryKeyValues = selectedRows.getEntryPrimaryKeyValues();
        HashSet<Long> entryIdSet = new HashSet<Long>(entryPrimaryKeyValues.length);
        HashMap<Long, List<DynamicObject>> goodsId_EntryMap = new HashMap<Long, List<DynamicObject>>(1024);
        for (DynamicObject row : prodDynArray) {
            Long goodsId = row.getLong("id");
            List<Object> entrys = new ArrayList<DynamicObject>(1024);
            if (null != goodsId_EntryMap.get(goodsId)) {
                entrys = (List)goodsId_EntryMap.get(goodsId);
            }
            entrys.add(row);
            goodsId_EntryMap.put(goodsId, entrys);
        }
        if (entryPrimaryKeyValues[0] != null) {
            for (Object entryPrimaryKeyValue : entryPrimaryKeyValues) {
                entryIdSet.add((Long)entryPrimaryKeyValue);
            }
        } else {
            for (DynamicObject dynamicObject : prodDynArray) {
                entryIdSet.add(dynamicObject.getLong("protocolentry.id"));
            }
        }
        if (!this.uploadConsistencyValid(goodsId_EntryMap, entryIdSet)) {
            args.setCancel(true);
            return;
        }
        Long supplierId = ((DynamicObject)prodDynArray.get(0)).getLong(CACHE_SUPPLIER);
        if (!this.supplierEffectValid(supplierId)) {
            args.setCancel(true);
            return;
        }
        String protocolId = "-1";
        for (DynamicObject prod : prodDynArray) {
            if (!entryIdSet.contains(prod.getLong("protocolentry.id")) || 0L == prod.getLong("protocolentry.protocol")) continue;
            protocolId = prod.getString("protocolentry.protocol");
            break;
        }
        if (!this.uploadStatusValid(goodsId_EntryMap, entryIdSet, protocolId, prodPoolIdList = new ArrayList<String>(primaryKeyValues.length))) {
            args.setCancel(true);
            return;
        }
        if (!this.uploadProdAuditValid(primaryKeyValues, protocolId)) {
            args.setCancel(true);
            return;
        }
        String selectCols = String.join((CharSequence)",", prodPoolIdList);
        this.getPageCache().put(CACHE_ALL_PROD, selectCols);
        this.getPageCache().put(CACHE_SUPPLIER, String.valueOf(supplierId));
    }

    private boolean uploadConsistencyValid(Map<Long, List<DynamicObject>> goodsId_EntryMap, Set<Long> entryIdSet) {
        Long supplierId = null;
        String protocolId = "";
        for (Map.Entry<Long, List<DynamicObject>> map : goodsId_EntryMap.entrySet()) {
            DynamicObject prodDyn = map.getValue().get(0);
            long prodSupplierId = prodDyn.getLong(CACHE_SUPPLIER);
            if (supplierId == null) {
                supplierId = prodSupplierId;
            } else if (supplierId != prodSupplierId) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u540c\u4e00\u4e2a\u4f9b\u5e94\u5546\u7684\u5546\u54c1\u8fdb\u884c\u4e0a\u67b6\u3002", (String)"GoodsManageProdPoolList_8", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return false;
            }
            for (DynamicObject entry : map.getValue()) {
                if (!entryIdSet.contains(entry.getLong("protocolentry.id"))) continue;
                Long protocolDynId = entry.getLong("protocolentry.protocol");
                if (StringUtils.isBlank((CharSequence)protocolId)) {
                    protocolId = protocolDynId == 0L ? "-1" : entry.getString("protocolentry.protocol");
                    continue;
                }
                if (protocolDynId == 0L && !protocolId.equals("-1") || protocolDynId != 0L && protocolId.equals("-1")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u6570\u636e\u4e2d\u5b58\u5728\u65e0\u534f\u8bae\u7684\u5546\u54c1\u53ca\u6709\u534f\u8bae\u7684\u5546\u54c1\uff0c\u8bf7\u5206\u5f00\u8d70\u4e0a\u67b6\u6d41\u7a0b\u3002", (String)"GoodsManageProdPoolList_10", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (protocolDynId == 0L || protocolId.equals(entry.getString("protocolentry.protocol"))) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u9009\u62e9\u7684\u5546\u54c1\u4e2d\u534f\u8bae\u4e0d\u540c\uff0c\u4ec5\u652f\u6301\u5bf9\u540c\u4e00\u4e2a\u534f\u8bae\u4e0b\u7684\u5546\u54c1\u6279\u91cf\u4e0a\u67b6\u3002", (String)"GoodsManageProdPoolList_11", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private boolean supplierEffectValid(Long supplierId) {
        DynamicObject supplier = QueryServiceHelper.queryOne((String)"bd_supplier", (String)"id,enable,mallstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)supplierId)});
        String enable = supplier.getString("enable");
        String mallStatus = supplier.getString("mallstatus");
        if ("0".equals(enable)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u6240\u5c5e\u5546\u5bb6\u5df2\u7981\u7528\uff0c\u5546\u54c1\u65e0\u6cd5\u4e0a\u67b6\u3002", (String)"GoodsManageProdPoolList_17", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if ("C".equals(mallStatus)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u6240\u5c5e\u5546\u5bb6\u5df2\u51bb\u7ed3\uff0c\u5546\u54c1\u65e0\u6cd5\u4e0a\u67b6\u3002", (String)"GoodsManageProdPoolList_18", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean uploadProdAuditValid(Object[] primaryKeyValues, String protocolId) {
        QFilter qFilter = new QFilter("entryentity.goods", "in", (Object)primaryKeyValues);
        if (!"-1".equals(protocolId)) {
            qFilter.and(new QFilter("protocolid", "=", (Object)Long.valueOf(protocolId)));
        }
        qFilter.and(new QFilter("cfmstatus", "!=", (Object)"B")).and(new QFilter("cfmstatus", "!=", (Object)"D")).and(new QFilter("cfmstatus", "!=", (Object)"C"));
        qFilter.and("biztype", "=", (Object)"1");
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"ent_prodrequest", (String)"id,billno,entryentity.goods.id goods,entryentity.goods.number goodsnumber", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObjects.size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (DynamicObject dynamicObject : dynamicObjects) {
                String msg = ResManager.loadKDString((String)"\u5546\u54c1\u7f16\u7801\uff1a%1$s\uff0c\u4e0a\u67b6\u7533\u8bf7\u5355\uff1a%2$s", (String)"GoodsManageProdPoolList_39", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                sb.append(String.format(msg, dynamicObject.getString("goodsnumber"), dynamicObject.getString("billno"))).append('\n');
            }
            this.getView().showMessage(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u90e8\u5206\u5546\u54c1\u5b58\u5728\u672a\u5ba1\u6279\u7684\u4e0a\u67b6\u5ba1\u6279\u5355\uff0c\u8bf7\u5148\u5ba1\u6279\u901a\u8fc7\u3002", (String)"GoodsManageProdPoolList_12", (String)"scm-pmm-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
            return false;
        }
        QFilter qFilter1 = new QFilter("prod", "in", (Object)primaryKeyValues);
        qFilter1.and("cfmstatus", "=", (Object)"A");
        DynamicObjectCollection prodChangeManages = QueryServiceHelper.query((String)"pmm_prodchange_manage", (String)"billno,prod.number", (QFilter[])qFilter1.toArray());
        StringBuilder sb = new StringBuilder();
        for (DynamicObject prodChangeManage : prodChangeManages) {
            String msg = ResManager.loadKDString((String)"\u5546\u54c1%1$s\u5b58\u5728\u5f85\u786e\u8ba4\u7684\u53d8\u66f4\u5355\uff1a%2$s\uff0c\u4e0d\u5141\u8bb8\u4e0a\u67b6\u3002", (String)"GoodsManageProdPoolList_24", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            sb.append(String.format(msg, prodChangeManage.getString("prod.number"), prodChangeManage.getString("billno"))).append('\n');
        }
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e0a\u67b6\u5931\u8d25", (String)"GoodsManageProdPoolList_32", (String)"scm-pmm-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
            return false;
        }
        return true;
    }

    private boolean uploadStatusValid(Map<Long, List<DynamicObject>> goodsId_EntryMap, Set<Long> entryIdSet, String protocolId, List<String> prodPoolIdList) {
        for (Map.Entry<Long, List<DynamicObject>> map : goodsId_EntryMap.entrySet()) {
            DynamicObject prodDyn = map.getValue().get(0);
            if (!BillStatusEnum.AUDIT.getVal().equals(prodDyn.getString("status"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u8fd8\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u4e0a\u67b6\u3002", (String)"GoodsManageProdPoolList_19", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return false;
            }
            for (DynamicObject entry : map.getValue()) {
                if (!entryIdSet.contains(entry.getLong("protocolentry.id"))) continue;
                String mallStatus = entry.getString("protocolentry.prodpool.mallstatus");
                if (MallStatusEnum.SOLDOUT.getVal().equals(mallStatus) || MallStatusEnum.BACKMODIFY.getVal().equals(mallStatus) || MallStatusEnum.TEMPSTATUS.getVal().equals(mallStatus)) {
                    if (!"-1".equals(protocolId) && !"B".equals(entry.getString("protocolentry.protocol.protocolstatus"))) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u751f\u6548\u4e2d\u7684\u534f\u8bae\u6216\u65e0\u534f\u8bae\u7684\u5546\u54c1\u4e0a\u67b6\u3002", (String)"GoodsManageProdPoolList_40", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                } else {
                    if (MallStatusEnum.UNSOLD.getVal().equals(mallStatus)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u672a\u751f\u6548\uff0c\u5f85\u751f\u6548\u540e\u81ea\u52a8\u4e0a\u67b6\uff0c\u65e0\u9700\u4eba\u5de5\u5904\u7406\u3002", (String)"GoodsManageProdPoolList_21", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                    if (MallStatusEnum.SOLD.getVal().equals(mallStatus)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u5df2\u4e0a\u67b6\uff0c\u65e0\u9700\u91cd\u590d\u4e0a\u67b6\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u3002", (String)"GoodsManageProdPoolList_22", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                        return false;
                    }
                }
                prodPoolIdList.add(entry.getString("protocolentry.prodpool"));
            }
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (null == result) {
            return;
        }
        switch (key = ((AbstractOperate)afterDoOperationEventArgs.getSource()).getOperateKey()) {
            case "upload": {
                HashMap<String, Object> param = new HashMap<String, Object>(8);
                String allProd = this.getPageCache().get(CACHE_ALL_PROD);
                if (!StringUtils.isNotEmpty((CharSequence)allProd)) break;
                param.put(CACHE_ALL_PROD, allProd);
                String supplierId = this.getPageCache().get(CACHE_SUPPLIER);
                if (StringUtils.isNotEmpty((CharSequence)supplierId)) {
                    param.put(CACHE_SUPPLIER, Long.valueOf(supplierId));
                }
                this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"pmm_prodaudit", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.ADDNEW, (long)0L, param, null));
                break;
            }
            case "setorgscope": {
                this.setOrgScopeOp();
                break;
            }
            case "relateprotocol": {
                this.relateProtocolOp();
                break;
            }
            case "download": {
                OperateOption option = ((AbstractOperate)afterDoOperationEventArgs.getSource()).getOption();
                option.setVariableValue("isshowmessage", String.valueOf(false));
                break;
            }
        }
    }

    private void downloadOp(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection prodDynColl = this.querySelectedProdDynColl();
        if (prodDynColl.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4ef6\u5546\u54c1\u3002", (String)"GoodsManageProdPoolList_38", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!this.downloadValid(prodDynColl)) {
            args.setCancel(true);
            return;
        }
        if (MalOrderUtil.getDefaultMalVersion()) {
            this.downloadToProdRequest(prodDynColl);
            args.setCancel(true);
        } else if (this.downloadProdPool(prodDynColl)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u67b6\u6210\u529f", (String)"GoodsManageProdPoolList_16", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        } else {
            args.setCancel(true);
        }
    }

    private void downloadToProdRequest(DynamicObjectCollection prodDynColl) {
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        params.put("biztype", OP_DOWNLOAD);
        List prodPoolIds = prodDynColl.stream().map(prodDyn -> prodDyn.getString("prodpool")).collect(Collectors.toList());
        params.put(CACHE_ALL_PROD, String.join((CharSequence)",", prodPoolIds));
        params.put(CACHE_SUPPLIER, ((DynamicObject)prodDynColl.get(0)).getLong(CACHE_SUPPLIER));
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"pmm_prodaudit", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.ADDNEW, (long)0L, params, null));
    }

    private boolean downloadProdPool(DynamicObjectCollection prodDynColl) {
        ArrayList<Long> prodPoolIdList = new ArrayList<Long>(prodDynColl.size());
        for (DynamicObject dynamicObject : prodDynColl) {
            prodPoolIdList.add(dynamicObject.getLong("prodpool"));
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        option.setVariableValue("isStrict", String.valueOf(false));
        option.setVariableValue("isshowmessage", String.valueOf(false));
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)OP_DOWNLOAD, (String)"pmm_prodpool", (Object[])prodPoolIdList.toArray(new Object[0]), (OperateOption)option);
        if (!operationResult.isSuccess()) {
            StringBuilder messageError = new StringBuilder();
            operationResult.getAllErrorOrValidateInfo().forEach(row -> messageError.append(row.getMessage()).append("\n\t"));
            if (operationResult.getSuccessPkIds().size() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u4e0b\u67b6\u5931\u8d25\u3002", (String)"GoodsManageProdPoolList_41", (String)"scm-pmm-formplugin", (Object[])new Object[0]), messageError.toString(), MessageTypes.Default);
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4e0b\u67b6\u5931\u8d25", (String)"GoodsManageProdPoolList_6", (String)"scm-pmm-formplugin", (Object[])new Object[0]), messageError.toString(), MessageTypes.Default);
            }
            return false;
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
        return true;
    }

    private boolean downloadValid(DynamicObjectCollection prodDynColl) {
        boolean haveEffectProtocol = false;
        Long protocolId = null;
        Long auditOrg = null;
        Long supplierId = null;
        HashSet<Long> prodIds = new HashSet<Long>(prodDynColl.size());
        for (DynamicObject prodDyn : prodDynColl) {
            if (!MallStatusEnum.SOLD.getVal().equals(prodDyn.getString("mallstatus")) && !MallStatusEnum.UNSOLD.getVal().equals(prodDyn.getString("mallstatus"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5f85\u4e0a\u67b6/\u5df2\u4e0a\u67b6\u7684\u5546\u54c1\u4e0b\u67b6\u3002", (String)"GoodsManageProdPoolList_42", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return false;
            }
            if ("B".equals(prodDyn.getString("protocolstatus"))) {
                haveEffectProtocol = true;
            }
            if (protocolId != null && protocolId.longValue() != prodDyn.getLong("protocol")) {
                if (protocolId == 0L || prodDyn.getLong("protocol") == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u6570\u636e\u4e2d\u5b58\u5728\u65e0\u534f\u8bae\u7684\u5546\u54c1\u53ca\u6709\u534f\u8bae\u7684\u5546\u54c1\uff0c\u8bf7\u5206\u5f00\u8d70\u4e0b\u67b6\u6d41\u7a0b\u3002", (String)"GoodsManageProdPoolList_28", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6279\u91cf\u9009\u62e9\u7684\u5546\u54c1\u4e2d\u534f\u8bae\u4e0d\u540c\uff0c\u4ec5\u652f\u6301\u5bf9\u540c\u4e00\u4e2a\u534f\u8bae\u4e0b\u7684\u5546\u54c1\u6279\u91cf\u4e0b\u67b6\u3002", (String)"GoodsManageProdPoolList_27", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                }
                return false;
            }
            protocolId = prodDyn.getLong("protocol");
            if (auditOrg != null && auditOrg.longValue() != prodDyn.getLong("auditorg")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5546\u54c1\u5206\u5f55\u4e2d\u5ba1\u6279\u7ec4\u7ec7\u76f8\u540c\u7684\u5546\u54c1\u5206\u5f55\u4e00\u8d77\u4e0b\u67b6\u3002", (String)"GoodsManageProdPoolList_30", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return false;
            }
            auditOrg = prodDyn.getLong("auditorg");
            if (supplierId != null && supplierId.longValue() != prodDyn.getLong(CACHE_SUPPLIER)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u6279\u91cf\u9009\u62e9\u540c\u4e00\u4e2a\u4f9b\u5e94\u5546\u7684\u5546\u54c1\u5206\u5f55\u4e00\u8d77\u4e0b\u67b6\u3002", (String)"GoodsManageProdPoolList_31", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return false;
            }
            supplierId = prodDyn.getLong(CACHE_SUPPLIER);
            prodIds.add(prodDyn.getLong("id"));
        }
        if (!this.checkProdOtherBill(protocolId, prodIds)) {
            return false;
        }
        if (haveEffectProtocol) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u5173\u8054\u7684\u534f\u8bae\u5df2\u751f\u6548\u4e2d\uff0c\u4e0b\u67b6\u540e\u7684\u5546\u54c1\u65e0\u6cd5\u641c\u5230\uff0c\u7ee7\u7eed\u4e0b\u67b6\u5417\uff1f", (String)"GoodsManageProdPoolList_15", (String)"scm-pmm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(DOWNLOAD_CONFIRM));
            return false;
        }
        return true;
    }

    private boolean checkProdOtherBill(Long protocolId, Set<Long> prodIds) {
        QFilter qFilter = new QFilter("prod", "in", prodIds);
        qFilter.and("cfmstatus", "=", (Object)"A");
        DynamicObjectCollection prodChangeManages = QueryServiceHelper.query((String)"pmm_prodchange_manage", (String)"billno,prod.number", (QFilter[])qFilter.toArray());
        StringBuilder sb = new StringBuilder();
        for (DynamicObject prodChangeManage : prodChangeManages) {
            String msg = ResManager.loadKDString((String)"\u5546\u54c1%1$s\u5b58\u5728\u5f85\u786e\u8ba4\u7684\u53d8\u66f4\u5355\uff1a%2$s\uff0c\u4e0d\u5141\u8bb8\u4e0b\u67b6\u3002", (String)"GoodsManageProdPoolList_25", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            sb.append(String.format(msg, prodChangeManage.getString("prod.number"), prodChangeManage.getString("billno"))).append('\n');
        }
        QFilter qFilterRequest = new QFilter("entryentity.goods", "in", prodIds);
        qFilterRequest.and("cfmstatus", "=", (Object)"A");
        qFilterRequest.and("biztype", "=", (Object)"2");
        qFilterRequest.and("protocolid", "=", (Object)protocolId);
        DynamicObjectCollection prodRequests = QueryServiceHelper.query((String)"pmm_prodaudit", (String)"billno,entryentity.goods.id goods,entryentity.goods.number goodsnumber", (QFilter[])qFilterRequest.toArray());
        for (DynamicObject prodRequest : prodRequests) {
            String msg = ResManager.loadKDString((String)"\u5546\u54c1%1$s\u5b58\u5728\u5f85\u5ba1\u6279\u7684\u4e0b\u67b6\u7533\u8bf7\u5355\uff1a%2$s\uff0c\u4e0d\u5141\u8bb8\u4e0b\u67b6\u3002", (String)"GoodsManageProdPoolList_29", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            sb.append(String.format(msg, prodRequest.getString("goodsnumber"), prodRequest.getString("billno"))).append('\n');
        }
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u4e0b\u67b6\u5931\u8d25", (String)"GoodsManageProdPoolList_6", (String)"scm-pmm-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
            return false;
        }
        return true;
    }

    private void setOrgScopeOp() {
        DynamicObjectCollection prodDynColl = this.querySelectedProdDynColl();
        if (this.checkRelateProtocolOpValid(prodDynColl)) {
            this.jumpToOrgScopeSetting(prodDynColl);
        }
    }

    private boolean checkRelateProtocolOpValid(DynamicObjectCollection prodDynColl) {
        String protocolID = null;
        boolean onlyOne = false;
        for (DynamicObject prodDyn : prodDynColl) {
            String saleStatus = prodDyn.getString("salestatus");
            String protocol = prodDyn.getString("protocol");
            String prodPool = prodDyn.getString("prodpool");
            if (SaleStatusEnum.HIDE.getVal().equals(saleStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5f85\u4e0a\u67b6/\u5df2\u4e0a\u67b6\u7684\u5546\u54c1\u8bbe\u7f6e\u91c7\u4e70\u7ec4\u7ec7\u8303\u56f4\u3002", (String)"GoodsManageProdPoolList_14", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!onlyOne) {
                if (!SaleStatusEnum.SALE.getVal().equals(saleStatus)) {
                    onlyOne = true;
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u53ef\u552e\u72b6\u6001\u4e3a\u53ef\u552e\u7684\u5546\u54c1\uff0c\u8fdb\u884c\u6279\u91cf\u7ec4\u7ec7\u8303\u56f4\u53ca\u53ef\u552e\u8bbe\u7f6e\u3002", (String)"GoodsManageProdPoolList_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (protocolID == null) {
                if (protocol == null) {
                    protocolID = "-1";
                    continue;
                }
                protocolID = protocol;
                continue;
            }
            if (onlyOne) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u53ef\u552e\u72b6\u6001\u4e3a\u53ef\u552e\u7684\u5546\u54c1\uff0c\u8fdb\u884c\u6279\u91cf\u7ec4\u7ec7\u8303\u56f4\u53ca\u53ef\u552e\u8bbe\u7f6e\u3002", (String)"GoodsManageProdPoolList_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (StringUtils.isBlank((CharSequence)prodPool) && !"-1".equals(protocolID)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u65e0\u534f\u8bae\u5546\u54c1\u6216\u534f\u8bae\u53f7\u76f8\u540c\u7684\u5546\u54c1\uff0c\u8fdb\u884c\u7ec4\u7ec7\u8303\u56f4\u53ca\u53ef\u552e\u8bbe\u7f6e\u3002", (String)"GoodsManageProdPoolList_7", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!StringUtils.isNotBlank((CharSequence)prodPool) || protocolID.equals(protocol)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u65e0\u534f\u8bae\u5546\u54c1\u6216\u534f\u8bae\u53f7\u76f8\u540c\u7684\u5546\u54c1\uff0c\u8fdb\u884c\u7ec4\u7ec7\u8303\u56f4\u53ca\u53ef\u552e\u8bbe\u7f6e\u3002", (String)"GoodsManageProdPoolList_7", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        ArrayList<String> goodsIdProtocols = new ArrayList<String>(1024);
        ArrayList<String> protocolsPurPlanIds = new ArrayList<String>(1024);
        for (DynamicObject prodDyn : prodDynColl) {
            String goodsId = prodDyn.getString("id");
            String protocol = prodDyn.getString("protocol");
            String purplanid = prodDyn.getString("purplanid");
            String key = goodsId + protocol;
            String entryKey = protocol + purplanid;
            if (goodsIdProtocols.contains(key)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u4e00\u5546\u54c1\u4ec5\u652f\u6301\u5bf9\u4e0d\u540c\u534f\u8bae\u8fdb\u884c\u91c7\u4e70\u7ec4\u7ec7\u8bbe\u7f6e\u3002", (String)"GoodsManageProdPoolList_35", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return false;
            }
            goodsIdProtocols.add(key);
            if (protocolsPurPlanIds.contains(entryKey)) continue;
            protocolsPurPlanIds.add(entryKey);
        }
        if (protocolsPurPlanIds.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5546\u54c1\u7684\u91c7\u4e70\u7ec4\u7ec7\u8303\u56f4\u4e0d\u540c\uff0c\u4e0d\u5141\u8bb8\u6279\u91cf\u8bbe\u7f6e\u3002", (String)"GoodsManageProdPoolList_36", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void jumpToOrgScopeSetting(DynamicObjectCollection prodDynColl) {
        ArrayList<Long> prodPoolIds = new ArrayList<Long>(prodDynColl.size());
        ArrayList<Long> goodsIds = new ArrayList<Long>(1024);
        for (DynamicObject dynamicObject : prodDynColl) {
            prodPoolIds.add(dynamicObject.getLong("prodpool"));
            goodsIds.add(dynamicObject.getLong("id"));
        }
        DynamicObject dynamicObject = (DynamicObject)prodDynColl.get(0);
        HashMap<String, Object> detailParamMap = new HashMap<String, Object>();
        FormShowParameter showParameter = new FormShowParameter();
        detailParamMap.put("protocolentryid", dynamicObject.getLong("protocolentry"));
        detailParamMap.put("protocolid", dynamicObject.getLong("protocol"));
        detailParamMap.put("goodsid", goodsIds);
        detailParamMap.put("prodPoolIds", prodPoolIds);
        detailParamMap.put("status", "1");
        detailParamMap.put("differentarea", dynamicObject.getBoolean("differentarea"));
        showParameter.setFormId("pmm_orgscopesetting");
        showParameter.setCustomParams(detailParamMap);
        showParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), ACTION_ORGSCPOESETTINE));
        showParameter.setCaption(ResManager.loadKDString((String)"\u91c7\u4e70\u7ec4\u7ec7\u8bbe\u7f6e", (String)"GoodsManageProdPoolList_34", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void relateProtocolOp() {
        DynamicObjectCollection prodDynColl = this.queryProdDynCollByPKId();
        if (!this.relateProtocolConsistencyValid(prodDynColl)) {
            return;
        }
        if (!this.checkHasProtocolViewPermission()) {
            return;
        }
        HashSet<Long> prodIDSet = new HashSet<Long>(prodDynColl.size());
        ArrayList<Long> protocolIdList = new ArrayList<Long>(prodDynColl.size());
        boolean containNoProtocol = false;
        for (DynamicObject prodDyn : prodDynColl) {
            prodIDSet.add(prodDyn.getLong("id"));
            Long protocol = prodDyn.getLong("protocol");
            if (protocol == null || protocol == 0L) {
                containNoProtocol = true;
                continue;
            }
            protocolIdList.add(protocol);
        }
        this.getProtocolQFilter(prodIDSet, protocolIdList);
        this.getPageCache().put(RELATE_PROTOCOL_OP_PROD_ID_SET, SerializationUtils.toJsonString(prodIDSet));
        this.getPageCache().put("protocolIdList", SerializationUtils.toJsonString(protocolIdList));
        if (containNoProtocol) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u5546\u54c1\u5df2\u8bbe\u7f6e\u4e3a\u975e\u534f\u8bae\u5546\u54c1\uff0c\u5173\u8054\u534f\u8bae\u5219\u66f4\u65b0\u4ef7\u683c\u53ca\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\uff0c\u786e\u8ba4\u8981\u5173\u8054\u5417\uff1f", (String)"GoodsManageProdPoolList_43", (String)"scm-pmm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(RELATE_PROTOCOL_CONFIRM));
            return;
        }
        this.openProtocolF7();
    }

    private boolean relateProtocolConsistencyValid(DynamicObjectCollection prodDynArray) {
        Long supplierId = null;
        for (DynamicObject prodDyn : prodDynArray) {
            if (!BillStatusEnum.AUDIT.getVal().equals(prodDyn.getString("status"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u8fd8\u672a\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u5173\u8054\u5546\u57ce\u534f\u8bae\u3002", (String)"GoodsManageProdPoolList_44", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return false;
            }
            long prodSupplierId = prodDyn.getLong(CACHE_SUPPLIER);
            if (supplierId == null) {
                supplierId = prodSupplierId;
                continue;
            }
            if (supplierId == prodSupplierId) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u540c\u4e00\u4e2a\u4f9b\u5e94\u5546\u7684\u5546\u54c1\u8fdb\u884c\u5173\u8054\u5546\u57ce\u534f\u8bae\u3002", (String)"GoodsManageProdPoolList_13", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.getPageCache().put("supplierId", String.valueOf(supplierId));
        return true;
    }

    private void getProtocolQFilter(Set<Long> prodIDSet, List<Long> protocolIdList) {
        QFilter qFilter = new QFilter("entryentity.goods", "in", prodIDSet);
        qFilter.and(new QFilter("cfmstatus", "=", (Object)"E").or(new QFilter("cfmstatus", "=", (Object)"A")));
        DynamicObjectCollection prodAudits = QueryServiceHelper.query((String)"pmm_prodaudit", (String)"protocolid", (QFilter[])qFilter.toArray());
        prodAudits.forEach(prodAudit -> protocolIdList.add(prodAudit.getLong("protocolid")));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (RELATE_PROTOCOL_CONFIRM.equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.openProtocolF7();
        }
        if (DOWNLOAD_CONFIRM.equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            DynamicObjectCollection prodDynColl = this.querySelectedProdDynColl();
            if (MalOrderUtil.getDefaultMalVersion()) {
                this.downloadToProdRequest(prodDynColl);
            } else if (this.downloadProdPool(prodDynColl)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4e0b\u67b6\u6210\u529f", (String)"GoodsManageProdPoolList_16", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void openProtocolF7() {
        String protocolIdListJson;
        String supplierId = this.getPageCache().get("supplierId");
        QFilter protocolQFilter = new QFilter("partyb", "=", (Object)Long.valueOf(supplierId));
        protocolQFilter.and(new QFilter("protocolstatus", "=", (Object)"A").or("protocolstatus", "=", (Object)"B"));
        protocolQFilter.and(new QFilter("confirmstatus", "=", (Object)"C").or(new QFilter("confirmstatus", "=", (Object)"A")));
        protocolQFilter.and(new QFilter("entryentity1", "=", null));
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), null, null, (String)"pmm_protocol", (String)"47150e89000000ac");
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            List permOrgs = hasPermOrgResult.getHasPermOrgs();
            protocolQFilter.and(new QFilter("org", "in", (Object)permOrgs));
        }
        if (StringUtils.isNotBlank((CharSequence)(protocolIdListJson = this.getPageCache().get("protocolIdList")))) {
            List protocolIdList = (List)SerializationUtils.fromJsonString((String)protocolIdListJson, List.class);
            protocolQFilter.and(new QFilter("id", "not in", (Object)protocolIdList));
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setLookUp(true);
        listShowParameter.getListFilterParameter().setFilter(protocolQFilter);
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setBillFormId("pmm_protocol_bd");
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u5546\u57ce\u534f\u8bae", (String)"GoodsManageProdPoolList_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("960px");
        styleCss.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        listShowParameter.setMultiSelect(false);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, OPEN_PROTOCOL_F7_CALL_BACK));
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)OPEN_PROTOCOL_F7_CALL_BACK)) {
            this.protocolF7CallBack(closedCallBackEvent);
        }
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)ACTION_ORGSCPOESETTINE)) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }

    private void protocolF7CallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData != null) {
            Set relateProtocolOpProdIdSet = (Set)SerializationUtils.fromJsonString((String)this.getPageCache().get(RELATE_PROTOCOL_OP_PROD_ID_SET), Set.class);
            Object primaryKeyValue = ((ListSelectedRowCollection)returnData).get(0).getPrimaryKeyValue();
            DynamicObjectCollection pmmProtocolDynColl = QueryServiceHelper.query((String)"pmm_protocol", (String)"id,org,purmode,protocolstatus,isgoodvisible,effectdate,invaliddate,entryentity.orgname.id orgname", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKeyValue)});
            HashSet<Long> protocolOrgSet = new HashSet<Long>(pmmProtocolDynColl.size());
            for (DynamicObject dynamicObject : pmmProtocolDynColl) {
                protocolOrgSet.add(dynamicObject.getLong("orgname"));
            }
            DynamicObject[] prodPoolDynArray = BusinessDataServiceHelper.load((String)"pmm_prodpool", (String)"id,protocol,goods,isgoodvisible,entryentity.orgname", (QFilter[])new QFilter[]{new QFilter("goods", "in", (Object)relateProtocolOpProdIdSet)});
            if (!this.checkOrgIntersection(prodPoolDynArray, (DynamicObject)pmmProtocolDynColl.get(0), protocolOrgSet)) {
                return;
            }
            this.addNewProdPool(pmmProtocolDynColl);
        }
        BillList billList = (BillList)this.getControl("billlistap");
        billList.refresh();
    }

    private boolean checkOrgIntersection(DynamicObject[] prodPoolDynArray, DynamicObject pmmProtocolDyn, Set<Long> protocolOrgSet) {
        for (DynamicObject prodPoolDyn : prodPoolDynArray) {
            DynamicObject protocol = prodPoolDyn.getDynamicObject("protocol");
            if (protocol == null || "C".equals(protocol.getString("protocolstatus")) || "D".equals(protocol.getString("protocolstatus")) || !this.checkProtocolDateIntersection(protocol, pmmProtocolDyn)) continue;
            if (prodPoolDyn.getBoolean("isgoodvisible") || pmmProtocolDyn.getBoolean("isgoodvisible")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u65b0\u534f\u8bae\u7684\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u4e0e\u539f\u534f\u8bae\u6709\u4ea4\u53c9\uff0c\u65e0\u6cd5\u5173\u8054\uff0c\u8bf7\u67e5\u660e\u539f\u56e0\u540e\u91cd\u8bd5\u3002", (String)"GoodsManageProdPoolList_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return false;
            }
            DynamicObjectCollection entryEntity = prodPoolDyn.getDynamicObjectCollection("entryentity");
            HashSet<Long> poolOrgSet = new HashSet<Long>(entryEntity.size());
            for (DynamicObject dynamicObject : entryEntity) {
                poolOrgSet.add(dynamicObject.getDynamicObject("orgname").getLong("id"));
            }
            for (Long protocolOrgId : protocolOrgSet) {
                if (!poolOrgSet.contains(protocolOrgId)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u65b0\u534f\u8bae\u7684\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u4e0e\u539f\u534f\u8bae\u6709\u4ea4\u53c9\uff0c\u65e0\u6cd5\u5173\u8054\uff0c\u8bf7\u67e5\u660e\u539f\u56e0\u540e\u91cd\u8bd5\u3002", (String)"GoodsManageProdPoolList_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private boolean checkProtocolDateIntersection(DynamicObject protocol, DynamicObject pmmProtocolDyn) {
        Date oldEffectDate = protocol.getDate("effectdate");
        Date oldInvalidDate = protocol.getDate("invaliddate");
        Date newEffectDate = pmmProtocolDyn.getDate("effectdate");
        Date newInvalidDate = pmmProtocolDyn.getDate("invaliddate");
        if (oldInvalidDate == null && newInvalidDate == null) {
            return true;
        }
        if (oldInvalidDate == null && newInvalidDate.after(oldEffectDate)) {
            return true;
        }
        if (newInvalidDate == null && oldInvalidDate.after(newEffectDate)) {
            return true;
        }
        if (oldInvalidDate != null && newInvalidDate != null) {
            return newEffectDate.compareTo(oldEffectDate) >= 0 && newEffectDate.compareTo(oldInvalidDate) <= 0 || newInvalidDate.compareTo(oldEffectDate) >= 0 && newInvalidDate.compareTo(oldInvalidDate) <= 0;
        }
        return false;
    }

    private void addNewProdPool(DynamicObjectCollection pmmProtocolDynColl) {
        DynamicObjectCollection prodDynArray = this.querySelectedProdDynCollWithNoEntry();
        long userMainOrgId = UserServiceHelper.getUserMainOrgId((long)UserServiceHelper.getCurrentUserId());
        ArrayList orgIdList = new ArrayList(pmmProtocolDynColl.size());
        pmmProtocolDynColl.forEach(pmmProtocolDyn -> orgIdList.add(pmmProtocolDyn.getLong("orgname")));
        HashSet<ProdPool> prodPools = new HashSet<ProdPool>(prodDynArray.size());
        for (DynamicObject prodDyn : prodDynArray) {
            ProdPool prodPool = new ProdPool();
            prodPool.setTaxPrice(prodDyn.getBigDecimal("taxprice"));
            prodPool.setTaxRateID(Long.valueOf(prodDyn.getLong("taxrateid")));
            prodPool.setTaxRate(prodDyn.getBigDecimal("taxrate"));
            prodPool.setPrice(prodDyn.getBigDecimal("price"));
            prodPool.setCreateOrgID(Long.valueOf(userMainOrgId));
            prodPool.setAuditOrgID(Long.valueOf(((DynamicObject)pmmProtocolDynColl.get(0)).getLong("org")));
            prodPool.setPlatform("1");
            prodPool.setUnit(Long.valueOf(prodDyn.getLong("unit")));
            prodPool.setName(prodDyn.getString("name"));
            prodPool.setProductId(Long.valueOf(prodDyn.getLong("id")));
            prodPool.setEffectDate(((DynamicObject)pmmProtocolDynColl.get(0)).getDate("effectdate"));
            prodPool.setInvalidDate(((DynamicObject)pmmProtocolDynColl.get(0)).getDate("invaliddate"));
            prodPool.setCentralPurType(((DynamicObject)pmmProtocolDynColl.get(0)).getString("purmode"));
            prodPool.setIsGoodVisible(Boolean.valueOf(((DynamicObject)pmmProtocolDynColl.get(0)).getBoolean("isgoodvisible")));
            prodPool.setProtocolId(Long.valueOf(((DynamicObject)pmmProtocolDynColl.get(0)).getLong("id")));
            prodPool.setProtocolStatus(((DynamicObject)pmmProtocolDynColl.get(0)).getString("protocolstatus"));
            prodPool.setOrgIdList(orgIdList);
            prodPools.add(prodPool);
        }
        ProdPoolCommandServiceImpl prodPoolCommandService = new ProdPoolCommandServiceImpl();
        List prodPoolDynList = prodPoolCommandService.addNewProdPoolByProtocol(prodPools);
        prodPoolCommandService.auditProdPool(prodPoolDynList);
    }

    private DynamicObjectCollection querySelectedProdDynColl() {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectCol = listview.getSelectedRows();
        if (selectCol.isEmpty()) {
            return new DynamicObjectCollection();
        }
        Object[] entryPrimaryKeyValues = selectCol.getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)entryPrimaryKeyValues);
        if (selectCol.getEntryPrimaryKeyValues().length > 0 && selectCol.getEntryPrimaryKeyValues()[0] != null) {
            entryPrimaryKeyValues = selectCol.getEntryPrimaryKeyValues();
            qFilter = new QFilter("protocolentry.id", "in", (Object)entryPrimaryKeyValues);
        }
        DynamicObjectCollection prodDynColl = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,unit,status,taxprice,taxrateid,taxrate,price,supplier,protocolentry.protocol.id protocol,protocolentry.protocol.differentarea differentarea,protocolentry.protocol.protocolstatus protocolstatus,protocolentry.prodpool.id prodpool,protocolentry.prodpool.salestatus salestatus,protocolentry.prodpool.mallstatus mallstatus,protocolentry.prodpool.auditorg auditorg,protocolentry.prodpool.protocolentry protocolentry,protocolentry.prodpool.protocolentry.purplanid purplanid", (QFilter[])qFilter.toArray());
        return prodDynColl;
    }

    private DynamicObjectCollection queryProdDynCollByPKId() {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectCol = listview.getSelectedRows();
        Object[] primaryKeyValues = selectCol.getPrimaryKeyValues();
        DynamicObjectCollection prodDynColl = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,unit,status,taxprice,taxrateid,taxrate,price,supplier,protocolentry.protocol.id protocol,protocolentry.protocol.protocolstatus protocolstatus,protocolentry.prodpool.id prodpool,protocolentry.prodpool.salestatus salestatus,protocolentry.prodpool.mallstatus mallstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
        return prodDynColl;
    }

    private DynamicObjectCollection querySelectedProdDynCollWithNoEntry() {
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectCol = listview.getSelectedRows();
        Object[] primaryKeyValues = selectCol.getPrimaryKeyValues();
        DynamicObjectCollection prodDynColl = QueryServiceHelper.query((String)"pmm_prodmanage", (String)"id,name,unit,isprotocolprod,status,taxprice,taxrateid,taxrate,price", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)primaryKeyValues)});
        return prodDynColl;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object entryPrimaryKeyValue = list.getCurrentSelectedRowInfo().getEntryPrimaryKeyValue();
        if ("protocol_protocolname".equals(fieldName)) {
            args.setCancel(true);
            DynamicObject prodDynColl = QueryServiceHelper.queryOne((String)"pmm_prodmanage", (String)"protocolentry.id,protocolentry.protocol protocol", (QFilter[])new QFilter[]{new QFilter("protocolentry.id", "=", entryPrimaryKeyValue)});
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("pmm_protocol");
            showParameter.setPkId((Object)prodDynColl.getLong("protocol"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private boolean checkHasProtocolViewPermission() {
        String appId = AppMetadataCache.getAppInfo((String)"pmm").getId();
        boolean hasPermResult = PermissionServiceHelper.checkPermission((Long)UserServiceHelper.getCurrentUserId(), (String)appId, (String)"pmm_protocol", (String)"47150e89000000ac");
        if (!hasPermResult) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u534f\u8bae\u7b7e\u8ba2\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"GoodsManageProdPoolList_23", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

