/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.parent.TreeListBuildTreePlugin;

public class PmmCategoryMatMappingList
extends TreeListBuildTreePlugin {
    private static final String CMBSTANDARDLST = "cmbstandardlst";
    private static final String ZJ = "944841720602823680";
    private static final String MDRGOODSCLASS = "mdr_goodsclass";
    private static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue(CMBSTANDARDLST, (Object)ZJ);
        this.setComboEdit();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"baritemap1"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"tblquery"});
    }

    private void setComboEdit() {
        ComboEdit combo = (ComboEdit)this.getView().getControl(CMBSTANDARDLST);
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(5);
        DynamicObjectCollection comboEdit = this.getStandardDyos();
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5546\u57ce\u5546\u54c1\u5206\u7c7b\u6807\u51c6(00000801)", (String)"PmmCategoryMatMappingList_1", (String)"scm-pmm-formplugin", (Object[])new Object[0])), ZJ));
        if (!CollectionUtils.isEmpty((Collection)comboEdit)) {
            for (DynamicObject dyo : comboEdit) {
                data.add(new ComboItem(this.getStandardName(dyo), dyo.getString("standard.id")));
            }
        }
        combo.setComboItems(data);
    }

    private DynamicObjectCollection getStandardDyos() {
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and(new QFilter("openstatus", "=", (Object)"2").and(new QFilter("tenantid", "=", (Object)RequestContext.getOrCreate().getTenantId())));
        return QueryServiceHelper.query((String)"pmm_ecadmit", (String)"id,number,name,platform,standard.id,standard.number,standard.name", (QFilter[])new QFilter[]{qFilter}, (String)"platform desc");
    }

    private LocaleString getStandardName(DynamicObject dyo) {
        return new LocaleString(dyo.getString("standard.name") + "(" + dyo.getString("standard.number") + ")");
    }

    public void initializeTree(EventObject e) {
        TreeNode node = this.getCloudData(ZJ);
        node.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"PmmCategoryMatMappingList_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        ITreeModel treeModel = this.getTreeModel();
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        if (null == treeModel.getRoot() || treeModel.getRoot().getText().equals(ResManager.loadKDString((String)"\u5168\u90e8", (String)"PmmCategoryMatMappingList_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]))) {
            treeModel.setRoot(node);
            treeView.addNode(node);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        super.refreshNode(e);
        String nodeId = e.getNodeId().toString();
        List<TreeNode> treeNodes = this.getTreeChildren(nodeId);
        e.setChildNodes(treeNodes);
    }

    private List<TreeNode> getTreeChildren(String nodeId) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        Object standardId = this.getModel().getValue(CMBSTANDARDLST);
        QFilter qFilter = new QFilter("standard", "=", (Object)Long.parseLong(String.valueOf(standardId)));
        if (ROOTNODEID.equals(nodeId)) {
            nodeId = "0";
        }
        QFilter qFilter2 = new QFilter("parent", "=", (Object)Long.parseLong(nodeId));
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)MDRGOODSCLASS, (String)"id,number,name,parent,level,longnumber,isleaf", (QFilter[])new QFilter[]{qFilter, qFilter2});
        for (DynamicObject row : dynamicObjects) {
            String parentid = row.getString("parent");
            int level = row.getInt("level");
            if ("0".equals(parentid)) {
                if (level != 1) continue;
                parentid = ROOTNODEID;
            }
            TreeNode node = new TreeNode(parentid, row.getString("id"), row.getString("name"), !row.getBoolean("isleaf"), (Object)row);
            treeNodes.add(node);
        }
        return treeNodes;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String property = e.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)property, (CharSequence)CMBSTANDARDLST)) {
            TreeView treeView = this.getTreeListView().getTreeView();
            TreeNode root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
            } else {
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                treeView.treeNodeClick("", root.getId());
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        String nodeId = this.getTreeListView().getTreeView().getTreeState().getFocusNodeId();
        if (!ROOTNODEID.equals(nodeId)) {
            Iterator iterator = qFilters.iterator();
            while (iterator.hasNext()) {
                QFilter qFilter = (QFilter)iterator.next();
                String property = qFilter.getProperty();
                if (!"goodscategory".equals(property)) continue;
                iterator.remove();
            }
        }
        QFilter filter = this.getRefreshFilter();
        qFilters.add(filter);
    }

    private QFilter getRefreshFilter() {
        String nodeId = this.getTreeListView().getTreeView().getTreeState().getFocusNodeId();
        QFilter qFilter = null;
        String classStandardId = (String)this.getModel().getValue(CMBSTANDARDLST);
        qFilter = new QFilter("goodscategory.standard.id", "=", (Object)Long.parseLong(classStandardId));
        if (ROOTNODEID.equals(nodeId) || nodeId == null) {
            return qFilter;
        }
        long itemClassId = Long.parseLong(nodeId);
        ArrayList<Long> childClassIds = new ArrayList<Long>();
        DynamicObject goodsClass = QueryServiceHelper.queryOne((String)MDRGOODSCLASS, (String)"longnumber,isleaf", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)itemClassId)});
        if (goodsClass != null) {
            if (!goodsClass.getBoolean("isleaf")) {
                String longnumber = goodsClass.getString("longnumber");
                QFilter f1 = new QFilter("longnumber", "like", (Object)(longnumber + ".%"));
                QFilter f2 = new QFilter("standard.id", "=", (Object)Long.parseLong(classStandardId));
                QFilter[] qFilters = new QFilter[]{f1, f2};
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)MDRGOODSCLASS, (String)"id", (QFilter[])qFilters, (String)"id");){
                    dataSet.forEach(row -> childClassIds.add(row.getLong("id")));
                }
            }
            childClassIds.add(itemClassId);
        }
        qFilter.and("goodscategory.id", "in", childClassIds);
        return qFilter;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if (key.equalsIgnoreCase("new")) {
            this.newValid(args);
        }
        if ("batchmaintain".equals(key)) {
            this.batchMaintainValid(args);
        }
    }

    private void newValid(BeforeDoOperationEventArgs args) {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        String nodeId = treeView.getTreeState().getFocusNodeId();
        if (null != nodeId) {
            if (nodeId.equals(ROOTNODEID)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e93\u7ea7\u5546\u54c1\u5206\u7c7b\u540e\u518d\u65b0\u589e\u3002", (String)"PmmCategoryMatMappingList_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            QFilter filters = new QFilter("id", "=", (Object)Long.parseLong(nodeId));
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)MDRGOODSCLASS, (String)"id,level,enable", (QFilter[])filters.toArray());
            if (dynamicObject.getInt("level") != 3) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e93\u7ea7\u5546\u54c1\u5206\u7c7b\u540e\u518d\u65b0\u589e\u3002", (String)"PmmCategoryMatMappingList_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            boolean hasCreated = QueryServiceHelper.exists((String)"pmm_categorymatmapping", (QFilter[])new QFilter("goodscategory.id", "=", (Object)Long.parseLong(nodeId)).toArray());
            if (hasCreated) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b\u5df2\u5173\u8054\u7269\u6599\u5206\u7c7b\uff0c\u4e0d\u53ef\u65b0\u589e\u3002", (String)"PmmCategoryMatMappingList_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if ("0".equals(dynamicObject.getString("enable"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b\u5df2\u7981\u7528\uff0c\u4e0d\u80fd\u7ef4\u62a4\u5bf9\u5e94\u5173\u7cfb\u3002", (String)"PmmCategoryMatMappingList_5", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    private void batchMaintainValid(BeforeDoOperationEventArgs args) {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        String nodeId = treeView.getTreeState().getFocusNodeId();
        if (nodeId.equals(ROOTNODEID)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u3001\u4e8c\u7ea7\u5546\u54c1\u5206\u7c7b\u540e\u518d\u6279\u91cf\u7ef4\u62a4\u3002", (String)"PmmCategoryMatMappingList_4", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        QFilter filters = new QFilter("id", "=", (Object)Long.parseLong(nodeId));
        DynamicObject goodsClass = QueryServiceHelper.queryOne((String)MDRGOODSCLASS, (String)"longnumber,number,level,enable", (QFilter[])filters.toArray());
        if (goodsClass.getInt("level") == 3) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u3001\u4e8c\u7ea7\u5546\u54c1\u5206\u7c7b\u540e\u518d\u6279\u91cf\u7ef4\u62a4\u3002", (String)"PmmCategoryMatMappingList_4", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!"1".equals(goodsClass.getString("enable"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5546\u54c1\u5206\u7c7b\u5df2\u7981\u7528\uff0c\u8bf7\u5148\u542f\u7528\u540e\u518d\u6279\u91cf\u7ef4\u62a4\u3002", (String)"PmmCategoryMatMappingList_7", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String classStandardId = (String)this.getModel().getValue(CMBSTANDARDLST);
        QFilter f1 = new QFilter("longnumber", "like", (Object)(goodsClass.getString("longnumber") + ".%"));
        f1.and(new QFilter("standard.id", "=", (Object)Long.parseLong(classStandardId)));
        f1.and("enable", "=", (Object)"1");
        f1.and("level", "=", (Object)3);
        boolean hasChildClass = QueryServiceHelper.exists((String)MDRGOODSCLASS, (QFilter[])f1.toArray());
        if (!hasChildClass) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u4e0b\u65e0\u53ef\u7528\u7684\u4e09\u7ea7\u5206\u7c7b\uff0c\u65e0\u9700\u6279\u91cf\u7ef4\u62a4\u3002", (String)"PmmCategoryMatMappingList_6", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("batchmaintain".equals(operateKey) && operationResult.isSuccess()) {
            TreeView treeView = (TreeView)this.getView().getControl("treeview");
            String nodeId = treeView.getTreeState().getFocusNodeId();
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("pmm_batchcategorymapping");
            fsp.setCustomParam("classId", (Object)nodeId);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchMaintainCloseCallBack"));
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(fsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if ("batchMaintainCloseCallBack".equals(closedCallBackEvent.getActionId())) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }
}

