/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.BillFormUtil;

public class PmmGoodsRuleLogList
extends AbstractListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("operatedown".equals(operateKey)) {
            this.checkOperateDown(args);
        }
        if ("cancel".equals(operateKey)) {
            this.checkCancel(args);
        }
    }

    private void checkCancel(BeforeDoOperationEventArgs args) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        if (primaryKeyValues.length > 0) {
            HashSet<Long> idSet = new HashSet<Long>(16);
            for (Object id : primaryKeyValues) {
                idSet.add(Long.parseLong(String.valueOf(id)));
            }
            QFilter qFilter = new QFilter("id", "in", idSet);
            qFilter.and(new QFilter("dealstatus", "!=", (Object)"A"));
            boolean isDiffStatus = QueryServiceHelper.exists((String)"pmm_goodsrulelog", (QFilter[])qFilter.toArray());
            if (isDiffStatus) {
                args.setCancel(true);
                String msg = ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u9009\u62e9\u672a\u5904\u7406\u7684\u6570\u636e\u8fdb\u884c\u624b\u5de5\u4f5c\u5e9f\u3002", (String)"PmmGoodsRuleLogList_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(msg);
            }
        }
    }

    private void checkOperateDown(BeforeDoOperationEventArgs args) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        if (primaryKeyValues.length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u624b\u5de5\u4e0b\u67b6\u3002", (String)"PmmGoodsRuleLogList_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (null != afterDoOperationEventArgs.getOperationResult() && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            switch (operateKey) {
                case "operatedown": {
                    this.doOperateDown();
                    break;
                }
                case "cancel": {
                    this.doCancel(afterDoOperationEventArgs);
                    break;
                }
            }
        }
    }

    private void doCancel(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        HashMap<String, String> paramMap = new HashMap<String, String>(16);
        List successPkIds = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds();
        paramMap.put("ids", SerializationUtils.toJsonString((Object)successPkIds));
        FormShowParameter formShowParameter = BillFormUtil.assembleShowDynamicFormParam((String)"pmm_cancellog", paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "cancel"), (ShowType)ShowType.Modal);
        this.getView().showForm(formShowParameter);
    }

    private void doOperateDown() {
        DynamicObjectCollection pmmGoodsRuleLogs = this.getInfos();
        ArrayList<Long> goodsIds = new ArrayList<Long>(16);
        ArrayList<String> goodsPoolIds = new ArrayList<String>(16);
        HashMap<String, String> goodsId_LogIdMap = new HashMap<String, String>(16);
        this.setGoodsMapVal(goodsIds, goodsPoolIds, goodsId_LogIdMap, pmmGoodsRuleLogs);
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        String formId = "";
        if (pmmGoodsRuleLogs.size() > 0) {
            DynamicObject info = (DynamicObject)pmmGoodsRuleLogs.get(0);
            String platform = info.getString("platform");
            params.put("srcbillidMap", SerializationUtils.toJsonString(goodsId_LogIdMap));
            params.put("srcbilltype", "pmm_goodsrulelog");
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(platform)) {
                params.put("biztype", "download");
                params.put("allProd", String.join((CharSequence)",", goodsPoolIds));
                params.put("supplier", info.getLong("supplier"));
                formId = "pmm_prodaudit";
            } else {
                params.put("biztype", "2");
                params.put("goodsids", goodsIds);
                formId = "pmm_ecprodaudit";
            }
        }
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)formId, (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.ADDNEW, (long)0L, params, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "operatedown")));
    }

    private DynamicObjectCollection getInfos() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        QFilter qFilter = new QFilter("id", "in", (Object)primaryKeyValues);
        return QueryServiceHelper.query((String)"pmm_goodsrulelog", (String)"id,supplier,platform,goodspool.id,goodsid,goodspool.protocol,goodspool.protocolentry", (QFilter[])qFilter.toArray());
    }

    private void setGoodsMapVal(List<Long> goodsIds, List<String> goodsPoolIds, Map<String, String> goodsId_logIdMap, DynamicObjectCollection pmmGoodsRuleLogs) {
        for (DynamicObject row : pmmGoodsRuleLogs) {
            String goodsid = row.getString("goodsid");
            if (EcPlatformEnum.ECPLATFORM_SELF.getVal().equals(row.getString("platform"))) {
                String protocolEntry;
                if (StringUtils.isEmpty((CharSequence)row.getString("goodsid"))) continue;
                String protocolId = row.getString("goodspool.protocol");
                if (StringUtils.isEmpty((CharSequence)protocolId)) {
                    protocolId = "0";
                }
                if (StringUtils.isEmpty((CharSequence)(protocolEntry = row.getString("goodspool.protocolentry")))) {
                    protocolEntry = "0";
                }
                goodsPoolIds.add(row.getString("goodspool.id"));
                goodsId_logIdMap.put(goodsid + protocolId + protocolEntry, row.getString("id"));
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)row.getString("goodsid"))) continue;
            goodsIds.add(Long.parseLong(goodsid));
            goodsId_logIdMap.put(row.getString("goodsid"), row.getString("id"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("operatedown".equals(actionId) || "cancel".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }
}

