/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.list;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scm.common.helper.apiconnector.api.util.EcApiUtil;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.MutexUtil;
import kd.scm.pmm.common.util.PmmMallGoodsUtil;

public class PmmMallGoodsList
extends AbstractListPlugin {
    private static final String EC_SEARCH = "ec_search";

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("mappingupgrade".equals(evt.getItemKey())) {
            JobInfo jobInfo = new JobInfo();
            String routeAppId = this.getView().getFormShowParameter().getServiceAppId();
            jobInfo.setAppId(routeAppId);
            jobInfo.setJobType(JobType.REALTIME);
            jobInfo.setName(ResManager.loadKDString((String)"\u6570\u636e\u5347\u7ea7\u4e2d", (String)"PmmOperateruleList_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            jobInfo.setId(UUID.randomUUID().toString());
            jobInfo.setTaskClassname("kd.scm.pmm.formplugin.task.PmmEcGoodsMappingUpgradeTask");
            HashMap params = new HashMap();
            jobInfo.setParams(params);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "taskcloseback");
            JobFormInfo clientJobInfo = new JobFormInfo(jobInfo);
            clientJobInfo.setCloseCallBack(closeCallBack);
            clientJobInfo.setCanBackground(false);
            JobForm.dispatch((JobFormInfo)clientJobInfo, (IFormView)this.getView());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String platform = this.getPlatform();
        DynamicObject ecAdminDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"pmm_ecadmit", (QFilter[])new QFilter[]{new QFilter("platform", "=", (Object)platform).and("openstatus", "=", (Object)"2")});
        if (ecAdminDyn != null) {
            this.getView().setVisible(Boolean.valueOf(ecAdminDyn.getBoolean("external_search")), new String[]{"bar_external_search"});
        }
        if (!MalOrderUtil.getDefaultMalVersion()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_addtopackege"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        IListView listview;
        ListSelectedRowCollection selectCol;
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        if ("setmaterialmapping".equals(key) && (selectCol = (listview = (IListView)this.getView()).getSelectedRows()).getPrimaryKeyValues().length > 1) {
            listview.showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5bf9\u5355\u4e2a\u5546\u54c1\u8bbe\u7f6e\u7269\u6599\u5bf9\u5e94\u5173\u7cfb\u3002", (String)"GoodsManageList_23", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("del_download".equals(operateKey)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                PmmMallGoodsUtil.delDownloadGoods(new ArrayList(), (String)this.getPlatform());
            } else {
                Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
                PmmMallGoodsUtil.delDownloadGoods(Arrays.asList(primaryKeyValues), (String)this.getPlatform());
            }
            this.getView().invokeOperation("refresh");
        } else if ("update_ec_isc_schema".equals(operateKey)) {
            PmmMallGoodsUtil.updateEcIscSchema((String)this.getPlatform());
        } else if ("clean_duplicate_items".equals(operateKey)) {
            PmmMallGoodsUtil.cleanDuplicateItems((String)this.getPlatform());
        } else if ("external_search".equals(operateKey)) {
            this.externalSearch();
        } else if ("addtopackege".equals(operateKey)) {
            OperationResult result = afterDoOperationEventArgs.getOperationResult();
            if (null == result || !result.isSuccess()) {
                return;
            }
            this.checkAddtopackege(afterDoOperationEventArgs);
        }
        if ("setmaterialmapping".equals(operateKey)) {
            this.showMaterialMapping();
        }
    }

    private void showMaterialMapping() {
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("openStyle", "setmaterialmapping");
        IListView listview = (IListView)this.getView();
        ListSelectedRowCollection selectCol = listview.getSelectedRows();
        customParams.put("selectType", "ecgoods");
        QFilter qFilter = new QFilter("id", "=", selectCol.get(0).getPrimaryKeyValue());
        DynamicObject ecGoods = QueryServiceHelper.queryOne((String)"pmm_mallgoods", (String)"id,source,prodmatmapping", (QFilter[])qFilter.toArray());
        BillShowParameter param = new BillShowParameter();
        param.setStatus(OperationStatus.ADDNEW);
        if (null != ecGoods) {
            customParams.put("source", ecGoods.getString("source"));
            long prodMappingId = ecGoods.getLong("prodmatmapping");
            if (0L != prodMappingId) {
                boolean request = MutexUtil.request((String)ecGoods.getString("id"), (String)"pmm_mallgoods", (String)"setmaterialmapping");
                if (!request) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6253\u5f00\u5546\u54c1\u5bf9\u5e94\u8868\u5931\u8d25\uff0c\u5176\u4ed6\u7528\u6237\u6b63\u5728\u7f16\u8f91\u3002", (String)"GoodsManageList_26", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                }
                param.setStatus(OperationStatus.EDIT);
                param.setPkId((Object)prodMappingId);
            }
        }
        customParams.put("id", selectCol.get(0).getPrimaryKeyValue().toString());
        param.setFormId("pmm_prodmatmapping");
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setCustomParams(customParams);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "setmaterialmapping"));
        this.getView().showForm((FormShowParameter)param);
    }

    private void externalSearch() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("mal_search_parampage");
        fsp.setAppId("mal");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EC_SEARCH));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("sources", this.getPlatform());
        fsp.setCustomParam("malSearchParam", params);
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        if (EC_SEARCH.equals(closedCallBackEvent.getActionId()) && !ObjectUtils.isEmpty((Object)(returnData = closedCallBackEvent.getReturnData()))) {
            String malSearchStr = JSON.toJSONString((Object)returnData);
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("mal_ecsearch_v1");
            fsp.getOpenStyle().setShowType(ShowType.NewWindow);
            fsp.setCustomParam("param_search", (Object)malSearchStr);
            fsp.setCustomParam("ec_search_source", (Object)this.getPlatform());
            this.getView().showForm(fsp);
        }
        if (StringUtils.equals((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)"setmaterialmapping")) {
            IListView listview = (IListView)this.getView();
            ListSelectedRowCollection selectCol = listview.getSelectedRows();
            if (selectCol.size() > 0) {
                MutexUtil.release((String)selectCol.get(0).getPrimaryKeyValue().toString(), (String)"pmm_mallgoods", (String)"setmaterialmapping");
            }
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }

    private String getPlatform() {
        String cmbstandardlst = this.getModel().getDataEntity().getString("cmbstandardlst");
        if (ObjectUtils.isEmpty((Object)cmbstandardlst)) {
            return "";
        }
        return EcApiUtil.getSource((String)cmbstandardlst);
    }

    private void checkAddtopackege(AfterDoOperationEventArgs e) {
        IListView listview = (IListView)this.getView();
        Object[] selectCol = listview.getSelectedRows().getPrimaryKeyValues();
        if (selectCol.length == 0) {
            return;
        }
        if (null != selectCol) {
            ArrayList<Long> proIds = new ArrayList<Long>(selectCol.length);
            for (Object s : selectCol) {
                proIds.add(Long.parseLong(s.toString()));
            }
            QFilter idFilter = new QFilter("id", "in", proIds);
            QFilter[] filters = new QFilter[]{idFilter};
            String selectFields = "id,number,name,source,status";
            DynamicObjectCollection col = QueryServiceHelper.query((String)"pmm_mallgoods", (String)selectFields, (QFilter[])filters);
            StringBuilder msg = new StringBuilder(64);
            HashSet<String> prodList = new HashSet<String>(col.size());
            for (DynamicObject prod : col) {
                if (!"C".equals(prod.getString("status"))) {
                    msg.append(ResManager.loadKDString((String)"\u5546\u54c1{0}\uff1a\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u5546\u54c1\u624d\u5141\u8bb8\u52a0\u5165\u91c7\u8d2d\u5957\u9910\u3002\r\n", (String)"PmmMallGoodsList_0", (String)"scm-pmm-formplugin", (Object[])new Object[]{prod.getString("number") + prod.getString("name")}));
                    continue;
                }
                prodList.add(String.valueOf(prod.getLong("id")));
            }
            String appId = AppMetadataCache.getAppInfo((String)"pmm").getId();
            HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)UserServiceHelper.getCurrentUserId(), (String)"04", (boolean)true, (String)appId, (String)"pmm_packageselection", (String)"47156aff000000ac");
            List orgids = hasPermOrgResult.getHasPermOrgs();
            if (!hasPermOrgResult.hasAllOrgPerm() && orgids.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u201c\u91c7\u8d2d\u5957\u9910\u201d\u7684\u201c\u65b0\u589e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PmmMallGoodsList_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return;
            }
            Long org = 0L;
            long curOrg = RequestContext.get().getOrgId();
            if (hasPermOrgResult.hasAllOrgPerm()) {
                DynamicObject orgDyn = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,fispurchase", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)curOrg)});
                if (orgDyn == null) {
                    DynamicObjectCollection orgDyncol = QueryServiceHelper.query((String)"bos_org", (String)"id,fispurchase", (QFilter[])new QFilter[]{new QFilter("fispurchase", "=", (Object)"1")});
                    if (orgDyncol.size() > 0) {
                        org = ((DynamicObject)orgDyncol.get(0)).getLong("id");
                    }
                } else {
                    org = curOrg;
                }
            } else {
                org = !orgids.contains(curOrg) ? (Long)orgids.get(0) : Long.valueOf(curOrg);
            }
            if (prodList.size() == 0 && msg.length() > 0) {
                this.getView().showTipNotification(msg.toString());
                return;
            }
            this.getPageCache().put("pakage_org", String.valueOf(org));
            this.getPageCache().put("pakage_prodlist", String.join((CharSequence)",", prodList));
            if (msg.length() > 0) {
                String error = String.format(ResManager.loadKDString((String)"\u5df2\u9009 %1$s\u6761\u6570\u636e\u52a0\u5165\u91c7\u8d2d\u5957\u9910\uff0c\u7b26\u5408\u6761\u4ef6\u7684%2$s\u6761\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PmmMallGoodsList_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]), selectCol.length, prodList.size());
                this.getView().showConfirm(error, msg.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("addtopackege"));
            } else {
                this.addPackege();
            }
        }
    }

    private void addPackege() {
        String prodliststr = this.getPageCache().get("pakage_prodlist");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("source", "pbd_mallgoods");
        param.put("allprodids", prodliststr);
        param.put("cur_org", this.getPageCache().get("pakage_org"));
        this.getPageCache().remove("pakage_org");
        this.getPageCache().remove("pakage_prodlist");
        this.getPageCache().remove("pbd_mallgoods");
        this.getView().showForm((FormShowParameter)BillFormUtil.assembleShowBillFormParam((String)"pmm_packageselection", (ShowType)ShowType.MainNewTabPage, (OperationStatus)OperationStatus.ADDNEW, (long)0L, param, null));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("addtopackege".equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.addPackege();
        }
    }
}

