/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.plugin.ICardCustomFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.HyperLinkClickUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.PurBizPersonUtil;
import kd.scm.common.util.StringConversionUtil;
import kd.scm.pmm.business.service.impl.PmmAuditCfmValidatorServiceImpl;

public class PmmPriceAuditList
extends AbstractListPlugin
implements ICardCustomFilter {
    private static Log log = LogFactory.getLog(PmmPriceAuditList.class);
    private static final String KEY_CONFIRM = "confirm";
    private static final String BILLSTATUS = "billstatus";
    private static final String CFMSTATUS = "cfmstatus";
    private static final String ORIGIN = "origin";
    private static final String ORIGIN_SUP = "1";
    private static final String ORIGIN_PUR = "2";
    private static final String ORG = "org";
    private static final String MODE = "mode";
    private static final String BILLIDLIST = "billidlist";
    private static final String RESULTCALLBACKID = "confirmActionId";
    private static final String MALLMANAGEBIZAPPID = "/FQ504NB63AY";
    private static final String AUDITCFM = "auditCfm";

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        this.malVersionView(args);
    }

    private void malVersionView(BeforeCreateListColumnsArgs args) {
        boolean defaultMalVersion = MalOrderUtil.getDefaultMalVersion();
        Set<String> hideColumns = this.malVersionHideColumns(defaultMalVersion);
        List listColumns = args.getListColumns();
        for (IListColumn listColumn : listColumns) {
            String listFieldKey;
            if (!(listColumn instanceof ListColumn) || !hideColumns.contains(listFieldKey = listColumn.getListFieldKey())) continue;
            listColumn.setVisible(0);
        }
    }

    private Set<String> malVersionHideColumns(boolean isMalNewVersion) {
        HashSet<String> hideColumns = new HashSet<String>(16);
        if (!isMalNewVersion) {
            hideColumns.add("prodpool.protocol.billno");
        }
        return hideColumns;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilterList = e.getQFilters();
        qFilterList.add(this.getListFilter());
    }

    public QFilter getCustomFilter() {
        return this.getListFilter();
    }

    public List<QFilter> getCustomFilterList() {
        return null;
    }

    public QFilter getListFilter() {
        QFilter qFilter = null;
        List orgid = OrgUtil.getAllPurViewPermissionOrgs((String)"pmm_priceaudit");
        QFilter orgFilter = new QFilter(ORG, "in", (Object)orgid);
        ArrayList<String> billStatusList = new ArrayList<String>();
        billStatusList.add(BillStatusEnum.AUDIT.getVal());
        billStatusList.add(BillStatusEnum.CLOSED.getVal());
        billStatusList.add(BillStatusEnum.CANCELED.getVal());
        QFilter purFilter = new QFilter(ORIGIN, "=", (Object)ORIGIN_PUR).and(orgFilter);
        purFilter.and(orgFilter);
        qFilter = new QFilter(ORIGIN, "=", (Object)ORIGIN_SUP).and(new QFilter(BILLSTATUS, "in", billStatusList)).or(new QFilter(ORIGIN, "=", (Object)ORIGIN_SUP).and(new QFilter(CFMSTATUS, "=", (Object)"D")));
        qFilter.and(orgFilter);
        DynamicObjectCollection bizpersons = PurBizPersonUtil.getBizPartners((String[])new String[]{"prodclass", "supscope", "supclass"});
        HashSet<Long> prodclasses = new HashSet<Long>();
        HashSet<Long> supscopes = new HashSet<Long>();
        HashSet<Long> supclasses = new HashSet<Long>();
        for (DynamicObject bizperson : bizpersons) {
            String supclass;
            String supscope;
            String prodclass = bizperson.getString("prodclass");
            if (!"0".equals(prodclass)) {
                prodclasses.add(Long.valueOf(prodclass));
            }
            if (!"0".equals(supscope = bizperson.getString("supscope"))) {
                supscopes.add(Long.valueOf(supscope));
            }
            if ("0".equals(supclass = bizperson.getString("supclass"))) continue;
            supclasses.add(Long.valueOf(supclass));
        }
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("group", "in", supclasses)});
        for (DynamicObject dynamicObject : objects) {
            String id = dynamicObject.getString("id");
            if ("0".equals(id)) continue;
            supscopes.add(Long.valueOf(id));
        }
        if (supscopes.size() > 0) {
            qFilter.and(new QFilter("supplier", "in", supscopes));
        }
        if (prodclasses.size() > 0) {
            qFilter.and(new QFilter("entryentity.class", "in", prodclasses));
        }
        qFilter.or(purFilter);
        return qFilter;
    }

    private boolean checkBeforeAudit() {
        IListView listview = (IListView)this.getView();
        StringBuilder sb = new StringBuilder();
        ListSelectedRowCollection selectCols = listview.getSelectedRows();
        if (selectCols.size() == 0) {
            return false;
        }
        ArrayList<String> noFlowIdList = new ArrayList<String>();
        for (Object id : selectCols.getPrimaryKeyValues()) {
            if (WorkflowServiceHelper.inProcess((String)String.valueOf(id))) continue;
            noFlowIdList.add(id.toString());
        }
        IPageCache cache = this.getPageCache();
        cache.put("select", String.join((CharSequence)",", noFlowIdList));
        QFilter filter = new QFilter("id", "in", (Object)selectCols.getPrimaryKeyValues());
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"pmm_priceaudit", (String)"id,org,billno,cfmstatus", (QFilter[])filters);
        StringBuilder errorString = new StringBuilder();
        for (DynamicObject obj : objs) {
            if (noFlowIdList.contains(obj.getString("id"))) {
                String cfmstatus = obj.getString(CFMSTATUS);
                if ("A".equals(cfmstatus)) continue;
                sb.append(String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u53f7\u7b49\u4e8e%s\u7684\u8c03\u4ef7\u7533\u8bf7\u5355\u4e0d\u662f\u5f85\u5ba1\u6279\u7684\u72b6\u6001\uff0c\u4e0d\u80fd\u5ba1\u6279\u3002\n", (String)"PmmPriceAuditList_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]), obj.getString("billno")));
                this.removeProd(obj.getString("id"));
                continue;
            }
            errorString.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5355\u636e\u5df2\u5728\u6d41\u7a0b\u4e2d\u6d41\u8f6c\uff0c\u4e0d\u80fd\u5ba1\u6279\u3002\n", (String)"PmmPriceAuditList_4", (String)"scm-pmm-formplugin", (Object[])new Object[0]), obj.getString("billno")));
        }
        if (selectCols.getPrimaryKeyValues().length != noFlowIdList.size()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5ba1\u6279\u5931\u8d25\uff0c\u5b58\u5728\u5355\u636e\u5df2\u5728\u6d41\u7a0b\u4e2d\u6d41\u8f6c\u3002", (String)"PmmPriceAuditList_5", (String)"scm-pmm-formplugin", (Object[])new Object[0]), errorString.toString(), MessageTypes.Default);
            return false;
        }
        ArrayList selectList = StringConversionUtil.conversion((String)this.getPageCache().get("select"));
        if (sb.length() > 0 && selectList.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5747\u4e0d\u7b26\u5408\u89c4\u5219\u3002", (String)"PmmPriceAuditList_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]), String.valueOf(sb), MessageTypes.Default);
            return false;
        }
        if (sb.length() > 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e\u4e0d\u7b26\u5408\u89c4\u5219\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PmmPriceAuditList_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]), String.valueOf(sb), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(AUDITCFM));
            return false;
        }
        return true;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "confirmActionId": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (AUDITCFM.equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.auditResult();
        }
    }

    private void auditResult() {
        this.openDealPage("pmm_priceauditcfm", RESULTCALLBACKID, ShowType.Modal);
    }

    private void openDealPage(String pageKey, String actionId, ShowType showType) {
        if (this.checkGoodsHasChange()) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
            return;
        }
        String select = this.getPageCache().get("select");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put(BILLIDLIST, select);
        paramMap.put(MODE, "batch");
        log.info("$$$$217" + select);
        this.getView().showForm(BillFormUtil.assembleShowDynamicFormParam((String)pageKey, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, actionId), (ShowType)showType));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (StringUtils.equals((CharSequence)"billno", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            int rowIndex = args.getRowIndex();
            BillList list = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection selectRows = list.getSelectedRows();
            Iterator iterator = selectRows.iterator();
            Long id = 0L;
            while (iterator.hasNext()) {
                ListSelectedRow row = (ListSelectedRow)iterator.next();
                if (row.getRowKey() != rowIndex) continue;
                id = (Long)row.getPrimaryKeyValue();
            }
            DynamicObject dyo = QueryServiceHelper.queryOne((String)"pmm_pricerequest", (String)"origin, billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
            if (dyo != null && dyo.getString(ORIGIN).equals(ORIGIN_PUR) && dyo.getString(BILLSTATUS).equals("A")) {
                BillShowParameter billShowParameter = new BillShowParameter();
                billShowParameter.setBillStatus(BillOperationStatus.EDIT);
                billShowParameter.setStatus(OperationStatus.EDIT);
                billShowParameter.setFormId("pmm_pricerequest");
                billShowParameter.setPkId((Object)id);
                billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)billShowParameter);
                args.setCancel(true);
                return;
            }
        }
        if (StringUtils.equals((CharSequence)"goods_name", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            HyperLinkClickUtil.MallGoodsView((IFormView)this.getView(), (String)"pmm_priceaudit", (String)"entryentity.goods", (String)"entryentity.id", (String)"pmm_prodmanage");
        }
    }

    private void removeProd(String prodpk) {
        ArrayList selectCols = StringConversionUtil.conversion((String)this.getPageCache().get("select"));
        for (int i = selectCols.size() - 1; i >= 0; --i) {
            if (!prodpk.equalsIgnoreCase((String)selectCols.get(i))) continue;
            selectCols.remove(i);
        }
        IPageCache cache = this.getPageCache();
        cache.put("select", String.join((CharSequence)",", selectCols));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        String itemKey = args.getOperateKey();
        if (itemKey.equals("add")) {
            BillShowParameter billShowParameter = new BillShowParameter();
            billShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
            billShowParameter.setStatus(OperationStatus.ADDNEW);
            billShowParameter.setFormId("pmm_pricerequest");
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)billShowParameter);
            return;
        }
        if (null == result || !result.isSuccess()) {
            return;
        }
        switch (itemKey) {
            case "confirm": {
                if (!this.checkBeforeAudit()) break;
                this.auditResult();
                break;
            }
        }
    }

    private boolean checkGoodsHasChange() {
        PmmAuditCfmValidatorServiceImpl pmmAuditCfmValidatorService = new PmmAuditCfmValidatorServiceImpl();
        ArrayList selectCols = StringConversionUtil.conversion((String)this.getPageCache().get("select"));
        List ids = selectCols.stream().map(Long::valueOf).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObject[] prodAudits = BusinessDataServiceHelper.load((String)"pmm_priceaudit", (String)"id,billno,cfmstatus,suggestion,entryentity.goods,entryentity.prodpool", (QFilter[])qFilter.toArray());
        StringBuilder msg = pmmAuditCfmValidatorService.checkGoodsProtocol(prodAudits);
        if (msg.length() > 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u90e8\u5206\u5546\u54c1\u5df2\u5173\u8054\u534f\u8bae\uff0c\u6570\u636e\u5df2\u6539\u53d8\uff0c\u8bf7\u91cd\u65b0\u53d1\u8d77\u8c03\u4ef7\u7533\u8bf7\u3002", (String)"PmmPriceAuditList_6", (String)"scm-pmm-formplugin", (Object[])new Object[0]), msg.toString(), MessageBoxOptions.OK, ConfirmTypes.Default, new ConfirmCallBackListener(KEY_CONFIRM));
            return true;
        }
        return false;
    }
}

