/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.plugin.ICardCustomFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.plugin.AbstractMalListPlugin;
import kd.scm.common.util.BillFormUtil;
import kd.scm.common.util.HyperLinkClickUtil;
import kd.scm.common.util.MalOrderUtil;
import kd.scm.common.util.OrgUtil;
import kd.scm.common.util.PurBizPersonUtil;
import kd.scm.common.util.StringConversionUtil;

public class PmmProdAuditList
extends AbstractMalListPlugin
implements ICardCustomFilter {
    private static final String KEY_CONFIRM = "confirm";
    private static final String BILLSTATUS = "billstatus";
    private static final String CFMSTATUS = "cfmstatus";
    private static final String ORIGIN = "origin";
    private static final String ORIGIN_SUP = "1";
    private static final String ORIGIN_PUR = "2";
    private static final String ORG = "org";
    private static final String MODE = "mode";
    private static final String BILLIDLIST = "billidlist";
    private static final String RESULTCALLBACKID = "confirmActionId";
    private static final String AUDITCFM = "auditCfm";
    private static final String BIZTYPE_UPLOAD = "1";
    private static final String BIZTYPE_DOWNLOAD = "2";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (!MalOrderUtil.getDefaultMalVersion()) {
            e.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u4e0a\u67b6\u7ba1\u7406", (String)"PmmProdAuditList_14", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        this.malVersionView(args);
    }

    private void malVersionView(BeforeCreateListColumnsArgs args) {
        boolean defaultMalVersion = MalOrderUtil.getDefaultMalVersion();
        Set<String> hideColumns = this.malVersionHideColumns(defaultMalVersion);
        List listColumns = args.getListColumns();
        for (IListColumn listColumn : listColumns) {
            String listFieldKey;
            if (!(listColumn instanceof ListColumn) || !hideColumns.contains(listFieldKey = listColumn.getListFieldKey())) continue;
            listColumn.setVisible(0);
        }
    }

    private Set<String> malVersionHideColumns(boolean isMalNewVersion) {
        HashSet<String> hideColumns = new HashSet<String>(16);
        if (!isMalNewVersion) {
            hideColumns.add("protocolid.billno");
        }
        return hideColumns;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilterList = e.getQFilters();
        qFilterList.add(this.getListFilter());
    }

    public QFilter getCustomFilter() {
        return this.getListFilter();
    }

    public List<QFilter> getCustomFilterList() {
        return null;
    }

    public QFilter getListFilter() {
        List orgid = OrgUtil.getAllPurViewPermissionOrgs((String)"pmm_prodaudit");
        QFilter orgFilter = new QFilter(ORG, "in", (Object)orgid);
        ArrayList<String> billStatusList = new ArrayList<String>();
        billStatusList.add(BillStatusEnum.AUDIT.getVal());
        billStatusList.add(BillStatusEnum.CLOSED.getVal());
        billStatusList.add(BillStatusEnum.CANCELED.getVal());
        QFilter qFilter = new QFilter(ORIGIN, "=", (Object)"2").or(new QFilter(ORIGIN, "=", (Object)"1").and(new QFilter(BILLSTATUS, "in", billStatusList)).or(new QFilter(ORIGIN, "=", (Object)"1").and(new QFilter(CFMSTATUS, "=", (Object)"D"))));
        qFilter.and(orgFilter).and("platform", "=", (Object)EcPlatformEnum.ECPLATFORM_SELF.getVal());
        DynamicObjectCollection bizpersons = PurBizPersonUtil.getBizPartners((String[])new String[]{"prodclass", "supscope", "supclass"});
        HashSet<Long> prodclasses = new HashSet<Long>();
        HashSet<Long> supscopes = new HashSet<Long>();
        HashSet<Long> supclasses = new HashSet<Long>();
        for (DynamicObject bizperson : bizpersons) {
            String supclass;
            String supscope;
            String prodclass = bizperson.getString("prodclass");
            if (!"0".equals(prodclass)) {
                prodclasses.add(Long.valueOf(prodclass));
            }
            if (!"0".equals(supscope = bizperson.getString("supscope"))) {
                supscopes.add(Long.valueOf(supscope));
            }
            if ("0".equals(supclass = bizperson.getString("supclass"))) continue;
            supclasses.add(Long.valueOf(supclass));
        }
        DynamicObjectCollection objects = QueryServiceHelper.query((String)"bd_supplier", (String)"id", (QFilter[])new QFilter[]{new QFilter("group", "in", supclasses)});
        for (DynamicObject dynamicObject : objects) {
            String id = dynamicObject.getString("id");
            if ("0".equals(id)) continue;
            supscopes.add(Long.valueOf(id));
        }
        if (supscopes.size() > 0) {
            qFilter.and(new QFilter("supplier", "in", supscopes));
        }
        if (prodclasses.size() > 0) {
            qFilter.and(new QFilter("entryentity.class", "in", prodclasses));
        }
        return qFilter;
    }

    private boolean checkBeforeAudit() {
        IListView listview = (IListView)this.getView();
        StringBuilder sb = new StringBuilder();
        ListSelectedRowCollection selectCols = listview.getSelectedRows();
        if (selectCols.size() == 0) {
            return false;
        }
        ArrayList<String> noFlowIdList = new ArrayList<String>();
        for (Object id : selectCols.getPrimaryKeyValues()) {
            if (WorkflowServiceHelper.inProcess((String)String.valueOf(id))) continue;
            noFlowIdList.add(id.toString());
        }
        IPageCache cache = this.getPageCache();
        cache.put("select", String.join((CharSequence)",", noFlowIdList));
        QFilter filter = new QFilter("id", "in", (Object)selectCols.getPrimaryKeyValues());
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection objs = QueryServiceHelper.query((String)"pmm_prodaudit", (String)"id,org,billno,cfmstatus,biztype", (QFilter[])filters);
        StringBuilder errorString = new StringBuilder();
        String biztype = null;
        for (DynamicObject obj : objs) {
            if (noFlowIdList.contains(obj.getString("id"))) {
                String cfmstatus = obj.getString(CFMSTATUS);
                if (!"A".equals(cfmstatus)) {
                    sb.append(String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u5355\u53f7\u7b49\u4e8e%s\u7684\u4e0a\u67b6\u7533\u8bf7\u5355\u4e0d\u662f\u5f85\u5ba1\u6279\u7684\u72b6\u6001\uff0c\u4e0d\u80fd\u5ba1\u6279\u3002\n", (String)"PmmProdAuditList_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]), obj.getString("billno")));
                    this.removeProd(obj.getString("id"));
                }
            } else {
                errorString.append(String.format(ResManager.loadKDString((String)"%s\uff1a\u5355\u636e\u5df2\u5728\u6d41\u7a0b\u4e2d\u6d41\u8f6c\uff0c\u4e0d\u80fd\u5ba1\u6279\u3002\n", (String)"PmmProdAuditList_4", (String)"scm-pmm-formplugin", (Object[])new Object[0]), obj.getString("billno")));
            }
            String objBizType = obj.getString("biztype");
            if (biztype != null && !objBizType.equals(biztype)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u67b6/\u4e0b\u67b6\u7533\u8bf7\u8bf7\u5206\u5f00\u5ba1\u6838\u3002", (String)"PmmProdAuditList_12", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                return false;
            }
            biztype = objBizType;
        }
        cache.put("biztype", biztype);
        if (selectCols.getPrimaryKeyValues().length != noFlowIdList.size()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5ba1\u6279\u5931\u8d25\uff0c\u5b58\u5728\u5355\u636e\u5df2\u5728\u6d41\u7a0b\u4e2d\u6d41\u8f6c\u3002", (String)"PmmProdAuditList_5", (String)"scm-pmm-formplugin", (Object[])new Object[0]), errorString.toString(), MessageTypes.Default);
            return false;
        }
        ArrayList selectList = StringConversionUtil.conversion((String)this.getPageCache().get("select"));
        if (sb.length() > 0 && selectList.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5747\u4e0d\u7b26\u5408\u89c4\u5219\u3002", (String)"PmmProdAuditList_2", (String)"scm-pmm-formplugin", (Object[])new Object[0]), String.valueOf(sb), MessageTypes.Default);
            return false;
        }
        if (sb.length() > 0) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4ee5\u4e0b\u5355\u636e\u4e0d\u7b26\u5408\u89c4\u5219\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PmmProdAuditList_3", (String)"scm-pmm-formplugin", (Object[])new Object[0]), String.valueOf(sb), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(AUDITCFM));
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (AUDITCFM.equals(callBackId) && messageBoxClosedEvent.getResult().compareTo((Enum)MessageBoxResult.Yes) == 0) {
            this.auditResult();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "confirmActionId": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void auditResult() {
        this.openDealPage("pmm_prodauditcfm", RESULTCALLBACKID, ShowType.Modal);
    }

    private void openDealPage(String pageKey, String actionId, ShowType showType) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put(BILLIDLIST, this.getPageCache().get("select"));
        paramMap.put("biztype", this.getPageCache().get("biztype"));
        paramMap.put(MODE, "batch");
        FormShowParameter formShowParameter = BillFormUtil.assembleShowDynamicFormParam((String)pageKey, paramMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, actionId), (ShowType)showType);
        if ("2".equals(this.getPageCache().get("biztype"))) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u4e0b\u67b6\u5ba1\u6279\u7ed3\u679c", (String)"PmmProdAuditList_15", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm(formShowParameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (StringUtils.equals((CharSequence)"goods_name", (CharSequence)args.getHyperLinkClickEvent().getFieldName())) {
            args.setCancel(true);
            HyperLinkClickUtil.MallGoodsView((IFormView)this.getView(), (String)"pmm_prodaudit", (String)"entryentity.goods", (String)"entryentity.id", (String)"pmm_prodmanage");
        }
    }

    private void removeProd(String prodpk) {
        ArrayList selectCols = StringConversionUtil.conversion((String)this.getPageCache().get("select"));
        for (int i = selectCols.size() - 1; i >= 0; --i) {
            if (!prodpk.equalsIgnoreCase((String)selectCols.get(i))) continue;
            selectCols.remove(i);
        }
        IPageCache cache = this.getPageCache();
        cache.put("select", String.join((CharSequence)",", selectCols));
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String itemKey;
        super.afterDoOperation(args);
        OperationResult result = args.getOperationResult();
        if (null == result || !result.isSuccess()) {
            return;
        }
        switch (itemKey = args.getOperateKey()) {
            case "confirm": {
                if (!this.checkBeforeAudit()) break;
                this.auditResult();
                break;
            }
            case "resubmit": {
                AppCache.get((String)this.getView().getPageId()).put("resubmit", (Object)"true");
                this.getView().invokeOperation("copy");
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)operate.getOperateKey(), (CharSequence)"resubmit")) {
            this.checkResubmit(args);
        }
    }

    private void checkResubmit(BeforeDoOperationEventArgs args) {
        BillList list = (BillList)this.getView().getControl("billlistap");
        Object[] objects = list.getSelectedRows().getPrimaryKeyValues();
        if (objects.length != 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u4e14\u53ea\u80fd\u9009\u62e9\u4e00\u5f20\u5355\u636e\u64cd\u4f5c\u3002", (String)"PmmProdAuditList_16", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }
}

