/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.task;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.util.ExceptionUtil;

public class PmmEcGoodsMappingUpgradeTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(PmmEcGoodsMappingUpgradeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        log.info("kd.scm.pmm.formplugin.task.PmmEcGoodsMappingUpgradeTask execute start ---------");
        try {
            this.doEcGoodsMappingUpgrade();
        }
        catch (Exception e) {
            log.info(ExceptionUtil.getStackTrace((Throwable)e));
        }
        log.info("kd.scm.pmm.formplugin.task.PmmEcGoodsMappingUpgradeTask execute end ---------");
    }

    private void doEcGoodsMappingUpgrade() {
        QFilter qFilter = new QFilter("platform", "!=", (Object)EcPlatformEnum.ECPLATFORM_SELF.getVal());
        qFilter.and(new QFilter("platform", "!=", (Object)""));
        qFilter.and(new QFilter("ecgoods", "!=", (Object)0L));
        qFilter.and(new QFilter("material", "!=", (Object)0L));
        HashMap<Long, String> ecGooodsMap = new HashMap<Long, String>(16);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PmmEcGoodsMappingUpgradeTask", (String)"pmm_prodmatmapping", (String)"ecgoods,platform,material,id", (QFilter[])qFilter.toArray(), (String)"id");){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                ecGooodsMap.put(row.getLong("ecgoods"), row.getString("id") + "_" + row.getString("material"));
            }
        }
        if (ecGooodsMap.size() > 0) {
            DynamicObject[] pmm_mallgoods;
            QFilter ecQf = new QFilter("id", "in", ecGooodsMap.keySet());
            for (DynamicObject info : pmm_mallgoods = BusinessDataServiceHelper.load((String)"pmm_mallgoods", (String)"prodmatmapping,id,material", (QFilter[])ecQf.toArray())) {
                String[] keys;
                long id = info.getLong("id");
                if (null == ecGooodsMap.get(id) || StringUtils.isEmpty((CharSequence)(keys = ((String)ecGooodsMap.get(id)).split("_"))[0])) continue;
                info.set("prodmatmapping_id", (Object)Long.parseLong(keys[0]));
                if (keys.length <= 1 || StringUtils.isEmpty((CharSequence)keys[1])) continue;
                info.set("material", (Object)Long.parseLong(keys[1]));
            }
            if (pmm_mallgoods.length > 0) {
                SaveServiceHelper.save((DynamicObject[])pmm_mallgoods);
            }
        }
    }
}

