/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.task;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.helper.apiconnector.api.util.Parser;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.pmm.common.ecinit.entity.EcInitializeArgs;
import kd.scm.pmm.common.enums.TaskStatusEnum;
import kd.scm.pmm.servicehelper.PmmEcInitServiceHelper;

public class PmmEcInitTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(PmmEcInitTask.class);

    public void execute(RequestContext request, Map<String, Object> params) throws KDException {
        log.info("kd.scm.pmm.formplugin.PmmEcInitTask execute start ---------");
        EcInitializeArgs args = (EcInitializeArgs)SerializationUtils.fromJsonString((String)Parser.toString((Object)params.get("EcInitializeArgs")), EcInitializeArgs.class);
        ThreadPools.executeOnce((String)"http-request-pool-PmmEcInitServiceHelper-PmmEcInitServiceHelper", () -> PmmEcInitServiceHelper.doEcInitialize((EcInitializeArgs)args));
        Long ecResultId = args.getEcInitResultId();
        QFilter filter = new QFilter("id", "=", (Object)ecResultId);
        int waitTime = 1;
        int cycleTimes = 0;
        try {
            while (true) {
                Thread.sleep(waitTime * 1000);
                DynamicObject result = QueryServiceHelper.queryOne((String)"pmm_initresult", (String)"progress,status", (QFilter[])new QFilter[]{filter});
                if (null == result) continue;
                String status = result.getString("status");
                if (TaskStatusEnum.TASK_SUCCESS.getValue().equals(status) || TaskStatusEnum.TASK_FAIL.getValue().equals(status)) break;
                if (cycleTimes > 60 && TaskStatusEnum.TASK_DOING.getValue().equals(status)) {
                    waitTime = 10;
                }
                HashMap<String, Long> customData = new HashMap<String, Long>(4);
                customData.put("ecInitResultId", ecResultId);
                String name = MessageFormat.format(ResManager.loadKDString((String)"{0}\u521d\u59cb\u5316\u8fd0\u884c\u4e2d,\u76d1\u63a7\u6b21\u6570\uff1a", (String)"PmmEcInitTask_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]), EcPlatformEnum.fromVal((String)Parser.toString((Object)params.get("platform"))).getName());
                this.feedbackProgress(result.getInt("progress"), name + cycleTimes, customData);
                ++cycleTimes;
            }
            HashMap<String, Long> data = new HashMap<String, Long>(4);
            data.put("ecInitResultId", ecResultId);
            this.feedbackCustomdata(data);
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u66f4\u65b0\u5546\u54c1\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a", (String)"PmmEcInitTask_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            throw new KDBizException(msg + ExceptionUtil.getStackTrace((Throwable)e));
        }
        log.info("kd.scm.pmm.formplugin.PmmEcInitTask execute end ---------");
    }
}

