/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.scm.common.fulltext.utils.PbdMalElasticSearchUtils;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.malcore.enums.MallStatusEnum;

public class PmmImportPictureTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(PmmImportPictureTask.class);
    private static final String[] SPECIAL_SYMBOLS = new String[]{"%", "=", "+", "&"};

    public void execute(RequestContext request, Map<String, Object> params) throws KDException {
        log.info("kd.scm.pmm.formplugin.task.PmmImportPictureTask execute start ---------");
        try {
            this.updateGoodsPicture(request, params);
        }
        catch (Exception e) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("success", "false");
            this.feedbackCustomdata(result);
            String msg = ResManager.loadKDString((String)"\u56fe\u7247\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"PmmImportPictureTask_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]);
            throw new KDBizException(msg + ExceptionUtil.getStackTrace((Throwable)e));
        }
        log.info("kd.scm.pmm.formplugin.task.PmmImportPictureTask execute end ---------");
    }

    public void updateGoodsPicture(RequestContext request, Map<String, Object> params) {
        int i;
        String number;
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u56fe\u7247\u4fdd\u5b58\u4e2d", (String)"PmmImportPictureTask_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]), null);
        String domainUrl = UrlService.getDomainContextUrl() + "/";
        List goodsIds = (List)params.get("goodsIds");
        DynamicObject[] goodsDynArray = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)"id,number,thumbnail,picture1,picture2,picture3,picture4", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)goodsIds)});
        int len = goodsDynArray.length;
        boolean coverFlag = StringUtils.equals((CharSequence)"true", (CharSequence)params.get("coverFlag").toString());
        HashMap<String, DynamicObject> oldGoodsMap = new HashMap<String, DynamicObject>(len);
        for (DynamicObject goodsDyn : goodsDynArray) {
            number = goodsDyn.getString("number");
            oldGoodsMap.put(number, goodsDyn);
        }
        Map thumbnailMap = (Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)params.get("thumbnailMap")), Map.class);
        Map pictureMap = (Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)params.get("pictureMap")), Map.class);
        Set entrys = thumbnailMap.entrySet();
        HashMap<String, String> urlMap = new HashMap<String, String>(len * 5);
        number = null;
        for (Map.Entry entryDyn : entrys) {
            number = entryDyn.getKey().toString();
            DynamicObject goodsDyn = (DynamicObject)oldGoodsMap.get(number);
            this.putUrlMapInfo((String)entryDyn.getValue(), goodsDyn, "thumbnail", urlMap, coverFlag, domainUrl);
            for (int j = 1; j < 5; ++j) {
                this.putUrlMapInfo((String)pictureMap.get(number + j), goodsDyn, "picture" + j, urlMap, coverFlag, domainUrl);
            }
        }
        String selectFields = "id,name,tempfile,url,pageid,size";
        QFilter[] filters = new QFilter[]{new QFilter("tempfile", "=", (Object)"0"), new QFilter("url", "in", urlMap.keySet()), new QFilter("status", "=", (Object)"B")};
        DynamicObject[] att = BusinessDataServiceHelper.load((String)"bd_attachment", (String)selectFields, (QFilter[])filters);
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        ArrayList<String> uploadPatchs = new ArrayList<String>();
        FileService imageFileService = FileServiceFactory.getImageFileService();
        int size = att.length;
        int progress = 0;
        for (i = 0; i < size; ++i) {
            String string = att[i].getString("url");
            String name = att[i].getString("name");
            Object attPk = att[i].getPkValue();
            if (!string.contains("configKey") || !urlMap.containsKey(string)) continue;
            String path = FileNameUtils.getAttachmentFileName((String)tenantId, (String)accountId, (Object)attPk, (String)(uuid + "/" + PmmImportPictureTask.replaceSpeSymbol(name)));
            TempFileCache downLoad = CacheFactory.getCommonCacheFactory().getTempFileCache();
            FileItem fileItem = new FileItem(name, path, downLoad.getInputStream(string));
            String uploadPatch = imageFileService.upload(fileItem);
            uploadPatchs.add(uploadPatch);
            progress = 100 * i / size;
            if (progress == 100) {
                progress = 99;
            }
            this.feedbackProgress(progress, ResManager.loadKDString((String)"\u56fe\u7247\u4fdd\u5b58\u4e2d", (String)"PmmImportPictureTask_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]), null);
            if (!this.isStop()) continue;
            this.stop();
        }
        for (i = 0; i < att.length; ++i) {
            String string = att[i].getString("url");
            if (!string.contains("configKey") || !urlMap.containsKey(string)) continue;
            urlMap.put(string, (String)uploadPatchs.get(i));
            att[i].set("url", uploadPatchs.get(i));
            att[i].set("tempfile", (Object)1);
            att[i].set("pageid", (Object)"");
        }
        SaveServiceHelper.save((DynamicObject[])att);
        ArrayList<String> oldPathList = new ArrayList<String>(goodsDynArray.length * 5);
        for (DynamicObject goodsDyn : goodsDynArray) {
            String url = (String)thumbnailMap.get(goodsDyn.getString("number"));
            this.updateGoodsPicture(goodsDyn, url, "thumbnail", urlMap, coverFlag, domainUrl, oldPathList);
            for (int i2 = 1; i2 < 5; ++i2) {
                url = (String)pictureMap.get(goodsDyn.getString("number") + i2);
                this.updateGoodsPicture(goodsDyn, url, "picture" + i2, urlMap, coverFlag, domainUrl, oldPathList);
            }
        }
        SaveServiceHelper.save((DynamicObject[])goodsDynArray);
        this.deleteOldPitcutreFile(oldPathList);
        this.soldPublish(goodsIds);
        this.feedbackProgress(100, "", null);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("success", "true");
        this.feedbackCustomdata(hashMap);
    }

    private void updateGoodsPicture(DynamicObject goodsDyn, String url, String pictueKey, Map<String, String> urlMap, boolean coverFlag, String domianUrl, List<String> oldPathList) {
        if (StringUtils.isNotEmpty((CharSequence)url)) {
            String newUrl;
            if (url.startsWith(domianUrl)) {
                url = url.substring(domianUrl.length());
            }
            if (StringUtils.isNotEmpty((CharSequence)(newUrl = urlMap.get(url)))) {
                if (coverFlag) {
                    String path = goodsDyn.getString(pictueKey);
                    goodsDyn.set(pictueKey, (Object)newUrl);
                    if (StringUtils.isNotEmpty((CharSequence)path) && !path.equals(newUrl)) {
                        oldPathList.add(path);
                    }
                } else if (StringUtils.isEmpty((CharSequence)goodsDyn.getString(pictueKey))) {
                    goodsDyn.set(pictueKey, (Object)newUrl);
                }
            }
        } else {
            goodsDyn.set(pictueKey, null);
        }
    }

    private void deleteOldPitcutreFile(List<String> oldPathList) {
        if (oldPathList != null && !oldPathList.isEmpty()) {
            try {
                FileService fileService = FileServiceFactory.getImageFileService();
                for (String path : oldPathList) {
                    fileService.delete(path);
                }
            }
            catch (KDException e) {
                log.error("\u5546\u54c1\u56fe\u7247\u5220\u9664\u6267\u884c\u62a5\u9519", (Throwable)e);
            }
            catch (Exception e) {
                log.error("\u5546\u54c1\u56fe\u7247\u5220\u9664\u6267\u884c\u62a5\u9519", (Throwable)e);
            }
        }
    }

    private void putUrlMapInfo(String pictureUrl, DynamicObject goodsDyn, String pictueKey, Map<String, String> urlMap, boolean coverFlag, String domianUrl) {
        if (StringUtils.isNotEmpty((CharSequence)pictureUrl) && pictureUrl.contains("configKey")) {
            if (pictureUrl.startsWith(domianUrl)) {
                pictureUrl = pictureUrl.substring(domianUrl.length());
            }
            if (coverFlag) {
                urlMap.put(pictureUrl, null);
            } else if (StringUtils.isEmpty((CharSequence)goodsDyn.getString(pictueKey))) {
                urlMap.put(pictureUrl, null);
            }
        } else {
            urlMap.put(pictureUrl, pictureUrl);
        }
    }

    private static String replaceSpeSymbol(String str) {
        for (int i = 0; i < SPECIAL_SYMBOLS.length; ++i) {
            if (!str.contains(SPECIAL_SYMBOLS[i])) continue;
            str = str.replace(SPECIAL_SYMBOLS[i], "_");
        }
        return str;
    }

    private void soldPublish(List<Long> goodsIds) {
        DynamicObjectCollection dynList = QueryServiceHelper.query((String)"pmm_prodpool", (String)"id,mallstatus", (QFilter[])new QFilter("goods", "in", goodsIds).toArray());
        ArrayList prodpoolId = new ArrayList(dynList.size());
        dynList.forEach(t -> {
            String mallStatus = t.getString("mallstatus");
            if (MallStatusEnum.SOLD.getVal().equals(mallStatus)) {
                prodpoolId.add(t.getLong("id"));
            }
        });
        if (!prodpoolId.isEmpty()) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"soldpublish", (String)"pmm_prodpool", (Object[])prodpoolId.toArray(), (OperateOption)option));
        }
        PbdMalElasticSearchUtils.MalGoodsBatchSync((String)"pmm_prodmanage", goodsIds);
    }
}

