/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.formplugin.task;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.algo.util.io.IOUtils;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;

public class PmmPictureTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(PmmPictureTask.class);
    private static String DIGIT_RANGE = "12345";

    public void execute(RequestContext request, Map<String, Object> params) throws KDException {
        log.info("kd.scm.pmm.formplugin.task.PmmPictureTask execute start ---------");
        try {
            this.getImageInfoUrl(request, params);
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.info("kd.scm.pmm.formplugin.task.PmmPictureTask execute end ---------");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getImageInfoUrl(RequestContext request, Map<String, Object> params) {
        String fileUrl = params.get("zipfileurl").toString();
        int size = Integer.parseInt(params.get("size").toString()) * 5;
        HashMap picListMap = new HashMap(5);
        int result = 0;
        ZipInputStream zipInputStream = null;
        InputStream inputStream = null;
        TempFileCache fileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try {
            int timeout = 7200;
            inputStream = fileCache.getInputStream(fileUrl);
            zipInputStream = new ZipInputStream(inputStream, Charset.forName("GBK"));
            ZipEntry zipEntry = null;
            int spliteSize = Integer.parseInt(System.getProperty("redis.tempfile.splite.size", "10")) * 1024 * 1024;
            int progress = 0;
            int i = 0;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                block12: {
                    block13: {
                        block14: {
                            String filename = zipEntry.getName();
                            if (zipEntry.isDirectory() || !StringUtils.isNotEmpty((CharSequence)filename) || filename.indexOf(95) <= 0) break block12;
                            String name = filename.substring(0, filename.lastIndexOf(46));
                            int index = name.indexOf(95);
                            if (name.length() < index + 2) break block13;
                            String number = name.substring(0, index);
                            String digit = name.substring(index + 1, index + 2);
                            if (!DIGIT_RANGE.contains(digit)) break block14;
                            HashMap picList = (HashMap)picListMap.get(number);
                            if (picList == null) {
                                picList = new HashMap(5);
                                picListMap.put(number, picList);
                            }
                            if (picList.get(Integer.parseInt(digit)) != null) {
                                result = 1;
                                break block12;
                            } else if (picList.size() >= 5) {
                                result = 2;
                                break block12;
                            } else {
                                byte[] data = this.readDataFromStream(zipInputStream, spliteSize);
                                String tempUrl = fileCache.saveAsUrl(name, data, timeout);
                                HashMap<String, String> imageMap = new HashMap<String, String>(2);
                                imageMap.put("name", filename);
                                imageMap.put("url", tempUrl);
                                picList.put(Integer.parseInt(digit), imageMap);
                            }
                            break block12;
                        }
                        result = 1;
                        break block12;
                    }
                    result = 1;
                }
                if ((progress = 100 * i / size) >= 100) {
                    progress = 99;
                }
                ++i;
                this.feedbackProgress(progress, ResManager.loadKDString((String)"\u56fe\u7247\u4e0a\u4f20\u4e2d", (String)"PmmPictureTask_0", (String)"scm-pmm-formplugin", (Object[])new Object[0]), null);
                if (!this.isStop()) continue;
                this.stop();
            }
            zipInputStream.closeEntry();
        }
        catch (KDBizException e) {
            try {
                log.error("file batch upload error", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u538b\u7f29\u5305\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"PmmPictureTask_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                catch (Exception e2) {
                    log.error("file batch upload error", (Throwable)e2);
                    throw new KDBizException(ResManager.loadKDString((String)"\u538b\u7f29\u5305\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u5206\u6790\u3002", (String)"PmmPictureTask_1", (String)"scm-pmm-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(zipInputStream);
                IOUtils.closeQuietly((AutoCloseable)inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((AutoCloseable)zipInputStream);
        IOUtils.closeQuietly((AutoCloseable)inputStream);
        HashMap<String, Object> resultParams = new HashMap<String, Object>();
        resultParams.put("coverflag", params.get("coverflag"));
        resultParams.put("success", "true");
        resultParams.put("result", result);
        resultParams.put("picListMap", picListMap);
        this.feedbackCustomdata(resultParams);
    }

    private byte[] readDataFromStream(InputStream in, int spliteSize) {
        try {
            int doneRead = 0;
            byte[] dataAll = new byte[spliteSize];
            do {
                int toRead = in.available();
                int curRead = in.read(dataAll, doneRead, toRead);
                doneRead += curRead;
            } while (in.available() > 0);
            return dataAll;
        }
        catch (IOException e) {
            throw new IllegalStateException("fail read data from file steam : ", e);
        }
    }
}

