/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.common.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.ORMUtil;
import kd.scm.common.util.CommonUtil;
import kd.scm.common.util.DateUtil;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.malcore.enums.MallStatusEnum;
import kd.scm.malcore.enums.ProdEffectStatusEnum;

public class PmmAutoDownloadTask
extends AbstractTask {
    private static Log log = LogFactory.getLog(PmmAutoDownloadTask.class);
    public static final int pageSize = 1000;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        log.info("@@@@@kd.scm.pmm.common.task.PmmAutoDownloadTask start execute");
        this.autoUploadOp();
        this.autoDownloadOp();
        log.info("@@@@@kd.scm.pmm.common.task.PmmAutoDownloadTask end execute");
    }

    private void autoUploadOp() {
        Date now = TimeServiceHelper.now();
        log.info("@@@@@kd.scm.pmm.common.task.PmmAutoDownloadTask start autoUploadOp");
        QFilter qFilter = new QFilter("goods", "is not null", (Object)0L).and("goods", "!=", (Object)0L);
        qFilter.and(new QFilter("mallstatus", "=", (Object)MallStatusEnum.UNSOLD.getVal()));
        qFilter.and(new QFilter("priceeffectdate", "<=", (Object)now));
        int count = ORMUtil.getCount((QFilter[])qFilter.toArray(), (String)"pmm_prodpool");
        if (count == 0) {
            return;
        }
        log.info("@@@@@kd.scm.pmm.common.task.PmmAutoDownloadTask count:" + count);
        int countSize = this.getCountSize(count);
        for (int i = 0; i <= countSize; ++i) {
            DynamicObject[] prods;
            DynamicObject[] prodPools = BusinessDataServiceHelper.load((String)"pmm_prodpool", (String)"id,goods,mallstatus,effectstatus,salestatus,isgoodvisible,entryentity.orgname,protocol,protocolentry.id", (QFilter[])qFilter.toArray(), null, (int)i, (int)1000);
            ArrayList<Long> prodIds = new ArrayList<Long>(prodPools.length);
            for (DynamicObject prodPool : prodPools) {
                prodPool.set("mallstatus", (Object)MallStatusEnum.SOLD.getVal());
                prodPool.set("effectstatus", (Object)ProdEffectStatusEnum.EFFECTIVE.getVal());
                if (prodPool.getDynamicObject("protocol") != null) continue;
                prodIds.add(prodPool.getLong("goods_id"));
            }
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"sold", (String)"pmm_prodpool", (DynamicObject[])prodPools, (OperateOption)option);
            if (!operationResult.isSuccess()) {
                StringBuilder messageError = new StringBuilder();
                messageError.append("@@@@@kd.scm.pmm.common.task.PmmAutoDownloadTask AutoUpload failed:");
                messageError.append(operationResult.getMessage());
                operationResult.getAllErrorOrValidateInfo().forEach(row -> messageError.append(row.getMessage()).append("\n\t"));
                log.info(messageError.toString());
            }
            if (prodIds.isEmpty()) continue;
            QFilter qFilter1 = new QFilter("id", "in", prodIds);
            String prodSelectFields = DynamicObjectUtil.getSelectfields((String)"pmm_prodmanage", (boolean)false);
            for (DynamicObject prod : prods = BusinessDataServiceHelper.load((String)"pmm_prodmanage", (String)(prodSelectFields + ",protocolentry.prodpool,protocolentry.protocol"), (QFilter[])qFilter1.toArray())) {
                prod.set("mallstatus", (Object)MallStatusEnum.SOLD.getVal());
            }
            CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"save", (String)"pmm_prodmanage", (DynamicObject[])prods, (OperateOption)option));
        }
    }

    private void autoDownloadOp() {
        log.info("@@@@@kd.scm.pmm.common.task.PmmAutoDownloadTask start autoDownloadOp");
        Date now = TimeServiceHelper.now();
        Date date = DateUtil.addDays((Date)now, (int)-1);
        QFilter qFilter = new QFilter("goods", "is not null", (Object)0L).and("goods", "!=", (Object)0L);
        qFilter.and(new QFilter("effectstatus", "!=", (Object)ProdEffectStatusEnum.INVALID.getVal()));
        qFilter.and(new QFilter("priceinvaliddate", "<=", (Object)date));
        String selectProperties = "id,goods,billno,protocol,mallstatus,salestatus,effectstatus";
        int count = ORMUtil.getCount((QFilter[])qFilter.toArray(), (String)"pmm_prodpool");
        if (count == 0) {
            return;
        }
        int countSize = this.getCountSize(count);
        log.info("@@@@@kd.scm.pmm.common.task.PmmAutoDownloadTask,count:" + count);
        ArrayList downloadAllProdIds = new ArrayList(1024);
        for (int i = 0; i <= countSize; ++i) {
            DynamicObject[] prodPoolArray = BusinessDataServiceHelper.load((String)"pmm_prodpool", (String)selectProperties, (QFilter[])qFilter.toArray(), null, (int)i, (int)1000);
            ArrayList<Long> downloadProdIds = new ArrayList<Long>(1024);
            ArrayList<Long> prodIds = new ArrayList<Long>(prodPoolArray.length);
            for (DynamicObject prodPool : prodPoolArray) {
                String mallStatus = prodPool.getString("mallstatus");
                if (MallStatusEnum.SOLDOUT.getVal().equals(mallStatus)) continue;
                downloadProdIds.add(prodPool.getLong("id"));
                prodIds.add(prodPool.getLong("goods_id"));
            }
            if (downloadProdIds.isEmpty()) {
                return;
            }
            downloadAllProdIds.addAll(downloadProdIds);
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            option.setVariableValue("isStrict", String.valueOf(false));
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"download", (String)"pmm_prodpool", (Object[])downloadProdIds.toArray(), (OperateOption)option);
            if (!operationResult.isSuccess()) {
                StringBuilder messageError = new StringBuilder();
                messageError.append("@@@@@kd.scm.pmm.common.task.PmmAutoDownloadTask autoDownloadOp failed reason:");
                messageError.append(operationResult.getMessage());
                operationResult.getAllErrorOrValidateInfo().forEach(row -> messageError.append(row.getMessage()).append("\n\t"));
                log.info(messageError.toString());
            }
            if (prodIds.isEmpty()) continue;
            CommonUtil.check((OperationResult)OperationServiceHelper.executeOperate((String)"download", (String)"pmm_prodmanage", (Object[])prodIds.toArray(), (OperateOption)option));
        }
        log.info("@@@@@kd.scm.pmm.common.task.PmmAutoDownloadTask,downloadProdIds:" + SerializationUtils.toJsonString(downloadAllProdIds));
    }

    private int getCountSize(int count) {
        int countSize = count / 1000;
        if (countSize == 0) {
            countSize = 1;
        }
        return countSize;
    }
}

