/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.common.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scm.common.util.ExceptionUtil;

public class PmmAutoPortocolTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog((String)PmmAutoPortocolTask.class.getName());
    public static final int pageSize = 1000;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Date now = TimeServiceHelper.now();
        log.info("$$$$\u5904\u7406\u751f\u6548\u6570\u636estart");
        this.effectpProtocol(now);
        log.info("$$$$\u5904\u7406\u751f\u6548\u6570\u636eend");
        log.info("$$$$\u5904\u7406\u5931\u6548\u6570\u636estart");
        this.invalidProtocol(now);
        log.info("$$$$\u5904\u7406\u5931\u6548\u6570\u636eend");
    }

    private void invalidProtocol(Date now) {
        ArrayList<String> protocolStatusList = new ArrayList<String>(2);
        protocolStatusList.add("A");
        protocolStatusList.add("B");
        QFilter qFilter = new QFilter("protocolstatus", "in", protocolStatusList);
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qFilter.and(new QFilter("effectdate", "<", (Object)now));
        qFilter.and(new QFilter("prosource", "!=", (Object)"2"));
        this.doOperate(qFilter, "invalid");
    }

    private void effectpProtocol(Date now) {
        ArrayList<String> confirmstatusList = new ArrayList<String>(2);
        confirmstatusList.add("A");
        confirmstatusList.add("C");
        QFilter qFilter = new QFilter("confirmstatus", "in", confirmstatusList);
        qFilter.and(new QFilter("protocolstatus", "=", (Object)"A"));
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        qFilter.and(new QFilter("effectdate", "<=", (Object)now));
        this.doOperate(qFilter, "effect");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOperate(QFilter qFilter, String effect) {
        HashSet<Long> idSet = new HashSet<Long>(1024);
        try (DataSet ds = null;){
            ORM orm = ORM.create();
            ds = orm.queryDataSet("pmm_protocol", "pmm_protocol", "id", qFilter.toArray());
            for (Row row : ds) {
                Long id = Long.parseLong(String.valueOf(row.get("id")));
                idSet.add(id);
            }
        }
        OperateOption option = OperateOption.create();
        option.setVariableValue("isStrict", "false");
        option.setVariableValue("ishasright", "true");
        OperationResult effectResullt = OperationServiceHelper.executeOperate((String)effect, (String)"pmm_protocol", (Object[])idSet.toArray(), (OperateOption)option);
        if (!effectResullt.isSuccess()) {
            String msg = ExceptionUtil.getErrorInfoDetails((List)effectResullt.getAllErrorOrValidateInfo());
            log.error(msg);
        }
    }
}

