/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.common.task;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.MessageHandler;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.ecapi.enums.EcPlatformEnum;
import kd.scm.common.ecapi.jd.JDAccessTokenUtil;
import kd.scm.common.util.AESUtil;
import kd.scm.common.util.ExceptionUtil;
import kd.scm.common.util.MalOrderUtil;
import net.sf.json.JSONObject;

public class PmmAutoUpdateEcadmitTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog((String)PmmAutoUpdateEcadmitTask.class.getName());

    public MessageHandler getMessageHandle() {
        return null;
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (MalOrderUtil.getDefaultMalVersion()) {
            return;
        }
        DynamicObject[] ecadmitDyns = this.loadEcadmitDyns();
        boolean success = false;
        for (DynamicObject ecadmitDyn : ecadmitDyns) {
            String tenantId = RequestContext.getOrCreate().getTenantId();
            String clientId = ecadmitDyn.getString("client_id");
            String secret = ecadmitDyn.getString("client_secret");
            DynamicObjectCollection entryCol = ecadmitDyn.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryCol) {
                String userName = entry.getString("mallaccount");
                String passWord = entry.getString("mallpwd");
                try {
                    passWord = AESUtil.decryptToStringNew((String)passWord);
                }
                catch (Exception e) {
                    log.info("Exception=" + ExceptionUtil.getStackTrace((Throwable)e));
                    log.warn("PmmAutoUpdateEcadmitTask\u89e3\u5bc6passWord\u5931\u8d25:" + clientId);
                    continue;
                }
                String tokenJson = JDAccessTokenUtil.getJDTokenJSON((String)userName, (String)passWord, (String)tenantId, (String)clientId, (String)secret);
                success = this.updateEntry(entry, tokenJson);
            }
        }
        if (success) {
            SaveServiceHelper.save((DynamicObject[])ecadmitDyns);
        }
    }

    public boolean updateEntry(DynamicObject entry, String tokenJson) {
        JSONObject node = JSONObject.fromObject((Object)tokenJson);
        if (node.getString("success").equals("true")) {
            JSONObject rs = node.getJSONObject("result");
            String refreshToken = rs.optString("refresh_token");
            long expriDate = Long.parseLong(rs.optString("refresh_token_expires"));
            entry.set("uneffectualdate", (Object)new Date(expriDate));
            entry.set("token", (Object)refreshToken);
            return true;
        }
        return false;
    }

    private DynamicObject[] loadEcadmitDyns() {
        QFilter filter = new QFilter("platform", "=", (Object)EcPlatformEnum.ECPLATFORM_JD.getVal()).and("openstatus", "=", (Object)"2");
        return BusinessDataServiceHelper.load((String)"pmm_ecadmit", (String)"entryentity,client_id,client_secret,entryentity.mallaccount,entryentity.mallpwd,entryentity.uneffectualdate,entryentity.token", (QFilter[])new QFilter[]{filter});
    }
}

