/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.pmm.common.util;

import java.math.BigDecimal;
import kd.bos.entity.datamodel.IDataModel;
import kd.scm.common.enums.TaxTypeEnum;
import kd.scm.common.util.NumberUtils;
import kd.scm.common.util.cal.CalImpl;
import kd.scm.common.util.cal.CalculateUtils;

public class PmmProtocolCalImpl
extends CalImpl {
    public void calEntryDiscountAmount(IDataModel model, String entryKey) {
        int rowIndex = model.getEntryCurrentRowIndex(entryKey);
        Object value = model.getValue("discounttype", rowIndex);
        if (null != value && "B".equals(value)) {
            int index = model.getEntryCurrentRowIndex(entryKey);
            BigDecimal qty = this.getEntryBigDecimalValue(model, index, "qty");
            BigDecimal dctrate = this.getEntryBigDecimalValue(model, index, "dctrate");
            int scale = this.getAmtPrecision(model, entryKey);
            BigDecimal discountAmount = BigDecimal.ZERO;
            discountAmount = dctrate.multiply(qty);
            discountAmount = discountAmount.setScale(scale, 4);
            model.setValue("dctamount", (Object)discountAmount, index);
        } else {
            super.calEntryDiscountAmount(model, entryKey);
        }
    }

    public void calEntryTaxAmount(IDataModel model, String entryKey) {
        int index = model.getEntryCurrentRowIndex(entryKey);
        Object value = model.getValue("discounttype", index);
        String taxType = this.getHeadStringValue(model, "taxtype");
        boolean containTax = this.isContainTax(taxType);
        BigDecimal taxAmount = BigDecimal.ZERO;
        int scale = this.getAmtPrecision(model, entryKey);
        if (containTax) {
            BigDecimal qty = this.getEntryBigDecimalValue(model, index, "qty");
            BigDecimal taxPrice = this.getEntryBigDecimalValue(model, index, "taxprice");
            BigDecimal discount = this.getEntryBigDecimalValue(model, index, "dctrate");
            taxAmount = null != value && "B".equals(value) ? PmmProtocolCalImpl.calTaxAmountByDiscountPercent(qty, taxPrice, discount, scale) : CalculateUtils.calTaxAmountByDiscountPercent((BigDecimal)qty, (BigDecimal)taxPrice, (BigDecimal)discount, (int)scale);
        } else {
            BigDecimal amount = this.getEntryBigDecimalValue(model, index, "amount");
            BigDecimal tax = this.getEntryBigDecimalValue(model, index, "tax");
            taxAmount = CalculateUtils.calTaxAmount((BigDecimal)amount, (BigDecimal)tax, (int)scale);
        }
        model.setValue("taxamount", (Object)taxAmount, index);
    }

    public void calEntryAmount(IDataModel datamodel, String entryKey) {
        String taxType = this.getHeadStringValue(datamodel, "taxtype");
        int index = datamodel.getEntryCurrentRowIndex(entryKey);
        Object value = datamodel.getValue("discounttype", index);
        BigDecimal amount = BigDecimal.ZERO;
        int scale = this.getAmtPrecision(datamodel, entryKey);
        if (TaxTypeEnum.TAXSEXPRICE_INTAX.getVal().equals(taxType) || TaxTypeEnum.TAXSINPRICE_INTAX.getVal().equals(taxType)) {
            BigDecimal taxAmount = this.getEntryBigDecimalValue(datamodel, index, "taxamount");
            BigDecimal tax = this.getEntryBigDecimalValue(datamodel, index, "tax");
            amount = CalculateUtils.calAmountInTax((BigDecimal)taxAmount, (BigDecimal)tax, (int)scale);
        } else if (TaxTypeEnum.TAXSEXPRICE_EXTAX.getVal().equals(taxType)) {
            BigDecimal discountRate = this.getEntryBigDecimalValue(datamodel, index, "dctrate");
            BigDecimal qty = this.getEntryBigDecimalValue(datamodel, index, "qty");
            BigDecimal price = this.getEntryBigDecimalValue(datamodel, index, "price");
            amount = null != value && "B".equals(value) ? PmmProtocolCalImpl.calTaxAmountByDiscountPercent(qty, price, discountRate, scale) : CalculateUtils.calAmountByDiscountPercent((BigDecimal)qty, (BigDecimal)price, (BigDecimal)discountRate, (int)scale);
        }
        datamodel.setValue("amount", (Object)amount, index);
    }

    private static BigDecimal calAmountByDiscountPercent(BigDecimal qty, BigDecimal price, BigDecimal discountRate, int scale) {
        qty = NumberUtils.effectualNumeric((BigDecimal)qty);
        price = NumberUtils.effectualNumeric((BigDecimal)price);
        discountRate = NumberUtils.effectualNumeric((BigDecimal)discountRate);
        BigDecimal amount = qty.multiply(price.subtract(discountRate));
        amount = amount.setScale(scale, 4);
        return amount;
    }

    private static BigDecimal calTaxAmountByDiscountPercent(BigDecimal qty, BigDecimal taxPrice, BigDecimal discountRate, int scale) {
        qty = NumberUtils.effectualNumeric((BigDecimal)qty);
        taxPrice = NumberUtils.effectualNumeric((BigDecimal)taxPrice);
        discountRate = NumberUtils.effectualNumeric((BigDecimal)discountRate);
        BigDecimal totalTaxAmount = qty.multiply(taxPrice.subtract(discountRate));
        totalTaxAmount = totalTaxAmount.setScale(scale, 4);
        return totalTaxAmount;
    }
}

